#include <stdio.h>

unsigned
	Line,

unsigned char
	dir[100],
	env[100],
	temp[100],
	temp1[100],
	name[100],
	*ptr,
	*nptr;

FILE
	*fp;

register error(unsigned args)
{
	unsigned char buffer[200];
	_format_(nargs() * 2 + & args, buffer);
	fputs(buffer, stdout);
	putc('\n', stdout);
	if(fp)
		fclose(fp);
	exit(-1);
}

int skip()
{
	while(isspace(*ptr))
		++ptr;
	return *ptr;
}

void parse(unsigned char *dest, char f)
{
	unsigned char c, d, *p;
	FILE *fp;

	if(!skip())
		error("%u: No data", Line);

	while((c = *ptr) && !isspace(c)) {
		++ptr;
		if((c == '@') && isdigit(*ptr) && f) {
			c = *ptr - '0';
			if(!*(p = env)) {	// Environment not read
				if(!getenv("XS", env)) {
					strcpy(nptr, "DEF");
					fp = fopen(name, "rvq");
					fgets(env, sizeof(env)-1, fp);
					fclose(fp); } }
			while(c) {
				while((d = *p++) != ';') {
					if(!d)
						error("%u: Element @%c not set", Line, *ptr); }
				--c; }
			while((d = *p++) && (d != ';'))
				*dest++ = d;
			++ptr;
			continue; }
		*dest++ = toupper(c); }
	*dest = 0;
}

char hello[] = { "\neXpress Switch directory - Dave Dunfield - "#__DATE__"" };
char help[] = { "\n\
	XS nickname			<= change directory\n\
	XS =element[;element...]	<= select default directory elements\n\
	XS /D				<= display nicknames and Directories\n\
	XS /P				<= display nicknames and Path defs\n\
	set XS=element[;element...]	<= override directory elements\n\
	set XS=				<= return to default elements\n\
\n\
XS  is a CD command which takes you to specific directories using a nickname.\n\
It also allows elements to be automatically inserted into the directory path,\n\
making it easy to select between identical subdirctory trees/projects/drives.\n\n\
The file XS.DAT contains the nickname to full path descriptions:\n\
	root	@0:\\@1\n\
	source	@0:\\@1\\source\n\
	include	@0:\\@1\\include\n\
Elements are substituted into the path where '@0-9' occurs:\n\
	XS =D;PROJ1\n\
	XS root		-> CD D:\\PROJ1\n\
	XS source	-> CD D:\\PROJ1\\source\n\
	XS include	-> CD D:\\PROJ1\\include\n\
The nickname can be matched with partial input:\n\
	XS s		-> CD D:\\PROJ1\\source\n\
" };

main(int argc, char *argv[])
{
	unsigned char c, f;

	strcpy(ptr = name, argv[0]);
	nptr = f = 0;
	while(c = *ptr++) {
		switch(c) {
		case ':' :
		case '\\': nptr = 0; continue;
		case '.' : nptr = ptr; } }

	if(argc < 2) {
		fputs(hello, stdout);
		printf(" - 'XS ?' for help\n\n", stdout);
		strcpy(nptr, "DEF");
		fputs("Current elements are : ", stdout);
		if(fp = fopen(name, "r")) {
			fgets(env, sizeof(env)-1, fp);
			fclose(fp);
			printf("%s\n", env); }
		else
			fputs("Not set\n", stdout);
		if(getenv("XS", env))
			printf("Override elements are: %s\n", env);
		getdir(temp);
		printf("Current directory is : %c:\\%s\n", get_drive()+'A', temp);
		printf("Available nicknames  :\n");
		c = 0;
dolist:	strcpy(nptr, "DAT");
		fp = fopen(name, "rvq");
		while(fgets(ptr = temp, sizeof(temp)-1, fp)) {
			switch(skip()) {
			case ';' :
			case 0 : continue; }
			parse(temp1, 0);
			if(c) {
				printf("%-13s", temp1);
				if(c & 0xF0) {
					parse(temp1, 255);
					ptr = temp1; }
				else
					skip();
				printf("%s\n", ptr); }
			else {
				if(++Line % 6)
					printf(" %-12s", temp1);
				else
					printf("%s\n", temp1); } }
		if(Line % 6)
			putc('\n', stdout);
		fclose(fp);
		return; }

	if(strbeg("?", ptr = argv[1])) {
		fputs(hello, stdout);
		fputs(help, stdout);
		return; }

	parse(dir, 0);
	if(strbeg(dir, "/D")) {
		c = 255;
		goto dolist; }
	if(strbeg(dir, "/P")) {
		c = 15;
		goto dolist; }

	if(!nptr)
		error("ARGV error");

	if(*dir == '=') {		// Set default file
		if(!dir[1])
			abort("No argument");
		strcpy(nptr, "DEF");
		fp = fopen(name, "wvq");
		fputs(dir+1, fp);
		putc('\n', fp);
		fclose(fp);
		return; }

	strcpy(nptr, "DAT");
	fp = fopen(name, "rvq");
	while(fgets(ptr = temp, sizeof(temp)-1, fp)) {
		++Line;
		switch(skip()) {
		case ';' :
		case 0 : continue; }
		parse(temp1, 0);
		if(strbeg(temp1, dir)) {
			parse(temp1, f=255);
			if(cd(temp1))
				continue;
			fclose(fp);
			c = temp1[0];
			if((temp1[1] == ':') && ((c >= 'A') && (c <= 'Z')))
				set_drive(c - 'A');
			return; } }
	if(f)
		error("Unable to CD: %s\n", temp1);
	else
		error("Not found: %s", dir);
}
