/*
 * Copy file * translate {...} time references
 */
#include <stdio.h>
#include <file.h>

#define	NAMES	50

unsigned
	Day,			// Current day
	Month,			// Current month
	Year,			// Current year
	Hour,			// Current hour
	Minite,			// Current minite
	Second,			// Current second
	Ptop,			// Top of string pool
	Ntop;			// Top of name list
FILE
	*fpi,			// Input file pointer
	*fpo;			// Output file pointer
unsigned char
	*Ptr,			// General pointer
	*Ifile,			// Input file name
	*Ofile,			// Output file name
	*Names[NAMES],	// Name lists
	*Text[NAMES],	// Name substitution list
	Oc = '{',		// Open character
	Cc = '}',		// Close character
	Buffer[512],	// General buffer
	Temp[512],		// Temp buffer
	Pool[8192];		// String pool

unsigned char *Months[] = { "---",
	"January", "February", "March", "April", "May", "June",
	"July", "August", "September", "October", "November", "December" };

unsigned char Help[] = { "\n\
Use: XTIME infile outfile [SYMBOL=text] [={}]\n\n\
{SYMBOL} is replaced by text\n\
{%TIME...} lead-in for time data:\n\
	%[-]0nD		- Day\n\
	%[-]0nM		- Month (numeric)\n\
	%T		- Month (full text)\n\
	%t		- Month (text-3)\n\
	%[-]0nY		- Year (4 digits)\n\
	%[-]0ny		- Year (2 digits)\n\
	%[-]0nH		- Hour (24)\n\
	%[-]0nh		- Hour (12)\n\
	%[-]0nm		- Minite\n\
	%[-]0ns		- Second\n\
	%a		- 'a' or 'p'\n\
	%A		- 'A' or 'P'\n\
" };

unsigned char *add_pool(unsigned char *s)
{
	unsigned char *p;
	p = Pool+Ptop;
	do {
		if(Ptop >= sizeof(Pool))
			abort("Pool exhausted"); }
	while(Pool[Ptop++] = *s++);
	return p;
}

// Process time string
int xtime(unsigned char *f)
{
	int c;
	unsigned v;
	unsigned char *p, *p1, fmt[16], out[128];
	p1 = out;
	for(;;) switch(c = *f++) {
		default: *p1++ = c;	continue;
		case 0 :		// End
			*p1 = 0;
			fputs(out, fpo);
			return 0;
		case '%' :		// Format
			p = fmt;
			*p++ = '%';
			if(*f == '-')
				*p = *f++;
			while(isdigit(*f))
				*p++ = *f++;
			*p++ = 'u';
			*p = 0;
			switch(*f++) {
			default: return 255;
			case 't' :
				for(v=0; v < 3; ++v)
					*p1++ = Months[Month][v];
				continue;
			case 'T' : strcpy(p1, Months[Month]); goto xx2;
			case 'a' : *p1++ = (Hour < 12) ? 'a' : 'p'; continue;
			case 'A' : *p1++ = (Hour < 12) ? 'A' : 'P'; continue;
			case 'h' : if(!(v = Hour % 12)) v = 12;	goto xx1;
			case 'H' : v = Hour;					goto xx1;
			case 'm' : v = Minite;					goto xx1;
			case 'M' : v = Month;					goto xx1;
			case 's' :
			case 'S' : v = Second;					goto xx1;
			case 'd' :
			case 'D' : v = Day;						goto xx1;
			case 'Y' : v = Year;					goto xx1;
			case 'y' : v = Year%100;
xx1:			sprintf(p1, fmt, v);
xx2:			while(*p1) ++p1; } }
}

main(int argc, char *argv[])
{
	int c;
	unsigned i;
	unsigned char *p, *p1;

	for(i=1; i < argc; ++i) {
		if(*(Ptr = p1 = argv[i]) == '=') {
			Oc = Ptr[1];
			Cc = Ptr[2];
			continue; }
		p = Buffer;
		for(;;) switch(*p++ = *Ptr++) {
			case 0 :
				if(!Ifile)	{ Ifile = p1;	goto ex1; }
				if(!Ofile)	{ Ofile = p1;	goto ex1; }
	help:		abort(Help);
			case '=' :
				if(Ntop >= NAMES)
					abort("Too many symbols");
				*(p-1) = 0;
				Names[Ntop] = add_pool(Buffer);
				Text[Ntop++] = add_pool(Ptr);
				goto ex1; } ex1: }
	if(!Ifile) goto help;
				
	get_date(&Day, &Month, &Year);
	get_time(&Hour, &Minite, &Second);

	IOB_size = 4096;

	fpi = fopen(Ifile, "rvq");
	fpo = Ofile ? fopen(Ofile, "wvq") : stdout;

	while(fgets(Ptr = Buffer, sizeof(Buffer)-1, fpi)) {
		while(c = *Ptr++) {
			if(c != Oc) {
				putc(c, fpo);
				continue; }
			// Possible name
			p = Temp;
			while(*Ptr != Cc) {
				if(!*Ptr)
					goto nosub;
				*p++ = *Ptr++; }
			*p = 0;
			if(strbeg(Temp, "%TIME%")) {
				if(xtime(Temp+5))
					goto nosub;
				++Ptr;
				goto ex2; }
			for(i=0; i < Ntop; ++i) {
				if(!strcmp(Names[i], Temp)) {
					fputs(Text[i], fpo);
					++Ptr;
					goto ex2; } }
nosub:		putc(Oc, fpo);
			fputs(Temp, fpo);
ex2:		}
		putc('\n', fpo); }
					
	fclose(fpo);
	fclose(fpi);
}
