#include <stdio.h>
#include <window.h>
#include <file.h>
#include <setjmp.h>

#define	SCREEN	384
#define	LINE	16

unsigned
	Seg,					// Segment
	Ablock = -1,			// Active block
	ScanSize,				// Scan block size
	Offset,					// Offset into screen
	MaxOff,					// Maximum offset
	Size[2],				// Size of file
	HiL[2] = { -1, -1 },	// Highlite low address
	HiH[2],					// Highlite high address
	Pos[2],					// Position in file
	End[2],					// End of file
	Scan[2];				// Scan position

HANDLE
	Fh,						// File access handle
	Fh1;					// ""

struct WINDOW
	*Mwin,					// Main window
	*Swin;					// Status window

unsigned char
	*Ptr,					// General pointer
	*File,					// Filename
	Update,					// Update mode (0=None, 1=Hex, 2=Text)
	CutMode = 255,			// Modified cut mode
	Status,					// Status entry
	ScanCase = 255,			// String case sensitivity
	ScanMask,				// Scanning mask
	ScanBuf[128],			// Scan block top
	OutFile[65],			// Output file
	Temp[256];				// Temp storage buffer

jmp_buf Jump;

unsigned
	L1[2] = { 1, 0 };

unsigned char Hello[] = { "\n\
heXView by Dave Dunfield - "#__DATE__"\n" };

unsigned char CmdHelp[] = { "\n\
Use: XV filename [options]\n\n\
opts:	/F	= use First select mode\n\
	/K	= display function Key help\n\
	/P	= Patch mode (edit file)\n\
	A=addr	= display specified Address\n\
" };

unsigned char	Help[] = { "\n\
   F1 = go to address                   Left = Move back one byte\n\
   F2 = find string   [from top ]      Right = Advance one byte\n\
   F3 = find hex data [of screen]         Up = Move back one line\n\
   F4 = find next                       Down = Advance one line\n\
   F5 = select low bound                PgUp = Move back one screen\n\
   F6 = select high bound               PgDn = Advance one screen\n\
   F7 = show/clear selected region      Home = go to start of file\n\
   F8 = save selected region to file     End = go to end of file\n\
   F9 = toggle case sensitivity        ^Home = Align to 16-byte boundary\n\
  F10 = Exit                            ^End = toggle last/first select\n\
\n\
LAST    F6 sets HIGH bound to last byte shown on screen.\n\
select: End-of-file view is full screen.\n\
        Easiest to select as screen shows block being selected, however you\n\
        may not be able to select desired position in end-of-file view.\n\n\
FIRST   F6 sets HIGH bound to first byte shown on screen.\n\
select: End-of-file view is a single byte.\n\
        Allows you to set block end at ANY position - but more fiddly.\n\
"};

/*
 * Update status line
 */
register status(unsigned args)
{
	unsigned char buf[81];
	_format_(nargs() * 2 + &args, buf);
	wclwin();
	wputs(buf);
	Status = 0x55;
}

// Read block into file
void readseg(seg) asm
{
		MOV		AX,4[BP]				; Get segment
		CMP		AX,DGRP:_Ablock			; Does it match?
		JZ		rse2					; Yes, exit
		MOV		DGRP:_Ablock,AX			; Resave
		MOV		BX,DGRP:_Fh				; Get handle
		MOV		CX,AX					; CX = upper address (Seg)
		XOR		DX,DX					; DX = lower address (0)
		MOV		AX,4200h				; Seek absolute
		INT		21h						; Ask DOS
		MOV		BX,DGRP:_Fh				; Get handle
		PUSH	BX						; Save
		MOV		CX,32768				; Read 32k
		XOR		DX,DX					; At offset zero
		MOV		DS,DGRP:_Seg			; Point to segment
		MOV		AH,3Fh					; Read file
		INT		21h						; Ask DOS
		POP		BX						; Restore handle
		JC		rse1					; Error
		MOV		CX,32768				; Read 32k
		MOV		DX,CX					; At 32k
		MOV		AH,3Fh					; Read file
		INT		21h						; Ask DOS
rse1:	PUSH	CS						; Save CS
		POP		DS						; Restore our DS
rse2:
}

// Display running status for scan/write
void scanstat(void)
{
	wprintf("\r%04x", Ablock);
	if(kbtst() == 0x1B)
		longjmp(Jump, "Aborted!");
}

// Write block to file
void writeseg(offset, size) asm
{
		MOV		CX,4[BP]			; Get size
		MOV		DX,6[BP]			; Get offset
		MOV		BX,DGRP:_Fh1		; Get handle
		MOV		DS,DGRP:_Seg		; Get segment
		MOV		AH,40h				; Write file
		INT		21h					; Ask DOS
		PUSH	CS					; Get our segment
		POP		DS					; Restore DS
		CALL	_scanstat			; Display status
}

// Scan for string in segment
void scan(void) asm
{
		MOV		SI,DGRP:_Scan			; Get low address
		MOV		DX,DGRP:_Scan+2			; Get high address
		MOV		AH,DGRP:_ScanMask		; Set mask
		XOR		BX,BX					; Zero offset
		CALL	lds						; Load segment
; Scan for data
sc1:	MOV		AL,ES:[SI]				; Get byte from dest
		CMP		AL,'a'					; Lower?
		JB		sc1a					; No
		CMP		AL,'z'					; Upper?
		JA		sc1a					; No
		AND		AL,AH					; Convert
sc1a:	CMP		AL,DGRP:_ScanBuf[BX]	; Does it match?
		JNZ		sc3						; No, skip to next
		INC		SI						; Advance dest
		JNZ		sc2						; No carry
		CALL	ldsi					; Advance
sc2:	INC		BX						; Advance source
		CMP		BX,DGRP:_ScanSize		; Are we over?
		JB		sc1						; And continue
		JMP short sc5					; Exit
sc3:	XOR		BX,BX					; Reset offset
		INC		SI						; Advance
		JNZ		sc1						; No wrap
		CALL	ldsi					; Advance to next
		JMP short sc1					; And continue
; Load next segment into
ldsi:	INC		DX						; Advance to next segment
lds:	CMP		DX,DGRP:_Size+2			; Are we over?
		JA		sc4						; Yes, stop
		PUSH	SI						; Save SI
		PUSH	AX						; Save AX
		PUSH	BX						; Save BX
		PUSH	DX						; Save DX
		CALL	_readseg				; Read the data
		CALL	_scanstat				; Update status
		POP		DX						; Restore DX
		POP		BX						; Restore BX
		POP		AX						; Restore AX
		POP		SI						; Restore SI
		MOV		ES,DGRP:_Seg			; Point to segment
		RET
sc4:	POP		AX						; Clear return
sc5:	MOV		DGRP:_Scan,SI			; Save position
		MOV		DGRP:_Scan+2,DX			; And continue
}

// Set cursor based on mode
void wcursoroff(void)
{
	if(!Update)
		wcursor_off();
}

// Convert an ASCII-hex nibble
unsigned hnib(unsigned c)
{
	if((c >= '0') && (c <= '9')) return	c - '0';
	if((c >= 'a') && (c <= 'f')) return	c - ('a'-10);
	if((c >= 'A') && (c <= 'F')) return c - ('A'-10);
	return 255;		// Invalid
}

/*
 * Get a hex value from the input line
 */
int hex(unsigned v[2], unsigned digits)
{
	unsigned c, d, n, b;

	longset(v, n=b=0);
	for(;;) {
		if(b) {
			c = b & 255;
			b >>= 8; }
		else
			c = wgetc();
		switch(d = c) {
		case 0x1B:		// Escape - abort
			return -1;
		case _KBS:		// Backspace
			if(n) {
				wputs("\b \b");
				longshr(v);
				longshr(v);
				longshr(v);
				longshr(v);
				--n;
				continue; }
			return -2;
		case _KHO:
		case _KPU:
			return -3;
		case '\n':		// Enter - accept
			return n;
		case '\'':
			wputc(c);
			c = wgetc();
			wputs("\b \b");
			if(c & 0xFF00)
				continue;
			if((b = (c >> 4) + '0') > '9')
				b += 7;
			if((d = (c & 15) + '0') > '9')
				d += 7;
			b |= (d << 8);
			continue; }

		if(digits) {
			if((c = hnib(c)) > 15)
				continue;

			wputc(d);
			longshl(v);
			longshl(v);
			longshl(v);
			longshl(v);
			*v |= c;
			if(++n >= digits)
				break; } }
	return n;
}

// Input hex value
unsigned hexstring(unsigned char *prompt, unsigned length)
{
	unsigned p, v[2];
	wcursor_line();
clr:
	status("%s?", prompt);
	p = 0;
	while(p < ScanSize)
		wprintf("%02x ", ScanBuf[p++]);
	for(;;) {
		switch(hex(v, (p < length) * 2)) {
		case -1 :		// Escape
			p = 0;
			goto exit;
		case -2 :		// Backspace
			if(p) {
				wputs("\b\b\b   \b\b\b");
				--p; }
			continue;
		case -3:
			ScanSize = 0;
			goto clr;
		default:
			ScanBuf[p++] = *v;
			wputc(' ');
			continue;
		case 1 :
			ScanBuf[p++] = *v;
		case 0 : exit:
			wcursoroff();
			return p; } }
}

// Draw the screen
void draw_screen()
{
	unsigned c, e, i, j, m, l[2], l1[2];
	unsigned char x[16], xa[16];

	longcpy(l, Pos);
	e = 16;
	readseg(l[1]);
	W_OPEN = Mwin;
	m = *l;
	for(i=0; i < 24; ++i) {
		wgotoxy(0, i);
		longcpy(l1, Size);
		longsub(l1, l);
		if(!longtst(l1)) {
//			wcleol();
//			continue; }
			wcleow();
			break; }
		e = 16;
		if(!l1[1])
			e = *l1;
		if(e > 16)
			e = 16;
		wprintf("%04x%04x ", l[1], *l);
		for(j=0; j < e; ++j) {
			if(!(j & 3))
				wputc(' ');
			xa[j] = *W_OPEN =
				( (longcmp(l, HiL) >= 0) && (longcmp(l, HiH) < 0) )
				? 0x1E : 0x17;
			wprintf(" %02x", x[j] = peek(Seg, *l));
			if(!++*l)
				readseg(++l[1]); }
		*W_OPEN = 0x17;
		while(j < 16) {
			if(!(j & 3))
				wputc(' ');
			wputs("   ");
			++j; }
		wputs("   ");
		for(j=0; j < e; ++j) {
			c = x[j];
			if((c < ' ') || (c > '~'))
				c = 0xF9;
			*W_OPEN = xa[j];
			wputc(c); }
		*W_OPEN = 0x17;
		while(j++ < 16)
			wputc(' '); }
	MaxOff = *l - m;
	W_OPEN = Swin;
}

// Display "toggle" field in status line
void statfield(unsigned char v, unsigned char *s)
{
	*Swin = v ? 0x70 : 0x74;
	wputs(s);
	*Swin = 0x70;
}

// Update cursor to edit position
void upcursor(unsigned mode)
{
	unsigned i;
	i = Offset & 15;
	switch(mode) {
	case 1 :		// Hex
		w_gotoxy((i*3)+(i>>2)+11, Offset >> 4, Mwin);
		return;
	case 2 :		// Text
		w_gotoxy(i+64, Offset >> 4, Mwin); }
}

void setoffset(void)
{
	if(longcmp(Pos, End) > 0)
		Offset = *Pos - *End;
	else
		Offset = 0;
}

	
main(int argc, char *argv[])
{
	unsigned i, j, k, lk, l[2], l1[2];

	for(i=1; i < argc; ++i) {
		Ptr = argv[i];
		switch((toupper(*Ptr++) << 8) | toupper(*Ptr++)) {
		case '-F' :
		case '/F' : CutMode = 0;			continue;
		case '-P' :
		case '/P' : Update = 1;				continue;
		case '-K' :
		case '/K' :
			fputs(Hello, stdout);
			fputs(Help, stdout);
			return;
		case 'A=' : atol(Ptr, Pos, 16);		continue;
		} if(File)
			goto chelp;
		File = Ptr-2; }

	if(!File) { chelp:
		fputs(Hello, stderr);
		abort(CmdHelp); }

	Seg = alloc_seg(4096);

	if(find_first(File, 0x3F, ScanBuf+16, &Size[1], &Size[0], &i, &i, &i)) {
no:		printf("Unable to open: %s\n", File);
		exit(-1); }
	if(!(Fh = open(File, Update ? F_READ|F_WRITE|F_BINARY : F_READ|F_BINARY)))
		goto no;
	if(!longtst(Size))
		Update = 0;

	Mwin = wopen(0, 0, 80, 24, WSAVE|WCOPEN|0x17);
	Swin = wopen(0, 24, 80, 1, WSAVE|WCOPEN|0x70);
	wcursoroff();

	status("%04x%04x  heXView by Dave Dunfield - "#__DATE__" - Press '?' for help",
		Size[1], *Size);

	if(Ptr = setjmp(Jump)) {
		status(Ptr);
		if(Fh1) {
			close(Fh1);
			Fh1 = 0; }
		goto redraw; }

reend:
	longset(l, CutMode ? SCREEN-LINE : 1);
	if(longcmp(Size, l) <= 0)
		longset(End, 0);
	else {
		longcpy(End, Size);
		longsub(End, l); }

redraw:
	if(longcmp(Pos, End) > 0)
		longcpy(Pos, End);
	lseek(Fh, Pos[1], *Pos, 0);
	draw_screen();
	longcpy(l, Pos);
	for(;;) {
		if(Status) {
			if(Status == 0x55)
				Status = 255;
			else {
				status("%04x%04x   1=Go  ", Size[1], *Size);
				statfield(ScanCase, "2=fST");
				wputs(" 3=fHX 4=fNX  5=sLO ");
				statfield(CutMode, "6=sHI");
				wputs(" 7=sSC 8=sWF  9=tCS  10=Quit");
				Status = 0; } }
repos:
		lk = k;
		if(Offset >= MaxOff)
			Offset = MaxOff - 1;
		upcursor(Update);
rekey:	k = w_getc(Mwin);
		if(Update) switch(k) {
			case _CPU:
			case _CPD:
				Update = (Update & 1) + 1;
				goto repos;
			case _KLA:
				if(Offset--) goto repos;
				Offset = 0; // 383;
				break;
			case _KRA: right:
				if(++Offset < 384) goto repos;
				Offset = 383; // 0;
				break;
			case _KUA:
				if(Offset < 16) break;
				Offset -= 16; goto repos;
			case _KDA:
				if(Offset >= (368)) break;
				Offset += 16; goto repos; }
		switch(k) {
//default: status("%04x", k); continue;
		case _KLA: i = 1;		goto xsub;
		case _KUA: i = LINE;	goto xsub;
		case _KPU: i = SCREEN;
xsub:		longcpy(l1, Pos);
			longset(l, i);
			longsub(Pos, l);
			if(longcmp(Pos, l1) >= 0)
				longset(Pos, 0);
			goto redraw;
		case _KRA: i = 1;		goto xadd;
		case _KDA: i = LINE;	goto xadd;
		case _KPD: i = SCREEN;
xadd:		longset(l, i);
			longadd(Pos, l);
			goto redraw;
		case _KHO: longset(Pos, Offset = 0);			goto redraw;
		case _KEN: longcpy(Pos, Size); Offset = 384;	goto redraw;
		case _CHO: *Pos &= 0xFFF0;						goto redraw;
		case _K1:											// Goto
			status("Goto?");
			if(hex(l, 8) > 0) {
				longcpy(Pos, l);
				setoffset(); }
			wcursoroff();
			goto redrawXS;
		case _K2:											// Find string
			status("String?");
			for(Ptr = ScanBuf; i = *Ptr; ++Ptr) {
				if((i < ' ') || (i > '~')) {
					*ScanBuf = 0;
					break; } }
			i = wgets(Swin->WINcurx, 0, ScanBuf, 80-Swin->WINcurx);
			wcursoroff();
			Status = 255;
			if(i == 0x1B)
				continue;
			ScanSize = strlen(ScanBuf);
			ScanMask = 0xFF;
			if(ScanCase) {
				strupr(ScanBuf);
				ScanMask = 0xDF; }
			goto ds1;
		case _K3:											// Find HEX
			ScanMask = 0xFF;
			ScanSize = hexstring("Hex", 25);
			ScanBuf[ScanSize] = 0;
ds1:		longcpy(Scan, Pos);
			goto doscan;
		case _K4:											// Find hext
			longset(l, 1);
			longadd(Scan, l);
doscan:		if(!ScanSize) {
				Status = 255;
				goto redraw; }
			status("-------- Scanning...");
			scan();
			if(longcmp(Scan, Size) > 0) {
				status("Not found!");
				goto redraw; }
			longcpy(HiH, Scan);
			longset(l, ScanSize);
			longsub(Scan, l);
			longcpy(HiL, Scan);
			if(longcmp(Pos, HiL) > 0)
				goto goxx;
			longset(l, SCREEN);
			longadd(l, Pos);
			if(longcmp(l, HiH) >= 0)
				goto redrawXS;
goxx:		longcpy(Pos, Scan);
			setoffset();
redrawXS:	Status = 255;
			goto redraw;
		case _K5:											// Select LO
			longcpy(HiL, Pos);
			if(longcmp(HiH, HiL) <= 0) {
				longcpy(HiH, HiL);
				longadd(HiH, L1); }
			goto shoHL;
		case _K6:											// Select HI
			if(CutMode) {
				longset(HiH, SCREEN);
				longadd(HiH, Pos);
				if(longcmp(HiH, Size) > 0)
					longcpy(HiH, Size);
			} else {
				longcpy(HiH, Pos);
				longadd(HiH, L1); }
			if(longcmp(HiH, HiL) <= 0) {
				longcpy(HiL, HiH);
				if(longtst(HiL))
					longsub(HiL, L1); }
			goto shoHL;
		case _K7:											// Show/clear
			if(lk == _K7) {
				longset(HiH, 0);
				HiL[1] = *HiL = -1; }
shoHL:		if(longcmp(HiL, HiH) >= 0)
				status("No selection");
			else {
				longcpy(l, HiH);
				longsub(l, L1);
				longcpy(l1, HiH);
				longsub(l1, HiL);
				ltoa(l1, Temp, 10);
				status("%04x%04x-%04x%04x (%s bytes)", HiL[1], *HiL, l[1], *l, Temp);
				if(k == _K7)
					wputs(" - F7 to clear"); }
			goto redraw;
		case _K8 :											// Save file
			if(longcmp(HiL, HiH) >= 0)
				goto shoHL;
			status("File?");
			i = wgets(Swin->WINcurx, 0, OutFile, 64);
			wcursoroff();
			Status = 255;
			if(i == 0x1B)
				continue;
			if(!(Fh1 = open(OutFile, F_WRITE|F_BINARY))) {
				status("Can't write: %s", OutFile);
				continue; }
			longcpy(l, HiL);	// L = address
			readseg(l[1]);
			status("-------- Writing...");
			if(l[1] == HiH[1]) 	// Within one segment
				writeseg(*l, *HiH-*l);
			else {
				// Write first partial segment
				if(*l)
					writeseg(*l, 0-*l);
				// Write full segments in-between
				while(l[1] < HiH[1]) {
					readseg(l[1]);
					writeseg(0, 32768);
					writeseg(0x8000, 32768);
					++l[1]; }
				// Write last partial segment
				if(*HiH) {
					readseg(l[1]);
					writeseg(0, *HiH); } }
			close(Fh1);
			Fh1 = 0;
			longcpy(l, HiH);
			longsub(l, HiL);
			ltoa(l, Temp, 10);
			status("Wrote %04x%04x (%s) bytes", l[1], *l, Temp);
			continue;
		case _K9 :
			ScanCase = ScanCase ? 0 : 255;
			Status = 255;
			continue;
		case _CEN :
			CutMode = CutMode ? 0 : 255;
			Status = 255;
			longcpy(Pos, Size);
			Offset = 383;
			goto reend;
		case _K10 :
			wclose();
			wclose();
			close(Fh);
			return;
		case '?' :
			if(Update != 2) {		// Only View/Non-Text
				W_OPEN = Mwin;
				wclwin();
				wputs(Hello);
				wputs(Help);
				if(Update)
					wputs("\n^PgUp/^PgDn = Toggle Hex/Ascii (Patch mode only)\n");
				W_OPEN = Swin;
				status("Press any key");
				wgetc();
				goto redrawXS; }
		default:
			if(k & 0xFF00) goto rekey;
			switch(Update) {
			case 1 :		// Hex mode
				if((i = hnib(k)) > 15) goto rekey;
				w_putc(k, Mwin);
				k = w_getc(Mwin);
				if((j = hnib(k)) > 15) goto redraw;
				k = (i << 4) | j;
			case 2 :		// Text mode
				longset(l, Offset);
				longadd(l, Pos);
				lseek(Fh, l[1], *l, 0);
				write(&k, 1, Fh);
				upcursor(1);
				w_printf(Mwin, "%02x", k);
				upcursor(2);
				w_putc(((k >= ' ') && (k < 0x7F)) ? k : 0xFA, Mwin);
				Ablock = -1;
				k = _KRA;
				goto right;
			default: goto rekey; } } }
}
