#include <stdio.h>
#include <file.h>
#include <window.h>
#include <comm.h>
#define	LFN_FIND
#define	LFN_MKDIR
#define	LFN_OPEN
//#define	LFN_GET_SHORT
#include <lfn.ch>


#define	RC_NOFILE	2		// File not found
#define	RC_NODIR	3		// Directory not found
#define	RC_EXISTS	5		// Directory already exists
#define	RC_NOMORE	18		// No more files

#define	TICK		peekw(0x40,0x6C)		// BIOS tick
unsigned
	Aseg, Atop,				// Attribute segment
	Dseg, Dtop,				// Directory segment
	Nseg, Ntop,				// Name segment
	Lseg, Ltop,				// Log segment
	Cport = 1,				// COM port
	DiskID = 1,				// Disk identification
	Dsize[4],				// Directory size
	Csize[4],				// Copied size
	Ctop,					// Top of COM buffer
	Cstate,					// COM state
	Ctime = 10,				// COM timeout
	Line,					// Input line number
	CDon,					// Check disk ON reading
	CDoff,					// Check disk OFF reading
	Time, Date,				// File timestamp
	Day, Month, Year,		// Current date
	Hour, Minite, Second;	// Current time
unsigned char
	*Ptr,					// General pointer
	*Send,					// Source path end pointer
	*Dend,					// Destination path end pointer
	ERRcom = 255,			// COM error
	Abflag,					// Abort flag
	Cecho,					// COM echo
	Ewait,					// Wait on error
	FullCopy,				// Perform full copy
	Dest[128],				// Destination
	Spath[260],				// Source path
	Dpath[260],				// Destination path
	Cbuffer[64],			// Comm command buffer
	Temp[4096],				// Temporary name
	Error,					// Error encountered flag
	CDrom = 'F',			// Active CDROM drive
	Critical;				// Critical error counter

unsigned
	L1[2] = { 1, 0 };

unsigned
	PickupMotor = 1,
	PickupEndSensor = 3,
	PickupSolinoid = 11,
	PickupBin = 3000,
	PickupTray = 1000,
	PickupCal = 150,
	RampMotor = 2,
	RampAccept = 3000,
	RampReject = 5000,
	RampCal = 500,
	SetupTray = 500,
	SetupBin = 1500,
	AlarmSolinoid = 12,
	IRoutput = 13,
	IRdetect = 0,
	IRthreshold = 500;
unsigned *IniVars[] = {
	&PickupMotor,			// 2
	&PickupEndSensor,		// 3
	&PickupSolinoid,		// 4
	&PickupBin,				// 5
	&PickupTray,			// 6
	&PickupCal,				// 7
	&RampMotor,				// 8
	&RampAccept,			// 9
	&RampReject,			// 10
	&RampCal,				// 11
	&SetupTray,				// 12
	&SetupBin,				// 13
	&AlarmSolinoid,			// 14
	&IRoutput,				// 15
	&IRdetect,				// 16
	&IRthreshold };			// 17

struct WINDOW *Mwin, *Swin;

struct LFN Lfn;

void Sskip();
void Dskip();
void tty(void);
void dump_log(void);
register Ccmd(unsigned args);
void Astring(seg, string);
unsigned peekw(unsigned s, unsigned off);

// Display an error message
register error(unsigned args)
{
	unsigned t;
	unsigned char *p, ec, buf[81];

	_format_(nargs() *2+&args, p=buf);
	ec = ERRcom;
	ERRcom = 0;

	if(Ltop)
		dump_log(255);
	if(*p == '~')		// Do not wait
		++p;
	else if(Ewait) {
		wprintf("\n%u: %s\n", Line, p);
		wputs("Press any key.\n");
		if(ec) {
			Ccmd("R");
			Ccmd("N%u", AlarmSolinoid); }
		t = 25*120;
		do {
			delay(500);
			wprintf("\r%u", t);
			if(wtstc())
				break; }
		while(--t);
		if(ec)
			Ccmd("F%u", AlarmSolinoid); }
	if(Mwin) {
		Cclose();
		while(W_OPEN)
			wclose(); }
	printf("%u: %s\n", Line, p);
	exit(-1);
}

int tstabt()
{
	switch(wtstc()) {
	case 0x03:
		Ccmd("R");
		error("~^C");
	case 0x1B:
	case _K10: Abflag = 0xFF; break;
	case _K1 : Abflag = 0x0F; }
	return Abflag;
}

register status(unsigned args)
{
	unsigned char buf[81];
	_format_(nargs() * 2 + &args, buf);
	w_clwin(Swin);
	w_puts(buf, Swin);
}

// Display a LOG message
register log(unsigned args)
{
	unsigned char buf[512];
	_format_(nargs() *2 + &args, buf+1);
	buf[0] = '\n';
	Astring(&Lseg, buf);
	--Ltop;
	wputs(buf);
}

int getkey(void)
{
	int c;
	if((c = wgetc()) == 0x03) {
		Ccmd("R");
		error("~^C"); }
	return toupper(c);
}

// Skip ahead to non-blank
int skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

int parse(unsigned char *dest, unsigned char t)
{
	unsigned l;
	l = 0;
	skip();
	while(*Ptr != t) {
		if(isspace(*Ptr)) {		// Blanks at end
			if(!t)				// No terminator, this is the end
				break;
			if(skip() == t)		// See if terminator present
				break; }
		if(!*Ptr)
			error("Missing '%c'", Line, t);
		dest[l++] = toupper(*Ptr++); }
	if(t)
		++Ptr;
	dest[l] = 0;
	return l;
}

// Put string conditionally to file (if open)
void Cput(FILE *fp)
{
	if(fp)
		fputs(Temp, fp);
}

// Dump the pending log records
void dump_log(unsigned char header)
{
	unsigned i, j;
	FILE *lfp, *efp;

	strcpy(Dend = Dpath, Dest);
	Dskip();
	if(*(Dend - 1) != '\\')
		*Dend++ = '\\';
	sprintf(Dend, "%02u%02u%02u\\%02u%02u%02u",
		Year%100, Month, Day, Year%100, Month, Day);
	Dskip();
	strcpy(Dend, ".LOG");
	if(!FullCopy)
		return;
	lfp = fopen((FullCopy == 0x55) ? "DRYRUN.LOG" : Dpath, "wavq");
	putc('\n', lfp);
	efp = 0;
	if(Error) {
		strcpy(Dend, ".ERR");
		efp = fopen((FullCopy == 0x55) ? "DRYRUN.ERR" : Dpath, "wav");
		putc('\n', efp); }
	if(header) {
		sprintf(Temp, "Disk %u %02u:%02u:%02u", DiskID, Hour, Minite, Second);
		Cput(lfp);
		Cput(efp); }
	for(i=j=0; i < Ltop; ++i) {
		if(j >= (sizeof(Temp)-1)) {
			Temp[j] = 0;
			Cput(lfp);
			Cput(efp);
			j = 0; }
		Temp[j++] = peek(Lseg, i); }
	Temp[j] = Ltop = 0;
	Cput(lfp);
	Cput(efp);
	if(efp) { putc('\n', efp); fclose(efp); }
	putc('\n', lfp);
	fclose(lfp);
}

// Check to see if drive is ready
int CheckCD(void)
{
	Critical = 0;
	asm {
		MOV		AH,36h				// Get drive information
		MOV		DL,DGRP:_CDrom		// Get drive letter
		SUB		DL,40h				// Convert to 1...
		INT		21h					// Ask DOS
		XOR		AH,AH				// Zero high
		MOV		AL,DGRP:_Critical	// Report critical errors
	}
}
asm {	// Critical error handler - record CRIT count
INT24:	PUSH	DS
		PUSH	CS
		POP		DS
		INC		byte ptr DGRP:_Critical
		POP		DS
		MOV		AL,3		// Always fail
		IRET
}

// Set timestamp for file
int touch(handle, time, date) asm
{
		MOV		DX,4[BP]		// Get date
		MOV		CX,6[BP]		// Get time
		MOV		BX,8[BP]		// Get handle
		MOV		AX,5701h		// Set date & time function
		INT		21h				// Ask DOS
		JNC		trz				// Success
		MOV		AX,1			// Report fail
		POP		BP
		RET
trz:	XOR		AX,AX
}

void Sskip() { while(*Send) ++Send; }		// Skip to end of source path
void Dskip() { while(*Dend)	++Dend; }		// Skip to end of dest path

// Create a directory and check return code
void Mkdir(unsigned char *n)
{
	int r;
	log("Mkdir: %s", n);
	if(FullCopy != 0x55) {
		switch(r = lfn_mkdir(n)) {
		default:
			Error = 255;
			log("mkdir fail %u", r);
		case 5 :
		case 0 : ; } }
}

// Strip undesirable characters from path
void strip(unsigned char *p)
{
	unsigned char *p1, c;
	p1 = p;
	while(c = *p++) {
		if((c >= ' ') && (c <= 0x7F))
			*p1++ = c; }
	*p1 = 0;
}

// Copy a file from Spath to Dpath
void copy_file()
{
	unsigned i, j, k, r, hr, hw;
	unsigned char c;

	log("Copy: %s", Spath);
	if(FullCopy == 0x55)
		return;

	Csize[3] = Csize[2] = Csize[1] = Csize[0] = 0;
	if(!(hr = lfn_open(Spath, F_READ))) {
		if(*(Temp+1024)) {		// Short name available
			strcpy(Send, Temp+1024);
			if(hr = lfn_open(Spath, F_READ)) {
				strip(Dend);
				goto ok; } }
		Error = 255;
		log("Can't open source");
		return; }
ok:
	if(!(hw = lfn_open(Dpath, F_WRITE))) {
		Error = 255;
		log("Can't open dest");
		goto quit2; }

	j = 256;
	k = 79;
	c = 0;
	do {
		if(i = read(Temp, sizeof(Temp), hr)) {
			if(r = write(Temp, i, hw)) {
				Error = 255;
				log("Write error %u", r);
				goto quit1;  } }
			i; asm {
			add word ptr DGRP:_Csize,ax
			adc word ptr DGRP:_Csize+2,0
			adc word ptr DGRP:_Csize+4,0
			adc word ptr DGRP:_Csize+6,0
			}
			if(!--j) {
				if(r = tstabt()) switch(r) {
					case 0xFF:
						Error = 0x55;
						log("Stopped by operator");
						goto quit1;
					case 0x0F:
						Error = 255;
						log("Skipped by operator");
						Abflag = 0;
						goto quit1; }
				if(!c) {
					wputc('\n');
					c = '*'; }
				wputc(c);
				j = 256;
				if(!--k) {
					k = 79;
					wputc('\r');
					c = (c == '*') ? '-' : '*'; } } }
	while(i == sizeof(Temp));
	if(c) {
		wputc('\r');
		wcleol(); }
	if(	(Dsize[0] != Csize[0]) || (Dsize[1] != Csize[1])
	||	(Dsize[2] != Csize[2]) || (Dsize[3] != Csize[3]) ) {
		Error = 255;
		log("Copy size error %04x%04x%04x%04x %04x%04x%04x%04x",
			Dsize[3], Dsize[2], Dsize[1], Dsize[0],
			Csize[3], Csize[2], Csize[1], Csize[0]); }
	touch(hw, Time, Date);
quit1:
	close(hw);
quit2:
	close(hr);
}

// Report a segment overflow
void segover(void)
{
	abort("Segment overflow");
}

/*
 * Add string to segment
 */
void Astring(seg, string) asm
{
		MOV		BX,6[BP]		// Segment pointer
		MOV		ES,[BX]			// Get segment
		MOV		DI,2[BX]		// Get dest
		MOV		SI,4[BP]		// Get source
as1:	MOV		AL,[SI]			// Get from source
		INC		SI				// Next
		MOV		ES:[DI],AL		// Write to dest
		INC		DI				// Next
		AND		AL,AL			// End of string?
		JNZ		as1				// Keep going
		CMP		DI,2[BX]		// Overflow?
		JA		as2				// It's OK
		CALL	_segover		// Report overflow
as2:	MOV		2[BX],DI		// Resave
}

/*
 * Get string from segment
 */
unsigned Gstring(seg, source, string) asm
{
		MOV		ES,8[BP]		// Get segment
		MOV		SI,6[BP]		// Get source
		MOV		DI,4[BP]		// Get dest
gs1:	MOV		AL,ES:[SI]		// Get from source
		INC		SI				// Next
		MOV		[DI],AL			// Write to dest
		INC		DI				// Next
		AND		AL,AL			// End?
		JNZ		gs1				// Keep going
		MOV		AX,SI			// Return source
}

// Check for unwanted file extensions
check_unwanted(unsigned char *p)
{
	unsigned i;
	unsigned char c, *p1, *p2;
	static unsigned char *utype[] = {
		"NFO",
		0 };
	p1 = 0;
	p2 = p;
	while(c = *p2++) {
		if(c == '.')
			p1 = p2;
		if((c > 0x7F) || (c < 0x20))
			log("[%02x]%s", c, p); }
	if(p1) {
		p = Temp;
		while(*p++ = toupper(*p1++));
		for(i=0; p = utype[i]; ++i) {
			if(!strcmp(Temp, p))
				return 255; } }
	return 0;
}

// Copy complete directory structure
void copy_dir()
{
	unsigned i, dir;
	unsigned char *sbase, *dbase;
	static unsigned j, k;
	static int rc;
	static unsigned char *p;


	Atop = Ntop = 0;
	*(sbase = Send) = 0;
	*(dbase = Dend) = 0;
	dir = Dtop;
//	log("Source: %s", Spath);
	strcpy(Send, "*.*");

	// Scan source and record files/directories
	if(rc = lfn_find_first(Spath, 0xFF, Lfn)) {
		if((rc != RC_NOFILE) && (rc != RC_NOMORE)) {
			Error = 255;
			log("Unable to read source path, RC=%u", rc);
			goto doexit; } }
	else {
//printf("\n%02x %s", Lfn.Attrib, Lfn.Lname);
		do {
			if(Lfn.Attrib & VOLUME) {
				continue; }
			if(Lfn.Attrib & (HIDDEN|SYSTEM))
				continue;
			strcpy(Send, p = Lfn.Lname);
			if(Lfn.Attrib & DIRECTORY) {
				if(*p == '.') switch(p[1]) {	// Ignore . and ..
					case '.' :
						if(p[2])
							break;
					case 0 : continue; }
				Astring(&Dseg, p);
				continue; }
			// Add file to list
			if(check_unwanted(p)) {
				log("Skip: %s", p);
				continue; }
			poke(Aseg, i=Atop, Lfn.Attrib & 0x7F);
			pokew(Aseg, Atop+1, Lfn.Time);
			pokew(Aseg, Atop+3, Lfn.Date);
			pokew(Aseg, Atop+5, Lfn.SizeL[0]);
			pokew(Aseg, Atop+7, Lfn.SizeL[1]);
			pokew(Aseg, Atop+9, Lfn.SizeH[0]);
			pokew(Aseg, Atop+11, Lfn.SizeH[1]);
			pokew(Aseg, Atop+13, Ntop);
			Atop += 15;
			if(Atop < i)
				segover();
			Astring(&Nseg, p);
			Astring(&Nseg, Lfn.Sname); }
		while(!lfn_find_next(Lfn));
		lfn_find_close(); }

	for(i=0; i < Atop; i += 15) {	// Copy all files
		j = peekw(Aseg, i+13);
		Time = peekw(Aseg, i+1);
		Date = peekw(Aseg, i+3);
		Dsize[0] = peekw(Aseg, i+5);
		Dsize[1] = peekw(Aseg, i+7);
		Dsize[2] = peekw(Aseg, i+9);
		Dsize[3] = peekw(Aseg, i+11);
		k = Gstring(Nseg, j, Temp);
		Gstring(Nseg, k, Temp+1024);
		if(*(Send-1) != '\\')
			*Send++ = '\\';
		if(*(Dend-1) != '\\')
			*Dend++ = '\\';
		strcpy(Send, Temp);
		strcpy(Dend, Temp);
		copy_file();
		Send = sbase;
		Dend = dbase;
		if(Error == 0x55)
			goto doexit; }

	for(i=dir; i < Dtop;) {			// Copy sources
		i = Gstring(Dseg, i, Temp);
		strcpy(Send, Temp);
		strcpy(Dend, Temp);
		Sskip();
		Dskip();
		*Send++ = '\\';
		*Dend = 0;
		Mkdir(Dpath);
		*Dend++ = '\\';
		copy_dir();
		Send = sbase;
		Dend = dbase;
		if(Error == 0x55)
			goto doexit; }

doexit:
	Dtop = dir;
}

void tray_open(void)
{
	exec("C:\\CMDS\\NIRCMD.EXE", " cdrom open");
}
void tray_close(void)
{
	exec("C:\\CMDS\\NIRCMD.EXE", " cdrom close");
}

// Perform a complete disk copy
int copy_disk(void)
{
	unsigned r, i;

	// Perform single disk copy
	Ltop = 0;
	get_date(&Day, &Month, &Year);
	get_time(&Hour, &Minite, &Second);
	sprintf(Send = Spath, "%c:\\", CDrom);
	Sskip();

	status("%5u %c:\\", DiskID, CDrom);
	r = 3;
r1:	for(i=0; i < 3; ++i) {
		if(!CheckCD())
			goto dok;
		delay(5000); }
	if(--r) {
		tray_open();
		delay(5000);
		tray_close();
		goto r1; }
	error("Drive not ready, disk %u", DiskID);
dok:
	strcpy(Dend = Dpath, Dest);
	Dskip();
	if(*(Dend - 1) != '\\')
		*Dend++ = '\\';
	sprintf(Dend, "%02u%02u%02u", Year%100, Month, Day);
	if(FullCopy != 0x55)
		lfn_mkdir(Dpath);
	Dskip();
	sprintf(Dend, "\\%u\\", DiskID);
	w_puts(" to ", Swin);
	w_puts(Dpath, Swin);
	Mkdir(Dpath);
	Dskip();
	copy_dir();
	dump_log(255);
	return 0;
}

// Read the .INI file
void read_ini(void)
{
	unsigned i, j;
	FILE *fp;
	unsigned char *p;
	static unsigned char *IniCmd[] = {
		"SOURCE",			// 0
		"DESTINATION",		// 1
		"PICKUPMOTOR",		// 2
		"PICKUPENDSENSOR",	// 3
		"PICKUPSOLINOID",	// 4
		"PICKUPBIN",		// 5
		"PICKUPTRAY",		// 6
		"PICKUPCAL",		// 7
		"RAMPMOTOR",		// 8
		"RAMPACCEPT",		// 9
		"RAMPREJECT",		// 10
		"RAMPCAL",			// 11
		"SETUPTRAY",		// 12
		"SETUPBIN",			// 13
		"ALARMSOLINOID",	// 14
		"IROUTPUT",			// 15
		"IRDETECT",			// 16
		"IRTHRESHOLD",		// 17
		0 };

	fp = fopen("DVDROBOT.INI", "rvq");
	while(fgets(Ptr = Temp, sizeof(Temp), fp)) {
		++Line;
		switch(skip()) {
		case ';' :				// Comment
		case 0 : continue; }	// Null line
		parse(Spath, '=');
		for(i=0; p=IniCmd[i]; ++i) {
			if(!strcmp(Spath, p))
				goto found; }
		error("Bad INI '%s'\n", Spath);
found:	skip();
		j = 0;
		while(Ptr[j]) ++j;
		while(j && isspace(Ptr[j-1])) --j;
		Ptr[j] = 0;
		switch(i) {
		case 0 :	// DRIVE
			CDrom = toupper(*Ptr);
			if((CDrom < 'A') || (CDrom > 'Z') || (j != 1))
				error("Bad drive");
			continue;
		case 1 :	// Destination
			strcpy(Dest, Ptr);
			if(Dest[1] != ':')
				error("DESTINATION must include drive");
			continue;
		default:
			*IniVars[i-2] = atoi(Ptr); } }
	fclose(fp);
	Line = 0;
}

void tty(void)
{
	int c;
	unsigned char f;
	wclwin();
	wcursor_line();
	f = 255;
	status("TTY: F10 to exit");
	for(;;) {
		if((c = Ctestc()) != -1) {
			wputc(c);
			f = 255;
			continue; }
		if(f) {
			wupdatexy();
			f = 0; }
		if(c = wtstc())	switch(c) {
			case _K10:
				wcursor_off();
				wclwin();
				return;
			case _KBS: c = 0x08; goto go;
			case _KDL: c = 0x7F; goto go;
			case '\n' :
				c = '\r';
			default: go:
				if(!(c & 0xFF00))
					Cputc(c); } }
}

// Flush COM input
void Cflush(unsigned t)
{
	int c;
	unsigned t1;
again:
	t1 = TICK;
	do {
		if((c = Ctestc()) != -1) {
			if(Cecho)
				wputc(c);
			goto again; } }
	while((TICK - t1) <= t);
}

// Get COM character with timeout
int Cgett(unsigned t)
{
	int c;
	unsigned t1;
	t1 = TICK;
	do {
		if((c = Ctestc()) != -1) {
			if(Cecho)
				wputc(c);
			return c; } }
	while((TICK - t1) <= t);
	ERRcom = 0;
	error("COM timeout (%04x): %s", Cstate, Cbuffer);
}

// Send a command to the COM port and receive a response
register Ccmd(unsigned args)
{
	unsigned t;
	unsigned char *p, c;
	_format_(nargs() *2 + &args, p = Cbuffer);
	tstabt();
	t = 18*15;
	if(*p == '~') {
		++p;
		t = 18*60; }
	while(Ctestc() != -1);
	while(c = *p++) {
		Cstate = (unsigned)c|0x100;
		Cputc(c);
		while(Cgett(Ctime) != c); }
	Cstate = 2;
	Cputc('\r');
	c = Cgett(t);
	Ctop = 0;
	Cstate = 3;
	while(c != '>') {
		if((c >= ' ') && (c < 0x7F))
			Temp[Ctop++] = c;
		c = Cgett(Ctime); }
	Temp[Ctop] =  0;
}

// Test COM commands
int comtest()
{
	int c;
	unsigned t;
	wcursor_line();
	for(;;) {
		wputs("\nCMD>");
		*Spath = 0;
		c = wgets(W_OPEN->WINcurx, W_OPEN->WINcury, Spath, 64);
		switch(c) {
		case _K10 : return;
		default: continue;
		case 0x0A : ; }
		t = TICK;
		Ccmd(Spath);
		wprintf("\n[%s]", Temp); }
}

void calibrate(unsigned m, unsigned l)
{
	Ccmd("S%u", m);
	Ccmd("C%u", l);
	Ccmd("~W");
	if(*Temp != 'Z')	
		error("Motor %u calibrate fail", m);
}

unsigned get_position()
{
	Ccmd("P");
	if(!isdigit(*Temp))
		error("Bad position report");
	return atoi(Temp);
}

void tste(unsigned char *m)
{
	if(*Temp != 'E') {
		Ccmd("F%u", PickupSolinoid);
		error("%s not at END '%s'", m, Temp); }
}

// Check to see if a disk is present (in zero position)
int check_disk(void)
{
	Ccmd("F%u", IRoutput);
	Ccmd("A%u", IRdetect);
	if(!isdigit(*Temp))
		error("Bad ADC report1");
	CDon = atoi(Temp);
	Ccmd("N%u", IRoutput);
	Ccmd("A%u", IRdetect);
	if(!isdigit(*Temp))
		error("Bad ADC report2");
	CDoff = atoi(Temp);
	return (CDon+IRthreshold) > CDoff;
}

void disk_load(void)
{
	unsigned r;
	status("Loading disk %u", DiskID);
	Ccmd("S1");
	r = 3;
r1:	Ccmd("G%u %u", PickupBin, PickupEndSensor); Ccmd("W");
	tste("Bin pickup");
	delay(500);
	Ccmd("N%u", PickupSolinoid);
	delay(250);
	Ccmd("G%u", get_position()-40); Ccmd("W");
	Ccmd("G0"); Ccmd("W");
	if(!check_disk()) {
		Ccmd("F%u", PickupSolinoid);
		if(--r)
			goto r1;
		error("Pickup fail"); }
	tray_open();
	r = 3;
r2:	Ccmd("G%u %u", PickupTray, PickupEndSensor); Ccmd("W");
	tste("Tray drop");
	Ccmd("F%u", PickupSolinoid);
	Ccmd("G0"); Ccmd("W");
	if(check_disk()) {
		Ccmd("N%u", PickupSolinoid);
		if(--r)
			goto r2;
		Ccmd("F%u", PickupSolinoid);
		error("Tray drop fail"); }
	tray_close();
	calibrate(PickupMotor, PickupCal);
}

void disk_unload(unsigned char f)
{
	unsigned r;
	r = 3;
	status("Unloading disk %u - %s", DiskID, f ? "REJECT" : "ACCEPT");
	Ccmd("S1");
	tray_open();
r1:	Ccmd("G%u %u", PickupTray, PickupEndSensor); Ccmd("W");
	tste("Tray pickup");
	delay(500);
	Ccmd("N%u", PickupSolinoid);
	delay(250);
	Ccmd("G%u", get_position()-40); Ccmd("W");
	Ccmd("G0"); Ccmd("W");
	if(!check_disk()) {
		Ccmd("F%u", PickupSolinoid);
		if(--r)
			goto r1;
		tray_close();
		error("Disk unload fail"); }
	tray_close();
	Ccmd("S2");
	Ccmd("G%u", f ? RampReject : RampAccept); Ccmd("W");
	r = 3;
r2:	Ccmd("F%u", PickupSolinoid);
	delay(250);
	if(check_disk()) {
		if(--r) {
			Ccmd("N%u", PickupSolinoid);
			delay(250);
			goto r2; }
		error("Unload drop fail"); }
	Ccmd("G0"); Ccmd("W");
	calibrate(RampMotor, RampCal);
}

void check_space(void)
{
	unsigned char *p, *p1;
	FILE *fp;

	status("Checking drive space: ");

	sprintf(Temp, "/D/C DIR/AS/-C %c:\\ >$CS$.TMP", *Dest);
	if(exec("C:\\WINDOWS\\SYSTEM32\\CMD.EXE", Temp))
		error("execCMD fail: %s", Temp);

	if(!(fp = fopen("$CS$.TMP", "r")))
		error("open $CS$.TMP fail");
	while(fgets(Temp, sizeof(Temp)-1, fp));
	fclose(fp);
	delete("$CS$.TMP");

	p = Temp;
	while(*p) {
		if(*p++ == ')')
			break; }
	while(isspace(*p))
		++p;
	p1 = p;
	while(isdigit(*p1))
		++p1;
	*p1 = 0;
	w_puts(p, Swin);
	if((p1 - p) > 10)
		return;
	*(p1 - 6) = 0;
	if(atoi(p) < 5000)
		error("Insufficent space: %s", p);
}

void setup(void)
{
	unsigned p;
	unsigned x;
	unsigned char t;

	wclwin();
	wputs("SETUP:\n");
	calibrate(PickupMotor, PickupBin+PickupCal);
	calibrate(RampMotor, RampReject+RampCal);
	Ccmd("S%u", PickupMotor);
	x = 0x55;
	p = t = 0;
top:
	switch(x) {
	default:
		p = SetupBin;
		if(t) {
			Ccmd("G0");
			wputs("\nRemove DVD from tray - Press SPACE");
			Ccmd("W");
	k1:		switch(getkey()) {
			default: goto k1;
			case 0x1B : goto quit;
			case ' ' : ; } }
		tray_close();
		t = 0;
		break;
	case 0 :
		p = SetupTray;
		if(t != 0x55) {
			Ccmd("G0");
			wputs("\nPlace DVD in tray - Press SPACE");
			Ccmd("W");
			tray_open();
			t = 0x55;
	k2:		switch(getkey()) {
			default: goto k2;
			case 0x1B : goto quit;
			case ' ' : ; } }
	case 0x55 : ; }

	wputs("\nPosition pickup directly over DVD hole:");
	wputs("\n    Up/Down  = -/+ 100");
	wputs("\n  PgUp/PgDn  = -/+ 200");
	wputs("\n ^PgUp/^PgDn = -/+ 300");
	wputs("\n      0      = 0");
	wputs("\n      C      = Calibrate");
	wputs("\n      T      = calibrate Tray");
	wputs("\n      B      = calibrate Bin");
	wputs("\nPress ENTER when done:");
	Ccmd("W");
rp:	if(p & 0x8000)
		p = 0;
	Ccmd("G%u %u", p, PickupEndSensor);
	Ccmd("W");
	status("Posiiton: %u", get_position());
	for(;;) switch(getkey()) {
	case _KUA:	p -= 100;	goto rp;
	case _KDA:	p += 100;	goto rp;
	case _KPU:	p -= 200;	goto rp;
	case _KPD:	p += 200;	goto rp;
	case _CPU:	p -= 300;	goto rp;
	case _CPD:	p += 300;	goto rp;
	case 'C' :
		if(t) { tray_close(); t=0; }
		calibrate(PickupMotor, PickupBin+PickupCal);
		goto rp;
	case 'T' :	x = 0;		goto top;
	case 'B' :	x = 255;	goto top;
	case '0' :
		if(t) tray_close();
		p = t = 0;
		goto rp;
	case '\n' : quit:
	case 0x1B :
		Ccmd("G0");
		if(t) {
			wputs("\nRemove DVD from tray - Press SPACE");
			Ccmd("W");
	k3:		switch(getkey()) {
			default: goto k3;
			case 0x1B : return;
			case ' ' : ; }
			tray_close(); }
		return; }
}

unsigned char *Prompt[] = {
	"SSetup",
	"Fperform Full run (copy)",
	"Dperform Dry run (no copy)",
	"Mperform Motions only (no read)",
	"TTTY (controller console)",
	"LLoad disk into reader",
	"Aunload to Accept bin",
	"Runload to Reject bin",
	"Pselect Pickup motor",
	"Uselect Unload motor",
	"CCalibrate selected motor",
	"VVerify disk loaded",
	"WWait for operation to complete",
	"HHalt movement",
	"Xreset controller",
	"Echeck Empty space",
	"Qquit",
	"~0Selected motor to zero",
	"1Selected motor to Tray/Accept",
	"2Selected motor to Bin/Reject",
	"3open DVD tray",
	"4close DVD tray",
	"5activate pickup solinoid",
	"6dactivate pickup solinoid",
	"7activate alarm solinoid",
	"8deactivate alarm solinoid",
	0 };
 	
main(int argc, char *argv[])
{
	unsigned i, j, k;
	static unsigned m;
	for(i=1; i < argc; ++i) {
		Ptr = argv[i];
		switch((toupper(*Ptr++) << 8) | toupper(*Ptr++)) {
		case '/E' : Ewait = 255;		continue;
		case '/T' : Ctime = 18*3;		continue;
		} error("Unknown option: %s", Ptr-2); }

	if(!(Aseg = alloc_seg(4096*4)))
		abort("No memory");
	Lseg = (Dseg = (Nseg = Aseg + 4096) + 4096) + 4096;

	read_ini();
	lfn_init();

	asm {
		MOV		DX,offset INT24	; Address of handler
		MOV		AX,2524h		; Set interrupt24
		INT		21h				; Ask DOS
	}
	if(Copen(Cport, _19200, PAR_NO|DATA_8|STOP_1, SET_RTS|SET_DTR|OUTPUT_2))
		error("Unable to open COM%u", Cport);
	Cflags |= TRANSPARENT;
	Swin = wopen(0,24, 80,  1, WSAVE|WCOPEN|0x70);
	Mwin = wopen(0, 0, 80, 24, WSAVE|WWRAP|WSCROLL|0x17);
top:
	wclwin();
	wcursor_off();
	if(m == PickupMotor)
		status("[PICKUP]");
	else if(m == RampMotor)
		status("[RAMP]");
	else
		status("[none]");
	w_puts(" Selection?", Swin);
	*Spath = 0;
	j = 5; k = 1;
	for(i=0; Ptr = Prompt[i]; ++i) {
		if(*Ptr == '~') {
			++Ptr;
			j = 42; k = 1-i; }
		wgotoxy(j, i+k);
		wprintf("%c - %s", *Ptr, Ptr+1); }
	for(;;) switch(getkey()) {
		case 'S' : setup();				goto top;
		case 'F' : FullCopy = 255;		goto dorun;
		case 'D' : FullCopy = 0x55;		goto dorun;
		case 'M' : FullCopy = 0;		goto dorun;
		case 'T' : tty(); 				goto top;
		case 'L' : disk_load();			continue;
		case 'A' : disk_unload(0);		continue;
		case 'R' : disk_unload(255);	continue;
		case 'P' : m = PickupMotor;		goto top;
		case 'U' : m = RampMotor;		goto top;
		case 'W' : Ccmd("W");			continue;
		case 'H' : Ccmd("H");			continue;
		case 'X' : Ccmd("R"); m=0;		goto top;
		case 'E' : check_space();		continue;
		case 'C' :
			calibrate(m, (m == PickupMotor) ? (PickupBin+PickupCal) : (RampReject+RampCal));
			continue;
		case 'V' :
			j = check_disk();
			status("Disk_loaded=%u On=%u Off=%u", j, CDon, CDoff);
			continue;
		case '0' :
			Ccmd("S%u", m);
			Ccmd("G0");
			continue;
		case '1' :
			Ccmd("S%u", m);
			if(m == RampMotor)
				Ccmd("G%u", RampAccept);
			else
				Ccmd("G%u %u", PickupTray, PickupEndSensor);
			continue;
		case '2' :
			Ccmd("S%u", m);
			if(m == RampMotor)
				Ccmd("G%u", RampReject);
			else
				Ccmd("G%u %u", PickupBin, PickupEndSensor);
			continue;
		case '3' : tray_open();					continue;
		case '4' : tray_close();				continue;
		case '5' : Ccmd("N%u", PickupSolinoid);	continue;
		case '6' : Ccmd("F%u", PickupSolinoid);	continue;
		case '7' : Ccmd("N%u", AlarmSolinoid);	continue;
		case '8' : Ccmd("F%u", AlarmSolinoid);	continue;
		case 'Q' :
		case 0x1B: error("~Operator abort"); }

dorun:
	wclwin();
	wcursor_line();
	wputs("\nEnter starting DiskID?");
	switch(wgets(W_OPEN->WINcurx, W_OPEN->WINcury, Ptr = Spath, 64)) {
	default: goto dorun;
	case _K10 :
	case _KEN :
	case 0x1B :
		goto top;
	case '\n' :
		skip();
		if(!(DiskID = atoi(Ptr)))
			goto dorun; }

	wputs("\nNote?");
	*Temp = 0;
	switch(wgets(W_OPEN->WINcurx, W_OPEN->WINcury, Ptr = Temp, 64)) {
	default: goto dorun;
	case _K10 :
	case _KEN :
	case 0x1B :
		goto top;
	case '\n' : ; }

	wclwin();
	wcursor_off();
	Ltop = Error = 0;

	get_date(&Day, &Month, &Year);
	get_time(&Hour, &Minite, &Second);

	switch(FullCopy) {
	case 0 : log("Test - motions only");	break;
	case 0x55:
		log("Test - no copy");
		delete("DRYRUN.LOG");
		delete("DRYRUN.ERR"); }

	if(skip())
		log("Note: %s", Ptr);
	Cputc('\r'); Cflush(10);
	calibrate(PickupMotor, PickupBin+PickupCal);
	calibrate(RampMotor, RampReject+RampCal);
	tray_close();
	Ewait = 255;

	if(Ltop)
		dump_log(0);

	i = 1;
	for(;;) {
		Abflag = 0;
		if(tstabt() == 0xFF)
			goto top;
		Error = 0;
		disk_load();
		if(FullCopy) {
			check_space();
			delay(5000);
			if(copy_disk())
				goto top;
			delay(5000); }
		else
			Error = ++i & 1;
		disk_unload(Error);
		++DiskID; }
}
