/*
 * Dave's library functions
 *
 * I define required library functions myself, because I do not trust the
 * libraries supplied with tools to not include a pile of unneeded, slow
 * and unnecessary "crap".
 */

#if 155
// Test for received character from USART1
int Testc(void)
{
	BG();
	if(USART1_SR & (1<<5))
		return USART1_DR & 0xFF;
	return -1;
}

// Get a character from the console
int Getc(void)
{
	int c;
	while((c = Testc()) == -1);
	return c;
}

// Write 8-bit character to UART1
void Putc(unsigned char c)
{
again:
	BG();
	while(!(USART1_SR & (1<<7))) {	// Wait for TX empty
		; }
	if((USART1_DR = c) == '\n') {
		c = '\r';
		goto again; }
}
#endif

/*
 * Output a string to the UART1
 */
void Puts(char *s)
{
	while(*s)
		Putc(*s++);
}

// Determine length of string
unsigned Strlen(char *s)
{
	unsigned l;
	l = 0;
	while(s[l]) ++l;
	return l;
}

/*
 * Format to string routine, format operands are passed
 * as a pointer to the calling functions argument lists.
 */
unsigned _format_(char *output, unsigned len, const char *format, va_list optr)
{
	unsigned width, value, i;
	char justify, zero, minus, c, *ptr, *o;
	char outstk[33];

	o = output;
	while((c = *format++)) {
		if(c == '%') {					/* format code */
			c = *format++;
			*(ptr = &outstk[32]) = justify = minus = width = value = i = 0;
			zero = ' ';
			if(c == '-') {				/* left justify */
				--justify;
				c = *format++; }
			if(c == '0')					/* leading zeros */
				zero = '0';
			while((c >= '0') && (c <= '9')) {	/* Field width */
				width = (width * 10) + (c - '0');
				c = *format++; }

			value = va_arg(optr, unsigned);

			switch(c) {
			case 'd' :					/* decimal number */
				if(value & 0x80000000) {
					value = -value;
					++minus; }
			case 'u' :					/* unsigned number */
				i = 10;
				break;
			case 'x' :					/* hexidecimal number (LC) */
			case 'X' :
				i = 16;
				break;
			case 'o' :					/* octal number */
				i = 8;
				break;
			case 'b' :					/* binary number */
				i = 2;
				break;
			case 'c' :					/* character data */
				*--ptr = value;
				break;
			case 's' :					/* string */
				if(!(ptr = (char *) value))
					ptr = "";
				break;
			default:					/* all others */
//				--optr;
				*--ptr = c; }

			if(i) do {	/* for all numbers, generate the ASCII string */
				if((c = (value % i) + '0') > '9')
					c += 7;
				*--ptr = c; }
			while(value /= i);

/* output sign if any */
			if(minus) {
				if(len) {
					--len;
					*o++ = '-'; }
				if(width)
					--width; }

/* pad with 'zero' value if right justify enabled  */
			if(width && !justify) {
				for(i = Strlen(ptr); i < width; ++i) {
					if(!len) break;
					--len;
					*o++ = zero; } }

/* move in data */
			i = 0;
			value = width - 1;
			while((*ptr) && (i <= value)) {
				if(!len) break;
				--len;
				*o++ = *ptr++;
				++i; }

/* pad with 'zero' value if left justify enabled */
			if(width && justify) {
				while(i < width) {
					if(!len) break;
					--len;
					*o++ = zero;
					++i; } } }
		else {
			if(!len) break;
			--len;
			*o++ = c; } }

	*o = 0;
	return (unsigned)o - (unsigned)output;
}

/*
 * Formatted print to string
 *
unsigned sprintf(void *output, const char *format, ...)
{
	unsigned l;
	va_list a;
	va_start(a, format);
	l = _format_((char*)output, 0xFF00, format, a);
	va_end(a);
	return l;
}
unsigned snprintf(void *output, unsigned len, const char *format, ...)
{
	unsigned l;
	va_list a;
	va_start(a, format);
	l = _format_((char*)output, len, format, a);
	va_end(a);
	return l;
} */

/*
 * Formatted print directly to USART1
 */
void Printf(const char *format, ...)
{
	char buffer[150];
	va_list a;
	va_start(a, format);
	_format_(buffer, 149, format, a);
	va_end(a);
	Puts(buffer);
}

/*
 * Get string from the console with editing
 */
unsigned Gets(unsigned char *dest, unsigned maxlen)
{
	int c;
	unsigned p;
	p = 0;
	--maxlen;
	for(;;) switch(c = Getc()) {
		case '\r' :		// Return
		case '\n' :		// Newline (line-feed)
			dest[p] = 0;
			return p;
		case '\b' :		// Backspace
		case 0x7F :		// Delete
			if(p) {
				--p;
				Puts("\b \b"); }
			continue;
//		case '$' :		// Launch DESMO only if '$' first on line
//			if(!p)
//				desmo();
		default:
			if((c >= ' ') && (p < maxlen)) {
				Putc(c);
				if((c >= 'a') && (c <= 'z'))
					c -= ('a'-'A');
				dest[p++] = c; } }
}

/*
 * These definitions "replace" the standard library functions in a way that
 * will not conflict with built-in compiler definitions.
 */
#define putc	Putc
#define puts	Puts
#define	printf	Printf
#define	strlen	Strlen
