#define	FULL		2		// Ticks/step at full speed
#define	SLOW		25		// Ticks/step at slow speed
#define CSTEP		10		// Calibration
#define RSTEP		1		// Time Adjustment per step

int
	Sdir;				// Step direction
unsigned
	Srate,				// Current stepping rate
	Slast;				// Last tick at step
U16
	Smirror,			// Port mirror
	SdriveMask,			// Mask of bits to drive
	SzeroMask,			// Zero position mask
	SendMask,			// End travel mask
	RampUp,				// Steps to ramp-up
	RampLevel,			// Steps to ramp-level
	RampDown,			// Steps to Ramp-down
	Sposition,			// Current stepper position
	Sposition1,			// Stepper 1 position
	Sposition2,			// Stepper 2 position
	StepTable[8];		// Dynamic step table
U8
	Sactive,			// ACtive stepper
	Sstate,				// Stepping state
	Slimit,				// Step limit detect
	StepPos;			// Step table position

U16 InPins[] = { 0, 1<<6, 1<<7, 1<<8, 1<<11, 1<<12, 1<<15 };

void stepwait(void)
{
	do {
		BG(); }
	while(Sstate);
}

void stepselect(U8 motor)
{
	Debug(DB_STEP, "\nstepselect(%u)", motor);
	stepwait();
	if(motor != Sactive) {
		switch(Sactive) {
		case 1 : Sposition1 = Sposition;	break;
		case 2 : Sposition2 = Sposition;	}
		switch(motor) {
		default:
			printf("\n?motor");
			return;
		case 1 :
			Sposition = Sposition1;
			break;
		case 2 :
			Sposition = Sposition2; }
		Sactive = motor; }
}

void stepgo(unsigned pos, U16 ebit, U16 slow, U16 full)
{
	unsigned i, p, steps;
	U16 b, m, s, m1;
	static U8 stable[] = { 0x01, 0x03, 0x02, 0x06, 0x04, 0x0C, 0x08, 0x09 };

	Debug(DB_STEP, "\nstepgo(%u, %u, %u, %u)", pos, ebit, slow, full);
	stepwait();
	switch(Sactive) {
	default:
		printf("\n?stepper");
		return;
	case 1 :
		b = 3;							// Drive position
		SzeroMask = InPins[1];			// Home detect bit
		SdriveMask = ~(0xF << 7);		// Inhibit motor2
		break;
	case 2 :
		b = 7;							// Drive position
		SzeroMask = InPins[2];			// Home detect bit
		SdriveMask = ~(0xF << 3); }		// Inhibit motor1
	SendMask = InPins[ebit];

	// Calculate number of steps and direction
	if(pos > Sposition) {
		steps = pos - Sposition;
		Sdir = 1; }
	else if(pos < Sposition) {
		steps = Sposition - pos;
		Sdir = -1; }
	else
		return;

	// Build the dynamic step table
	m = 0x0F << b;					// Mask of valid bits
	s = (Smirror >> b) & 0x0F;		// Current position
	m1 = Smirror & ~m;				// Don't change the rest
	for(p=0; p < 8; ++p) {
		if(stable[p] == s)
			goto fp; }
	Debug(DB_STEP, "\nExisting motor position invalid, using 0");
	Smirror = (Smirror & m1) | (1 << b);
	p = 0;
fp:
	for(i=0; i < 8; ++i) {
		p = (p + Sdir) & 7;
		StepTable[i] = (stable[p] << b) | m1; }

	Srate = slow;
	if(!full)			// Single speed
		goto gl;
	else {				// Ramped
		m = (slow-full)/RSTEP;		// Length of Ramp
		if((m*3) > steps) {
	gl:		RampLevel = steps;
			RampUp = RampDown = 0;
			Sstate = 2; }
		else {
			RampUp = m;
			RampDown = (m+1);
			RampLevel = steps - (RampUp + RampDown);
			Sstate = 1; } }		// Ramping up

	Debug(DB_STEP, "\nSteps=%s%u Sstate=%u R=%u/%u/%u",
		(Sdir < 0) ? "-" : "", steps, Sstate,
		RampUp, RampLevel, RampDown);

	Slast = Tick;				// Setup timer
	StepPos = Slimit = 0;		// Setup step table postion
//	while(Sstate)
//		BG();
}
