#include <stdio.h>
#include <window.h>
#include <file.h>
#define	DOS						// Fake LFNs under DOS (test)

#define	SSIZE		24			// Screen size (#entries)
#define	FILES		512			// Max. number of files
#define	NSIZE		127			// Max. size of name

#define	DELETE		('D'|0x80)	// Delete string
#define	REPLACE		('R'|0x80)	// Replace string
#define	COPY		(' '|0x80)	// Copy text
#define	KEEP		0			// Keep exact string
#define	COPY_TO		0x81		// Copy to string
#define	COPY_REM	0x82		// Copy remainder

#define	A_STATUS	0x70		// Status line
#define	A_PROMPT	0x74		// Prompt
#define	A_DELETE	0x4E		// Delete section
#define	A_KEEP		0x3E		// Keep section
#define	A_REPLACE	0x5E		// Replace section
#define	A_COPY		0x0E		// Copy section
#define	A_CLEAR		0x14		// Clear screen
#define	A_FAIL		0x12		// auto-edit failed
#define	A_SUCCESS	0x13		// auto-edit succeded
#define	A_SAVE		0x17		// Filename locked
#define	A_HELP		0x60		// Help text
#define	A_ORIG		0x1B		// Original display
#define	A_DEL		0x1C		// To be deleted
#define	A_EDIT		0x70		// Editing name
#define	A_BROWSE	0x17		// Viewing file
#define	A_HILITE	0x71		// Control-Character display

unsigned
	Seg,				// External segment
	Seg1,				// External segment
	Files,				// Number of files
	Top,				// Top of screen
	Select,				// Selected item
	Base,				// Base screen position
	Cursor,				// Current cursor position
	Length,				// Length of current line
	Pptr,				// Decoding position pointer
	Atop;				// Top of action list
unsigned char
	*ptr,				// General pointer
	Buffer[1024],		// Work buffer
	Current[128],		// Current line
	Pattern[128],		// Update pattern
	Rlist[10][65],		// Replace list
	Action[2048],		// Action list
	Save[FILES],		// List of saved files
	Ctranslate[256],	// Copy Translate table
	Mtranslate[256],	// Encode translate table
	Cflag,				// Changed made flag
	Dflag,				// Directory mode flag
	Sflag,				// Status display flag
	Lflag;				// Lock display flag

unsigned char Hattr[] = {
	A_HELP,			// 0 Normal
	A_DELETE,		// 1 Auto-delete
	A_KEEP,			// 2 Auto-keep
	A_REPLACE,		// 3 Auto-replace
	A_COPY,			// 4 Auto-copy
	A_FAIL,			// 5 Auto-fail
	A_SUCCESS,		// 6 Auto-success
	A_SAVE,			// 7 Locked
	A_DEL };		// 8 Deletion

/*
 * Longfilename lookup structure
 */
struct LFN_HANDLE {
	unsigned		Attrib[2];
	unsigned		Ctime[4];
	unsigned		Atime[4];
	unsigned		Mtime[4];
	unsigned		SizeH[2];
	unsigned		SizeL[2];
	unsigned char	Reserved[8];
	unsigned char	Lname[260];
	unsigned char	Sname[14];
	} Lfn;

unsigned char Banner[] = {
"Edit Long Filenames - Dave Dunfield - "#__DATE__" - Press F1 for help" };

unsigned char Chelp[] = { "\n\
Edit Long Filenames - Dave Dunfield - "#__DATE__"\n\n\
use:	ELF	[options...]\n\n\
opts:	-D		- begin with change Directory\n\
	-C<c>=<c>	- set Copy translation\n\
	-M<c>-<c>	- set Match translation\n\
	@filename	- read command options from file\n" };

unsigned char CDhelp[] = {
"Select Directory  ENTER=Go  F10=Stay  ESC=Quit" };

unsigned char TRmsg[] = {
"Translate %s characters  F1=new  F2=reset  F10=Done" };

unsigned char Help[] = { "\
filename movement:					auto-edit movement:\n\
    Up/Down = move 1 line			  Left/Right = Move 1 character\n\
  PgUp/PgDn = Move 24 lines           Home/End   = Go to first/last in line\n\
 ^Home/^End = Go to first/last file\n\n\
filename commands:					auto-edit commands:\n\
	A)uto-lock successful auto-edits	D)elete\n\
	E)dit & lock						K)eep\n\
	L)ock current file					R)eplace\n\
	U)nlock	current file			  space=copy/translate\n\
	? = show orignal names			  enter=apply auto-edits\n\n\
general commands:\n\
	 F1 = help (this screen)		 	 F5 = view file content\n\
	 F2 = change directory				 F6 = mark file for deletion\n\
	 F3 = edit COPY translations		F10 = rename (locked) files & exit\n\
	 F4 = edit MATCH translations		esc = quit without save\n\n\
	\x81auto-edit DELETE section\x80		\x83auto-edit    REPLACE     section\n\
	\x82auto-edit  KEEP  section\x80		\x84auto-edit COPY/TRANSLATE section\n\
	\x85current auto-edit fails on this filename (will not lock)\n\
	\x86current auto-edit works on this filename (can be locked)\n\
	\x87this filename has been locked (new name for original file)\n\
	\x88this file has been marked for deletion\n" };

#if 0		// Switchable DEBUG printf
unsigned char Xout;
register Xprintf(unsigned args)
{
	unsigned char buf[101];
	_format_(nargs() * 2 + &args, buf);
	if(Xout)
		fputs(buf, stdout);
}
#endif

#if 0		// Display LFN find structure
void lfn_show(void)
{
	printf("Attrib: %04x %04x\n", Lfn.Attrib[1], Lfn.Attrib[0]);
	printf("Ctime : %04x %04x %04x %04x\n", Lfn.Ctime[3], Lfn.Ctime[2], Lfn.Ctime[1], Lfn.Ctime[0]);
	printf("Atime : %04x %04x %04x %04x\n", Lfn.Atime[3], Lfn.Atime[2], Lfn.Atime[1], Lfn.Atime[0]);
	printf("Mtime : %04x %04x %04x %04x\n", Lfn.Mtime[3], Lfn.Mtime[2], Lfn.Mtime[1], Lfn.Mtime[0]);
	printf("SizeH : %04x %04x\n", Lfn.SizeH[1], Lfn.SizeH[0]);
	printf("SizeL : %04x %04x\n", Lfn.SizeL[1], Lfn.SizeL[0]);
	printf("Lname : '%s'\n", Lfn.Lname);
	printf("Sname : '%s'\n", Lfn.Sname);
}
#endif

#ifdef DOS		// Fake LFN for testing under DOS
/*
 * Lookup first LFN name
 */
unsigned FFA;
unsigned lfn_find_first(name, unsigned attributes)
{
	unsigned a;
	if(find_first("*.*", attributes, Lfn.Sname, &Lfn.SizeL[1], &Lfn.SizeL[0],
			&a, &Lfn.Mtime[0], &Lfn.Mtime[1]))
		return -1;
	FFA = attributes >> 8;
	do {
		if((a & FFA) || !FFA) {
			strcpy(Lfn.Lname, Lfn.Sname);
			return 0; } }
	while(!find_next(Lfn.Sname, &Lfn.SizeL[1], &Lfn.SizeL[0], &a,
		&Lfn.Mtime[0], &Lfn.Mtime[1]));
	return -1;
}

/*
 * Lookup next LFN name
 */
int lfn_find_next(handle)
{
	unsigned a;
	while(!find_next(Lfn.Sname, &Lfn.SizeL[1], &Lfn.SizeL[0], &a,
		&Lfn.Mtime[0], &Lfn.Mtime[1])) {
		if((a & FFA) || !FFA) {
			strcpy(Lfn.Lname, Lfn.Sname);
			return 0; } }
	return 255;
}

#define	lfn_find_close(h)
#define lfn_rename(o,n)	rename(o,n)
#define lfn_cd(d)		cd(d)
#define	lfn_getdir(b)	getdir(b)
#define	lfn_delete(f)	delete(f)
#define	lfn_open(a)		open(a, F_READ)
#define	lfn_close(h)	close(h)
#else
/*
 * Lookup first LFN name
 */
unsigned lfn_find_first(name, attributes) asm
{
	MOV		AX,714Eh			// LFN find-first
	MOV		CX,4[BP]			// Required/Allowed attributes
	MOV		DX,6[BP]			// Filename
	MOV		DI,offset DGRP:_Lfn	// Structure
	MOV		SI,1				// DOS format date/time
	PUSH	DS					// Copy
	POP		ES					// ES = DS
	STC							// Assume fail
	INT		21h					// Ask DOS
	JNC		ok1					// Worked!
	MOV		AX,0FFFFh			// Indicate failed
ok1:
}

/*
 * Lookup next LFN name
 */
int lfn_find_next(handle) asm
{
	MOV		AX,714Fh			// LFN find-next
	MOV		BX,4[BP]			// Handle
	MOV		SI,1				// DOS format date/time
	MOV		DI,offset DGRP:_Lfn	// Structure
	PUSH	DS					// Copy
	POP		ES					// ES = DS
	INT		21h					// Ask DOS
	JC		ok2					// Failed!
	XOR		AX,AX				// No error
ok2:
}

/*
 * Close LFN search
 */
void lfn_find_close(handle) asm
{
	MOV		AX,71A1h			// LFN find close
	MOV		BX,4[BP]			// Handle
	INT		21h					// Ask DOS
}

/*
 * Rename LFN file
 */
int lfn_rename(old, new) asm
{
	MOV		AX,7156h			// LFN rename
	MOV		DX,6[BP]			// Old name
	MOV		DI,4[BP]			// New name
	PUSH	DS					// Copy
	POP		ES					// ES = DS
	STC							// Assume failure
	INT		21h					// Ask DOS
	JC		ok3					// Failed!
	XOR		AX,AX				// Indicate success
ok3:
}

/*
 * Change LFN directory
 */
int lfn_cd(directory) asm
{
	MOV		AX,713Bh			// LFN chdir
	MOV		DX,4[BP]			// Directory
	STC							// Assume fail
	INT		21h					// Ask DOS
	JC		ok4					// Failed!
	XOR		AX,AX				// Success
ok4:
}

/*
 * Get LFN current directory
 */
int lfn_getdir(buffer) asm
{
	MOV		AX,7147h			// LFN getdir
	XOR		DL,DL				// Current
	MOV		SI,4[BP]			// Buffer
	STC							// Assume fail
	INT		21h					// Ask DOS
	JC		ok5					// Failed
	XOR		AX,AX				// Success
ok5:
}

/*
 * Delete LFN file
 */
int lfn_delete(file) asm
{
	MOV		AX,7141h			// LFN delete
	MOV		DX,4[BP]			// Filename
	XOR		SI,SI				// No search attributes
	XOR		CX,CX				// No search attrbutes
	STC							// Assume fail
	INT		21h					// Ask DOS
	JC		ok6					// Failed!
	XOR		AX,AX				// Success
ok6:
}

/*
 * Open LFN file for READ
 */
unsigned lfn_open(name) asm
{
	MOV		AX,716Ch			// LFN open
	XOR		BX,BX				// Access mode = READ
	XOR		CX,CX				// Attributes = None
	MOV		DX,1				// Action = open/read
	MOV		SI,4[BP]			// Name
	STC							// Assume fail
	INT		21h					// Ask DOS
	JNC		ok7					// Success!
	XOR		AX,AX				// Indicate fail
ok7:
}

/*
 * Close an open file handle
 */
int lfn_close(handle) asm
{
	MOV		AH,3Eh
	MOV		BX,4[BP]
	INT		21h
}
#endif


/*
 * Sound alarm
 */
void alarm(void)
{
	beep(500, 200);
}

/*
 * Display line to end of screen
 */
void line(unsigned char *s)
{
	unsigned x;
	while(*s) {
		x = W_OPEN->WINcurx;
		wputc(*s++);
		if(x >= 79)
			return; }
	wcleol();
}

/*
 * Display status message
 */
register status(unsigned args)
{
	unsigned char a, buf[81];

	_format_(nargs() * 2 + &args, buf);
	wgotoxy(Sflag=0, 24);
	a = *W_OPEN;
	*W_OPEN = A_STATUS;
	line(buf);
	*W_OPEN = a;
}

/*
 * Skip ahead to non-blank
 */
int skip()
{
	while(isspace(*ptr))
		++ptr;
	return *ptr;
}

/*
 * Get string from status line
 */
void get_string(unsigned char* prompt, unsigned char *string, unsigned size)
{
	wgotoxy(0, 24);
	*W_OPEN = A_PROMPT;
	line(prompt);
	wgets(W_OPEN->WINcurx, 24, string, size);
	wcursor_line();
}

/*
 * Write a string to the extra segment
 */
void ESputs(unsigned seg, unsigned index, unsigned char *string)
{
	unsigned char c;
	index *= (NSIZE+1);
	while(c = *string++)
		poke(seg, index++, c);
	poke(seg, index, 0);
}

/*
 * Get a string from the extra segment
 */
void ESgets(unsigned seg, unsigned index, unsigned char *string)
{
	unsigned char c;
	index *= (NSIZE+1);
	while(c = peek(seg, index++))
		*string++ = c;
	*string = 0;
}

/*
 * Test for one string beginning with another (with match translaction)
 */
int Strbeg(unsigned char *str1, unsigned char *str2)
{
	while(*str2)
		if(Mtranslate[*str1++] != *str2++)
			return 0;
	return 1;
}

unsigned
	Handle,					// File handle
	Bptr,					// Block pointer
	Bsize,					// Block size
	Sh, Sl,					// High/Low size
	Ph, Pl,					// High/Low position
	Line,					// Current line
	Lines,					// # lines in file
	Llist[2048][2];			// Line offset list

/*
 * Get byte from file
 */
int Fgetc(void)
{
	unsigned char c;

	if(!Bptr)
		Bsize = read(Buffer, sizeof(Buffer), Handle);
	if(Bptr >= Bsize)
		return -1;
	c = Buffer[Bptr++];
	if(!++Pl)
		++Ph;
	if(Bptr >= sizeof(Buffer))
		Bptr = 0;
	return c;
}

/*
 * Get string from input file
 */
int Fgets(unsigned char *dest, unsigned l)
{
	int c;
	unsigned char e;

	e = 0;
	while((c = Fgetc()) != -1) {
		e = 255;
		if(c == '\n')
			break;
		if(c != '\r') {
			*dest++ = c;
			if(!--l)
				break; } }
	*dest = 0;
	return e;
}
	
/*
 * Goto a particular line
 */
void goline(unsigned l)
{
	int c;
	unsigned b;

	if(l > Lines)
		Line = l = Lines;
	b = l >> 5;
	l &= 0x1F;
	lseek(Handle, Ph=Llist[b][1], Pl=Llist[b][0], Bptr=0);
	while(l--) {
		while((c = Fgetc()) != '\n') {
			if(c == -1)
				return; } }
}

/*
 * Display character in window
 */
void Putc(int c)
{
	if((Base <= Cursor) && ((Base+80) > Cursor))
		wputc(c);
	++Cursor;
}

/*
 * 32-bit compare of two pairs of unsigned
 */
int Lcmp(unsigned h1, unsigned l1, unsigned h2, unsigned l2)
{
	if(h1 < h2) return -1;
	if(h1 > h2) return 1;
	if(l1 < l2) return -1;
	if(l1 > l2) return 1;
	return 0;
}

/*
 * File viewer
 */
int view(unsigned char *file)
{
	int c;
	unsigned h, i, j, k, l, m, n;
	unsigned char f, buf[16];

	*W_OPEN = A_BROWSE;
	wclwin();

	Base = Line = Lines = Bsize = Bptr = Sh = Sl = h = l = m = n = 0;
	if(!(Handle = lfn_open(file))) {
		status("Unable to open!");
		return 255; }

	// Build line index
	status("Indexing...");
	while(i = read(Buffer, sizeof(Buffer), Handle)) {
		for(j=0; j < i; ++j) {
			if(!++Sl)
				++Sh;
			switch(c = Buffer[j]) {
			default:
				if((c < ' ') || (c > 0x7E)) {
					if(!++n)
						++m; }
			case '\t' :
			case '\r' : continue;
			case '\n' :
				++Lines;
				if(!(Lines & 0x1F)) {	// 64-line boundary
					k = Lines >> 5;
					if(k >= 2048) {
						status("File exceeds 64k lines");
						lfn_close(Handle);
						return 255; }
					Llist[k][0] = Sl;
					Llist[k][1] = Sh; } } } }

	wcursor_off();

	// If 1/8 or more of file is unprintable, assume HEX
	i = Sh & 7;
	j = (Sl >> 3) | (i << 13);
	i = Sh >> 3;
	if(Lcmp(m, n, i, j) >= 0)
		goto rehex;

	// ASCII viewer
retext:
	if(Base & 0x8000)
		Base = 0;
	if((Line+SSIZE) > Lines)
		Line = Lines-(SSIZE-1);
	if((Line & 0x8000) || (Lines < (SSIZE-1)))
		Line = 0;
	goline(Line);
	h = Ph;
	l = Pl;
	for(i=f=0; i < SSIZE; ++i) {
		wgotoxy(Cursor=0, i);
		if(!f) {
			while((c = Fgetc()) != '\n') {
				switch(c) {
				case -1:
					*W_OPEN = A_HILITE;
					Putc('E'); Putc('O'); Putc('F');
					*W_OPEN = A_BROWSE;
					f = 255;
					goto clr;
				case '\t' :
					do {
						Putc(' '); }
					while(Cursor & 7);
				case '\r' : continue; }
				if(c < ' ') {
					*W_OPEN = A_HILITE;
					c += '@'; }
				Putc(c);
				*W_OPEN = A_BROWSE; } }
clr:	if((Cursor-Base) < 80)
			wcleol(); }

	status("Lines %u-%u of %u, Columns %u-%u", Line+1, Line+24, Lines, Base+1, Base+80);
	for(;;) switch(i = wgetc()) {
		case _KUA:	--Line;			goto retext;
		case _KDA:	++Line;			goto retext;
		case _KPU:	Line -= 24;		goto retext;
		case _KPD:	Line += 24;		goto retext;
		case _CHO:	Line = 0;		goto retext;
		case _CEN:	Line = 32767;	goto retext;
		case _KLA:	--Base;			goto retext;
		case _KRA:	++Base;			goto retext;
		case _KHO:	Base = 0;		goto retext;
		case _K1:					goto rehex;
		case _K10:
		case 0x1B:
quit:		wclwin();
			wcursor_line();
			lfn_close(Handle);
			Sflag = 255;
			return Base = Cursor = 0; }

	// Hexidecimal viewer
rehex:
	if((Sl <= 384) && !Sh)
		h = l = 0;
	i=Sh; j = Sl - (23*16);
	if(j > Sl)
		--i;
	if(Lcmp(h, l, i, j) >= 0) {
		h = i;
		l = j; }
	lseek(Handle, Ph=h, Pl=l, Bptr=0);
	for(i=f=0; i < 24; ++i) {
		wgotoxy(0, i);
		m = Ph;
		n = Pl;
		for(j=k=0; j < 16; ++j) {
			if(!f) {
				if((c = Fgetc()) == -1)
					f=255;
				else
					buf[k++] = c; } }
		wcleol();
		if(k) {
			wprintf("%04x%04x ", m, n);
			for(j=0; j < 16; ++j) {
				if(!(j&3))
					wputc(' ');
				if(j < k)
					wprintf(" %02x", buf[j]);
				else
					wputs("   "); }
			wputs("   ");
			for(j=0; j < k; ++j) {
				c = buf[j];
				wputc( ((c >= ' ') && (c <= 0x7E)) ? c : '.'); } } }
	if(Ph|Pl) {
		i = Pl;
		if(--Pl > i)
			--Ph; }
	status("%04x%04x-%04x%04x of %04x%04x", h, l, Ph, Pl, Sh, Sl);
	for(;;) switch(wgetc()) {
	case _KRA: i=1;	goto doadd;
	case _KLA: i=1;	goto dosub;
	case _KUA: i = 16; dosub:
		j = l;
		if((l -= i) > j)  {
			if(!h--)
				h=l=0; }
		goto rehex;
	case _KDA: i = 16; doadd:
		j = l;
		if((l += i) < j)
			++h;
		goto rehex;
	case _KPU: i = (24*16);		goto dosub;
	case _KPD: i = (24*16);		goto doadd;
	case _KHO: l &= 0xFFF0;		goto rehex;
	case _CHO: h=l=0;			goto rehex;
	case _CEN: h=Sh; l=Sl;		goto rehex;
	case _K1 :					goto retext;
	case _K10:
	case 0x1B:					goto quit; }
}

// --------------- Filename Editor ---------------
/*
 * Draw current (selected) line
 */
void draw_current(void)
{
	unsigned p, e;
	unsigned char a;

	e = Base + 80;
	for(p=0; p < Length; ++p) {
		if((p < Base) || (p >= e))
			continue;
		switch(Pattern[p]) {
		case DELETE	: a = A_DELETE;		break;		// Remove string
		case KEEP	: a = A_KEEP;		break;		// Keep string
		case REPLACE: a = A_REPLACE;	break;		// Replace string
		case COPY	: a = A_COPY;		break;		// Copy existing text
		default: a = 0x0A; }
		*W_OPEN = a;
		wputc(Current[p]); }
	*W_OPEN = A_CLEAR;
	if(W_OPEN->WINcurx < 79)
		wcleol();
}

/*
 * Get index number of action
 */
unsigned action_index(unsigned char a, unsigned position)
{
	unsigned i, r;
	unsigned char f;

	for(i=r=f=0; i <= position; ++i) {
		if(Pattern[i] == a) {
			if(!f)
				++r;
			f = 255; }
		else
			f = 0; }
	return r;
}

/*
 * Encode a single action
 */
void process_action(void)
{
	unsigned i, p, s;
	unsigned char a;

	a = Pattern[Pptr];
	s = 0;
	for(p=Pptr; Pattern[p] == a; ++p)
		Buffer[s++] = Current[p];
	Buffer[s] = 0;

	switch(a) {
	case DELETE:
	case KEEP:
	case REPLACE:
		Action[Atop++] = a;		// Set action
		Action[Atop++] = s;		// Size of string
		for(i=0; i < s; ++i)	// Copy in string
			Action[Atop++] = Mtranslate[Buffer[i]];
		if(a == REPLACE) {
			strcpy(Buffer, Rlist[action_index(REPLACE, Pptr)]);
			Action[Atop++] = s = strlen(Buffer);
			for(i=0; i < s; ++i)
				Action[Atop++] = Buffer[i]; }
		break;
	case COPY :
		switch(Pattern[p]) {
		case DELETE	:
		case KEEP	:
		case REPLACE:
			Action[Atop++] = COPY_TO;
			break;
		default:
			Action[Atop++] = COPY_REM; } }
}

/*
 * Encode Pattern into Action[Atop]
 */
void encode(void)
{
	unsigned i;
	unsigned char a, sp;

	sp = Pattern[Length];
	Pattern[Length] = 255;
	a = Pattern[0];

	for(Atop=i=Pptr=0; i < Length; ++i) {
		if(Pattern[i] != a) {		// Same pattern
			a = Pattern[i];
			process_action();
			Pptr = i; } }
	if(Pptr < i)
		process_action();
	Action[Atop] = 255;
	Pattern[Length] = sp;
}

/*
 * Get string to action buffer
 */
unsigned action_string(unsigned char *d)
{
	unsigned s, l;
	s = l = Action[Pptr++];
	while(l--)
		*d++ = Action[Pptr++];
	*d = 0;
	return s;
}

/*
 * Apply action list to buffer
 */
int apply()
{
	unsigned i, t;
	unsigned char *dest, *source, c, temp[128];

	dest = (source = Buffer) + 256;
	Pptr = 0;
	Action[Atop] = 255;
	while(Pptr < Atop) {
		*dest = 0;
		t = 0;
		switch(Action[Pptr++]) {
		case DELETE:		// Delete this string
			i = action_string(temp);
			while(i--) {
				if(Mtranslate[*source++] != temp[t++])
					return -1; }
			continue;
		case KEEP:			// Keep this string
			i = action_string(temp);
			while(i--) {
				if(Mtranslate[*dest++ = *source++] != temp[t++])
					return -1; }
			continue;
		case REPLACE:		// Replace this string
			i = action_string(temp);
			while(i--) {
				if(Mtranslate[*source++] != temp[t++])
					return -1; }
			i = action_string(temp);
			t = 0;
			while(i--)
				*dest++ = temp[t++];
			continue;
		case COPY_REM:		// Copy remainder of strings
			while(c = *source++)
				*dest++ = Ctranslate[c];
			continue;
		case COPY_TO:
			// Combine following DELETE/KEEP/REPLACE strings for better accuracy
			t = Pptr;
			i = 0;
nxt:		switch(c=Action[Pptr++]) {
			case DELETE:
			case KEEP:
			case REPLACE:
				i += action_string(temp+i);
				if(c == REPLACE)
					Pptr += (Action[Pptr]+1);
				goto nxt; }
			Pptr = t;
			while(!Strbeg(source, temp)) {
				if(!*source)
					return -1;
				*dest++ = Ctranslate[*source++]; }
			continue;
		case 255: return -1;
	}	}
	*dest = 0;
}

/*
 * Draw complete screen
 */
void draw_screen(void)
{
	unsigned i, j;

	for(i=0; i < SSIZE; ++i) {
		if((j = Top + i) >= Files) {
			*W_OPEN = A_CLEAR;
			wcleol();
			continue; }
		wgotoxy(0, i);
		ESgets(Seg, j, Buffer);
		if(Lflag == 0x55) {				// '?' query mode
			*W_OPEN = A_ORIG;
			line(Buffer);
			continue; }
		switch(Save[j]) {
		case 255:						// Filename is locked
			ESgets(Seg1, j, Buffer);
			*W_OPEN = A_SAVE;
			line(Buffer);
			continue;
		case 0x55:						// File to be deleted
			*W_OPEN = A_DEL;
			line(Buffer);
			continue; }

		if((j == Select) && !Lflag) {	// Selected file
			strcpy(Current, Buffer);
			Length = strlen(Current);
			draw_current();
			continue; }

		if(apply()) {					// auto-edit failed
			*W_OPEN = A_FAIL;
			line(Buffer); }
		else {							// auto-edit completed
			*W_OPEN = A_SUCCESS;
			line(Buffer+256); } }
}

/*
 * Edit the translate table
 */
void transedit(unsigned char *translate, unsigned char *prompt)
{
	unsigned i, s, x, y;

	*W_OPEN = 0x17;
	wclwin();
	s = 0;

redraw:
	if(s & 0x8000)
		s = 94;
	if(s >= 95)
		s = 0;
	for(i = 0; i < 95; ++i) {
		wgotoxy(((i/19)*15)+5, (i%19)+2);
		wprintf("'%c' = '", i+' ');
		if(i == s) {
			x = W_OPEN->WINcurx;
			y = W_OPEN->WINcury;
			*W_OPEN = 0x71;
			wputc(translate[i+' ']);
			*W_OPEN = 0x17; }
		else
			wputc(translate[i+' ']);
		wputc('\''); }
restat:
	status(TRmsg, prompt);
	for(;;) {
		wgotoxy(x, y);
		switch(i=wgetc()) {
		case _KUA: --s; 	goto redraw;
		case _KDA: ++s; 	goto redraw;
		case _KRA: s += 19;	goto redraw;
		case _KLA: s -= 19;	goto redraw;
		case _KHO: s = 0;	goto redraw;
		case _KEN: s = 94;	goto redraw;
		case _K1 :
			status("Press new (translated) character:");
			i = wgetc();
			if((i >= ' ') && (i <= 0x7E)) {
				translate[s+' '] = i;
				goto redraw; }
			alarm();
			goto restat;
		case _K2:
			for(i=0; i < 256; ++i)
				translate[i] = i;
			goto redraw;
		case '\n':
		case 0x1B:
		case _K10:
			wclwin();
			return;
		default:
			if((i >= ' ') && (i <= 0x7E)) {
				s = i - ' ';
				goto redraw; }
			alarm();
	} }
}

nlock(unsigned *l, unsigned  *d)
{
	unsigned i;
	for(*l=*d=i=0; i < Files; ++i) switch(Save[i]) {
		case 0x55: ++*d;	continue;
		case 255: ++*l; }
	return *l+*d;
}

/*
 * Edit filenames
 */
int edit(void)
{
	unsigned c, i, t, lb;

	lb = 0;
restat:
//	Sflag = 255;
	status(Banner);
redraw:
	if(Select & 0x8000)
		Select = 0;
	if(Select >= Files)
		Select = Files-1;
	if(Select < Top)
		Top = Select;
	if(Select >= (Top+SSIZE)) {
		Top = Select - (SSIZE-1);
		if(Top & 0x8000)
			Top = 0; }
	draw_screen();
	for(;;)	{
		if(Cursor & 0x8000)
			Cursor = Length-1;
		if(Cursor >= Length)
			Cursor = 0;

		Base = (Cursor > 75) ? Cursor-75 : 0;
		if((Base+80) > Length)
			Base = Length-80;
		if(Length < 80)
			Base = 0;
		if(lb != Base) {
			lb = Base;
			wgotoxy(0, Select-Top);
			draw_current(); }
//status("B=%u C=%u L=%u", Base, Cursor, Length);
		if(Sflag)
			status("ELF: %u of %u  -  Press F1 for help", Select+1, Files);
		Sflag = 255;
		wgotoxy(Cursor-Base, Select-Top);
		c = toupper(wgetc());
		if(Lflag) {
			Lflag = 0;
			draw_screen(); }
		switch(c) {
		case _KUA: --Select;			goto redraw;
		case _KDA: ++Select;			goto redraw;
		case _KPU: Select -= SSIZE;		goto redraw;
		case _KPD: Select += SSIZE;		goto redraw;
		case _CHO: Select = 0;			goto redraw;
		case _CEN: Select = 32767;		goto redraw;
		case _KRA: ++Cursor;			goto showsel;
		case _KLA: --Cursor;			goto showsel;
		case _KHO: Cursor = 0;			goto showsel;
		case _KEN: Cursor = -1;			goto showsel;
		case 'K' : c = 0;				goto setpat;	// Keep
		case ' ' :										// Copy
		case 'D' :										// Delete
		case 'R' : c |= 0x80;							// Rename
setpat:		if(Save[Select]) {
				alarm();
				continue; }
			i = Pattern[Cursor];
			Pattern[Cursor] = c;
			wgotoxy(0, Select-Top);
			draw_current();
			if(c == REPLACE) {
				if((!Cursor) || (i==REPLACE) || (Pattern[Cursor-1] != REPLACE))
					get_string("Replace with?", Rlist[action_index(REPLACE, Cursor)], 64); }
			if(++Cursor >= Length)
				--Cursor;
showsel:	switch(c=Pattern[Cursor]) {
			case DELETE : status("Delete section");		break;
			case REPLACE:
				status("Replace section with '%s'", Rlist[action_index(c, Cursor)]);
				break;
			case KEEP	: status("Keep (exact) section");	break;
			case COPY	: status("Copy original section"); }
			continue;
/*		case 'T' :										// Text
			if(Pattern[Cursor] != REPLACE) {
				alarm();
				continue; }
			get_string("Replace with?", Rlist[action_index(REPLACE, Cursor)], 64);
			goto showsel; */
		case '\n' :										// Encode
			encode();
			Lflag = Cflag = 255;
			goto redraw;
		case '?' :										// Query
			Lflag = 0x55;
			goto redraw;
		case 'E' :										// Edit
			ESgets(Save[Select] ? Seg1 : Seg, Select, Buffer);
			*W_OPEN = A_EDIT;
again:		i=wgets(0, Select-Top, Buffer, NSIZE);
			wcursor_line();
			switch(i) {
			default: goto again;
			case '\n' :
				ESputs(Seg1, Select, Buffer);
				Save[Select] = Cflag = 255;
			case 0x1B: }
			goto redraw;
		case 'L' :
			if(!Save[Select]) {
				ESgets(Seg, Select, Buffer);
				if(apply())
					ESputs(Seg1, Select, Buffer);
				else
					ESputs(Seg1, Select, Buffer+256);
				Save[Select] = Cflag = 255; }
			goto redraw;
		case 'U' :										// Unlock name
			Save[Select] = 0;
			goto redraw;
		case 'A' :										// Lock name
			for(c=0; c < Files; ++c) {
				if(!Save[c]) {
					ESgets(Seg, c, Buffer);
					if(!apply()) {
						ESputs(Seg1, c, Buffer+256);
						Save[c] = Cflag = 255; } } }
			goto redraw;
		case _K1:
			*W_OPEN = A_HELP;
			wclwin();
			for(i=t=0; c=Help[i]; ++i) {
				if(c & 0x80) {
					*W_OPEN = Hattr[c&0x7F];
					continue; }
				switch(c) {
				case '\t' :
					do {
						wputc(' '); }
					while(++t & 3);
					continue;
				case '\n' :
					*W_OPEN = A_HELP;
					t = -1; }
				wputc(c);
				++t; }
			status("Press any key.");
			wgetc();
			*W_OPEN = A_CLEAR;
			wclwin();
			goto restat;
		case _K2:
			if(nlock(&i, &c)) {
				status("%u locked files, %u delete files - abandon?", i, c);
				alarm();
				for(;;) switch(wgetc()) {
					case 'y' :
					case 'Y' : return 2;
					case 'n' :
					case 'N' :
					case 0x1B: goto restat; } }
			return 2;
		case _K3:
			transedit(Ctranslate, "COPY/TRANSLATE");
			goto restat;
		case _K4:
			transedit(Mtranslate, "MATCH");
			goto restat;
		case _K5:										// View file
			ESgets(Seg, Select, Buffer);
			view(Buffer);
			goto redraw;
		case _K6:										// Delete file
			if(Save[Select])
				alarm();
			else
				Save[Select] = Cflag = 0x55;
			goto redraw;
		case _K10:
			if(!nlock(&i, &c)) {
				status("No files are Locked/Deleted!  (use ESC to quit)");
				alarm();
				continue; }
			status("RENAME %u, DELETE %u  of %u files?", i, c, Files);
			if((i+c) < Files)
				alarm();
			for(;;) switch(wgetc()) {
				case 'y' :
				case 'Y' : return 1;
				case 'n' :
				case 'N' :
				case 0x1B: goto restat; }
		case 0x1B:
			if(!Cflag)
				return 0;
			status("QUIT (lose all changes)?");
			alarm();
			for(;;) switch(wgetc()) {
				case 'y' :
				case 'Y' : return 0;
				case 'n' :
				case 'N' :
				case 0x1B: goto restat; }
	}	}
}

/*
 * Zero segments & ststem variables
 */
void zero(void)
{
	unsigned i;
	i = 0;
	do {
		pokew(Seg, i, 0);
		pokew(Seg1, i, 0); }
	while(i -= 2);
	Files = Top = Select = Base = Cursor = Length = Pptr = Atop = Lflag = Cflag = 0;
	memset(Pattern, 0, sizeof(Pattern));
	memset(Rlist, 0, sizeof(Rlist));
	memset(Action, 0, sizeof(Action));
	memset(Save, 0, sizeof(Save));
}

/*
 * Select a new directory
 */
int cdirectory(unsigned char *stat)
{
	unsigned i, j;
	unsigned char *bp;

	wopen(0, 0, 80, SSIZE+1, WCOPEN|WCCLOSE|0x17);
	wcursor_off();
new:
	zero();
	if((i = lfn_find_first("*", 0x10F7)) == -1) {
		status("No directories! - Press any key");
		wgetc();
		i = 0;
		goto xclose; }
	do {
		if(strcmp(Lfn.Lname, ".")) {
			ESputs(Seg, Files, Lfn.Lname);
			++Files; } }
	while(!lfn_find_next(i));
	lfn_find_close(i);

	Buffer[0] = '\\';
	lfn_getdir(Buffer+1);
	if((i = strlen(bp = Buffer)) > 80)
		bp += i-80;
restat:
	status(stat || bp);
redraw:
	if(Select & 0x8000)
		Select = 0;
	if(Select >= Files)
		Select = Files-1;
	if(Select < Top)
		Top = Select;
	if(Select >= (Top+SSIZE)) {
		Top = Select - (SSIZE-1);
		if(Top & 0x8000)
			Top = 0; }

	for(i=0; i < SSIZE; ++i) {
		wgotoxy(0, i);
		*W_OPEN = 0x17;
		if((j = Top + i) >= Files) {
			wcleol();
			continue; }
		ESgets(Seg, j, Pattern);
		if(j == Select) {
			*W_OPEN = 0x71;
			strcpy(Current, Pattern); }
		line(Pattern); }
	for(;;) {
		i = wgetc();
		if(stat) {
			stat = 0;
			status(bp); }
		switch(i) {
		default : stat = CDhelp;		goto restat;
		case _KUA: --Select;			goto redraw;
		case _KDA: ++Select;			goto redraw;
		case _KPU: Select -= SSIZE;		goto redraw;
		case _KPD: Select += SSIZE;		goto redraw;
		case _KHO: Select = 0;			goto redraw;
		case _KEN: Select=Files-1;		goto redraw;
		case '\n':
			lfn_cd(Current);
			goto new;
		case _K1 :
		case _K10:
			i = 255;
			goto xclose;
		case 0x1B: i = 0;
xclose:		W_OPEN->WINpcurx = W_OPEN->WINpcury = 0;
			*W_OPEN = 0x07; wclose();
			return i; } }
}

/*
 * Process a single command line argument
 */
void argument(void)
{
	unsigned i, j;
	unsigned char *p;

	switch((toupper(*ptr++)<<8)|toupper(*ptr++)) {
	case '-#' : printf("%x\n", malloc(1)); exit(0);
	case '-D' : Dflag = 255;	return;
	case '-C' : p = Ctranslate; goto dotr1;
	case '-M' : p = Mtranslate;
dotr1:	if((*ptr == '=') && !ptr[2]) {
			i = ' ';
			j = ptr[1];
dotr2:		if((i < ' ') || (i > 0x7E) || (j < ' ') && (j > 0x7E))
				abort(Chelp);
			p[i] = j;
			return; }
		if(ptr[1] == '=') {
			i = *ptr;
			if(j = ptr[2]) {
				if(ptr[3])
					abort(Chelp); }
			else
				j = ' ';
			goto dotr2; }
	} abort(Chelp);
}

main(int argc, char *argv[])
{
	unsigned i;

	Seg1 = (Seg = alloc_seg(8192)) + 4096;

	// Set default translations
	for(i=0; i < 256; ++i) {
		Ctranslate[i] = i;
		Mtranslate[i] = i; }
	for(i='a'; i <= 'z'; ++i)
		Mtranslate[i] = i - ('a'-'A');
	Mtranslate['_'] = Mtranslate['='] = Mtranslate['+'] = '-';

	// Process command line arguments
	for(i=1; i < argc; ++i) {
		if(*(ptr = argv[i]) == '@') {		// From file
			if(!(Handle = lfn_open(ptr+1)))
				abort("Cannot open file");
			Bptr = 0;
			while(Fgets(ptr = Current, sizeof(Current)-1)) {
				switch(skip()) {
				case 0 :
				case ';': continue; }
				argument(); }
			lfn_close(Handle);
			continue; }
		argument(); }

	if(Dflag) {
docd:	if(!cdirectory(0))
			return; }

again:
	zero();
#ifdef DOS
	if(Handle = lfn_open("$LFNAME$.ELF")) {
		Bptr = 0;
		while(Fgets(ptr = Current, sizeof(Current)-1)) {
			switch(skip()) {
			case ';' :
			case 0 : continue; }
			if(strlen(Current) > NSIZE)
				goto fail;
			ESputs(Seg, Files, Current);
			ESputs(Seg1, Files++, Current); }
		lfn_close(Handle); }
	else
#endif
	{
		if((i = lfn_find_first("*", 0x00E7)) == -1) {
			if(cdirectory("No files in current directory!"))
				goto again;
			return; }
		do {
			if(strlen(Lfn.Lname) > NSIZE) {
				lfn_find_close(i);
fail:			fputs("Name too long!\n", stderr);
				fputs(Buffer, stderr);
				abort("\n"); }
			ESputs(Seg, Files, Lfn.Lname);
			ESputs(Seg1, Files++, Lfn.Lname); }
		while(!lfn_find_next(i));
		lfn_find_close(i); }

	Action[Atop++] = 255;
	wopen(0, 0, 80, SSIZE+1, WCOPEN|WCCLOSE|A_CLEAR);
	i = edit();
	W_OPEN->WINpcurx = W_OPEN->WINpcury = 0;
	*W_OPEN = 0x07; wclose();
	switch(i) {
	case 2 : goto docd;
	case 1 :
		for(i=0; i < Files; ++i) {
			ESgets(Seg, i, Buffer);
			ESgets(Seg1, i, Current);
			printf("%s\n", Buffer);
			switch(Save[i]) {
			case 0x55:		// Delete
				printf("  Delete");
				if(lfn_delete(Buffer))
					printf(" Failed!\n");
				else
					printf("d\n");
				continue;
			case 255 :		// Rename
				if(strcmp(Buffer, Current)) {
					printf("->%s\n", Current);
					if(lfn_rename(Buffer, Current))
						printf("  Failed!\n");
					continue; }
			default:
				printf("  Skipped!\n"); } } }
	if(Dflag)
		goto docd;
}
