/*
 * EMSETUP: Emily/Monica Setup
 *
 * ?COPY.TXT 1991-2005 Dave Dunfield
 * **See COPY.TXT**.
 */
#include <stdio.h
#include <window.h>
#include <file.h>

#define	SFRLENGTH	19				/* Length of fixed SFR's */

char version[1] = { 0x16 };

/* Special functions register table */
char sfrs[1024] = {
	0x00,	'A',
	0xF0,	'B',
	0xD0,	'P','S','W',
	0x81,	'S','P',
	0x82,	'D','P','L',
	0x83,	'D','P','H',
	0 };

/* 8250 uart configuration tables */
unsigned baud[8] = 0;
char baud_rate = 0, parity = 0, dbits = 0, sbits = 0;

/* Command line options */
char filename[50] = { ".HEX" };
unsigned hbaud = 4, com1 = 0x3FD, com2 = 0x2FD, adelay = 0, bdelay = 1000;
char reset = -1;

int	Cattrs[5] = 0;		/* Attributes for color monitors */

/* NOTE: form1 MUST follow initialized data */
char *form1[] = {
	62<<8|3,
	"\x00\x00\x31Filename:",
	0 };
char *form2[] = {
	40<<8|4,
	"\x00\x00\x85Instruction Animate delay (ms):",
	"\x00\x01\x85Breakpoint  (P)ause delay (ms):",
	0 };

char buffer[32000], fname[65];
unsigned bsize, boffset;

main(argc, argv)
	int argc;
	char *argv[];
{
	unsigned i, cmd;
	static char *menu1[] = {
		"Screen colors",
		"Special function registers",
		"Serial I/O defaults",
		"Target interface speed",
		"Serial port assignments",
		"Animate/Breakpoint delays",
		"RESET logic level",
		"Default load filename",
		"Exit EMSETUP",
		0 };

	*sfrs = 0xE0;
	fputs("EMSETUP version 1.7\n\n?COPY.TXT 1993-2005 Dave Dunfield\n**See COPY.TXT**.\n", stderr);
	if(argc < 2)
		abort("\nUse: emsetup <filename> [copy_to_files]\n");

	load_file(argv[1]);
	memcpy(sfrs, buffer+boffset, form1 - sfrs);
	wopen(cmd = 0, 0, 80, 25, WSAVE|WCOPEN|WBOX1|NORMAL);
	title("EMILY/MONICA setup utility v1.7");
	wcursor_off();
	wprintf("\rFile: %s", fname);
main:
	while(wmenu(25, 7, WSAVE|WCOPEN|WBOX1|REVERSE, menu1, &cmd));
	switch(cmd) {
		case 0 :
			colors();
			goto main;
		case 1 :
			setup_sfrs(sfrs+SFRLENGTH, sizeof(sfrs)-SFRLENGTH);
			goto main;
		case 2 :
			setup_serial();
			goto main;
		case 3 :
			set_hardware();
			goto main;
		case 4 :
			set_comm();
			goto main;
		case 5 :
			wform(20, 10, WSAVE|WBOX2|WCOPEN|REVERSE, form2, &adelay, &bdelay);
			goto main;
		case 6 :
			set_reset();
			goto main;
		case 7 :
			wform(10, 10, WSAVE|WBOX2|WCOPEN|REVERSE, form1, filename);
			goto main;
	}
	i = yesno("Save new settings");
	wclose();
	if(i) {
		memcpy(buffer+boffset, sfrs, form1 - sfrs);
		save_file();
		for(i=2; i < argc; ++i) {
			load_file(argv[i]);
			memcpy(buffer+boffset, sfrs, form1 - sfrs);
			save_file(); } }
	else
		fputs(" Not saved!\n", stderr);
}

/*
 * Load a file into memory and locate the data offset
 */
load_file(name)
	char *name;
{
	char *ptr, flag;
	HANDLE fh;

	ptr = fname;
	flag = -1;
	while(*ptr = *name++) {
		if(*ptr++ == '.')
			flag = 0; }
	if(flag)
		strcpy(ptr, ".COM");
	fprintf(stderr,"%-12s: Reading...", fname);
	if(!(fh = open(fname, F_READ)))
		abort("Failed!");

	bsize = read(buffer, sizeof(buffer), fh);
	close(fh);

	boffset = 0;
	while(boffset < bsize) {
		if(compare(buffer+(boffset++), version, SFRLENGTH+1))
			return; }
	abort(" Cannot locate data signature");
}

/*
 * Resave a file to
 */
save_file()
{
	HANDLE fh;
	fputs(" Writing...", stderr);
	if(!(fh = open(fname, F_WRITE))) {
		wclose();
		fprintf(stderr,"Unable to write: %s\n", fname);
		exit(-1); }
	write(buffer, bsize, fh);
	close(fh);
	fputs(" Done.\n", stderr);
}

/*
 * Compare memory for n bytes
 */
compare(ptr1, ptr2, n)
	char *ptr1, *ptr2;
	unsigned n;
{
	while(n--)
		if(*ptr1++ != *ptr2++)
			return 0;
	return 1;
}

/*
 * Set window colors
 */
colors()
{
	int num, color, f, b;
	static char *cnames[] = {
		"Disassembler",
		"Register display",
		"Int. RAM display",
		"Message window",
		"Editor windows" };

	num = 0;
	for(;;) {
		color = Cattrs[num];
		f = color & 0x0F;
		b = color & 0xF0;
		wopen(20, 9, 32, 8, (WSAVE|WCOPEN|WBOX2)|(color & 0xFF));
		title("Color Setup");
		wcursor_off();
		*W_OPEN = (f << 4) | (b >> 4);
		wgotoxy(0, 1);
		wputs(cnames[num]);
		*W_OPEN = color;
		wputs("\n\nUp/Down    = Change forground\n");
		wputs("Left/Right = Change background\n");
		wputs("PgUp/PgDn  = Change screen");
		switch(wgetc()) {
			case 0x1B :
				wclose();
				return;
			case _KPU : num = (num + 1) % 5;	break;
			case _KPD : num = (num + 4) % 5;	break;
			case _KUA : ++f;					goto setcolor;
			case _KDA : --f;					goto setcolor;
			case _KRA : b += 16;				goto setcolor;
			case _KLA : b -= 16;
			setcolor:
				Cattrs[num] = (color & 0xFF00) | (f & 0x0f) | (b & 0xF0);
			default: }
		wclose(); }
}

/*
 * Initialize uart after allowing change to parameters
 */
setup_serial()
{
	unsigned b;
	char buffer[6];
	static char *partab[] = { "Odd", "Even", "Mark", "Space", "None", 0 };

	wopen(30, 10, 20, 6, WSAVE|WCOPEN|WBOX2|REVERSE);
	title("COMM Setup");
	for(;;) {
		wgotoxy(0, 0);
		sprintf(buffer, "%u", scale(57600, 2, b = baud[baud_rate]));
		wprintf("(B)audrate:  %5s\n", baud_rate ? buffer : "Local");
		wprintf("(P)arity:    %5s\n", partab[parity]);
		wprintf("(D)ata bits: %5u\n", dbits+5);
		wprintf("(S)top bits: %5u", sbits+1);
		switch(toupper(wgetc())) {
			case _KUA :
				--b;
				goto setbaud;
			case _KDA :
				++b;
			setbaud:
				if(baud_rate) {
					if(b < 2) b = 2;
					baud[baud_rate] = b; }
				break;
			case 'B' :
				if(!baud[++baud_rate])
					baud_rate = 0;
				break;
			case 'P' :
				if(!partab[++parity])
					parity = 0;
				break;
			case 'D' :
				if(++dbits > 3)
					dbits = 0;
				break;
			case 'S' :
				if(++sbits > 1)
					sbits = 0;
				break;
			case 0x1B:
				wclose();
				return; } }
}

setup_sfrs(table, tsize)
	char table[];
	unsigned tsize;
{
	unsigned i, j, c, cmd;
	unsigned char buffer[10], buffer1[50], *ptr, *ptr1, *ptr2;
	static char *menu1[] = {
		"Change address",
		"Delete entry",
		"Insert before",
		"Insert after",
		0 };
	static char *form1[] = {
		21<<8|3,
		"\x00\x00\x08SFR name:",
		0 };
	static unsigned bank = 0;

	wopen(5, 1, 70, 22, WSAVE|WCOPEN|WBOX2|REVERSE);
	title("SFR Setup");
	cmd = 0;
	for(;;) {
		ptr = table;
		i = 0;
		do {
			wgotoxy(((i/20)*17)+1, i % 20);
			j = *ptr++;
			for(ptr1 = buffer; (c = *ptr) && !(c & 0x80); ++ptr)
				*ptr1++ = c;
			*ptr1 = 0;
			wprintf((i/20 == bank) ? "%c:" : "  ", (i%20)+'A');
			wprintf(" %-8s -%02x", buffer, j);
			++i; }
		while(*ptr);

		if((j = toupper(wgetc())) == 0x1B) {
			wclose();
			return; }

		if(j == ' ')
			bank = (bank + 1) % ((i+19)/20);
		if((j < 'A') || (j > 'T'))
			continue;

		ptr = table;
		j = i = (j - 'A') + (bank*20);
		while(*(ptr2 = ptr)) {
			++ptr;
			for(ptr1 = buffer; (c = *ptr) && !(c & 0x80); ++ptr)
				*ptr1++ = c;
			*ptr1 = 0;
			if(!i--) {
				if(!wmenu(20, 8, WSAVE|WBOX3|WCOPEN|NORMAL, menu1, &cmd)) switch(cmd) {
					case 3 :
						do ++ptr2;
						while(*ptr2 && !(*ptr2 & 0x80));
					case 2 :
						*buffer = 0;
						wform(20, 8, WSAVE|WBOX3|WCOPEN|NORMAL, form1, buffer);
						if(!(i = strlen(buffer)))
							break;
						while(*ptr) ++ptr;
						if((ptr1 = ptr + i + 1) >= (table + tsize)) {
							message("No space in SFR table");
							break; }
						while(ptr >= ptr2)
							*ptr1-- = *ptr--;
						*++ptr = 0xFF;
						ptr1 = buffer;
						while(*ptr1)
							*++ptr = *ptr1++;
					case 0 :
						sprintf(buffer1, "New address for %s? ", buffer);
						if(!get_number(buffer1, 16, &c)) {
							if((c >= 0x80) && (c <= 0xFF))
								*ptr2 = c;
							else
								message("Value must be between 80 and FF"); }
						break;
					case 1 :
						while(*ptr2++ = *ptr++);
						wclwin();
						break;
					}
				break; } } }
}

/*
 * Get an numeric value at a prompt
 */
get_number(prompt, base, var)
	char *prompt;
	int base, *var;
{
	unsigned int i, j, x, value, len;

	i = (len = (base == 10) ? 5 : 4) + strlen(prompt) + 3;
	wopen((80-i)/2, 10, i, 3, WSAVE|WBOX3|WCOPEN|NORMAL);
	wputs(prompt);
	wcursor_line();
	value = x = 0;
	for(;;) {
		switch(i = wgetc()) {
			case '\n' :
				if(x) {
					*var = value;
					wclose();
					return 0; }
			case 0x1B :
				wclose();
				return i;
			case _KBS :
			case _KLA :
				if(x) {
					--x;
					wputs("\b \b");
					value /= base; }
				break;
			default:
				if(isdigit(j = toupper(i)))		/* convert numeric digits */
					j -= '0';
				else if(j >= 'A')				/* convert alphabetics */
					j -= ('A' - 10);
				else							/* not a valid "digit" */
					break;
				if((x < len) && (j < base)) {
					wputc(i);
					++x;
					value = (value * base) + j; } } }
}

/*
 * Display a message and prompt for key
 */
message(ptr)
	char *ptr;
{
	int i;
	i = strlen(ptr)+2;
	wopen(40-(i/2), 10, i, 4, WSAVE|WCOPEN|WBOX1|REVERSE);
	wprintf("%s\nPress any key.", ptr);
	wgetc();
	wclose();
}

/*
 * Prompt for YES/NO response
 */
yesno(ptr)
	char *ptr;
{
	int i;

	i = strlen(ptr)+6;
	wopen((80-i)/2, 10, i, 3, WSAVE|WBOX3|WCOPEN|REVERSE);
	wprintf("%s ? Y", ptr);
	for(;;) switch(toupper(wgetc())) {
		case 'N' :
		case 0x1B :
			wclose();
			return 0;
		case '\n' :
		case 'Y' :
			wclose();
			return 1; }
}

/*
 * Set the hardware interface speed
 */
set_hardware()
{
	wopen(25, 10, 30, 4, WSAVE|WCOPEN|WBOX2|REVERSE);
	title("Target Speed Setup");
	wputs("\rUse Up/Down to change speed\nESC to exit.");
	for(;;) {
		if(hbaud < 2)
			hbaud = 2;
		wgotoxy(14, 1);
		wprintf("Speed: %-5u", scale(57600, 2, hbaud));
		switch(wgetc()) {
			case 0x1B :
				wclose();
				return;
			case _KUA :
				--hbaud;
				break;
			case _KDA :
				++hbaud; } }
}

/*
 * Set COMM port assignments
 */
set_comm()
{
	int i, t, s;
	static unsigned comaddr[] = { 0x3FD, 0x2FD, 0x3ED, 0x2ED };

	wopen(24, 10, 32, 5, WSAVE|WCOPEN|WBOX2|REVERSE);
	title("Serial Port Setup");
	for(i=t=s=0; i < 4; ++i) {
		if(comaddr[i] == com2)
			t = i;
		if(comaddr[i] == com1)
			s = i; }
	for(;;) {
		wgotoxy(0, 0);
		wprintf("S)erial: COM%u  (addr: %04x)\nT)arget: COM%u  (addr: %04x)",
			s+1, comaddr[s]-5, t+1, comaddr[t]-5);
		wputs("\nUse S/T to change, ESC to exit");
recmd:
		switch(wgetc()) {
			case 0x1B :
				if((com1 = comaddr[s]) == (com2 = comaddr[t])) {
					wputs("\rSerial / Target cannot be same\007");
					goto recmd; }
				com1 = comaddr[s];
				wclose();
				return;
			case 'T' :
			case 't' :
				t = (t + 1) & 0x03;
				break;
			case 'S' :
			case 's' :
				s = (s + 1) & 0x03; } }
}

/*
 * Set RESET logic level
 */
set_reset()
{
	wopen(22, 10, 34, 4, WSAVE|WCOPEN|WBOX2|REVERSE);
	title("Reset Setup");
	wputs("\rUse SPACE to change, ESC to exit");
	for(;;) {
		wgotoxy(0, 1);
		wprintf("Reset when RTS %sasserted.  ", reset ? "de" : "");
		switch(wgetc()) {
			case 0x1B :
				wclose();
				return;
			case ' ' :
				reset = reset ? 0 : -1; } }
}

/*
 * Display a title on a window
 */
title(ptr)
	char *ptr;
{
	char buffer[6];
	memcpy(buffer, W_OPEN, 6);
	*W_OPEN = REVERSE;
	W_OPEN[1] &= (~WBOX3 >> 8);
	--W_OPEN[3];
	wgotoxy(0,0);
	wprintf(" %s ", ptr);
	memcpy(W_OPEN, buffer, 6);
}

/*
 * Scale to a fractional value
 */
scale(value, multiply, divide) asm
{
		MOV		AX,8[BP]		; Get value
		MUL		WORD PTR 6[BP]	; Multiply to 32 bit product
		MOV		BX,4[BP]		; Get divisor
		DIV		BX				; Divide back to 16 bit result
		SHR		BX,1			; /2 for test
		INC		DX				; .5 rounds up
		SUB		BX,DX			; Set 'C' if remainder > half
		ADC		AX,0			; Increment result to scale
}
