;
; 8052 simulator for EMILY
;
; ?COPY.TXT 1991-2005 Dave Dunfield
; **See COPY.TXT**.
;
DGRP	GROUP	DSEG,BSEG
CSEG	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CSEG, DS:DGRP, SS:DGRP
	PUBLIC	_single_step, _multi_step, _isbreak, _patchio
	PUBLIC	_read_direct, _write_direct, _set_bit, _push16
	PUBLIC	_podcmd, _podrd, _rdpod, _wrpod, _SFRinit
	EXTRN	?temp:WORD, _com1:WORD, _com2:WORD, _mflag:BYTE
	EXTRN	_baud_rate:BYTE, _local_flag:BYTE, _local_menu:NEAR
	EXTRN	_wputc:NEAR, _wupdatexy:NEAR, _wclose:NEAR, _wgetc:NEAR
	EXTRN	_iomlo:WORD, _iomhi:WORD
; Opcode handler jump table
OJMPT	LABEL	WORD
	DW	?NOP		; 00	No operation
	DW	?AJMP		; 01
	DW	?LJMP		; 02	Long jump
	DW	?RRA		; 03	Rotate A right
	DW	?INCA		; 04	Increment A
	DW	?INCD		; 05	Increment Dir
	DW	?INCI		; 06-07	Increment Ind
	DW	?INCI		; 07
	DW	?INCR		; 08-0F	Increment Rn
	DW	?INCR		; 09
	DW	?INCR		; 0A
	DW	?INCR		; 0B
	DW	?INCR		; 0C
	DW	?INCR		; 0D
	DW	?INCR		; 0E
	DW	?INCR		; 0F
	DW	?JBC		; 10	Jump if BIT set & clear BIT
	DW	?ACALL		; 11
	DW	?LCALL		; 12	Long call
	DW	?RRCA		; 13	Rotate A right through cy
	DW	?DECA		; 14	Decrement A
	DW	?DECD		; 15	Decrement Dir
	DW	?DECI		; 16-17	Decrement Ind
	DW	?DECI		; 17
	DW	?DECR		; 18-1F	Decrement Rn
	DW	?DECR		; 19
	DW	?DECR		; 1A
	DW	?DECR		; 1B
	DW	?DECR		; 1C
	DW	?DECR		; 1D
	DW	?DECR		; 1E
	DW	?DECR		; 1F
	DW	?JB		; 20	Jump if BIT set
	DW	?AJMP		; 21
	DW	?RET		; 22	Return from sub
	DW	?RLA		; 23	Rotate A left
	DW	?ADDAM		; 24	Add A + Imm
	DW	?ADDAD		; 25	Add A + dir
	DW	?ADDAI		; 26-27 Add A + Ind
	DW	?ADDAI		; 27
	DW	?ADDAR		; 28-2F	Add A + Rn
	DW	?ADDAR		; 29
	DW	?ADDAR		; 2A
	DW	?ADDAR		; 2B
	DW	?ADDAR		; 2C
	DW	?ADDAR		; 2D
	DW	?ADDAR		; 2E
	DW	?ADDAR		; 2F
	DW	?JNB		; 30	Jump if BIT not set
	DW	?ACALL		; 31
	DW	?RETI		; 32	Return from int
	DW	?RLCA		; 33	Rotate A left through cy
	DW	?ADDCM		; 34	Add A + Imm
	DW	?ADDCD		; 35	Add A + Dir
	DW	?ADDCI		; 36-37	Add A + Ind
	DW	?ADDCI		; 37
	DW	?ADDCR		; 38-3F	Add A + Rn (with cy)
	DW	?ADDCR		; 39
	DW	?ADDCR		; 3A
	DW	?ADDCR		; 3B
	DW	?ADDCR		; 3C
	DW	?ADDCR		; 3D
	DW	?ADDCR		; 3E
	DW	?ADDCR		; 3F
	DW	?JC		; 40	Jump on cy
	DW	?AJMP		; 41
	DW	?ORLDA		; 42	OR Dir + A
	DW	?ORLDM		; 43	OR Dir + Imm
	DW	?ORLAM		; 44	OR A + Imm
	DW	?ORLAD		; 45	OR A + Dir
	DW	?ORLAI		; 46-47	OR A + Ind
	DW	?ORLAI		; 47
	DW	?ORLAR		; 48-4F	OR A + Rn
	DW	?ORLAR		; 49
	DW	?ORLAR		; 4A
	DW	?ORLAR		; 4B
	DW	?ORLAR		; 4C
	DW	?ORLAR		; 4D
	DW	?ORLAR		; 4E
	DW	?ORLAR		; 4F
	DW	?JNC		; 50	Jump on NO cy
	DW	?ACALL		; 51
	DW	?ANLDA		; 52	And Dir + a
	DW	?ANLDM		; 53	And Dir + Imm
	DW	?ANLAM		; 54	And A + Imm
	DW	?ANLAD		; 55	And A + Dir
	DW	?ANLAI		; 56	And A + Ind
	DW	?ANLAI		; 57
	DW	?ANLAR		; 58-5F	And A + Rn
	DW	?ANLAR		; 59
	DW	?ANLAR		; 5A
	DW	?ANLAR		; 5B
	DW	?ANLAR		; 5C
	DW	?ANLAR		; 5D
	DW	?ANLAR		; 5E
	DW	?ANLAR		; 5F
	DW	?JZ		; 60	Jump on z
	DW	?AJMP		; 61
	DW	?XRLDA		; 62	XOR Dir + A
	DW	?XRLDM		; 63	XOR Dir + Imm
	DW	?XRLAM		; 64	XOR A + Imm
	DW	?XRLAD		; 65	XOR A + Dir
	DW	?XRLAI		; 66-67	XOR A + Ind
	DW	?XRLAI		; 67
	DW	?XRLAR		; 68-6F	XOR A + Rn
	DW	?XRLAR		; 69
	DW	?XRLAR		; 6A
	DW	?XRLAR		; 6B
	DW	?XRLAR		; 6C
	DW	?XRLAR		; 6D
	DW	?XRLAR		; 6E
	DW	?XRLAR		; 6F
	DW	?JNZ		; 70	Jump on NO z
	DW	?ACALL		; 71
	DW	?ORLCB		; 72	OR Cy and BIT
	DW	?JMP		; 73	Jump [A+DPTR]
	DW	?MOVAM		; 74	Move Imm to A
	DW	?MOVDM		; 75	Move Imm to Dir
	DW	?MOVIM		; 76-77	Move Imm to Ind
	DW	?MOVIM		; 77
	DW	?MOVRM		; 78-7F	Move Imm to Rn
	DW	?MOVRM		; 79
	DW	?MOVRM		; 7A
	DW	?MOVRM		; 7B
	DW	?MOVRM		; 7C
	DW	?MOVRM		; 7D
	DW	?MOVRM		; 7E
	DW	?MOVRM		; 7F
	DW	?SJMP		; 80	Short jump
	DW	?AJMP		; 81
	DW	?ANLCB		; 82	And CY with BIT
	DW	?MOVCP		; 83	Move A from [A+PC]
	DW	?DIV		; 84	Divide
	DW	?MOVDD		; 85 	Move Dir to Dir
	DW	?MOVDI		; 86-87	Move Ind to Dir
	DW	?MOVDI		; 87
	DW	?MOVDR		; 88-8F	Move Dir to Rn
	DW	?MOVDR		; 89
	DW	?MOVDR		; 8A
	DW	?MOVDR		; 8B
	DW	?MOVDR		; 8C
	DW	?MOVDR		; 8D
	DW	?MOVDR		; 8E
	DW	?MOVDR		; 8F
	DW	?MOVDP		; 90	Move Imm to DPTR
	DW	?ACALL		; 91
	DW	?MOVBC		; 92	Move Bit from C
	DW	?MOVCD		; 93	Move A from [A+DPTR]
	DW	?SUBBM		; 94	Subtract Imm from A
	DW	?SUBBD		; 95	Subtract Dir from A
	DW	?SUBBI		; 96-97	Subtract Ind from A
	DW	?SUBBI		; 97
	DW	?SUBBR		; 98-9F	Subtract Rn from A
	DW	?SUBBR		; 99
	DW	?SUBBR		; 9A
	DW	?SUBBR		; 9B
	DW	?SUBBR		; 9C
	DW	?SUBBR		; 9D
	DW	?SUBBR		; 9E
	DW	?SUBBR		; 9F
	DW	?ORLCN		; A0	OR Cy & not BIT
	DW	?AJMP		; A1
	DW	?MOVCB		; A2	Move CY from BIT
	DW	?INCDP		; A3	Increment DPTR
	DW	?MUL		; A4	Multiply
	DW	ILLEGAL		; A5	ILLEGAL OPCODE
	DW	?MOVID		; A6-A7	Move Dir to Ind
	DW	?MOVID		; A7
	DW	?MOVRD		; A8-AF	Move Dir to Rn
	DW	?MOVRD		; A9
	DW	?MOVRD		; AA
	DW	?MOVRD		; AB
	DW	?MOVRD		; AC
	DW	?MOVRD		; AD
	DW	?MOVRD		; AE
	DW	?MOVRD		; AF
	DW	?ANLCN		; B0	And CY with NOT BIT
	DW	?ACALL		; B1
	DW	?CPLB		; B2	Complement BIT
	DW	?CPLC		; B3 	Complement CY
	DW	?CJNAM		; B4	CJNE A,Imm,Rel
	DW	?CJNAD		; B5	CJNE A,Dir,Rel
	DW	?CJNIM		; B6-B7	CJNE Ind,Imm,Rel
	DW	?CJNIM		; B7	
	DW	?CJNRM		; B8-BF	CJNE Rn,Imm,Rel
	DW	?CJNRM		; B9
	DW	?CJNRM		; BA
	DW	?CJNRM		; BB
	DW	?CJNRM		; BC
	DW	?CJNRM		; BD
	DW	?CJNRM		; BE
	DW	?CJNRM		; BF
	DW	?PUSH		; C0	Push
	DW	?AJMP		; C1
	DW	?CLRB		; C2	Clear BIT
	DW	?CLRC		; C3	Clear CY
	DW	?SWAP		; C4	Swap AH/AL
	DW	?XCHAD		; C5	XCH A + Dir
	DW	?XCHAI		; C6-C7	XCH A + Ind
	DW	?XCHAI		; C7
	DW	?XCHAR		; C8-CF	XCH A + Rn
	DW	?XCHAR		; C9
	DW	?XCHAR		; CA
	DW	?XCHAR		; CB
	DW	?XCHAR		; CC
	DW	?XCHAR		; CD
	DW	?XCHAR		; CE
	DW	?XCHAR		; CF
	DW	?POP		; D0	Pop
	DW	?ACALL		; D1
	DW	?SETBB		; D2	Set BIT
	DW	?SETBC		; D3	Set CY
	DW	?DAA		; D4	Decimal adjust
	DW	?DJNZD		; D5	DJNZ Dir
	DW	?XCHD		; D6-D7	Exchange A + [Rn]
	DW	?XCHD		; D7
	DW	?DJNZR		; D8-DF	DJNZ Rn
	DW	?DJNZR		; D9
	DW	?DJNZR		; DA
	DW	?DJNZR		; DB
	DW	?DJNZR		; DC
	DW	?DJNZR		; DD
	DW	?DJNZR		; DE
	DW	?DJNZR		; DF
MOVAE:	DW	?MOVAE		; E0	Move A from [DPTR]
	DW	?AJMP		; E1
MOVAF1:	DW	?MOVAF		; E2-E3	Move A from DSEG:[Rn]
MOVAF2:	DW	?MOVAF		; E3
	DW	?CLRA		; E4	Clear A
	DW	?MOVAD		; E5	Move Dir to A
	DW	?MOVAI		; E6-E7	Move Ind to A
	DW	?MOVAI		; E7
	DW	?MOVAR		; E8-EF	Move Rn to A
	DW	?MOVAR		; E9
	DW	?MOVAR		; EA
	DW	?MOVAR		; EB
	DW	?MOVAR		; EC
	DW	?MOVAR		; ED
	DW	?MOVAR		; EE
	DW	?MOVAR		; EF
MOVEA:	DW	?MOVEA		; F0	Move [DPTR] from A
	DW	?ACALL		; F1
MOVFA1:	DW	?MOVFA		; F2-F3	Move DSEG:[Rn] from A
MOVFA2:	DW	?MOVFA		; F3
	DW	?CPLA		; F4	Complement A
	DW	?MOVDA		; F5	Move Dir to A
	DW	?MOVIA		; F6-F7	Move A to Ind
	DW	?MOVIA		; F7
	DW	?MOVRA		; F8-FF	Move A to Rn
	DW	?MOVRA		; F9
	DW	?MOVRA		; FA
	DW	?MOVRA		; FB
	DW	?MOVRA		; FC
	DW	?MOVRA		; FD
	DW	?MOVRA		; FE
	DW	?MOVRA		; FF
;
; 'C' callable read direct memory
;
_read_direct:
	MOV	BX,SP		; Point to parms
	MOV	AH,2[BX]	; Get address
	CALL	RDIRX		; Perform the read
	XOR	AH,AH		; Zero high
	RET
;
; 'C' callable write direct memory
;
_write_direct:
	MOV	BX,SP		; Address parms
	MOV	AH,4[BX]	; Get address
	MOV	AL,2[BX]	; Get value
	JMP	WDIRX		; Write it
;
; 'C' callable write bit location
;
_set_bit:
	MOV	BX,SP		; Address parms
	MOV	AH,2[BX]	; Get bit locaton
	MOV	AL,1		; Set the BIT
	JMP	WBITX		; Write it
;
; Write a command to the serial port, and read back a value
;
_podcmd:CALL	_wrpod		; Write the command
_podrd:	PUSH	CX		; Save
	XOR	CX,CX		; Zero counter
podc1:	CALL	_rdpod		; Attempt to read
	LOOPZ	podc1		; Do it again
	POP	CX		; Restore
	RET
;
; Read a value from the serial port
;
_rdpod:	PUSH	DX		; Save ACC
	MOV	DX,DGRP:_com2	; Get COM address
	IN	AL,DX		; Read status
	AND	AL,01h		; Character ready?
	JZ	rser1		; No, wait for it
	SUB	DX,5		; Backup to data
	IN	AL,DX		; Read the data
rser1:	POP	DX		; Restore ACC
	RET
;
; Write a value to the serial port
;
_wrpod:	PUSH	DX		; Save ACC
	PUSH	AX		; Save
wser1:	MOV	DX,DGRP:_com2	; Get COM address
	IN	AL,DX		; Read status
	AND	AL,20h		; Tx ready?
	JZ	wser1		; No, its not
	SUB	DX,5		; Backup to data
	POP	AX		; Restore
	OUT	DX,AL		; Write it
	POP	DX		; Restore ACC
	RET
;
; Test for breakpoint
;
_isbreak: MOV	BX,SP		; Address parms
	MOV	CX,2[BX]	; Get parameter
	MOV	BX,OFFSET DGRP:_BRKPTS; Point to table
isb1:	MOV	AX,[BX]		; Get data byte
	AND	AX,AX		; End of table?
	JZ	isb2		; Not a breakpoint
	INC	BX		; Advance
	INC	BX		; Advance
	CMP	AX,CX		; Match?
	JNZ	isb1		; No, its not
	MOV	AX,20[BX]	; Return breakpoint flags
isb2:	RET
;
; Step one ONE instruction
;
_single_step:
	MOV	BYTE PTR DGRP:INTFLAG,-1; Indicate no interrupts
	CALL	LOADX		; Load up the registers
	PUSH	BP		; Save callers stack frame
	MOV	BP,DGRP:_TRCPTR	; Get pointer
	CALL	S8051		; Step one instruction
	JMP	SAVE		; Resave the registers
;
; Multi step several instructions
;
_multi_step:
; First patch into keyboard vector for ESCAPE abort
	MOV	AX,3509h	; Get INT 09 vector
	INT	21h		; Ask DOS
	MOV	DGRP:INT09_O,BX	; Save offset
	MOV	DGRP:INT09_S,ES	; Save segment
	MOV	DX,OFFSET INT09	; Get address of handler
	MOV	AX,2509h	; Set INT 09 vector
	INT	21h		; Ask DOS
	MOV	BYTE PTR DGRP:INTFLAG,0; Indicate we captured interrupts
; Get parameter, and determine execution type
	MOV	BX,SP		; Address parms
	MOV	AX,2[BX]	; Read parm
	PUSH	BP		; Save callers stack frame
	MOV	BP,DGRP:_TRCPTR	; Get pointer
	AND	AX,AX		; Continuous?
	JZ	mstep3		; Yes, do it
; Metered execution...
	MOV	DGRP:?temp,AX	; Save count
	CALL	LOAD		; Load the registers
mstep1:	CALL	S8051		; Step one instruction
	DEC	WORD PTR DGRP:?temp; Reduce count
	JZ	mstep6		; End, terminate
	MOV	BX,OFFSET DGRP:_BRKPTS;
mstep2:	MOV	AX,[BX]		; Read value
	AND	AX,AX		; End of table?
	JZ	mstep1		; Yes, exit
	INC	BX		; Advance
	INC	BX		; Advance
	CMP	AX,SI		; This one?
	JNZ	mstep2		; No, keep looking
	JMP 	SHORT mstep6	; Save & exit
; Continuous execution...
mstep3:	CALL	LOAD		; Load the registers
mstep4:	CALL	S8051		; Step the instruction
	MOV	BX,OFFSET DGRP:_BRKPTS;
mstep5:	MOV	AX,[BX]		; Read value
	AND	AX,AX		; End of table?
	JZ	mstep4		; Yes, continue
	INC	BX		; Advance
	INC	BX		; Advance
	CMP	AX,SI		; At this address?
	JNZ	mstep5		; No, keep looking
; Restore interrupt vectors & exit
mstep6:	PUSH	DX		; Save DX
	PUSH	DS		; Save DS
	MOV	DX,DGRP:INT09_O	; Get offset
	MOV	DS,DGRP:INT09_S	; Get segment
	MOV	AX,2509h	; Set INT 09 vector
	INT	21h		; Ask DOS
	POP	DS		; Restore DS
	POP	DX		; Restore DX
	JMP	SAVE		; Save registers & exit
;
; Illegal opcode detected, report
;
ILLEGAL:DEC	SI		; Backup to it
HALT:	XOR	AL,AL		; Get zero
	MOV	DGRP:_mflag,AL	; Indicate we stopped
	POP	AX		; Skip return address
	MOV	AL,DGRP:INTFLAG	; Get interrupt flag
	AND	AL,AL		; Enabled?
	JZ	mstep6		; Release INTs and exit
	JMP	SAVE		; Save registers & exit
;
; Keyboard handler, test for key & exit if ESCAPE is pressed
;
KEY:	MOV	WORD PTR DGRP:S8051,0B689h; Reset code
	MOV	AL,DGRP:_Aflag	; Get abort flag
	AND	AL,AL		; Abort pending?
	JZ	key3		; Yes, handle it
	MOV	AH,01h		; Func 1 - Get key status
	INT	16h		; Ask BIOS
	JZ	S8051		; No key, ignore
	XOR	AH,AH		; Func - Get key
	INT	16h		; Ask BIOS
	CMP	AL,1Bh		; Escape?
	JNZ	key1		; No, handle as local character
; ESCAPE key pressed
key3:	MOV	BYTE PTR DGRP:_Aflag,-1 ; Reset flag
	MOV	AH,DGRP:_baud_rate; Get baud rate setting
	AND	AH,AH		; Local mode?
	JNZ	HALT		; No, just stop it
	PUSH	DX		; Save 8051 ACC
	PUSH	SI		; Save 8051 PC
	PUSH	DI		; Save 8051 DPTR
	CALL	_local_menu	; Present to local menu
	POP	DI		; Restore 8051 DPTR
	POP	SI		; Restore 8051 PC
	POP	DX		; Restore 8051 ACC
	AND	AL,AL		; Ignore?
	JZ	S8051		; Keep simulating
	DEC	AL		; 1 - send escape?
	JNZ	HALT		; No, exit
	MOV	AL,1Bh		; Get ESCAPE
	JMP	SHORT key2	; And pass it on
; Non-ESCAPE key pressed
key1:	MOV	AH,DGRP:_baud_rate; Get baud rate setting
	AND	AH,AH		; Local mode?
	JNZ	S8051		; No, no keyboard input
; Local mode - set character from keyboard
key2:	MOV	DGRP:_INTRAM+119h,AL; Write SBUF
	MOV	AL,DGRP:_INTRAM+118h; Get SCON
	OR	AL,01		; Set RX ready
	MOV	DGRP:_INTRAM+118h,AL; Resave SCON
;
; Simulate an 8051 instruction
; DH=B, DL=A, DI=DPTR, SI=PC, ES=Code segment
;
; Note first word of this routine is patched to 89B6 (MOV) or
; EBxx (SJMP KEY) by the execution routines and the INT9 handler.
;
S8051:	MOV	DGRP:_TRCBUF[BP],SI; Save PC
	INC	BP		; Advance
	INC	BP		; Advance
	AND	BP,1FFFh	; Mask for 8K table
	MOV	BL,ES:[SI]	; Get opcode
	INC	SI		; Advance PC
	XOR	BH,BH		; Zero HIGH
	SHL	BX,1		; X2 for words
	JMP	OJMPT[BX]	; Execute handler
;
; Program Transfer instructions
;
; ACALL instruction
?ACALL:	LEA	AX,1[SI]	; Get new PC
	CALL	push16		; Write it out
; AJUMP instruction
?AJMP:	SHL	BX,1		; Shift in
	SHL	BX,1		; Shift in
	MOV	BL,ES:[SI]	; Get LOW
	AND	SI,0F800h	; Mask low buts
	OR	SI,BX		; Insert new
	RET
; LCALL instruction
?LCALL:	LEA	AX,2[SI]	; Get RET address
	CALL	push16		; Write it out
; LJUMP instruction
?LJMP:	MOV	AH,ES:[SI]	; Get HIGH byte
	MOV	AL,ES:1[SI]	; Get LOW byte
	MOV	SI,AX		; Set PC
	RET
; JMP instruction
?JMP:	MOV	BL,DL		; Get LOW address
	XOR	BH,BH		; Zero HIGH
	ADD	BX,DI		; Include DPTR
	MOV	SI,BX		; Set up PC
	RET
; RET instruction
?RETI:
?RET:	CALL	pop16		; Restore the PC
	MOV	SI,AX		; Set up PC
	RET
; DJNZ Rn instruction
?DJNZR:	CALL	RREG		; Read the register
	DEC	AL		; Reduce the count
	MOV	DGRP:_INTRAM[BX],AL; Write new value
	JNZ	?SJMP		; Not zero, execute jump
	INC	SI		; Skip address
	RET
; DJNZ Direct instruction
?DJNZD:	CALL	RDIR		; Read direct memory
	DEC	AL		; Reduce the count
	MOV	AH,ES:-1[SI]	; Get address back
	CALL	WDIRX		; Write the memory
	AND	AL,AL		; Zero?
	JNZ	?SJMP		; No, do the jump
	INC	SI		; Skip address
	RET
; Jump if BIT set
?JB:	CALL	RBIT		; Read the BIT
	JNZ	?SJMP		; Bit is set
	INC	SI		; Skip address
	RET
; Jump if BIT not set
?JNB:	CALL	RBIT		; Read the BIT
	JZ	?SJMP		; Bit is clear
	INC	SI		; Skip address
	RET
; Jump if BIT set and clear BIT
?JBC:	CALL	RBIT		; Read the bit
	JNZ	jbc1		; Set, do stuff
	INC	SI		; Skip address
	RET
jbc1:	XOR	AL,AL		; Zero bit
	MOV	AH,ES:-1[SI]	; Get address
	CALL	WBITX		; Clear BIT
	JMP	SHORT ?SJMP	; And proceed
; Jump if CARRY set
?JC:	PUSH	WORD PTR DGRP:FLAGS; Get flags
	POPF			; Restore them
	JC	?SJMP		; Perform JUMP
	INC	SI		; Skip address
	RET
; Jump of CARRY is NOT set
?JNC:	PUSH	WORD PTR DGRP:FLAGS; Get flags
	POPF			; Restore them
	JNC	?SJMP		; Perform JUMP
	INC	SI		; Skip address
	RET
; Jump if ACC is zero
?JZ:	AND	DL,DL		; Is ACC zero?
	JZ	?SJMP		; Yes, do the jump
JZ1:	INC	SI		; Skip address
	RET
; Jump if ACC is NOT zero
?JNZ:	AND	DL,DL		; Is ACC zero?
	JZ	JZ1		; Yes, don't execute
; SJMP instruction
?SJMP:	MOV	AL,ES:[SI]	; Get address
	INC	SI		; Advance
	CBW			; To 16 bits
	ADD	SI,AX		; Add to PC
?NOP:	RET
; CJNE A,Dir,Rel
?CJNAD:	CALL	RDIR		; Read direct value
	CMP	DL,AL		; Perform the compare
	PUSHF			; Save flags
	POP	WORD PTR DGRP:FLAGS; Save them
	JNZ	?SJMP		; Not same, jump
	INC	SI		; Skip address
	RET
; CJNE A,#DATA,Rel
?CJNAM:	MOV	AL,ES:[SI]	; Get value
	INC	SI		; Save flags
	CMP	DL,AL		; Perform the compare
	PUSHF			; Save flags
	POP	WORD PTR DGRP:FLAGS; Save them
	JNZ	?SJMP		; Not same, jump
	INC	SI		; Skip address
	RET
; CJNE Rn,#DATA,Rel
?CJNRM:	CALL	RREG		; Read register
	MOV	AH,ES:[SI]	; Get value
	INC	SI		; Advance
	CMP	AL,AH		; Perform the compare
	PUSHF			; Save flags
	POP	WORD PTR DGRP:FLAGS; Save them
	JNZ	?SJMP		; Not same, jump
	INC	SI		; Skip address
	RET
; CJNE [Ri],#DATA,Rel
?CJNIM:	CALL	RIND		; Read indirect
	MOV	AH,ES:[SI]	; Get value
	INC	SI		; Advance
	CMP	AL,AH		; Perform the compare
	PUSHF			; Save flags
	POP	WORD PTR DGRP:FLAGS; Save them
	JNZ	?SJMP		; Not same, jump
	INC	SI		; Skip address
	RET
;
; MOVE instructions
;
; Move A from register
?MOVAR:	CALL	RREG		; Read the register
	MOV	DL,AL		; Write ACC
	RET
; Move to A from direct
?MOVAD:	CALL	RDIR		; Read direct byte
	MOV	DL,AL		; Write ACC
	RET
; Move to A from indirect
?MOVAI:	CALL	RIND		; Read indirect
	MOV	DL,AL		; Write ACC
	RET
; Move to A from immediate
?MOVAM:	MOV	DL,ES:[SI]	; Read data
	INC	SI		; Advance
	RET
; Move to register from A
?MOVRA:	MOV	AL,DL		; Get ACC
	JMP	WREG		; Write it
; Move to register from direct
?MOVRD:	CALL	RDIR		; Read direct value
	MOV	BL,ES:-2[SI]	; Get the opcode
	JMP	WREGX		; Write it out
; Move to register from immediate
?MOVRM:	MOV	AL,ES:[SI]	; Read the data
	INC	SI		; Advance
	JMP	WREG		; And write it out
; Move to direct from A
?MOVDA:	MOV	AL,DL		; Get ACC
	JMP	WDIR		; Write it out
; Move to direct from register
?MOVDR:	CALL	RREG		; Read the register
	JMP	WDIR		; Write it out
; Move to direct from direct
?MOVDD:	CALL	RDIR		; Read direct
	JMP	WDIR		; Write it out
; Move to direct from indirect
?MOVDI:	CALL	RIND		; Read indirect
	JMP	WDIR		; Write direct
; Move to direct from immediate
?MOVDM:	MOV	AH,ES:[SI]	; Get dir address
	INC	SI		; Advance
	MOV	AL,ES:[SI]	; Get data byte
	INC	SI		; Advance
	JMP	WDIRX		; Write it out
; Move to indirect from A
?MOVIA:	MOV	AL,DL		; Get ACC
	JMP	WIND		; Write it
; Move to indirect from DIRECT
?MOVID:	CALL	RDIR		; Read direct
	MOV	BL,ES:-2[SI]	; Get ind address
	JMP	WINDX		; And write it
; Move to indirect from immediate
?MOVIM:	MOV	AL,ES:[SI]	; Get immediate
	INC	SI		; Advance
	JMP	WIND		; And write it
; Move to DPTR from immediate
?MOVDP:	MOV	AH,ES:[SI]	; Get HIGH data
	INC	SI		; Advance
	MOV	AL,ES:[SI]	; Get LOW data
	INC	SI		; Advance
	MOV	DI,AX		; Set DPTR
	RET
; Move to ACC from DPTR+ACC
?MOVCD:	MOV	BL,DL		; Get ACC
	XOR	BH,BH		; Zero high
	MOV	DL,ES:[DI+BX]	; Read the value
	RET
; Move to ACC from PC+ACC
?MOVCP:	MOV	BL,DL		; Get ACC
	XOR	BH,BH		; Zero high
	MOV	DL,ES:[SI+BX]	; Read the value
	RET
; Move to ACC from [DPTR]
?MOVAE:	PUSH	ES		; Save ES
	MOV	ES,DGRP:_DSEG	; Get data seg
	MOV	DL,ES:[DI]	; Read data
	POP	ES		; Restore ES
	RET
; Move to [DPTR] from ACC
?MOVEA:	PUSH	ES		; Save ES
	MOV	ES,DGRP:_DSEG	; Get data seg
	MOV	ES:[DI],DL	; Write it
	POP	ES		; Restore ES
	RET
; Move to ACC from EXT [Rn]
?MOVAF:	SHR	BL,1		; Shift back
	AND	BL,01h		; Mask register bits
	MOV	AL,DGRP:_PSW	; Get register bank
	AND	AL,18h		; Save bank select bits
	OR	BL,AL		; Include in address
	XOR	BH,BH		; Zero high
	MOV	BL,DGRP:_INTRAM[BX]; Read register contents
	MOV	BH,DGRP:_INTRAM+120h; High is P2 output latch
	PUSH	ES		; Save ES
	MOV	ES,DGRP:_DSEG	; Get data seg
	MOV	DL,ES:[BX]	; Read value
	POP	ES		; Restore ES
	RET
; Move to EXT [Rn] from ACC
?MOVFA:	SHR	BL,1		; Shift back
	AND	BL,01h		; Mask register bits
	MOV	AL,DGRP:_PSW	; Get register bank
	AND	AL,18h		; Save bank select bits
	OR	BL,AL		; Include in address
	XOR	BH,BH		; Zero high
	MOV	BL,DGRP:_INTRAM[BX]; Read register contents
	MOV	BH,DGRP:_INTRAM+120h; High is P2 output latch
	PUSH	ES		; Save ES
	MOV	ES,DGRP:_DSEG	; Get data seg
	MOV	ES:[BX],DL	; Write value
	POP	ES		; Restore ES
	RET
; Move to CY from BIT
?MOVCB:	CALL	RBIT		; Read the bit
	MOV	BX,DGRP:FLAGS	; Get flags
	AND	BL,0FEh		; Remove old carry
	OR	BL,AL		; Add in new
	MOV	DGRP:FLAGS,BX	; Resave flags
	RET
; Move to BIT from CY
?MOVBC:	MOV	AX,DGRP:FLAGS	; Get carry state
	JMP	WBIT		; Write the bit
;
; Exchange instructions
;
; Exchange A with regsiter
?XCHAR:	CALL	RREG		; Read the register
	XCHG	AL,DL		; Swap it
	MOV	DGRP:_INTRAM[BX],AL; Write back
	RET
; Exchange A with direct
?XCHAD:	CALL	RDIR		; Read direct
	XCHG	AL,DL		; Swap it
	MOV	AH,ES:-1[SI]	; Get address back
	JMP	WDIRX		; And write it
; Exchange A with indirect
?XCHAI:	CALL	RIND		; Read indirect
	XCHG	AL,DL		; Swap it
	MOV	DGRP:_INTRAM[BX],AL; Write it back
	RET
; Exchange digit with [RI]
?XCHD:	CALL	RIND		; Read indirect
	MOV	AH,AL		; Save LOW
	AND	AH,0Fh		; Nibble of [Ri]
	MOV	CH,DL		; Save LOW
	AND	CH,0Fh		; Nibble of ACC
	AND	AL,0F0h		; Keep high [Ri]
	AND	DL,0F0h		; Keep high ACC
	OR	AL,CH		; Insert LOW ACC in [Ri]
	OR	DL,AH		; Insert LOW [Ri] in ACC
	MOV	DGRP:_INTRAM[BX],AL; Write it back
	RET
; Swap nibbles in accumulator
?SWAP:	ROL	DL,1		; Move first bit
	ROL	DL,1		; Move second bit
	ROL	DL,1		; Move third bit
	ROL	DL,1		; Move forth bit
	RET
;
; Push/Pop instructions
;
; Push value onto stack
?PUSH:	CALL	RDIR		; Read direct address
	MOV	BL,DGRP:_SP	; Get SP
	INC	BL		; Advance
	XOR	BH,BH		; Zero high
	MOV	DGRP:_INTRAM[BX],AL; Write value
	MOV	DGRP:_SP,BL	; Rewrite SP
	RET
; Pop value from stack
?POP:	MOV	BL,DGRP:_SP	; Get SP
	XOR	BH,BH		; Zero high
	MOV	AL,DGRP:_INTRAM[BX]; Read value
	DEC	BL		; Backup
	MOV	DGRP:_SP,BL	; Rewrite SP
	JMP	WDIR		; Write the value
;
; Increment & Decrement Instructions
;
; Increment accumulator
?INCA:	INC	DL		; Advance ACC
	RET
; Increment register
?INCR:	CALL	RREG		; Read register
	INC	AL		; ADvance
	MOV	DGRP:_INTRAM[BX],AL; Rewrite
	RET
; Increment direct
?INCD:	CALL	RDIR		; Read dir value
	INC	AL		; Advance
	MOV	AH,ES:-1[SI]	; Get address
	JMP	WDIRX		; Write it
; Increment indirect
?INCI:	CALL	RIND		; Read indirect value
	INC	AL		; Advance it
	MOV	DGRP:_INTRAM[BX],AL; Rewrite
	RET
; Decrement accumulator
?DECA:	DEC	DL		; Backup ACC
	RET
; Decrement register
?DECR:	CALL	RREG		; Read register
	DEC	AL		; Backup
	MOV	DGRP:_INTRAM[BX],AL; Rewrite
	RET
; Decrement direct
?DECD:	CALL	RDIR		; Read dir value
	DEC	AL		; Backup
	MOV	AH,ES:-1[SI]	; Get address
	JMP	WDIRX		; Write it
; Decrement indirect
?DECI:	CALL	RIND		; Read indirect value
	DEC	AL		; Backup
	MOV	DGRP:_INTRAM[BX],AL; Rewrite
	RET
; Increment DATA POINTER
?INCDP:	INC	DI		; Advance it
	RET
;
; Logical AND OR and XOR
;
; AND ACC with REG
?ANLAR:	CALL	RREG		; Read register
	AND	DL,AL		; Perform AND
	RET
; AND ACC with direct
?ANLAD:	CALL	RDIR		; Read direct
	AND	DL,AL		; Perform AND
	RET
; AND ACC with INDIRECT
?ANLAI:	CALL	RIND		; Read indirect
	AND	DL,AL		; Perform AND
	RET
; AND ACC with IMMEDIATE
?ANLAM:	AND	DL,ES:[SI]	; Perform AND
	INC	SI		; Advance
	RET
; AND direct with ACC
?ANLDA:	CALL	RDIR		; Get direct
	AND	AL,DL		; Perform AND
	MOV	AH,ES:-1[SI]	; Get address back
	JMP	WDIRX		; And re-write
; AND direct with immediate
?ANLDM:	CALL	RDIR		; Get direct
	AND	AL,ES:[SI]	; Perform AND
	MOV	AH,ES:-1[SI]	; Get address back
	INC	SI		; Advance
	JMP	WDIRX		; And re-write
; AND CARRY with BIT
?ANLCB:	CALL	RBIT		; Read a bit
	MOV	BX,DGRP:FLAGS	; Read the flags
	AND	BL,AL		; Perform an AND
	MOV	DGRP:FLAGS,BX	; Rewrite flags
	RET
; AND CARRY with NOT BIT
?ANLCN:	CALL	RBIT		; Read a bit
	XOR	AL,01h		; Toggle bit
	MOV	BX,DGRP:FLAGS	; Read flags
	AND	BL,AL		; Perform the AND
	MOV	DGRP:FLAGS,BX	; Rewrite flags
	RET
; OR ACC with REG
?ORLAR:	CALL	RREG		; Read register
	OR	DL,AL		; Perform OR
	RET
; OR ACC with direct
?ORLAD:	CALL	RDIR		; Read direct
	OR	DL,AL		; Perform OR
	RET
; OR ACC with INDIRECT
?ORLAI:	CALL	RIND		; Read indirect
	OR	DL,AL		; Perform OR
	RET
; OR ACC with IMMEDIATE
?ORLAM:	OR	DL,ES:[SI]	; Perform OR
	INC	SI		; Advance
	RET
; OR direct with ACC
?ORLDA:	CALL	RDIR		; Get direct
	OR	AL,DL		; Perform OR
	MOV	AH,ES:-1[SI]	; Get address back
	JMP	WDIRX		; And re-write
; OR direct with immediate
?ORLDM:	CALL	RDIR		; Get direct
	OR	AL,ES:[SI]	; Perform OR
	MOV	AH,ES:-1[SI]	; Get address back
	INC	SI		; Advance
	JMP	WDIRX		; And re-write
; OR CARRY with BIT
?ORLCB:	CALL	RBIT		; Read a bit
	MOV	BX,DGRP:FLAGS	; Read the flags
	OR	BL,AL		; Perform an OR
	MOV	DGRP:FLAGS,BX	; Rewrite flags
	RET
; OR CARRY with NOT BIT
?ORLCN:	CALL	RBIT		; Read a bit
	XOR	AL,01h		; Toggle bit
	MOV	BX,DGRP:FLAGS	; Read flags
	OR	BL,AL		; Perform the OR
	MOV	DGRP:FLAGS,BX	; Rewrite flags
	RET
; XOR ACC with REG
?XRLAR:	CALL	RREG		; Read register
	XOR	DL,AL		; Perform XOR
	RET
; XOR ACC with direct
?XRLAD:	CALL	RDIR		; Read direct
	XOR	DL,AL		; Perform XOR
	RET
; XOR ACC with INDIRECT
?XRLAI:	CALL	RIND		; Read indirect
	XOR	DL,AL		; Perform XOR
	RET
; XOR ACC with IMMEDIATE
?XRLAM:	XOR	DL,ES:[SI]	; Perform XOR
	INC	SI		; Advance
	RET
; XOR direct with ACC
?XRLDA:	CALL	RDIR		; Get direct
	XOR	AL,DL		; Perform XOR
	MOV	AH,ES:-1[SI]	; Get address back
	JMP	WDIRX		; And re-write
; XOR direct with immediate
?XRLDM:	CALL	RDIR		; Get direct
	XOR	AL,ES:[SI]	; Perform XOR
	MOV	AH,ES:-1[SI]	; Get address back
	INC	SI		; Advance
	JMP	WDIRX		; And re-write
;
; Arithmetic operations
;
; Add A and register
?ADDAR:	CALL	RREG		; Read the register
	ADD	DL,AL		; Perform the ADD
	PUSHF			; Save the flags
	POP	WORD PTR DGRP:FLAGS; Save for later
	RET
; Add A and direct
?ADDAD:	CALL	RDIR		; Read direct location
	ADD	DL,AL		; Perform the ADD
	PUSHF			; Save the flags
	POP	WORD PTR DGRP:FLAGS; Save for later
	RET
; Add A and indirect
?ADDAI:	CALL	RIND		; Read indirect location
	ADD	DL,AL		; Perform the ADD
	PUSHF			; Save the flags
	POP	WORD PTR DGRP:FLAGS; Save for later
	RET
; Add A and immediate
?ADDAM:	ADD	DL,ES:[SI]	; Perform the ADD
	PUSHF			; Save the flags
	POP	WORD PTR DGRP:FLAGS; Save for later
	INC	SI		; Skip immediate
	RET
; Add A and register with carry
?ADDCR:	CALL	RREG		; Read the register
	PUSH	WORD PTR DGRP:FLAGS; Save flags
	POPF			; Restore flags
	ADC	DL,AL		; Add with CARRY
	PUSHF			; Save the flags
	POP	WORD PTR DGRP:FLAGS; Save for later
	RET
; Add A and direct with carry
?ADDCD:	CALL	RDIR		; Read direct
	PUSH	WORD PTR DGRP:FLAGS; Save flags
	POPF			; Restore flags
	ADC	DL,AL		; Add with CARRY
	PUSHF			; Save the flags
	POP	WORD PTR DGRP:FLAGS; Save for later
	RET
; Add A and indirect with carry
?ADDCI:	CALL	RIND		; Read indirect
	PUSH	WORD PTR DGRP:FLAGS; Save flags
	POPF			; Restore flags
	ADC	DL,AL		; Add with CARRY
	PUSHF			; Save the flags
	POP	WORD PTR DGRP:FLAGS; Save for later
	RET
; Add A and immediate with carry
?ADDCM:	PUSH	WORD PTR DGRP:FLAGS; Save flags
	POPF			; Restore to active
	ADC	DL,ES:[SI]	; Add with carry
	PUSHF			; Save active flags
	POP	WORD PTR DGRP:FLAGS; Save for later
	INC	SI		; Advance
	RET
; Subtract register from A with borrow
?SUBBR:	CALL	RREG		; Read the register
	PUSH	WORD PTR DGRP:FLAGS; Save flags
	POPF			; Restore flags
	SBB	DL,AL		; Subtract with borrow
	PUSHF			; Save the flags
	POP	WORD PTR DGRP:FLAGS; Save for later
	RET
; Subtract direct from A with borrow
?SUBBD:	CALL	RDIR		; Read direct
	PUSH	WORD PTR DGRP:FLAGS; Save flags
	POPF			; Restore flags
	SBB	DL,AL		; Subtract with borrow
	PUSHF			; Save the flags
	POP	WORD PTR DGRP:FLAGS; Save for later
	RET
; Subtract indirect from A with borrow
?SUBBI:	CALL	RIND		; Read indirect
	PUSH	WORD PTR DGRP:FLAGS; Save flags
	POPF			; Restore flags
	SBB	DL,AL		; Subtract with borrow
	PUSHF			; Save the flags
	POP	WORD PTR DGRP:FLAGS; Save for later
	RET
; Subtract immediate from A with borrow
?SUBBM:	PUSH	WORD PTR DGRP:FLAGS; Save flags
	POPF			; Restore to active
	SBB	DL,ES:[SI]	; Subtract with borrow
	PUSHF			; Save active flags
	POP	WORD PTR DGRP:FLAGS; Save for later
	INC	SI		; Advance
	RET
; Multiply A & B
?MUL:	MOV	AL,DH		; Get 'B' value
	MUL	DL		; Multiply
	MOV	DX,AX		; Copy it
	CLC			; Clear carry
	PUSHF			; Save active flags
	POP	WORD PTR DGRP:FLAGS; Save for later
	RET
; Divide A/B
?DIV:	MOV	AL,DH		; Get 'B' value
	AND	AL,AL		; Zero?
	JZ	?div1		; Yes, set OV
	XCHG	AL,DL		; DL = divisor
	XOR	AH,AH		; Zero high
	DIV	DL		; Perform division
	MOV	DX,AX		; Copy results
	PUSHF			; Get value
	POP	AX		; Get value
	AND	AX,0F7FEh	; Clear CY and OV
	MOV	DGRP:FLAGS,AX	; Save flags
	RET
; Divide by ZERO, set OV and exit
?div1:	CLC			; Clear carry
	PUSHF			; Save flags
	POP	AX		; Get flag values
	OR	AX,0800h	; Set OV
	MOV	DGRP:FLAGS,AX	; Save flags
	RET
;
; Rotate instructions
;
; Rotate A left
?RLA:	ROL	DL,1		; Shift ACC left
	RET
; Rotate A right
?RRA:	ROR	DL,1		; Shift ACC right
	RET
; Rotate A left through carry
?RLCA:	PUSH	WORD PTR DGRP:FLAGS; Read flags
	POPF			; Restore to active
	RCL	DL,1		; Shift ACC with carry
	PUSHF			; Save active flags
	POP	WORD PTR DGRP:FLAGS; Save for later
	RET
; Rotate A right through carry
?RRCA:	PUSH	WORD PTR DGRP:FLAGS; Read flags
	POPF			; Restore to active
	RCR	DL,1		; Shift ACC with carry
	PUSHF			; Save active flags
	POP	WORD PTR DGRP:FLAGS; Save for later
	RET
;
; Misc Stuff
;
; Clear A
?CLRA:	XOR	DL,DL		; Zero ACC
	RET
; Clear CY
?CLRC:	MOV	AX,DGRP:FLAGS	; Get flags
	AND	AL,0FEh		; Zero carry
	MOV	DGRP:FLAGS,AX	; Resave
	RET
; Clear BIT
?CLRB:	XOR	AL,AL		; Zero AL
	JMP	WBIT		; And write the bot
; Complement A
?CPLA:	XOR	DL,0FFh		; Complement ACC
	RET
; Complement C
?CPLC:	MOV	AX,DGRP:FLAGS	; Get flags
	XOR	AL,01h		; Complement Carry
	MOV	DGRP:FLAGS,AX	; Resave
	RET
; Complement BIT
?CPLB:	CALL	RBIT		; Read the bit
	XOR	AL,01h		; Complement BIT
	MOV	AH,ES:-1[SI]	; Get address back
	JMP	WBITX		; And write it
; Set C
?SETBC:	MOV	AX,DGRP:FLAGS	; Get flags
	OR	AL,01h		; Set CY
	MOV	DGRP:FLAGS,AX	; Resave
	RET
; Set BIT
?SETBB:	MOV	AL,01h		; Get set flag
	JMP	WBIT		; Write it
; Decimal adjust A
?DAA:	MOV	AL,DL		; Get A
	PUSH	WORD PTR DGRP:FLAGS; Get flags
	POPF			; Make active
	DAA			; Adjust
	PUSHF			; Resave flags
	POP	WORD PTR DGRP:FLAGS; Resave flags
	MOV	DL,AL		; Save result
	RET
;
; Patch jump table with alternate IO/MEM functions
;
_patchio:
	MOV	WORD PTR DGRP:MOVEA,OFFSET _MOVEA
	MOV	WORD PTR DGRP:MOVAE,OFFSET _MOVAE
	MOV	WORD PTR DGRP:MOVAF1,OFFSET _MOVAF
	MOV	WORD PTR DGRP:MOVAF2,OFFSET _MOVAF
	MOV	WORD PTR DGRP:MOVFA1,OFFSET _MOVFA
	MOV	WORD PTR DGRP:MOVFA2,OFFSET _MOVFA
	RET
; Alternate Move ACC from [DPTR] with IO range
_MOVAE:	MOV	BX,DI		; Get memory address
rdiom:	CMP	BX,DGRP:_iomlo	; Is it out of range?
	JB	rdiom1		; Yes, handle it
	CMP	BX,DGRP:_iomhi	; Out or range?
	JA	rdiom1		; Yes, handle it
; Read memory via kernal call
	MOV	AL,62h		; Get "READP" command
	CALL	_wrpod		; Write it
	MOV	AL,01h		; Length = 1
	CALL	_wrpod		; Write it
	MOV	AL,BL		; Get low address
	CALL	_wrpod		; Write it
	MOV	AL,BH		; Get high address
	CALL	_podcmd		; Write & read
	MOV	DL,AL		; ACC = value
	RET
rdiom1:	PUSH	ES		; Save ES
	MOV	ES,DGRP:_DSEG	; Get data segment
	MOV	DL,ES:[BX]	; Read the value
	POP	ES		; Restore ES
	RET
; Alternate Move to ACC from EXT [Rn] with IO range
_MOVAF:	SHR	BL,1		; Shift back
	AND	BL,01h		; Mask register bits
	MOV	AL,DGRP:_PSW	; Get register bank
	AND	AL,18h		; Save bank select bits
	OR	BL,AL		; Include in address
	XOR	BH,BH		; Zero high
	MOV	BL,DGRP:_INTRAM[BX]; Read register contents
	MOV	BH,DGRP:_INTRAM+120h; High is P2 output latch
	JMP short rdiom		; Read the memory
; Alternate Move to [DPTR] from ACC with IO range
_MOVEA:	MOV	BX,DI		; Get memory address
wriom:	CMP	BX,DGRP:_iomlo	; Is it out of range
	JB	wriom1		; Yes, handle it
	CMP	BX,DGRP:_iomhi	; Is it out of range
	JA	wriom1		; Yes, handle it
	MOV	AL,63h		; Get "WRITEE" command
	CALL	_wrpod		; Write it
	MOV	AL,01h		; Length = 1
	CALL	_wrpod		; Write it
	MOV	AL,BL		; Get low address
	CALL	_wrpod		; Write it
	MOV	AL,BH		; Get high address
	CALL	_wrpod		; Write it
	MOV	AL,DL		; Get ACC
	JMP	_wrpod		; write it
wriom1:	PUSH	ES		; Save ES
	MOV	ES,DGRP:_DSEG	; Get data seg
	MOV	ES:[BX],DL	; Write it
	POP	ES		; Restore ES
	RET
; Alternate Move to EXT [Rn] from ACC with IO range
_MOVFA:	SHR	BL,1		; Shift back
	AND	BL,01h		; Mask register bits
	MOV	AL,DGRP:_PSW	; Get register bank
	AND	AL,18h		; Save bank select bits
	OR	BL,AL		; Include in address
	XOR	BH,BH		; Zero high
	MOV	BL,DGRP:_INTRAM[BX]; Read register contents
	MOV	BH,DGRP:_INTRAM+120h; High is P2 output latch
	JMP short wriom		; Write the memory
;
; ---------- Support routines ----------
;
;
; Push the 8 bit value in AL unto the 8051 stack
;
push8:	PUSH	BX		; Save BX
	XOR	BH,BH		; Zero high
	MOV	BL,DGRP:_SP	; Get stack ptr
	INC	BL		; Advance
	MOV	DGRP:_INTRAM[BX],AL; Write value
	MOV	DGRP:_SP,BL	; Rewrite stack
	POP	BX		; Restore BX
	RET
;
; 'C' callable 16 bit push
;
_push16:MOV	BX,SP		; Address parms
	MOV	AX,2[BX]	; Get value
;
; Push the 16 bit value in AX unto the 8051 stack
;
push16:	PUSH	BX		; Save BX
	XOR	BH,BH		; Zero high
	MOV	BL,DGRP:_SP	; Get stack pointer
	INC	BL		; Advance
	MOV	DGRP:_INTRAM[BX],AL; Write LOW byte
	INC	BL		; Advance
	MOV	DGRP:_INTRAM[BX],AH; Write HIGH byte
	MOV	DGRP:_SP,BL	; Rewrite stack
	POP	BX		; Restore BX
	RET
;
; Pop an 8 bit value into AL from the 8051 stack
;
pop8:	PUSH	BX		; Save BX
	XOR	BH,BH		; Zero high
	MOV	BL,DGRP:_SP	; Get stack pointer
	MOV	AL,DGRP:_INTRAM[BX]; Read value
	DEC	BL		; Backup
	MOV	DGRP:_SP,BL	; Rewrite stack
	POP	BX		; Restore BX
	RET
;
; Pop a 16 bit value into AX from the 8051 stack
;
pop16:	PUSH	BX		; Save BX
	XOR	BH,BH		; Zero high
	MOV	BL,DGRP:_SP	; Get stack pointer
	MOV	AH,DGRP:_INTRAM[BX]; Read HIGH byte
	DEC	BL		; Backup
	MOV	AL,DGRP:_INTRAM[BX]; Read LOW byte
	DEC	BL		; Backup
	MOV	DGRP:_SP,BL	; Rewrite stack
	POP	BX		; Restore BX
	RET
;
; Read a byte from direct memory (AH)
;
RDIR:	MOV	AH,ES:[SI]	; Get operand
	INC	SI		; Advance
RDIRX:	TEST	AH,80h		; Direct location
	JNZ	rdir1		; Special location
; Access internal RAM
	MOV	BL,AH		; Get ADDRESS
	XOR	BH,BH		; Zero HIGH
	MOV	AL,DGRP:_INTRAM[BX]; Read the data
	RET
; Simulate access to internal registers
rdir1:	CMP	AH,0E0h		; ACC?
	JNZ	rdir2
	MOV	AL,DL
	RET
rdir2:	CMP	AH,0F0h		; B?
	JNZ	rdir3
	MOV	AL,DH
	RET
rdir3:	CMP	AH,83h		; DPH?
	JNZ	rdir4
	MOV	CX,DI
	MOV	AL,CH
	RET
rdir4:	CMP	AH,82h		; DPL?
	JNZ	rdir5
	MOV	CX,DI
	MOV	AL,CL
	RET
rdir5:	CMP	AH,81h		; SP?
	JNZ	rdir6
	MOV	AL,DGRP:_SP
	RET
rdir6:	CMP	AH,0D0h		; PSW?
	JNZ	rdir7
	MOV	AL,DGRP:_PSW
	AND	AL,3Ah		; Save only non-flag bits
	MOV	BX,DGRP:FLAGS	; Get CPU flags
	TEST	BL,01h		; C
	JZ	rdir61
	OR	AL,80h
rdir61:	TEST	BL,10h		; Ac
	JZ	rdir62
	OR	AL,40h
rdir62:	TEST	BH,08h		; Ov
	JZ	rdir63
	OR	AL,04h
rdir63:	AND	DL,DL		; P
	JP	rdir64
	OR	AL,01h
rdir64:	MOV	DGRP:_PSW,AL
	RET
; Access via loaded module if present
rdir7:	MOV	CX,word ptr DGRP:_Sseg; Redirect enabled?
	JCXZ	rdir72		; No, handle normally
	PUSH	AX		; Save AX
	MOV	AL,AH		; Get value
	XOR	AH,AH		; Zero high
	XOR	CX,CX		; Call sfr_read()
	CALL	SFRcall		; Perform the call
	AND	AH,AH		; Supported?
	JNZ	rdir71		; No, handle normally
	POP	BX		; Clean stack
	RET
rdir71:	POP	AX		; Restore AX
rdir72:	CMP	AH,98h		; SCON?
	JNZ	rdir8
	JMP	RSCON
rdir8:	CMP	AH,99h		; SBUF?
	JNZ	rdir9
	MOV	AL,DGRP:_baud_rate
	AND	AL,AL		; LOCAL mode?
	JZ	rdir10		; Yes, read from buffer
	PUSH	DX		; Save ACC
	MOV	DX,DGRP:_com1	; Point to COM1
	SUB	DX,5		; Address data register
	IN	AL,DX		; Read data register
	POP	DX
	RET
; Read data from an SFR
rdir9:	MOV	AL,DGRP:_POD	; Pod attached?
	AND	AL,AL		; Test
	JZ	rdir10		; No, get IRAM value
; Read data from POD
	MOV	AL,AH		; Get address
	JMP	_podcmd		; Write command 
; Read data from internal "faked" SFR
rdir10:	MOV	BL,AH		; Set up LOW
	XOR	BH,BH		; Zero high
	MOV	AL,DGRP:_INTRAM+128[BX]; Read the memory
	RET
;
; Write a byte to direct memory (AH)
;
WDIR:	MOV	AH,ES:[SI]	; Get operand
	INC	SI		; Advance
WDIRX:	XOR	BH,BH		; Zero HIGH
	MOV	BL,AH		; Get address
	TEST	AH,80h		; Direct location
	JNZ	wdir1		; Special location
; Access internal RAM
	MOV	DGRP:_INTRAM[BX],AL; Write the data
	RET
; Simulate access to internal registers
wdir1:	MOV	DGRP:_INTRAM+128[BX],AL ; Mirror data
	CMP	AH,0E0h		; ACC?
	JNZ	wdir2
	MOV	DL,AL
	RET
wdir2:	CMP	AH,0F0h		; B?
	JNZ	wdir3
	MOV	DH,AL
	RET
wdir3:	CMP	AH,83h		; DPH?
	JNZ	wdir4
	MOV	CX,DI
	MOV	CH,AL
	MOV	DI,CX
	RET
wdir4:	CMP	AH,82h		; DPL?
	JNZ	wdir5
	MOV	CX,DI
	MOV	CL,AL
	MOV	DI,CX
	RET
wdir5:	CMP	AH,81h		; SP?
	JNZ	wdir6
	MOV	DGRP:_SP,AL
	RET
wdir6:	CMP	AH,0D0h		; PSW?
	JNZ	wdir7
	MOV	BX,DGRP:FLAGS	; Get last flags
	AND	BL,0E2h		; Save other bits
	TEST	AL,80h		; C
	JZ	wdir61
	OR	BL,01h
wdir61:	TEST	AL,40h		; AC
	JZ	wdir62
	OR	BL,10h
wdir62:	TEST	AL,04h		; Ov
	JZ	wdir63
	OR	BL,08h
wdir63:	TEST	AL,01h		; P
	JZ	wdir64
	OR	BL,04h
wdir64:	MOV	DGRP:FLAGS,BX
	MOV	DGRP:_PSW,AL
	RET
; Access via loaded module of present
wdir7:	MOV	CX,word ptr DGRP:_Sseg; Get remote control segment
	JCXZ	wdir71		; Not loaded, skip
	PUSH	AX		; Save AX
	XOR	AH,AH		; Zero high (leave only value)
	MOV	CX,5		; Call sfr_write()
	CALL	SFRcall		; Write it
	AND	AH,AH		; Sucess?
	POP	AX		; Restore
	JNZ	wdir71		; No, do it manually
	RET
wdir71:	CMP	AH,98h		; SCON?
	JNZ	wdir8
	MOV	DGRP:_INTRAM+118h,AL
	RET
wdir8:	CMP	AH,99h		; SBUF?
	JNZ	wdir9
	PUSH	DX
	MOV	AH,DGRP:_baud_rate
	AND	AH,AH		; Local mode?
	JNZ	wdir8a		; No, use serial
	PUSH	SI		; Save PC
	PUSH	DI		; Save DPTR
	PUSH	AX		; Pass character
	CALL	_wputc		; Output to screen
	CALL	_wupdatexy	; Update cursor
	POP	AX		; Clean stack
	POP	DI		; Restore DPTR
	POP	SI		; Restore PC
	POP	DX		; Restore Acc
	RET
wdir8a:	MOV	DX,DGRP:_com1
	SUB	DX,5
	OUT	DX,AL
	POP	DX
wdir8b:	RET
; Write data to SFR
wdir9:	OR	BH,DGRP:_POD	; Pod attached?
	JZ	wdir8b		; No, don't access
; Communicate with "POD" for data
walpod:	MOV	BL,AL		; Save data
	MOV	AL,AH		; Get address
	AND	AL,07Fh		; Remove high bit
	CALL	_wrpod		; Write to port
	MOV	AL,BL		; Restore data
	JMP	_wrpod		; And write it
;
; Read a byte from a register (BL)
;
RREG:	SHR	BL,1		; Shift back
RREGX:	AND	BL,07h		; Mask register bits
	MOV	AL,DGRP:_PSW	; Get register bank
	AND	AL,18h		; Save bank select bits
	OR	BL,AL		; Include in address
	XOR	BH,BH		; Zero high
	MOV	AL,DGRP:_INTRAM[BX]; Read the register
	RET
;
; Write a byte to register (BL)
;
WREG:	SHR	BL,1		; Shift back
WREGX:	AND	BL,07h		; Mask register bits
	MOV	AH,DGRP:_PSW	; Get register bank
	AND	AH,18h		; Save bank select bits
	OR	BL,AH		; Include in address
	XOR	BH,BH		; Zero high
	MOV	DGRP:_INTRAM[BX],AL; Write the register
	RET
;
; Read a byte through indirect register (BL)
;
RIND:	SHR	BL,1		; Shift back
RINDX:	AND	BL,01h		; Mask register bits
	MOV	AL,DGRP:_PSW	; Get register bank
	AND	AL,18h		; Save bank select bits
	OR	BL,AL		; Include in address
	XOR	BH,BH		; Zero high
	MOV	BL,DGRP:_INTRAM[BX]; Read register contents
	MOV	AL,DGRP:_INTRAM[BX]; Read value
	RET
;
; Write a byte indirect through a register (BL)
;
WIND:	SHR	BL,1		; Shift back
WINDX:	AND	BL,01h		; Mask register bits
	MOV	AH,DGRP:_PSW	; Get register bank
	AND	AH,18h		; Save bank select bits
	OR	BL,AH		; Include in address
	XOR	BH,BH		; Zero high
	MOV	BL,DGRP:_INTRAM[BX]; Read register contents
	MOV	DGRP:_INTRAM[BX],AL; Write value
	RET
;
; Read BIT from memory
;
RBIT:	MOV	AH,ES:[SI]	; Read bit address
	INC	SI		; Advance
RBITX:	MOV	CL,AH		; Copy it
	AND	CL,07h		; Save only bit ID
	AND	AH,0F8h		; Mask bit field
	JS	rbit0		; SFR access
	SHR	AH,1		; Shift it
	SHR	AH,1		; Shift it
	SHR	AH,1		; Shift it
	ADD	AH,20h		; Offset to area
	MOV	BL,AH		; Set it up
	XOR	BH,BH		; Zero high
	MOV	AL,DGRP:_INTRAM[BX]; Read the data
	JMP SHORT rdbit
rbit0:	CMP	AH,0E0h		; Acc?
	JNZ	rbit1
	MOV	AL,DL
	JMP SHORT rdbit
rbit1:	CMP	AH,0F0h		; B?
	JNZ	rbit2
	MOV	AL,DH
	JMP SHORT rdbit
rbit2:	CMP	AH,0D0h		; PSW?
	JNZ	rbit3
	MOV	AL,DGRP:_PSW
	AND	AL,3Ah		; Save only on-flag bits
	MOV	BX,DGRP:FLAGS	; Get CPU flags
	TEST	BL,01h		; C
	JZ	rbit21
	OR	AL,80h
rbit21:	TEST	BL,10h		; Ac
	JZ	rbit22
	OR	AL,40h
rbit22:	TEST	BH,08h		; Ov
	JZ	rbit23
	OR	AL,04h
rbit23:	TEST	BL,04h		; P
	JZ	rbit24
	OR	AL,01h
rbit24:	MOV	DGRP:_PSW,AL
	JMP SHORT rdbit
; Remote access
rbit3:	PUSH	CX		; Save location
	MOV	CX,DGRP:_Sseg	; Get remote segment
	JCXZ	rbit32		; Not active
	PUSH	AX		; Save AX
	MOV	AL,AH		; Get address
	XOR	AH,AH		; Zero high
	XOR	CX,CX		; Call read function
	CALL	SFRcall		; Read the data
	AND	AH,AH		; Success?
	JNZ	rbit31		; No, handle as standard
	POP	CX		; Clean stack
	POP	CX		; Restore CX
	JMP SHORT rdbit
rbit31:	POP	AX		; Restore AX
rbit32:	POP	CX		; Restore CX
; Serial control port
	CMP	AH,98h		; SCON?
	JNZ	rbit4
	CALL	RSCON
	JMP SHORT rdbit
; Read bit from SFR
rbit4:	MOV	AL,DGRP:_POD	; Get pod flag
	AND	AL,AL		; Pod attached
	JNZ	rbit5		; Yes, read from it
; Internal "faked" SFR's
	MOV	BL,AH		; Get address
	XOR	BH,BH		; Zero high
	MOV	AL,DGRP:_INTRAM+128[BX]; Read data
	JMP SHORT rdbit		; And proceed
; Access POD for SFR data
rbit5:	MOV	AL,AH		; Get address
	CALL	_podcmd		; Read from pod
; Access individual bit from data
rdbit:	SHR	AL,CL		; Move bit into position
	AND	AL,01h		; Keep only this one
	RET	
;
; Write BIT to memory
;
WBIT:	MOV	AH,ES:[SI]	; Read bit address
	INC	SI		; Advance
WBITX:	AND	AL,01h		; Save only bit
	MOV	CL,AH		; Copy it
	AND	CL,07h		; Save only bit ID
	AND	AH,0F8h		; Mask bit field
	JS	wbit0		; SFR access
	PUSH	AX		; Save bit
	SHR	AH,1		; Shift it
	SHR	AH,1		; Shift it
	SHR	AH,1		; Shift it
	ADD	AH,20h		; Offset to RAM
	MOV	AL,AH		; Copy low
	CBW			; Zero high
	MOV	BX,OFFSET DGRP:_INTRAM
	ADD	BX,AX		; Offset to it
	POP	AX		; Restore bot
	JMP SHORT wrbit
wbit0:	CMP	AH,0E0h		; Acc?
	JNZ	wbit1
	ROR	DL,CL		; Shift
	AND	DL,0FEh		; Mask
	OR	DL,AL		; Include
	ROL	DL,CL		; Shift back
	RET
wbit1:	CMP	AH,0F0h		; B?
	JNZ	wbit2
	ROR	DH,CL		; Shift
	AND	DH,0FEh		; Mask
	OR	DH,Al		; Include
	ROL	DH,CL		; Shift back
	RET
wbit2:	CMP	AH,0D0h		; PSW?
	JNZ	wbit3
	MOV	BX,0001h	; Carry mask
	CMP	CL,7		; Carry bit?
	JZ	wbit21		; Handle it
	MOV	BX,0004h	; Parity mask
	AND	CL,CL		; Parity bit?
	JZ	wbit21		; Handle it
	MOV	BX,0010h	; Aux carry mask
	CMP	CL,6		; Aux carry bit?
	JZ	wbit21		; Handle it
	MOV	BX,0800h	; Overflow mask
	CMP	CL,2		; Overflow
	JNZ	wbit23		; No, skip it
wbit21:	AND	AL,AL		; Set or clear bit
	JZ	wbit22		; Clear it
	OR	BX,DGRP:FLAGS	; Set bit
	MOV	DGRP:FLAGS,BX	; Resave
	JMP	SHORT wbit23	; And proceed
wbit22:	NOT	BX		; Complement bit
	AND	BX,DGRP:FLAGS	; Clear the bit
	MOV	DGRP:FLAGS,BX	; Resave
; Check for 'C', 'AC', 'OV' and 'P' bits
wbit23:	MOV	BX,OFFSET DGRP:_PSW
; Set bit(CL) in [BX]
wrbit:	MOV	CH,[BX]		; Read the data
	ROR	CH,CL		; Shift it over
	AND	CH,0FEh		; Remove old bit
	AND	AL,01h		; Save only low
	OR	AL,CH		; Set BIT
	ROL	AL,CL		; Shift back
	MOV	[BX],AL		; Write it
wbit32:	RET
; Write to general SFR
wbit3:	MOV	BL,AH		; Get address
	XOR	BH,BH		; Zero high
	MOV	CH,DGRP:_INTRAM+128[BX] ; Read old value
	ROR	CH,CL		; Shift it over
	AND	CH,0FEh		; Remove old bit
	AND	AL,01h		; Save only low
	OR	AL,CH		; Set BIT
	ROL	AL,CL		; Shift back
	MOV	DGRP:_INTRAM+128[BX],AL ; Write new value
; Write to remote if active
	MOV	CX,DGRP:_Sseg	; Get remote segment
	JCXZ	wbit31		; Not active
	PUSH	AX		; Save AX
	PUSH	BX		; Save BX
	XOR	AH,AH		; Zero high data
	MOV	CX,5		; Call write() function
	CALL	SFRcall		; Call remote
	AND	AH,AH		; Success?
	POP	BX		; Restore BX
	POP	AX		; Restore AX
	JZ	wbit32		; Ok, don't go further
; Write to SFR memory image
wbit31:	CMP	AH,98h		; SCON
	JZ	wbit32		; Don't access POD
	MOV	BL,DGRP:_POD	; Get pod flag
	AND	BL,BL		; pod attached?
	JZ	wbit32		; No, ignore
	JMP	walpod		; Write it
;
; Load the registers from RAM prior to execution
;
LOAD:	MOV	WORD PTR DGRP:S8051,(((OFFSET KEY)-(OFFSET S8051)-2)*256)+0EBh;
LOADX:	MOV	BYTE PTR DGRP:_local_flag,0; Insure no window
	MOV	BYTE PTR DGRP:_Dflag,0 ; Allow output
	MOV	BYTE PTR DGRP:_Aflag,-1 ;No abort
	MOV	DL,DGRP:_A	; Get A
	MOV	DH,DGRP:_B	; Get B
	MOV	DI,DGRP:_DPTR	; Get DPTR
	MOV	SI,DGRP:_PC	; Get PC
	MOV	ES,DGRP:_CSEG	; Get execution segment
	MOV	AL,DGRP:_PSW	; Get state word
	MOV	BX,DGRP:FLAGS	; Get flags
	AND	BX,0F700h	; Clear state flags
	TEST	AL,80h		; Carry?
	JZ	load1		; No, leave off
	OR	BL,01h		; Set Cy
load1:	TEST	AL,40h		; Aux carry?
	JZ	load2		; No, leave off
	OR	BL,10h		; Set Acy
load2:	TEST	AL,04h		; Overflow?
	JZ	load3		; No, leave off
	OR	BH,08h		; Set Ov
load3:	TEST	AL,01h		; Parity?
	JZ	load4		; No, leave off
	OR	BL,04h		; Set Parity
load4:	MOV	DGRP:FLAGS,BX	; Save new flags
	RET
;
; Save the registers into RAM
;
SAVE:	MOV	DGRP:_TRCPTR,BP	; Save buffer position
	POP	BP		; Restore stack frame
	MOV	DGRP:_A,DL	; Save A
	MOV	DGRP:_B,DH	; Save B
	MOV	DGRP:_DPTR,DI	; Save DPTR
	MOV	DGRP:_PC,SI	; Save PC
;	CALL	RSCON		; Update SCON
	MOV	WORD PTR DGRP:S8051,0B689h; Reset save code (for DEMOCHECK)
	MOV	BYTE PTR DGRP:_Dflag,-1 ; Inhibit output
	MOV	AL,DGRP:_local_flag;
	AND	AL,AL		; Window open?
	JZ	save1		; No, its OK
	CALL	_wclose		; Close local window
save1:	MOV	AH,0D0h		; PSW
	JMP	RDIRX		; Read to set flags
;
; Read SCON port
;
RSCON:	MOV	AH,DGRP:_baud_rate
	AND	AH,AH		; Local mode
	JZ	rscon3		; Yes, handle
	PUSH	DX		; Save ACC
	MOV	DX,DGRP:_com1	; Get COM address
	IN	AL,DX		; Read status
	POP	DX		; Restore ACC
	MOV	AH,DGRP:_INTRAM+118h; Get current value
	TEST	AL,01h		; RX ready?
	JZ	rscon1		; No, don't set
	OR	AH,01h		; Set RX ready
rscon1:	TEST	AL,20h		; TX ready?
	JZ	rscon2		; No, don't set
	OR	AH,02h		; Set TX ready
rscon2:	MOV	AL,AH		; Copy to low
	MOV	DGRP:_INTRAM+118h,AL; Write new value
	RET
; Local mode - Set TX ready
rscon3:	MOV	AL,DGRP:_INTRAM+118h; Get SCON value
	OR	AL,02h		; Set TX ready
	MOV	DGRP:_INTRAM+118h,AL; Write new value
	RET
;
; Call SFR initialiation function
;
_SFRinit: MOV	CX,10		;Call sfr_init()
	MOV	BX,OFFSET DGRP:abdbg  ; Pass offset of debug abort
	MOV	SI,OFFSET DGRP:rddbg  ; Pass offset of debug input
	MOV	DI,OFFSET DGRP:wrtdbg ; Pass offset of debug output
	MOV	DX,OFFSET DGRP:_Dflag ; Pass offset of EMILY flags
	MOV	AX,CS		; Pass segment of debug output
;
; Call far address in CX, pass AX, BX, DX, SI, DI unchanged
;
SFRcall:PUSH	DX		; Save DX
	PUSH	SI		; Save SI
	PUSH	DI		; Save DI
	PUSH	BP		; Save BP
	MOV	BP,OFFSET DGRP:xret ; Get return offset
	MOV	DGRP:SAVESP,SP	; Save SP
	CLI
	MOV	SS,DGRP:_Sseg	; Set new SS
	MOV	SP,0		; Set new SP
	STI
	MOV	ES,DGRP:_Sseg	; Set new ES
	MOV	DS,DGRP:_Sseg	; Set new DS
; fake far call to SI:CX
	PUSH	CS		; Stack return segment
	PUSH	BP		; Stack return offset
	PUSH	DS		; Stack dest segment
	PUSH	CX		; Stack dest offset
	DB	0CBh		; RETF
; Return address for long call
xret:	MOV	DX,CS		; Get CS
	MOV	DS,DX		; Reset DS
	CLI
	MOV	SS,DX		; Reset SS
	MOV	SP,DGRP:SAVESP	; Restore SP
	STI
	MOV	ES,DGRP:_CSEG	; Reset ES
	POP	BP		; Restore BP
	POP	DI		; Restore DI
	POP	SI		; Restore SI
	POP	DX		; Restore DX
	RET
;
; Write charcter in AL to debug window
;
wrtdbg:	MOV	BX,CS		; Get out segment
	MOV	DS,BX		; Reset DS
	POP	DX		; Get return address
	PUSH	DGRP:_Sseg	; Stack return segment
	PUSH	DX		; Stack return offset
	MOV	CL,DGRP:_Dflag	; Get output flag
	AND	CL,CL		; Is it set
	JNZ	wrtdb1		; No, skip
	MOV	DX,SP		; Save current SP
	CLI
	MOV	SS,BX		; Reset SS
	MOV	SP,DGRP:SAVESP	; Restore SP
	STI
	MOV	DGRP:SAVESP,DX	; Save remote SP
	PUSH	AX		; Pass character
	CALL	_wputc		; Write to debug window
	CALL	_wupdatexy	; Update cursor
	POP	AX		; Clean stack
	MOV	DX,SP		; Get current SP
	CLI
	MOV	SS,DGRP:_Sseg	; Restore remote SS
	MOV	SP,DGRP:SAVESP	; Restore remote SP
	STI
	MOV	DGRP:SAVESP,DX	; Resave our SP
wrtdb1:	MOV	DS,DGRP:_Sseg	; Restore remote DS
	DB	0CBh		; RETF
;
; Read character from the debug window
;
rddbg:	MOV	BX,CS		; Get our segment
	MOV	DS,BX		; Restore DS
	POP	DX		; Get return address
	PUSH	DGRP:_Sseg	; Stack return segment
	PUSH	DX		; Stack return offset
	XOR	AX,AX		; Assume no character
	MOV	CL,DGRP:_Dflag	; Get output flag
	AND	CL,CL		; Is it set
	JNZ	wrtdb1		; No, skip
	MOV	DX,SP		; Save current SP
	CLI
	MOV	SS,BX		; Reset SS
	MOV	SP,DGRP:SAVESP	; Restore SP
	STI
	MOV	DGRP:SAVESP,DX	; Save remote SP
	CALL	_wgetc		; Write to debug window
	MOV	DX,SP		; Get current SP
	CLI
	MOV	SS,DGRP:_Sseg	; Restore remote SS
	MOV	SP,DGRP:SAVESP	; Restore remote SP
	STI
	MOV	DGRP:SAVESP,DX	; Resave our SP
	CMP	AL,1bh		; Escape?
	JZ	abdbg1		; Set abort pending
	MOV	DS,DGRP:_Sseg	; Restore remote DS
	DB	0CBh		; RETF
;
; Abort emily execution
;
abdbg:	POP	AX		; Get offset
	PUSH	CS		; Get our segment
	POP	DS		; Set DS
	PUSH	DGRP:_Sseg	; Stack return offset
	PUSH	AX		; Stack return offset
abdbg1:	MOV	BYTE PTR DGRP:_Aflag,0 ; Indicate abort
	MOV	WORD PTR CS:S8051,(((OFFSET KEY)-(OFFSET S8051)-2)*256)+0EBh;
	MOV	DS,DGRP:_Sseg	; Restore remote DS
	DB	0CBh		; RETF
;
; INT09 - Keyboard interrupt handler
; Patch simulator to cause branch to key test routine.
;
INT09:	MOV	WORD PTR CS:S8051,(((OFFSET KEY)-(OFFSET S8051)-2)*256)+0EBh;
	JMP	CS:INT09_V	; Chain to old vector
CSEG	ENDS
;
; Initialized data
;
DSEG	SEGMENT	BYTE PUBLIC 'IDATA'
	PUBLIC	_A, _B, _PSW, _SP, _DPTR, _PC, _POD, _TRCPTR, _Sseg,
	PUBLIC _Aflag, _Dflag
_A	DB	0		; 8051 A Accumulator
_B	DB	0		; 8051 B Accumulator
_PSW	DB	0		; 8051 Processor Status Word
_SP	DB	7		; 8051 Stack Pointer
_DPTR	DW	0		; 8051 Data Pointer
_PC	DW	0		; 8051 Program Counter
_TRCPTR	DW	0		; Trace buffer pointer
FLAGS	DW	0200h		; 8086 Flags
_Sseg	DW	0		; SFR Segment
_Dflag	DB	0		; Debug output flag
_POD	DB	0		; Pod connected flag
_Aflag	DB	-1		; Abort flag
DSEG	ENDS
;
; Uninitialized data
;
BSEG	SEGMENT	BYTE PUBLIC 'UDATA'
	PUBLIC	_CSEG, _DSEG, _BRKPTS, _BRKFLG, _INTRAM, _TRCBUF
_CSEG	DW	1 DUP(?)	; Active code (ROM) segment
_DSEG	DW	1 DUP(?)	; Active data (RAM) segment
INTFLAG	DB	1 DUP(?)	; Interrupts captured flag
_BRKPTS	DW	11 DUP(?)	; Active breakpoints
_BRKFLG	DW	10 DUP(?)	; Breakpoint flags
_INTRAM	DB	384 DUP(?)	; Internal ram & SFR mirror
_TRCBUF	DW	4096 DUP(?)	; Instruction trace buffer
SAVESP	DW	1 DUP(?)	; Saved SP during SFR calls
; Double word location for re-vectoring keyboard interrupt
INT09_V	LABEL	DWORD		; Saved INT 09 vector
INT09_O	DW	1 DUP(?)	; INT 9 Offset
INT09_S	DW	1 DUP(?)	; INT 9 Segment
BSEG	ENDS
	END
