*
* EMILY/MONICA Resident Kernal for 8051/8052
*
* The symbol BAUD determines the "reload" value used for timer1 to
* establish the system baud rate. It is calculated with this formula:
*
*	BAUD = (crystal / baud rate) / 384
*
* If the above formula returns a fractional value, round it to the nearest
* integer, and determine that the actual baud rate that will be generated
* using this formula:
*
*	SPEED = (crystal / integer BAUD) / 384
*
* If the result is not within 5 percent of the desired value, that speed
* is unobtainable with the crystal frequency you are using. In general, the
* lower the SPEED required, the better chance you will have of obtaining it.
*
* For example, A system running 11.0592 Mhz and running the default 28800
* baud control connection:
*
*	BAUD = (11059200 / 28800) / 384
*
* This calculation shows that on this system, the correct BAUD value is 1. 
*
* The following table shows usable BAUD values and resultant speeds for
* a number of common crystal frequencies:
*
*	Xtal (Mhz)  BAUD   Speed -> PC Speed
*	---------------------------------------
*	14.7456     1      38400 -> 38400  0.0%
*	12.0        3      10417 -> 10473  0.5%
*	11.0592     1      28800 -> 28800  0.0%
*	11.0        1      28646 -> 28800  0.5%
*	10.0        2      13020 -> 12800  1.7%
*	9.0         1      23438 -> 23040  1.7%
*	8.0         2      10417 -> 10473  0.5%
*	7.3728      1      19200 -> 19200  0.0%
*	7.0         2      9116  -> 8862   2.8%
*	6.0         2      7813  -> 7680   1.7%
*	5.0         1      13020 -> 12800  1.7%
*	4.0         1      10417 -> 10473  0.5%
*	3.68        1      9600  -> 9600   0.0%
*	3.59        1      9349  -> 9600   2.7%
*	3.0         1      7813  -> 7680   1.7%
*	2.0         1      5208  -> 5236   0.5%
*	1.84        1      4800  -> 4800   0.0%
*	1.0         1      2604  -> 2618   0.5%
*
* ?COPY.TXT 1991-2005 Dave Dunfield
* **See COPY.TXT**.
*
ROM	EQU	$0000		Start of this ROM
USERAM	EQU	$0800		Start of user code
BAUD	EQU	1		Baudrate divisor for TIMER1
IDBYTE	EQU	$55		Kernal identification byte
EFLAG1	EQU	$A5		Execution ID flag 1
EFLAG2	EQU	$5A		Execution ID flag 2
EFLAG3	EQU	$99		Execution ID flag 3
STACK	EQU	8		Initial stack
* DS5000 Memory Control Addresses
* (for use with MONICA's /DS5000 option)
TA	EQU	$C7		Timed access register
MCON	EQU	$C6		Memory control register
*
	ORG	ROM		Program goes here
	AJMP	BEGIN		Begin program
* Re-vector interrupts
	ORG	ROM+$0003	EXT Interrupt 0
	LJMP	USERAM+$03
	ORG	ROM+$000B	Timer 0 overflow
	LJMP	USERAM+$0B
	ORG	ROM+$0013	EXT Interrupt 1
	LJMP	USERAM+$13
	ORG	ROM+$001B	Timer1 - Single step
	LJMP	BRKSS
	ORG	ROM+$0023	RI+TI interrupt
	LJMP	USERAM+$23
	ORG	ROM+$002B	TF2+EXF2
	LJMP	USERAM+$2B
*
	ORG	ROM+$0040	Offset for Entry
*
* Wait for TX complete
*
WAITX	PUSH	A		Save ACC
	CLR	A		Zero ACC
* This DJNZ instruction should occur enough times to account for one
* character transmission time at the baud rate used by the target system
* Each DJNZ uses 512 cycles of CPU time (1 Cycle=12 XTAL periods)
* @12Mhz XTAL, each DJNZ provides .000512 sec delay
*
* 10x=0.00512 Sec delay, long enough for 2000 bps character
	DJNZ	A,*		Wait a bit
	DJNZ	A,*		Wait a bit
	DJNZ	A,*		Wait a bit
	DJNZ	A,*		Wait a bit
	DJNZ	A,*		Wait a bit
	DJNZ	A,*		Wait a bit
	DJNZ	A,*		Wait a bit
	DJNZ	A,*		Wait a bit
	DJNZ	A,*		Wait a bit
	POP	A		Restore A
	SETB	SCON.1		Force TX ready
*
* Respond to breakpoint or single-step interrupt
*
BRKSS	CLR	IE.3		Disable timer-1 interrupt
	JNB	SCON.1,WAITX	Wait for TX
	PUSH	IE		Save Interrupt enable
	MOV	IE,#0		Clear interrupts
* Restore timer-1 for serial I/O
	ANL	TMOD,#%00001111	Zero timer-1 mode
	ORL	TMOD,#%00100000	T1 = 8 bit auto-reload
	MOV	TH1,#-BAUD	Timer-1 reload value
	MOV	TL1,#-BAUD	Timer-1 initial value
* Signal a Breakpoint/Single-step return to the host
	JNB	SCON.1,*	Wait for TX
	CLR	SCON.1		Indicate send
	MOV	SBUF,#EFLAG1	Send breakpoint flag #1
	JNB	SCON.1,*	Wait for TX
	CLR	SCON.1		Indicate send
	MOV	SBUF,#EFLAG2	Send breakpoint flag #2
	JNB	SCON.1,*	Wait for TX
	CLR	SCON.1		Indicate send
	MOV	SBUF,#EFLAG3	Send breakpoint flag #3
* Upload registers to host
	JNB	SCON.1,*	Wait for TX
	CLR	SCON.1		Indicate send
	MOV	SBUF,PSW	Upload PSW
	JNB	SCON.1,*	Wait for TX
	CLR	SCON.1		Indicate send
	MOV	SBUF,A		Upload ACC
	JNB	SCON.1,*	Wait for TX
	CLR	SCON.1		Indicate send
	MOV	SBUF,B		Upload B
	POP	B		Save program IE
	POP	A		Get HIGH PC
	JNB	SCON.1,*	Wait for TX
	CLR	SCON.1		Indicate send
	MOV	SBUF,A		Upload PC.1
	POP	A		Get LOW PC
	JNB	SCON.1,*	Wait for TX
	CLR	SCON.1		Indicate send
	MOV	SBUF,A		Upload PC.0
	JNB	SCON.1,*	Wait for TX
	CLR	SCON.1		Indicate send
	MOV	SBUF,DPH	Upload DPTR.1
	JNB	SCON.1,*	Wait for TX
	CLR	SCON.1		Indicate send
	MOV	SBUF,DPL	Upload DPTR.0
	JNB	SCON.1,*	Wait for TX
	CLR	SCON.1		Indicate send
	MOV	SBUF,SP		Upload SP
	ANL	PSW,#%11100111	Insure RB=0
	JNB	SCON.1,*	Wait for TX
	CLR	SCON.1		Indicate send
	MOV	SBUF,0		Save R0
	MOV	R0,#1		Point to location 1
UPLR1	JNB	SCON.1,*	Wait for TX
	CLR	SCON.1		Indicate send
	MOV	SBUF,[R0]	Save memory
	INC	R0		Advance
	CJNE	R0,#$20,UPLR1	Do them all
	ACALL	IRET		Insure INT system reset
	AJMP	MAIN		Return to MAIN
*
* Initialize the timer 1 for auto-reload at 32xN
*
BEGIN	MOV	TMOD,#%00100000	T1=8 bit auto-reload
	MOV	TH1,#-BAUD	Timer-1 reload value
	MOV	TL1,#-BAUD	Timer-1 initial value
	MOV	TCON,#%01001001	Run 1, Hold 0
* Initialize the serial port
	MOV	SCON,#%01010010	Mode 1, REN, TXRDY, RXEMPTY
	ACALL	FLUSH		Clear out the buffer
*
* Handle any serial port commands
*
MAIN	MOV	SP,#STACK	Reset stack
MAIN1	ACALL	CHKCHR		Check for character
	CLR	C		Zero carry
	RLC	A		X2 for two byte entries
	JNC	MAIN2		Type 2 command
	MOV	DPTR,#CTAB1	Point to table 1
	ACALL	MAIN3		Execute handler & get data
	ACALL	WRCHR		Write the data back
	SJMP	MAIN1		And proceed
* Type 2 - Imediate data available
MAIN2	MOV	R7,A		Save data
	ACALL	GETCHR		Get the data
	XCH	A,R7		Swap back
	MOV	DPTR,#CTAB2	Point to table 2
	ACALL	MAIN3		Execute handler
	SJMP	MAIN		And continue
* Execute command handler & return
MAIN3	JMP	[A+DPTR]	Execute handler
*
* Get a character from the serial port
*
GETCHR	JNB	SCON.0,GETCHR	Wait for it
GETC1	CLR	SCON.0		Indicate we received
	MOV	A,SBUF		Read the data
	RET
*
* Check for a character received
*
CHKCHR	JB	SCON.0,GETC1	Data available
	MOV	A,#$FF		Default action
	RET
*
* Write a character to the serial port
*
WRCHR	JNB	SCON.1,*	Wait for the bit
	CLR	SCON.1		Indicte we are sending
	MOV	SBUF,A		Write out char
	RET
*
* Flush the receiver (Wait till all chars received)
*
FLUSH	MOV	R7,#0		Delay count
FLUSH1	ACALL	CHKCHR		Any data?
	CJNE	A,#$FF,FLUSH	Data, reset
	DJNZ	R7,FLUSH1	Wait for expiry
	RET
*
* INIT functions, Reset SFR's and send ID byte
*
INIT	CLR	A		Zero ACC
	MOV	B,A		Zero program IE
	MOV	IP,A
	MOV	IE,A
	MOV	T2CON,A
	MOV	TH0,A
	MOV	TL0,A
	MOV	TH2,A
	MOV	TL2,A
	MOV	RCAP2H,A
	MOV	RCAP2L,A
	MOV	PCON,A
* Call subroutines to write TMOD and TCON so that serial port remains OK
	MOV	R7,#0
	ACALL	WTMOD
	MOV	R7,#0
	ACALL	WTCON
	MOV	A,#$FF		Get FF
	MOV	P0,A
	MOV	P1,A
	MOV	P2,A
	MOV	P3,A
	MOV	A,#IDBYTE	Get ID byte
	RET
*
* Command table 1 (Read commands)
*
CTAB1	AJMP	RP0		80 - Read PORT 0
	AJMP	ERROR1		81 - Invalid code
	AJMP	ERROR1		82 - Invalid code
	AJMP	ERROR1		83 - Invalid code
	AJMP	ERROR1		84 - Invalid code
	AJMP	ERROR1		85 - Invalid code
	AJMP	ERROR1		86 - Invalid code
	AJMP	RPCON		87 - Read PCON
	AJMP	RTCON		88 - Read TCON
	AJMP	RTMOD		89 - Read TMOD
	AJMP	RTL0		8A - Read TL0
	AJMP	RTL1		8B - Read TL1
	AJMP	RTH0		8C - Read TH0
	AJMP	RTH1		8D - Read TH1
	AJMP	ERROR1		8E - Invalid code
	AJMP	ERROR1		8F - Invalid code
	AJMP	RP1		90 - Read PORT 1
	AJMP	ERROR1		91 - Invalid code
	AJMP	ERROR1		92 - Invalid code
	AJMP	ERROR1		93 - Invalid code
	AJMP	ERROR1		94 - Invalid code
	AJMP	ERROR1		95 - Invalid code
	AJMP	ERROR1		96 - Invalid code
	AJMP	ERROR1		97 - Invalid code
	AJMP	ERROR1		98 - Invalid code
	AJMP	ERROR1		99 - Invalid code
	AJMP	ERROR1		9A - Invalid code
	AJMP	ERROR1		9B - Invalid code
	AJMP	ERROR1		9C - Invalid code
	AJMP	ERROR1		9D - Invalid code
	AJMP	ERROR1		9E - Invalid code
	AJMP	ERROR1		9F - Invalid code
	AJMP	RP2		A0 - Read PORT 2
	AJMP	ERROR1		A1 - Invalid code
	AJMP	ERROR1		A2 - Invalid code
	AJMP	ERROR1		A3 - Invalid code
	AJMP	ERROR1		A4 - Invalid code
	AJMP	ERROR1		A5 - Invalid code
	AJMP	ERROR1		A6 - Invalid code
	AJMP	ERROR1		A7 - Invalid code
	AJMP	RIE		A8 - Read IE
	AJMP	ERROR1		A9 - Invalid code
	AJMP	ERROR1		AA - Invalid code
	AJMP	ERROR1		AB - Invalid code
	AJMP	ERROR1		AC - Invalid code
	AJMP	ERROR1		AD - Invalid code
	AJMP	ERROR1		AE - Invalid code
	AJMP	ERROR1		AF - Invalid code
	AJMP	RP3		B0 - Read PORT 3
	AJMP	ERROR1		B1 - Invalid code
	AJMP	ERROR1		B2 - Invalid code
	AJMP	ERROR1		B3 - Invalid code
	AJMP	ERROR1		B4 - Invalid code
	AJMP	ERROR1		B5 - Invalid code
	AJMP	ERROR1		B6 - Invalid code
	AJMP	ERROR1		B7 - Invalid code
	AJMP	RIP		B8 - Read IP
	AJMP	ERROR1		B9 - Invalid code
	AJMP	ERROR1		BA - Invalid code
	AJMP	ERROR1		BB - Invalid code
	AJMP	ERROR1		BC - Invalid code
	AJMP	ERROR1		BD - Invalid code
	AJMP	ERROR1		BE - Invalid code
	AJMP	ERROR1		BF - Invalid code
	AJMP	ERROR1		C0 - Invalid code
	AJMP	ERROR1		C1 - Invalid code
	AJMP	ERROR1		C2 - Invalid code
	AJMP	ERROR1		C3 - Invalid code
	AJMP	ERROR1		C4 - Invalid code
	AJMP	ERROR1		C5 - Invalid code
	AJMP	ERROR1		C6 - Invalid code
	AJMP	ERROR1		C7 - Invalid code
	AJMP	RT2CON		C8 - Read T2CON
	AJMP	ERROR1		C9 - Invalid code
	AJMP	RRCAP2L		CA - Read RCAP2L
	AJMP	RRCAP2H		CB - Read RCAP2H
	AJMP	RTL2		CC - Read TL2
	AJMP	RTH2		CD - Read TH2
	AJMP	ERROR1		CE - Invalid code
	AJMP	ERROR1		CF - Invalid code
	AJMP	ERROR1		D0 - Invalid code
	AJMP	ERROR1		D1 - Invalid code
	AJMP	ERROR1		D2 - Invalid code
	AJMP	ERROR1		D3 - Invalid code
	AJMP	ERROR1		D4 - Invalid code
	AJMP	ERROR1		D5 - Invalid code
	AJMP	ERROR1		D6 - Invalid code
	AJMP	ERROR1		D7 - Invalid code
	AJMP	ERROR1		D8 - Invalid code
	AJMP	ERROR1		D9 - Invalid code
	AJMP	ERROR1		DA - Invalid code
	AJMP	ERROR1		DB - Invalid code
	AJMP	ERROR1		DC - Invalid code
	AJMP	ERROR1		DD - Invalid code
	AJMP	ERROR1		DE - Invalid code
	AJMP	ERROR1		DF - Invalid code
	AJMP	SETBRK		E0 - Set BREAKPOINT
	AJMP	EXECUTE		E1 - Begin execution
	AJMP	STEP		E2 - Single-Step
	AJMP	ERROR1		E3 - Invalid code
	AJMP	ERROR1		E4 - Invalid code
	AJMP	ERROR1		E5 - Invalid code
	AJMP	ERROR1		E6 - Invalid code
	AJMP	ERROR1		E7 - Invalid code
	AJMP	ERROR1		E8 - Invalid code
	AJMP	ERROR1		E9 - Invalid code
	AJMP	ERROR1		EA - Invalid code
	AJMP	ERROR1		EB - Invalid code
	AJMP	ERROR1		EC - Invalid code
	AJMP	ERROR1		ED - Invalid code
	AJMP	ERROR1		EE - Invalid code
	AJMP	ERROR1		EF - Invalid code
	AJMP	ERROR1		F0 - Invalid code
	AJMP	ERROR1		F1 - Invalid code
	AJMP	ERROR1		F2 - Invalid code
	AJMP	ERROR1		F3 - Invalid code
	AJMP	ERROR1		F4 - Invalid code
	AJMP	ERROR1		F5 - Invalid code
	AJMP	ERROR1		F6 - Invalid code
	AJMP	ERROR1		F7 - Invalid code
	AJMP	ERROR1		F8 - Invalid code
	AJMP	ERROR1		F9 - Invalid code
	AJMP	ERROR1		FA - Invalid code
	AJMP	ERROR1		FB - Invalid code
	AJMP	ERROR1		FC - Invalid code
	AJMP	ERROR1		FD - Invalid code
	AJMP	INIT		FE - Initialize command
	AJMP	MAIN		FF - Idle command routine
*
* Read direct locations
*
RP0	MOV	A,P0		Read Port 0
	RET
RP1	MOV	A,P1		Read port 1
	RET
RP2	MOV	A,P2		Read port 2
	RET
RP3	MOV	A,P3		Read port 3
	RET
RIP	MOV	A,IP		Read IP
	RET
RIE	MOV	A,B		Read program IE
	RET
RTMOD	MOV	A,TMOD		Read timer mode
	RET
RTCON	MOV	A,TCON		Read timer control
	RET
RT2CON	MOV	A,T2CON		Read T2CON
	RET
RTH0	MOV	A,TH0		Read TH0
	RET
RTL0	MOV	A,TL0		Read TL0
	RET
RTH1	MOV	A,TH1		Read TH1
	RET
RTL1	MOV	A,TL1		Read TL1
	RET
RTH2	MOV	A,TH2		Read TH2
	RET
RTL2	MOV	A,TL2		Read TL2
	RET
RRCAP2H	MOV	A,RCAP2H	Read RCAP2H
	RET
RRCAP2L	MOV	A,RCAP2L	Read RCAP2L
	RET
RPCON	MOV	A,PCON		Read PCON
	RET
*
* Command table 2 (Write commands)
*
CTAB2	AJMP	WP0		00/80 - Write PORT 0
	AJMP	ERROR1		01/81 - Invalid code
	AJMP	ERROR1		02/82 - Invalid code
	AJMP	ERROR1		03/83 - Invalid code
	AJMP	ERROR1		04/84 - Invalid code
	AJMP	ERROR1		05/85 - Invalid code
	AJMP	ERROR1		06/86 - Invalid code
	AJMP	WPCON		07/87 - Write PCON
	AJMP	WTCON		08/88 - Write TCON
	AJMP	WTMOD		09/89 - Write TMOD
	AJMP	WTL0		0A/8A - Write TL0
	AJMP	WTL1		0B/8B - Write TL1
	AJMP	WTH0		0C/8C - Write TH0
	AJMP	WTH1		0D/8D - Write TH1
	AJMP	ERROR1		0E/8E - Invalid code
	AJMP	ERROR1		0F/8F - Invalid code
	AJMP	WP1		10/90 - Write PORT 1
	AJMP	ERROR1		11/91 - Invalid code
	AJMP	ERROR1		12/92 - Invalid code
	AJMP	ERROR1		13/93 - Invalid code
	AJMP	ERROR1		14/94 - Invalid code
	AJMP	ERROR1		15/95 - Invalid code
	AJMP	ERROR1		16/96 - Invalid code
	AJMP	ERROR1		17/97 - Invalid code
	AJMP	ERROR1		18/98 - Invalid code
	AJMP	ERROR1		19/99 - Invalid code
	AJMP	ERROR1		1A/9A - Invalid code
	AJMP	ERROR1		1B/9B - Invalid code
	AJMP	ERROR1		1C/9C - Invalid code
	AJMP	ERROR1		1D/9D - Invalid code
	AJMP	ERROR1		1E/9E - Invalid code
	AJMP	ERROR1		1F/9F - Invalid code
	AJMP	WP2		20/A0 - Write PORT 2
	AJMP	ERROR1		21/A1 - Invalid code
	AJMP	ERROR1		22/A2 - Invalid code
	AJMP	ERROR1		23/A3 - Invalid code
	AJMP	ERROR1		24/A4 - Invalid code
	AJMP	ERROR1		25/A5 - Invalid code
	AJMP	ERROR1		26/A6 - Invalid code
	AJMP	ERROR1		27/A7 - Invalid code
	AJMP	WIE		28/A8 - Write IE
	AJMP	ERROR1		29/A9 - Invalid code
	AJMP	ERROR1		2A/AA - Invalid code
	AJMP	ERROR1		2B/AB - Invalid code
	AJMP	ERROR1		2C/AC - Invalid code
	AJMP	ERROR1		2D/AD - Invalid code
	AJMP	ERROR1		2E/AE - Invalid code
	AJMP	ERROR1		2F/AF - Invalid code
	AJMP	WP3		30/B0 - Write PORT 3
	AJMP	ERROR1		31/B1 - Invalid code
	AJMP	ERROR1		32/B2 - Invalid code
	AJMP	ERROR1		33/B3 - Invalid code
	AJMP	ERROR1		34/B4 - Invalid code
	AJMP	ERROR1		35/B5 - Invalid code
	AJMP	ERROR1		36/B6 - Invalid code
	AJMP	ERROR1		37/B7 - Invalid code
	AJMP	WIP		38/B8 - Write IP
	AJMP	ERROR1		39/B9 - Invalid code
	AJMP	ERROR1		3A/BA - Invalid code
	AJMP	ERROR1		3B/BB - Invalid code
	AJMP	ERROR1		3C/BC - Invalid code
	AJMP	ERROR1		3D/BD - Invalid code
	AJMP	ERROR1		3E/BE - Invalid code
	AJMP	ERROR1		3F/BF - Invalid code
	AJMP	ERROR1		40/C0 - Invalid code
	AJMP	ERROR1		41/C1 - Invalid code
	AJMP	ERROR1		42/C2 - Invalid code
	AJMP	ERROR1		43/C3 - Invalid code
	AJMP	ERROR1		44/C4 - Invalid code
	AJMP	ERROR1		45/C5 - Invalid code
	AJMP	ERROR1		46/C6 - Invalid code
	AJMP	ERROR1		47/C7 - Invalid code
	AJMP	WT2CON		48/C8 - Write T2CON
	AJMP	ERROR1		49/C9 - Invalid code
	AJMP	WRCAP2L		4A/CA - Write RCAP2L
	AJMP	WRCAP2H		4B/CB - Write RCAP2H
	AJMP	WTL2		4C/CC - Write TL2
	AJMP	WTH2		4D/CD - Write TH2
	AJMP	ERROR1		4E/CE - Invalid code
	AJMP	ERROR1		4F/CF - Invalid code
	AJMP	ERROR1		50/D0 - Invalid code
	AJMP	ERROR1		51/D1 - Invalid code
	AJMP	ERROR1		52/D2 - Invalid code
	AJMP	ERROR1		53/D3 - Invalid code
	AJMP	ERROR1		54/D4 - Invalid code
	AJMP	ERROR1		55/D5 - Invalid code
	AJMP	ERROR1		56/D6 - Invalid code
	AJMP	ERROR1		57/D7 - Invalid code
	AJMP	ERROR1		58/D8 - Invalid code
	AJMP	ERROR1		59/D9 - Invalid code
	AJMP	ERROR1		5A/DA - Invalid code
	AJMP	ERROR1		5B/DB - Invalid code
	AJMP	ERROR1		5C/DC - Invalid code
	AJMP	ERROR1		5D/DD - Invalid code
	AJMP	ERROR1		5E/DE - Invalid code
	AJMP	ERROR1		5F/DF - Invalid code
	AJMP	READI		60/E0 - Read INTERNAL memory
	AJMP	WRITEI		61/E1 - Write INTERNAL memory
	AJMP	READE		62/E2 - Read EXTERNAL memory
	AJMP	WRITEE		63/E3 - Write EXTERNAL memory
	AJMP	READP		64/E4 - Read PROGRAM memory
	AJMP	WRITEP		65/E5 - Write PROGRAM memory
	AJMP	DS5000		66/E6 - Set memory addresses
	AJMP	ERROR1		67/E7 - Invalid code
	AJMP	ERROR1		68/E8 - Invalid code
	AJMP	ERROR1		69/E9 - Invalid code
	AJMP	ERROR1		6A/EA - Invalid code
	AJMP	ERROR1		6B/EB - Invalid code
	AJMP	ERROR1		6C/EC - Invalid code
	AJMP	ERROR1		6D/ED - Invalid code
	AJMP	ERROR1		6E/EE - Invalid code
	AJMP	ERROR1		6F/EF - Invalid code
	AJMP	ERROR1		70/F0 - Invalid code
	AJMP	ERROR1		71/F1 - Invalid code
	AJMP	ERROR1		72/F2 - Invalid code
	AJMP	ERROR1		73/F3 - Invalid code
	AJMP	ERROR1		74/F4 - Invalid code
	AJMP	ERROR1		75/F5 - Invalid code
	AJMP	ERROR1		76/F6 - Invalid code
	AJMP	ERROR1		77/F7 - Invalid code
	AJMP	ERROR1		78/F8 - Invalid code
	AJMP	ERROR1		79/F9 - Invalid code
	AJMP	ERROR1		7A/FA - Invalid code
	AJMP	ERROR1		7B/FB - Invalid code
	AJMP	ERROR1		7C/FC - Invalid code
	AJMP	ERROR1		7D/FD - Invalid code
	AJMP	ERROR1		7E/FE - Invalid code
	AJMP	ERROR1		7F/FF - Invalid code
*
* Write direct locations
*
WP0	MOV	P0,R7		Write port 0
	RET
WP1	MOV	P1,R7		Write port 1
	RET
WP2	MOV	P2,R7		Write port 2
	RET
WP3	MOV	A,R7		Get data
	ORL	A,#%00000011	Insure RX & TX remain enabled
	MOV	P3,A		Write port 3
	RET
WIP	MOV	IP,R7		Write IP
	RET
WIE	MOV	B,R7		Write program IE
	RET
* Write timer mode, but preserve timer1 for serial port
WTMOD	MOV	A,TMOD		Get old mode
	ANL	A,#%11110000	keep timer 1
	XCH	A,R7		Swap
	ANL	A,#%00001111	Include new timer
	ADD	A,R7		Get total
	MOV	TMOD,A		Write timer mode
	RET
* Write timer control, but preserve timer1 for serial port
WTCON	MOV	A,TCON		Get old control
	ANL	A,#%11000000	Save timer1
	XCH	A,R7		Swap
	ANL	A,#%00111111	Include new timer
	ADD	A,R7		Get total
	MOV	TCON,A		Writeit
	RET
WT2CON	MOV	T2CON,R7	Write T2CON
	RET
WTH0	MOV	TH0,R7		Write TH0
	RET
WTL0	MOV	TL0,R7		Write TL0
WTH1	EQU	*		Inhibit write to TH1
WTL1	RET			Inhibit write to TL1
WTH2	MOV	TH2,R7		Write TH2
	RET
WTL2	MOV	TL2,R7		Write TL2
	RET
WRCAP2H	MOV	RCAP2H,R7	Write RCAP2H
	RET
WRCAP2L	MOV	RCAP2L,R7	Write RCAP2L
	RET
WPCON	MOV	PCON,R7		Write PCON
	RET
* Write DS5000 MCON register
* (For use with MONICA's /DS5000 option)
DS5000	MOV	A,R7		Get value to write
	ORL	A,#%00000010	Set PAA bit
	MOV	TA,#$AA		Timed access byte 1
	MOV	TA,#$55		Timed access byte 2
	MOV	MCON,A		Write value
	ANL	A,#%11111101	Clear PAA bit
	MOV	TA,#$AA		Timed access byte 1
	MOV	TA,#$55		Timed access byte 2
	MOV	MCON,A		Write value
	RET
*
* Error has occured
*
ERROR1	CLR	A		Incase TX data
	RET
*
*------------------------
* Memory access routines
*------------------------
*
* Read INTERNAL memory (length = R7)
*
READI	ACALL	GETCHR		Get address
	MOV	R0,A		R0 = address
READI1	MOV	A,[R0]		Get character
	ACALL	WRCHR		Output
	INC	R0		Advance
	DJNZ	R7,READI1	Do them ALL
	RET
*
* Write INTERNAL memory (length = R7)
*
WRITEI	ACALL	GETCHR		Get address
	MOV	R0,A		R0 = address
WRITEI1	ACALL	GETCHR		Get character
	MOV	[R0],A		Write to memory
	INC	R0		Advance
	DJNZ	R7,WRITEI1	Do them ALL
	RET
*
* Read EXTERNAL memory (length = R7)
*
READE	ACALL	GETDP		Get address
READE1	MOVX	A,[DPTR]	Get data
	ACALL	WRCHR		Output
	INC	DPTR		Advance
	DJNZ	R7,READE1	Do them all
	RET
*
* Write EXTERNAL memory (length = R7)
*
WRITEE	ACALL	GETDP		Get address
WRITE1	ACALL	GETCHR		Get character
	MOVX	[DPTR],A	Write to memory
	INC	DPTR		Advance
	DJNZ	R7,WRITE1	Do them all
	RET
*
* Read PROGRAM memory (length = R7)
*
READP	ACALL	GETDP		Get address
READP1	CLR	A		Zero offset
	MOVC	A,[A+DPTR]	Read memory
	ACALL	WRCHR		Output
	INC	DPTR		Advance
	DJNZ	R7,READP1	Do them all
	RET
*
* Write PROGRAM memory (length = R7)
*
* Normally, write access to data/program memory is controlled from the PC
* (DTR line) or the DS5000 MCON register. Separate WRITEE and WRITEP entry
* points are available to allow the user to implement another access scheme,
* such as using an 8051 I/O pin for the switch.
*
WRITEP	EQU	WRITEE		Same as WRITEE in this implementation
*
* Set breakpoint at address
*
SETBRK	ACALL	GETDP		Get address
	MOV	A,#$12		LCALL instruction
	MOVX	[DPTR],A	Write it
	INC	DPTR		Advance
	MOV	A,#=BRKSS	HIGH address
	MOVX	[DPTR],A	Write to memory
	INC	DPTR		Advance
	MOV	A,#BRKSS	LOW address
	MOVX	[DPTR],A	Write to memory
	AJMP	MAIN		Next command
* Read HIGH and LOW values for DPTR
GETDP	ACALL	GETCHR		Get character
	MOV	DPL,A		Set LOW
	ACALL	GETCHR		Get address
	MOV	DPH,A		Set HIGH
	RET
*
* Begin execution
*
EXECUTE	ACALL	GETCHR		Get R0 value
	MOV	R0,#1		Address
DLR1	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	[R0],SBUF	Write data
	INC	R0		Advance
	CJNE	R0,#$20,DLR1	Do them all
	MOV	0,A		Set R0
	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	SP,SBUF		Download SP
	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	A,SBUF		Get PC.0
	PUSH	A		Save for later
	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	A,SBUF		Get PC.1
	PUSH	A		Save for later
	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	A,SBUF		Download ACC
	PUSH	B		Save program IE
	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	B,SBUF		Download B
	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	DPL,SBUF	Download DPTR.0
	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	DPH,SBUF	Download DPTR.1
	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	PSW,SBUF	Download PSW
	POP	IE		Restore program IE
	RET			Execute user program
*
* Step one instruction
*
STEP	ACALL	GETCHR		Get R0 value
	MOV	R0,#1		Address
DLR2	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	[R0],SBUF	Write data
	INC	R0		Advance
	CJNE	R0,#$20,DLR2	Do them all
	MOV	0,A		Set R0
* Resave remaining registers
	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	SP,SBUF		Download SP
	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	A,SBUF		Get PC.0
	PUSH	A		Save for later
	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	A,SBUF		Get PC.1
	PUSH	A		Save for later
	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	A,SBUF		Download ACC
	ORL	B,#%10001000	Enable timer-1 interrupt
	CLR	IP.3		Insure LOW priority
	PUSH	B		Save program IE
	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	B,SBUF		Download B
	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	DPL,SBUF	Download DPTR.0
	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	DPH,SBUF	Download DPTR.1
	JNB	SCON.0,*	Wait for char
	CLR	SCON.0		Indicate RX
	MOV	PSW,SBUF	Download PSW
* Set up Timer-1 for single step interrupt
	CLR	TCON.6		Stop timer-1
	ANL	TMOD,#%00001111	Zero timer-1 mode
	ORL	TMOD,#%00010000	Timer-1 16 bit
	MOV	TH1,#-1		Number of cycles
	MOV	TL1,#-4		Till first user instruction
	CLR	TCON.7		Clear timer-1 int pend.
* Enable timer for single-step interrupt
	SETB	TCON.6		Enable timer-1
	POP	IE		Set program IE
	RET			Execute user program
IRET	RETI
