;
; Low level ASYNC serial I/O driver for
; use with MICRO-C compiler on IBM/PC.
;
; ?COPY.TXT 1990-2005 Dave Dunfield
; **See COPY.TXT**.
;
; Misc constants.
BUFSIZ	EQU		4096			; Size of input buffer (power of 2)
RXRDY	EQU		00000001b		; Uart Receiver ready flag
TXRDY	EQU		00100000b		; Uart Transmitter ready flag
S8259	EQU		0020h			; 8259 interrupt controller
PODEID1	EQU		0A5h			; POD execution ID 1
PODEID2	EQU		05Ah			; POD execution ID 2
PODEID3	EQU		099h			; POD execution ID 3
;
DGRP	GROUP	DSEG,BSEG
DSEG	SEGMENT BYTE PUBLIC 'IDATA'
;
; Initialized variables & tables
;
cominfo	DW		0				; Comm interrupt vector
DSEG	ENDS
;
BSEG	SEGMENT BYTE PUBLIC 'UDATA'
rdptr	DW		1 DUP(?)		; Buffer read pointer
wrptr	DW		1 DUP(?)		; Buffer write pointer
_COMa	DW		1 DUP(?)		; Com port address
oldoff	DW		1 DUP(?)		; Saved old interrupt offset
oldseg	DW		1 DUP(?)		; Saved old interrupt segment
buffer 	DB		BUFSIZ DUP(?)
BSEG	ENDS
;
CSEG	SEGMENT	BYTE PUBLIC 'CODE'
		ASSUME	CS:CSEG, DS:DGRP, SS:DGRP
		PUBLIC	_COMopen, _COMclose, _COMtestc, _COMputc, _COMa, _go_remote
		EXTRN	_com1:WORD, _reset_target:NEAR, _mflag:BYTE
;
; Open the com port: Copen(int port, int speed, char mode, char modem)
;
_COMopen:PUSH	BP				; Save callers stack
		MOV		BP,SP			; Address parameters
		CALL	_COMclose		; Insure its closed
		MOV		DX,10[BP]		; Get com port address
		MOV		BX,1030h		; Comm 1-3 mask & vector
		CMP		DX,03FDh		; Is it COM1?
		JZ		copen1			; Yes, it is
		CMP		DX,02FDh		; Is it COM2?
		JZ		copen2			; Yes it it
		CMP		DX,03EDh		; Is it COM3?
		JZ		copen1			; Yes it it
		CMP		DX,02EDh		; Is it COM4?
		JZ		copen2			; Yes it it
; Report failure to open port
fail:	STI						; Insure interrupts enabled
		MOV		AX,-1			; Indicate failure
		POP		BP				; Restore caller
		RET
; Proceed with opening the comm port
copen2:	MOV		BX,082Ch		; Comm 2-4 mask & vector
copen1:	MOV		DGRP:_COMa,DX	; Save address
		CLI						; Inhibit interrupts
; Setup the uart
		DEC		DX				; Backup ...
		DEC		DX				; to line control register (FB)
		IN		AL,DX			; Read current value
		OR		AL,80h			; Enable baud rate register
		OUT		DX,AL			; Write it
		MOV		AX,8[BP]		; Get baud rate
		SUB		DX,3			; Point to baud rate LSB (F8)
		OUT		DX,AL			; Write it
		INC		DX				; Advance to MSB (F9)
		MOV		AL,AH			; Get MSB
		OUT		DX,AL			; Write it
		DEC		DX				; Backup to LSB (F8)
		IN		AL,DX			; Re-read LSB
		MOV		AH,AL			; Copy for later
		INC		DX				; Back to MSB (F9)
		IN		AL,DX			; Re-read MSB
		XCHG	AH,AL			; Swap for multi
		CMP		AX,8[BP]		; Does it match
		JNZ		fail			; No, its dosn't
		MOV		AL,6[BP]		; Get mode
		AND		AL,7Fh			; Insure no baud rate
		INC		DX				; Advance...
		INC		DX				; to line control register (FB)
		OUT		DX,AL			; Write it
		MOV		AL,01h			; Receive interrupt only
		DEC		DX				; Backup ...
		DEC		DX				; to Interrupt enable register (F9)
		OUT		DX,AL			; Write it
		MOV		AL,4[BP]		; Get modem control
		ADD		DX,3			; Point to modem control register (FC)
		OUT		DX,AL			; Write it
; Clear out any pending characters
		SUB		DX,4			; Point to data register (F8)
		IN		AL,DX			; Read to clear interrupt
		IN		AL,DX			; Read to clear interrupt
; Setup the interrupt controller
		MOV		DGRP:cominfo,BX	; Save mask & vector
		NOT		BH				; Invert mask for enable
		IN		AL,S8259+1		; Read interrupt mask
		AND		AL,BH			; Enable serial port
		OUT		S8259+1,AL		; Write interrupt controller
; Setup the interrupt vector
		XOR		BH,BH			; Zero high vector
		MOV		CS:DSVAL,DS		; Save data segment for int handler
		XOR		AX,AX			; Get a zero
		MOV		DGRP:rdptr,AX	; Zero read pointer
		MOV		DGRP:wrptr,AX	; Zero write pointer
		MOV		AX,ES:[BX]		; Get old offset
		MOV		DGRP:oldoff,AX	; Save old offset
		MOV		AX,ES:2[BX]		; Get old segmemt
		MOV		DGRP:oldseg,AX	; Save segment
		MOV		AX,OFFSET CSEG:COMINT; Point to routine
		MOV		ES:[BX],AX		; Write new offset
		MOV		ES:2[BX],CS		; Write new segment
		STI						; Re-enable interrupts
		XOR		AX,AX			; Indicate success
		POP		BP				; Restore caller
		RET
;
; Close the comm port: Cclose()
;
_COMclose:XOR	AX,AX			; Get zero
		MOV		ES,AX			; Point to interrupt vectors
		MOV		BX,DGRP:cominfo	; Get old vector
		AND		BX,BX			; Is it set?
		JZ		cclo1			; No, its not
		MOV		DGRP:cominfo,AX	; Indicate not set
		CLI						; Disable interrupts
; Disable interrupts on the uart
		MOV		DX,DGRP:_COMa	; Get uart address
		SUB		DX,4			; Point to interrupt enable register
		OUT		DX,AL			; Write zero
; Disconnect interrupt line (to allow COM3-4)
		ADD		DX,3			; Point to modem control register (F9)
		IN		AL,DX			; Get current value
		AND		AL,07h			; Clear OUT-2 (interrupt connect)
		OUT		DL,AL			; Write new value
; Disable COMM interrupt on the 8259
		IN		AL,S8259+1		; Read interrupt mask
		OR		AL,BH			; Disable comm interrupt
		OUT		S8259+1,AL		; Write interrupt mask
; Restore the old comm interrupt vector
		XOR		BH,BH			; Zero HIGH
		MOV		DX,DGRP:oldoff	; Get old offset
		MOV		ES:[BX],DX		; Restore old offset
		MOV		DX,DGRP:oldseg	; Get old segment
		MOV		ES:2[BX],DX		; Restore old segment
		STI						; Re-enable interrupts
cclo1:	RET
;
; Test for char from com port: int Ctestc()
;
_COMtestc:MOV	BX,DGRP:rdptr	; Get read pointer
		CMP		BX,DGRP:wrptr	; Test for data in buffer
		JNZ		cinp			; Yes, we have some
		MOV		AX,-1			; Report no data available
		RET
; Read character from com port
cinp:	MOV		AL,DGRP:buffer[BX]; Get character from buffer
		XOR		AH,AH			; Zero high
		INC		BX				; Advance read pointer
		AND		BX,BUFSIZ-1		; Mask for buffer wrap
		MOV		DGRP:rdptr,BX	; Resave read pointer
		RET
;
; Write a character to the com port: Cputc(char c)
;
_COMputc:PUSH	BP				; Save callers stack frame
		MOV		BP,SP			; Address parameters
cput1:	MOV		DX,DGRP:_COMa	; Get address of uart
		IN		AL,DX			; Read uart status
		TEST	AL,TXRDY		; Ok to transmit
		JZ		cput1			; No, wait for it
		SUB		DX,5			; Position to data address
		MOV		AL,4[BP]		; Get character
		OUT		DX,AL			; Write to comm port
		POP		BP				; Restore caller
		RET
;
; Read the com port signals: int Csignals()
;
_COMsignals:MOV	DX,DGRP:_COMa	; Get the com port address
		INC		DX				; Advance to modem status register
		IN		AL,DX			; Read modem status
		XOR		AH,AH			; Zero high bits
		RET
;
; Comms Interrupt handler
;
COMINT:	PUSH	AX				; Save AX
		PUSH	BX				; Save BX
		PUSH	DX				; Save DX
		PUSH	DS				; Save DS
		MOV		DS,CS:DSVAL		; Get data segment
		MOV		DX,DGRP:_COMa	; Get com port I/O address
		IN		AL,DX			; Read uart status register
		TEST	AL,RXRDY		; Receiver ready?
		JZ		cint1			; No, Spurious interrupt
		SUB		DX,5			; Backup to data port
		IN		AL,DX			; Read data character
; Normal character, stuff in buffer
		MOV		BX,DGRP:wrptr	; Get write pointer
		MOV		DGRP:buffer[BX],AL; Write into buffer
		INC		BX				; Advance
		AND		BX,BUFSIZ-1		; Mask for buffer wrap
		MOV		DGRP:wrptr,BX	; Resave pointer
; Reset 8259, Restore registers & return from interrupt
cint1:	MOV		AL,20h			; End of Interrupt command
		OUT		S8259,AL		; Write to interrupt controller
		POP		DS				; Restore DS
		POP		DX				; Restore DX
		POP		BX				; Restore BX
		POP		AX				; Restore AX
		IRET
;
; Transfer data in 'G'o remote mode
;
_go_remote:
		XOR		CL,CL			; State = 0
		SUB		SP,BUFSIZ		; Allocate buffer
		XOR		DI,DI			; Zero WRITE pointer
		XOR		SI,SI			; Zero READ pointer
gorem1:	MOV		DX,DGRP:_com1	; Get I/O address
		IN		AL,DX			; Read status
		MOV		AH,AL			; Copy status
		SUB		DX,5			; Backup to data
; Test for character from system
		TEST	AL,20h			; TX ready?
		JZ		gorem2			; Don't access
		MOV		BX,DGRP:rdptr	; Get read pointer
		CMP		BX,DGRP:wrptr	; Test for data in buffer
		JZ		gorem2			; No data available
; Transmit character to serial port
		MOV		AL,DGRP:buffer[BX]; Get character from buffer
		INC		BX				; Advance read pointer
		AND		BX,BUFSIZ-1		; Mask for buffer wrap
		MOV		DGRP:rdptr,BX	; Resave read pointer
		AND		CL,CL			; Non-zero state
		JNZ		gorem7			; Handle it
		CMP		AL,PODEID1		; Termination?
		JZ		gorem6			; If so, exit
gore11:	OUT		DX,AL			; Write character
; Test for character from serial port
gorem2:	MOV		BX,SP			; Get I/O buffer address
		TEST	AH,01h			; RX ready?
		JZ		gorem3			; No, skip it
		IN		AL,DX			; Read the character
		MOV		[BX+DI],AL		; Write into buffer
		INC		DI				; Advance
		AND		DI,BUFSIZ-1		; Mask for buffer wrap
; Test for character pending
gorem3:	CMP		SI,DI			; Any data available
		JZ		gorem4			; No, keep trying
		MOV		DX,DGRP:_COMa	; Address system port
		IN		AL,DX			; Get status
		TEST	AL,20h			; Ok to transmit?
		JZ		gorem4			; No, wait for it
		SUB		DX,5			; Address data
		MOV		AL,[BX+SI]		; Get character
		INC		SI				; Advance read pointer
		AND		SI,BUFSIZ-1		; Mask for buffer wrap
		OUT		DX,AL			; WRite port
; Test for command termination
gorem4:	MOV		AH,01h			; Func 1 - Get key status
		INT		16h				; Ask BIOS
		JZ		gorem1			; No key, ignore
		XOR		AH,AH			; Func 0 - Get key
		INT		16h				; Ask BIOS
		CMP		AL,20h			; Space?
		JZ		gorem5			; Yes, disable run
		CMP		AL,1Bh			; Escape?
		JNZ		gorem1			; No, handle as local character
; ESCAPE pressed, return
		ADD		SP,BUFSIZ		; Clean stack
		MOV		AX,-1			; Return -1 - RESET stop
		RET
; SPACE pressed, halt at watchpoint
gorem5:	XOR		AL,AL			; Get zero
		MOV		DGRP:_mflag,0	; Clear flag
		JMP	SHORT gorem1		; And proceed
; BREAKPOINT encountered - Check all three ID bytes
gorem6:	INC		CL				; State = 1
		JMP	SHORT gorem1		; And proceed
gorem7:	CMP		CL,1			; State = 1?
		JNZ		gorem8			; No, try next
; State 1 = Check for ID2
		CMP		AL,PODEID2		; Is this it?
		JZ		gorem6			; Yes, proceed
gore71:	DEC		BX				; Backup
		AND		BX,BUFSIZ-1		; Mask for wrap
		MOV		DGRP:rdptr,BX	; Resave read pointer
		XOR		CL,CL			; State = 0
		MOV		AL,PODEID1		; Get ID1
		JMP		gore11			; And proceed
; State 2 - Check for ID3
gorem8:	CMP		AL,PODEID3		; Is this it?
		JZ		gorem9			; Yes, handle it
		DEC		BX				; Backup
		JMP SHORT gore71		; And proceed
; Breakpoint has been verified
gorem9:	ADD		SP,BUFSIZ		; Clean stack
		XOR		AX,AX			; Return 0 - Breakpoint
		RET
; Saved data segment incase we are running in small model
DSVAL	DW		0				; Stored code segment value
;
CSEG	ENDS
		END
