/*
 * ESL encoding
 *
 * Dave Dunfield - 2005-2017
 */

// Operator encoding
#define	OMNEG		0		// Monadic negative
#define	OMNOT		1		// Monadic not
#define	OMCOM		2		// Monadic compliment
#define	OMIDX		3		// Monadic index
#define	ODADD		4		// Dyadic Addition (must be first dyadic)
#define	ODSUB		5		// Dyadic Subtraction
#define	ODMUL		6		// Dyadic Multiplication
#define	ODDIV		7		// Dyadic Division
#define	ODMOD		8		// Dyadic Modulus
#define	ODEQ		9		// Dyadic equal to
#define	ODNE		10		// Dyadic not-equal
#define	ODLT		11		// Dyadic LessThan
#define	ODGT		12		// Dyadic Greated Than
#define	ODLE		13		// Dyadic Less-or-Equal
#define	ODGE		14		// Dyadic Greater-or-Equal
#define	ODSL		15		// Dyadic Shift Left
#define	ODSR		16		// Dyadic Shift Right
#define	ODBAND		17		// Dynadic Bitwise And
#define	ODBOR		18		// Dyadic Bitwise Or
#define	ODBXOR		19		// Dyadic Bitwise Xor
#define	ODLAND		20		// Dyadic Logical And
#define	ODLOR		21		// Dyadic Logical Or
#define	ODASS		22		// Dyadic assignment
#define	ODIDX		23		// Dyadic index

// eXecution opcode values
#define	XSTOP		0
#define	XEVAL		1
#define	XSWITCH		2
#define	XCALL		3
#define	XBRANCH		4
#define	XBFALSE		5
#define	XBTRUE		6
#define	XRETURN		7
#define	XRESET		8
#define	XSET		9
#define	XUSER		10		// Must be LAST
