/*
 * Help File Compiler:
 *	Converts a text .SRC to a binady/indexd .HLP read by an allication.
 *	Needed to build some of my products.
 *
 * Copyright 1994-2024 Dave Dunfield
 */
#include <stdio.h>
#include <file.h>
#include <window.h>
#define	MemTst(a)
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#define	LINKS		25				/* Maximum number of links/section */
#define	NAME		24				/* Maximum size of name */
#define	WIDTH		68				/* Maximum width of line */
#define	LINES		15				/* Maximum number of lines */
#define	SECTIONS	256				/* Maximum number of sections */
#define	SYMBOLS		25				/* Maximum number of symbols */
#define	POOL		10000			/* Size of memory pool */
#define	FSTACK		5				// File stack

#define	LINK_S		('N'-0x40)		/* Start of link */
#define	LINK_E		('O'-0x40)		/* End of link */
#define	LINK_R		('P'-0x40)		/* Re-direct link */
#define	LINK_N		('R'-0x40)		/* Protect next */
#define	USER_CODE	('Q'-0x40)		/* User code entry */

#define	F_DEF		0x80			// Include in define file
#define	F_REF		0x01			// Referenced

#define	O_VIEW		0x01
#define	O_HDR		0x02
#define O_HDRA		0x04
#define	O_EXE		0x08

//ChtTxt R:\Help.h
/*ChtTxt Shelp
.SRC file format:

#~$19command~$19				<-HFC special command
	#define name text			<-make "name" read as "text"
	#name <max name size>												  [24]
	#links <max links/page>												  [15]
	#width <width of page>												  [68]
	#lines <max lines/page>												  [15]
	#tab <tab width>
	#hhfile <file[.HH]>			<-set .HH file name				  [outfile.HH]
	#include <file>				<-insert file here
	#rem ...					<-comment
	#end						<-premature end
|[+]Tagname|Title				<-Section Identifier		[+=add to .HHfile]
... ^NTagname^O	...				<-Use when Tagname is same as display text
... ^NText^PTagname^O ...		<-		""			different		""
... ^Qnnn ...					<-User handler
... ^Rc	...						<-don't take special action on 'c'
*/

unsigned
	pool_top,
	sym_top,
	Name = NAME,
	Links = LINKS,
	Lines = LINES,
	Width = 68,
	Tabsize = 4,
	ssize[SECTIONS],
	scount,
	scount1,
	scount2,
	line,
	links,
	Fsp,
	Lstack[FSTACK];
FILE
	*fpi,			// Input file
	*fpo,			// Output file
	*fph,			// Definitions file
	Fstack[FSTACK];	// File stack
unsigned char
	*Ptr,
	*Ptr1,
	*snames[SECTIONS],
	*symbols[SYMBOLS],
	*replace[SYMBOLS],
	Sflags[SECTIONS],
	Opt,
	link_state,
	Sfile[128],
	Ofile[128],
	Hfile[127],
	pool[POOL];
#message ** run CHT and BLD HLPEXE -G
#include "R:\\Help.h"
unsigned char Hlp[] =
#include "R:\\HLPEXE.H"

#ifndef MemTst
	void MemTst(unsigned char x)
	{
		unsigned i, j;
		unsigned char *p, *p1;
		static unsigned char *mp;

		if(x) {
			p1 = &i - 16;
			free(mp = p = malloc(8));
			while(p < p1)
				*p++ = 0xA5;
			return; }

		i = 0;
		p1 = &x;
		printf("Mem: %04x-", mp);
	a1:	j = 0;
		while(mp < p1) {
			if(*mp++ != 0xA5) {
				if(j > i) {
					i = j;
					p = mp; }
				goto a1; }
			++j; }
		printf("%04x %u\n", p, i);
	}
#endif

/*
 * Formatted print error message
 */
register error(args)
	unsigned args;
{
	unsigned char buf[50];

	_format_(nargs() * 2 + &args, buf);
	printf("ERROR: Line=%u", line);
	if(scount)
		printf(" Section=%u '%s'", scount-1, snames[scount-1], buf);
	printf(" : %s\n", buf);
	exit(-1);
}

/*
 * Help command - Implements "hypertext" screens
 */
#define	HELP_T		0x70			// Video attribute for main window
#define	HELP_L		0x71			// Video attribute for link
#define	HELP_S		0x17			// Video attribute for selected link
#define	TAB_SIZE	4				// Spacing of TABs
int help(unsigned section)
{
	int c, lx, ly, ox, oy;
	unsigned i, j, size, ncount;
	unsigned char buffer[65], savwin[6], *ptr;
	unsigned char xs[LINKS], ys[LINKS], names[LINKS][NAME+1], link[LINKS];
	FILE *fp;

	fp = fopen(Ofile, "rvbq");

	/* Locate the section in question */
lookup:
	size = getc(fp);
	size |= getc(fp) << 8;
	if(section--) {
		fseek(fp, 0, size, 1);
		goto lookup; }

	/* Draw the screen */
	wopen(5, 4, WIDTH+2, LINES+2, WSAVE|WCOPEN|WBOX1|(unsigned)HELP_T);
	wcursor_off();
	i = ncount = ptr = 0;
	while(buffer[i++] = getc(fp));

	memcpy(savwin, W_OPEN, 6);
	W_OPEN[1] &= (~WBOX3 >> 8);
	--W_OPEN[3];
	wgotoxy(0,0);
	wprintf(" %s ", buffer);
	memcpy(W_OPEN, savwin, 6);

	wgotoxy(0, 0);
	while(i++ < size) switch(c = getc(fp)) {
		case LINK_S :	/* Start link */
			ptr = names[ncount];
			xs[ncount] = W_OPEN->WINcurx;
			ys[ncount] = W_OPEN->WINcury;
			*W_OPEN = HELP_L;
			break;
		case LINK_E :	/* End link */
			link[ncount++] = getc(fp);
			*ptr = ptr = 0;
			*W_OPEN = HELP_T;
#if 0
	extra:	++i;
			break;
		case USER_CODE:	/* User control code */
			user_help(getc(fp));
			goto extra;
#else
			++i;
			break;
#endif
		case '\t' :		/* Horizontal TAB */
			do
				wputc(' ');
			while(W_OPEN->WINcurx % TAB_SIZE);
			break;
		case 0 :
			c = '\n';
		default:
			wputc(c);
			if(ptr)
				*ptr++ = c; }

	/* Allow user to select field & link to new screen */
	i = section = 0;
	for(;;) {
		wgotoxy(xs[section], ys[section]);
		*W_OPEN = HELP_L;
		wputs(names[section]);
		wgotoxy(xs[i], ys[i]);
		*W_OPEN = HELP_S;
		wputs(names[section = i]);
		*W_OPEN = HELP_T;
		switch(c = wgetc()) {		/* User keystroke */
			case _KLA :				/* Left arrow - previous field */
				i = (i ? i : ncount) - 1;
				break;
			case _KRA :				/* Right arrow - next field */
				i = (i + 1) % ncount;
				break;
			case _KUA : ox = oy = -1000; goto dofind;
			case _KDA : ox = oy = 1000;
			dofind:
				size = i;
				for(j = 0; j < ncount; ++j) {
					lx = (int)xs[j] - (int)xs[i];
					ly = (int)ys[j] - (int)ys[i];
					if(c == _KUA) {
						if((ly >= 0) || (ly < oy)) continue; }
					else {
						if((ly <= 0) || (ly > oy))	continue; }
					if(abs(lx) > abs(ox)) continue;
					size = j;
					ox = lx;
					oy = ly; }
				i = size;
				break;
			case '\n' :				/* Enter - chain to menu */
				rewind(fp);
				section = link[i];
				wclose();
				goto lookup;
			case 0x1B:				/* Escape exit */
				wclose();
				fclose(fp);
				return 0; } }
}


void Skip(void)
{
a1:	switch(*Ptr) {
	case ' ':
	case'\t': ++Ptr;	goto a1; }
}

unsigned char Tc, Tc1;
unsigned char tstc(void)
{
	if((Tc = Tc1 = *Ptr) == LINK_N) {
		if((Tc = *++Ptr) == LINK_N)
			Tc = *Ptr = 0xFF; }
	return Tc1;
}
unsigned char tstc1(void)
{
	if(tstc())
		++Ptr;
	return Tc1;
}
void Tpc(unsigned char c)
{
	if(c == 0xFF) c = LINK_N;
	putc(c, fpo);
}

xgets(unsigned char *buffer, unsigned size, unsigned char pass)
{
	unsigned i;
	unsigned char inline[200], name[200], *p1, *p2;
	static unsigned char *cmds[] = {
		"define",
		"name",
		"links",
		"width",
		"lines",
		"tab",
		"hhfile",
		"end",
		"include",
		"rem",
		0 };
read_next:
	if(!fgets(Ptr = p1 = p2 = inline, size, fpi)) {
ex:		if(Fsp) {
			fclose(fpi);
			fpi = Fstack[--Fsp];
			line = Lstack[Fsp];
			Debug(("Back(%u)\n", line))
			goto read_next; }
		return 0; }
	++line;
	Skip();
	if(tstc1() != '#')
		goto return_data;
	for(i=0; p1 = cmds[i]; ++i) {
		if(strbeg(Ptr, p1))
			goto found_cmd; }
	// Return the command line back to the source
return_data:
	Ptr = inline;
	do {
		if(tstc() == '~') {
			++Ptr;
			if((*Ptr >= '@') && (*Ptr <= '_')) {
				*buffer++ = *Ptr & 0x1F;
				continue; } }
		if(isalpha(*Ptr)) {		// Possible symbol
			p1 = name;
			while(isalpha(*Ptr) || isdigit(*Ptr))
				*p1++ = *Ptr++;
			*p1 = 0;
			p1 = name;
			for(i = 0; i < sym_top; ++i) {
				if(!strcmp(symbols[i], name)) {
					p1 = replace[i];
					break; } }
			while(*p1)
				*buffer++ = *p1++; }
		*buffer++ = *Ptr; }
	while(*Ptr++);
	return -1;

found_cmd:
	Ptr = inline + strlen(p1)+1;
	Skip();
	switch(i) {
	case 0 :	// Define
		if(!pass) {
			if(!isalpha(*Ptr))
				error("Invalid symbol name");
			symbols[sym_top] = &pool[pool_top];
			while(isalpha(*Ptr) || isdigit(*Ptr))
				pool[pool_top++] = *Ptr++;
			pool[pool_top++] = 0;
			Skip();
			replace[sym_top++] = &pool[pool_top];
			while(*Ptr)
				pool[pool_top++] = *Ptr++;
			pool[pool_top++] = 0; }
		break;
	case 1 : Name = atoi(Ptr);		break;		// Name width
	case 2 : Links = atoi(Ptr);		break;		// Max links
	case 3 : Width = atoi(Ptr);		break;		// Line width
	case 4 : Lines = atoi(Ptr);		break;		// Max lines
	case 5 : Tabsize = atoi(Ptr);	break;		// Tab size
	case 6 :									// hhfile
		if(!*Hfile)
			strcpy(Hfile, Ptr);
		break;
	case 7 :	goto ex;
	case 8 :									// Include
		if(Fsp >= FSTACK)
			error("#include too deep");
//printf("Including(%u) '%s'\n", line, p);
		Lstack[Fsp] = line;
		Fstack[Fsp++] = fpi;
//		FileExt(p, ".SRC");
		fpi = fopen(Ptr, "rvq"); }
	goto read_next;
}

unsigned Fd, Fe;
void Fext(unsigned char *fn, unsigned char *ext)
{
	unsigned i;
	i = Fd = 0;
a1:	Fe = 0;
a2:	switch(fn[i++]) {
	case ':':
	case'\\':	Fd = i;	goto a1;
	case '.':	Fe = i;
	default	:			goto a2;
	case 0	:	; }
	if(!Fe) {
		strcpy(fn+i-1, ext);
		Fe = i; }
}

/*
 * Main HELP compiler
 */
main(int argc, char *argv[])
{
	int c;
	unsigned i, size, l, w;
	unsigned char buffer[200];

	MemTst(7);

	printf("Help File Compiler v1.0\nCopyright 1994-2024 Dave Dunfield.  -- see COPY.TXT --.\n");

	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			case '?': switch(toupper(*Ptr)) {
				case 'S':	Ptr = Shelp; goto he1; }
			default	:	goto he;
/*ChtTxt Mhelp

use:	HFC infile[.SRC] [outfile[.HLP]] [options]

opts:	-H[name]	generate name.HH with |+ defines
		-A""					""		  All ""
		-E			make existing .HLP into .EXE
		-V			View existing .HLP

Builds fully linked .HLP from .SRC - more info: -?S

outfile defaults to infile.HLP

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
			case 'H':	c = O_HDR;	goto o3;
			case 'A':	c = O_HDRA|O_HDR;
o3:				strcpy(Hfile, Ptr);
				Ptr = "";
				goto o2;
			case 'E':	c = O_EXE;	goto o2;
			case 'V':	c = O_VIEW;
o2:				Opt ^= c; }
			if(*Ptr) goto o1;
			continue; }
		if(!*Sfile) {
			strcpy(Sfile, Ptr);
			continue; }
		if(*Ofile)
			goto he;
		strcpy(Ofile, Ptr); }
	if(!*Sfile) {
he:		Ptr = Mhelp;
he1:	while(c = *Ptr++) {
			if(c & 0x80) {
				while(c-- & 0x7F)
					putc(' ', stdout);
				continue; }
			putc(c, stdout); }
		goto ex; }

	IOB_size = 2048;
	if(Opt & O_EXE) {
		Fext(Sfile, ".HLP");
		fclose(fopen(Sfile, "rbvq"));
		Debug1(("H'%s'\n", Sfile))
		strcpy(Sfile+Fe, "EXE");
		Debug1(("E'%s'\n", Sfile))
		fpo = fopen(Sfile, "wbvq");
		fput(Hlp, sizeof(Hlp), fpo);
		strcpy(Sfile+Fe, "HLP");
		fpi = fopen(Sfile, "rbvq");
		while(i = fget(pool, sizeof(pool), fpi)) {
			fput(pool, i, fpo);
			if(i != sizeof(pool))
				break; }
		fclose(fpi);
		fclose(fpo);
		goto ex; }
	Fext(Sfile, ".SRC");
	if(!*Ofile) {
		strcpy(Ofile, Sfile);
		Ofile[Fe-1] = 0; }
	Fext(Ofile, ".HLP");

	if(Opt & O_VIEW) {
		help(0);
		goto ex; }

	fpi = fopen(Sfile, "rvq");

	printf("Pass 1... ");
	size = l = 0;
	while(xgets(Ptr = buffer, sizeof(buffer)-1, 0)) {
		Ptr = buffer;
		if(tstc() == '|') {
			if(scount) {
				ssize[scount-1] = size;
				size = 0;
				if(!links)
					error("At least one link required!"); }
			else if(size)
				error("Must begin with section");
			if(scount >= SECTIONS)
				error("Too many sections");
			while(isspace(*++Ptr));
			if(tstc() == '+') {
				++Ptr;
a1:				Sflags[scount] |= F_DEF;
				++scount2; }
			else if(Opt & O_HDRA)
				goto a1;
			snames[scount++] = &pool[pool_top];
			while(*Ptr && (tstc() != '|')) {
				if(!isspace(*Ptr))
					pool[pool_top++] = toupper(*Ptr);
				++Ptr; }
			pool[pool_top++] = links = l = 0;
			++Ptr; }
		if(l++ > Lines)
			error("Section exceeds %u lines", Lines);
		w = 0;
		while(*Ptr) {			/* Standard text line */
			++size;
			switch(tstc1()) {
				case '\t' :
					while(++w % Tabsize);
					--w;
				default:
					if(++w > Width)
						error("Line exceeds %u characters", Width);
					break;
				case USER_CODE:
					while(isdigit(*Ptr))
						++Ptr;
					++size;
					break;
				case LINK_S :	// Start of link
					++size;
					if(link_state)
						error("Unexpected link start");
					link_state = 1;
					scount1 = size;
					if(++links > Links)
						error("Too many links");
					break;
				case LINK_R :	// Redirect text->link
					if(link_state != 1)
						error("Unexpected link redirect");
					while(tstc1() != LINK_E);
					goto endlink;
				case LINK_E :	// End of link
					if(!link_state)
						error("Unexpected link end");
				endlink:
					if((size - scount1) > Name)
						error("Link name too long");
					link_state = 0; } }
		++size; }
	ssize[scount-1] = size;
	if(!links)
		error("At least one link required!");

	rewind(fpi);

	if(Opt & O_HDR) {
		if(!*Hfile) {
			strcpy(Hfile, Ofile);
			Hfile[Fe-1] = 0; }
		Fext(Hfile, ".HH");
		fph = fopen(Hfile, "wvq"); }

	fpo = fopen(Ofile, "wvqb");
	printf("Pass 2...\n");
	scount1 = scount;
	scount = size = line = 0;
	while(xgets(Ptr = buffer, sizeof(buffer)-1, -1)) {
		Ptr = buffer;
		if(tstc() == '|') {	/* Section definition */
			printf("Section %-3u '%-24s' %u\n", scount, snames[scount], ssize[scount]);
			if((Sflags[scount] & F_DEF) && fph)
				fprintf(fph, "#define H_%s %u\n", snames[scount], scount);
			if(scount) {
				if(ssize[scount-1] != size)
					abort("Size does not match");
				size = 0; }
			++Ptr;
			while(*Ptr && (*Ptr++ != '|'));
			putc(ssize[scount], fpo);
			putc(ssize[scount++] >> 8, fpo); }
		while(*Ptr) {			/* Standard text line */
			Tpc(*Ptr);
			++size;
			if(*Ptr == USER_CODE) {
				i = 0;
				while(isdigit(c = *++Ptr))
					i = (i * 10) + (c - '0');
				goto found; }
			if(tstc1() == LINK_S) {		// Start of link
				Ptr1 = Ofile;
				for(;;) {
					if(tstc1() == LINK_R) {	// Redirect
						Ptr1 = Ofile;
						while(tstc1() != LINK_E) {
							if(!isspace(Tc))
								*Ptr1++ = toupper(Tc); } }
					Tpc(Tc);
					++size;
					if(Tc1 == LINK_E)		// End of link
						break;
					if(!isspace(Tc))
						*Ptr1++ = toupper(Tc); }
				*Ptr1 = 0;
				for(i=0; i < scount1; ++i) {
					if(!strcmp(snames[i], Ofile)) {
						Sflags[i] |= F_REF;
						goto found; } }
/*				if(!strcmp("$", Ofile)) {
					i = 255;
					goto found; } */
				error("Link not found: '%s'\n", Ofile);
			found:
				Tpc(i);
				++size; } }
		Tpc(0);
		++size; }

	if(fph)
		fclose(fph);
	fclose(fpo);
	fclose(fpi);
	for(i=0; i < scount1; ++i) {
		if(!(Sflags[i] & F_REF))
			printf("Unreferenced: %s\n", snames[i]); }
	printf("Pool    : %5u/%u\n", pool_top, POOL);
	printf("Sections: %5u/%u\n", scount1, SECTIONS);
	printf("Synbols : %5u/%u\n", sym_top, SYMBOLS);
	if(Opt & O_HDR) {
		if(!scount2)
			printf("-H no |+\n"); }
	else if(scount2)
		printf("|+ no -H\n");
ex:	MemTst(0);
}
//BuildD cht hfc
//BuildD cc hlpexe -pof
//BuildD compak hlpexe.com
//BuildD com2exe hlpexe
//BuildD del hlp.com
//BuildD bin2c hlpexe.exe >R:\HLPEXE.H
//BuildD del hlpexe.exe
//BuildD cc hfc -pof -pof
