// HLPEEX
#include <stdio.h>
#include <window.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

unsigned
	OffL;
FILE
	*fp;

/* General parameters */
#define	LINK_S		('N'-0x40)		// Start of a link 
#define	LINK_E		('O'-0x40)		// End of a link

#define	NAME		24				// Max. size of name
#define	LINKS		25				// Maximum # links per screen
#define	WIDTH		68				// Width of window
#define	LINES		15				// Height of window
#define	TAB_SIZE	4				// Spacing of TABs

#define	HELP_T		0x70			// Video attribute for main window
#define	HELP_L		0x71			// Video attribute for link
#define	HELP_S		0x17			// Video attribute for selected link

/*
 * Display a title on a window
 */
void wintitle(char *ptr)
{
	char buffer[6];
	memcpy(buffer, W_OPEN, 6);
	W_OPEN[1] &= (~WBOX3 >> 8);
	--W_OPEN[3];
	wgotoxy(0,0);
	wprintf(" %s ", ptr);
	memcpy(W_OPEN, buffer, 6);
}

void Rewind(void)
{
	fseek(fp, 0, OffL, 0);
}

/*
 * Help commnd - Implements "hypertext" screens
 */
int main(int argc, char *argv[])
{
	int c, lx, ly, ox, oy;
	unsigned section, i, j, size, ncount;
	unsigned char buffer[65], *ptr;
	unsigned char xs[LINKS], ys[LINKS], names[LINKS][NAME+1], link[LINKS];

	fp = fopen(argv[0], "rbvq");
	fget(buffer, 8, fp);
	i = *(unsigned*)(buffer+2);
	j = *(unsigned*)(buffer+4);
	OffL = ((j-1)*512)+i;
	Debug(("bytes:%u pgs:%u Off:%u", i, j, OffL))

	section = (argc > 1) ? atoi(argv[1]) : 0;
	Debug(("[%u]", section))
	Rewind();

	/* Locate the section in question */
lookup:
	size = getc(fp);
	size |= getc(fp) << 8;
	if(section--) {
		fseek(fp, 0, size, 1);
		goto lookup; }

	/* Draw the screen */
	wopen(5, 4, WIDTH+2, LINES+2, WSAVE|WCOPEN|WBOX1|(unsigned)HELP_T);
	wcursor_off();
	i = ncount = ptr = 0;
	while(buffer[i++] = getc(fp));
	wintitle(buffer);
	wgotoxy(0, 0);
	while(i++ < size) switch(c = getc(fp)) {
		case LINK_S :	/* Start link */
			ptr = names[ncount];
			xs[ncount] = W_OPEN->WINcurx;
			ys[ncount] = W_OPEN->WINcury;
			*W_OPEN = HELP_L;
			break;
		case LINK_E :	/* End link */
			link[ncount++] = getc(fp);
			*ptr = ptr = 0;
			*W_OPEN = HELP_T;
#ifndef USER_CODE
			++i;
			break;
#else
	extra:	++i;
			break;
		case USER_CODE:	/* User control code */
			user_help(getc(fp));
			goto extra;
#endif
		case '\t' :		/* Horizontal TAB */
			do
				wputc(' ');
			while(W_OPEN->WINcurx % TAB_SIZE);
			break;
		case 0 :
			c = '\n';
		default:
			wputc(c);
			if(ptr)
				*ptr++ = c; }

	/* Allow user to select field & link to new screen */
	i = section = 0;
	for(;;) {
		wgotoxy(xs[section], ys[section]);
		*W_OPEN = HELP_L;
		wputs(names[section]);
		wgotoxy(xs[i], ys[i]);
		*W_OPEN = HELP_S;
		wputs(names[section = i]);
		*W_OPEN = HELP_T;
		switch(c = wgetc()) {		/* User keystroke */
			case _KLA :				/* Left arrow - previous field */
				i = (i ? i : ncount) - 1;
				break;
			case _KRA :				/* Right arrow - next field */
				i = (i + 1) % ncount;
				break;
			case _KUA : ox = oy = -1000; goto dofind;
			case _KDA : ox = oy = 1000;
			dofind:
				size = i;
				for(j = 0; j < ncount; ++j) {
					lx = (int)xs[j] - (int)xs[i];
					ly = (int)ys[j] - (int)ys[i];
					if(c == _KUA) {
						if((ly >= 0) || (ly < oy)) continue; }
					else {
						if((ly <= 0) || (ly > oy))	continue; }
					if(abs(lx) > abs(ox)) continue;
					size = j;
					ox = lx;
					oy = ly; }
				i = size;
				break;
			case '\n' :				/* Enter - chain to menu */
				Rewind();
				section = link[i];
				wclose();
				goto lookup;
			case 0x1B:				/* Escape exit */
				wclose();
				fclose(fp);
				return 0; } }
}
//BuildD cp HLPEXE.C R:\
//BuildD xcd =R:\
//BuildD cc hlpexe -pof
//BuildD compak hlpexe
//BuildD com2exe hlpexe
//BuildD del hlpexe.com
//BuildD bin2c hlpexe.exe >HLPEXE.H
//BuildD del hlpexe.exe
//BuildD del R:\hlpexe.c
//BuildD xcd -
