*
* SIMPLE! RS-232 I/R remote control transceiver firmware
*
* ?COPY.TXT 1994-2005 Dave Dunfield
*  -- see COPY.TXT --.
*
* Permission granted for personal (non-commercial) use only.
* Authors name and Copyright notice may not be altered or removed.
*
IRin	BIT	P1.0		Input I/R detect
IRout	BIT	P1.7		Output I/R driver
Busy	BIT	P1.6		Busy LED
LRpin	BIT	P1.1		Manual Learn key
AGpin	BIT	P1.2		Manual Again key
HSpin	BIT	P1.3		High speed (50Khz)
* P1.4 and P1.5 are used for setting default repeat count
BUFFER	EQU	$10		Buffer address (0C)
BUFEND	EQU	$7F		End of buffer
* BAUD = (crystal / 384) / speed
BAUD	EQU	3		Baudrate divisor for 9600 BPS
* Direct register access
?R0	EQU	0		Buffer pointer
?R1	EQU	?R0+1
?R2	EQU	?R0+2
?R3	EQU	?R0+3
?R4	EQU	?R0+4
?R5	EQU	?R0+5		Repeat count
?R6	EQU	?R0+6		Intedigit gap
?R7	EQU	?R0+7		End of buffer location
*
	ORG	$0000
* Initialize the timer 1 for auto-reload at 32xN
INIT	MOV	TMOD,#%00100000	T1=8 bit auto-reload
	MOV	TH1,#-BAUD	Timer 1 reload value
	MOV	TL1,#-BAUD	Timer 1 initial value
	MOV	TCON,#%01001001	Run 1, Hold 0
* Initialize the serial port
	MOV	SCON,#%01010010	Mode 1, REN, TXRDY, RXEMPTY
* Setup default control parameters
	MOV	A,P1		Get P1
	SWAP	A		Get into LOW nibble
	ANL	A,#%00000011	Save only config bits
	MOV	DPTR,#REPTAB	Point to table
	MOVC	A,[A+DPTR]	Read value
	MOV	R5,A		Set default repeat value
	MOV	R6,#1		Minimal inital interdigit.
	MOV	R7,#BUFFER	Zero initial length
* Execute next command
START	MOV	A,#'.'		Prompt
start1	MOV	SP,#7		Set initial SP
	ACALL	WRCHR
	CLR	IRout		Turn LED off
	CLR	Busy		Indicate Idle
start2	JNB	LRpin,golearn	Manual LEARN activation
	JNB	AGpin,goagain	Manual AGAIN activation
	JNB	SCON.0,start2	Wait for the bit
	CLR	SCON.0		Indicate we receved it
	MOV	A,SBUF		Read the data
	SETB	Busy		Indicate busy
	ACALL	WRCHR		Echo it
*
* Learn an I/R remote code
*
cmd1	CJNE	A,#'L',cmd2	Learn a code?
golearn	SETB	Busy		Indicate busy
	ACALL	LEARN		Learn the code
	JC	ERROR		Report an error
	MOV	A,#'*'		Success
	ACALL	WRCHR		Output
	MOV	A,R7		Get buffer count
	ADD	A,#-BUFFER	Convert to offset
	ACALL	WRCHR		Output count
	MOV	R0,#BUFFER	Point to buffer
cmd1a	MOV	A,[R0]		Get byte of code
	ACALL	WRCHR		output
	INC	R0		Advance
	MOV	A,R0		Get index
	CJNE	A,?R7,cmd1a	Do them all
	MOV	A,R6		Get interdigit count
	ACALL	WRCHR		Output
	AJMP	START		Next command
* An error has occured
ERROR	MOV	A,#'?'		Error character
	AJMP	START1
*
* Send an I/R remote code
*
cmd2	CJNE	A,#'S',cmd3	No, try next
	ACALL	RDCHR		Get data count
	MOV	R2,A		Save it
	ADD	A,#BUFFER	Offset to buffer
	MOV	R7,A		Save it
	MOV	R0,#BUFFER	Point to buffer
cmd2a	ACALL	RDCHR		Read byte
	MOV	[R0],A		Save it
	INC	R0		Get byte
	DJNZ	R2,cmd2a	read them all
	ACALL	RDCHR		Get inter-digit delay
	MOV	R6,A		Set delay
goagain	SETB	Busy		Indicate busy
	ACALL	SEND		Send the code
	AJMP	START		Next command
*
* Set the RESEND value
*
cmd3	CJNE	A,#'R',cmd4	No, try next
	ACALL	RDCHR		Get character
	MOV	R5,A		Set resend
	AJMP	START		And again
*
* Resend last command
*
cmd4	CJNE	A,#'A',cmd5	No, try next
	AJMP	goagain		Send command again
*
* Select 'N'ormal (38Khz) I/R frequency
*
cmd5	CJNE	A,#'N',cmd6	No, try next
	SETB	HSpin		Select LOW speed
	JNB	HSpin,error	Jumper is installed
	AJMP	START		And again
*
* Select 'H'igh (50Khz) I/R frequency
*
cmd6	CJNE	A,#'H',cmd7	No, try next
	CLR	HSpin		Select HIGH speed
cmd6a	AJMP	START		And again
*
* Help '?' command
*
cmd7	CJNE	A,#'?',error	No, try next
	MOV	DPTR,#HELPTXT	Point to message
cmd7a	CLR	A		Zero ACC
	MOVC	A,[A+DPTR]	Get char
	JZ	cmd6a		End of message
	INC	DPTR		Next
	ACALL	WRCHR		Output char
	SJMP	cmd7a		And go again
*
* LEARN an I/R control code and store pattern in memory buffer
*
LEARN	MOV	R0,#BUFFER	Point to buffer
* Wait for a I/R signal to start
learn1	JB	IRin,*		Wait for IR/ON
* Time signal LOW period (in 38Khz clock ticks)
learn2	CLR	A		;1 Begin count
learn3	INC	A		;1 Advance count
	JZ	learn4		;2 Overflow
	ACALL	DELAY		;9 Wait for delay
	ACALL	DELAY		;9 Wait for delay
	NOP			;1 Line up at 24 cycles
	JNB	IRin,learn3	;2 Bit is still HIGH
learn4	MOV	[R0],A		;2 Save the code
	INC	R0		;1 Advance
	CJNE	R0,#BUFEND,learn5 ;2 Buffer not empty
	AJMP	LEXIT		;Buffer is full, exit
learn5	JZ	learn3		;2 Special case - continue LOW time
* Time signal HIGH period (in 38Khz clock ticks)
	CLR	A		;1 Zero count
learn6	INC	A		;1 Advance count
	JZ	learn7		;2 Overflow
	ACALL	DELAY		;9 Wait for delay
	ACALL	DELAY		;9 Wait for delay
	NOP			;1 Line up at 24 cycles
	JB	IRin,learn6	;2 Bit is still LOW
learn7	MOV	[R0],A		;2 Save the code
	INC	R0		;1 Advance
	CJNE	R0,#BUFEND,learn8 ;2 Buffer not empty
	AJMP	LEXIT		;Buffer is full, exit
learn8	JZ	learn6		;2 Special case - continue HIGH time
	SJMP	learn2		;2 Time LOW bit
* IR buffer has filled, determine length of signal
LEXIT	MOV	R0,#BUFFER	Start at beginning
	MOV	R7,#0		Default end marker
	MOV	R6,#0		Default interdigit time
* Step through ON time
lexit1	CJNE	R0,#BUFEND,lexit3 Not at end
* End of buffer - check for errors
lexit2	MOV	A,R6		Get interdigit time
	JZ	LERROR		Invalid
	MOV	A,R7		Get buffer end marker
	JZ	LERROR		Invalid
	CLR	C		Indicate success
	RET
lexit3	MOV	A,[R0]		Get ON code
	INC	R0		Advance to next
	JZ	lexit1		Continuation...
* Step through OFF time
	MOV	R1,?R0		Save position
	MOV	R2,#0		Count of zero expansions
lexit4	CJNE	R0,#BUFEND,lexit7 Not at end
lexit5	MOV	A,R2		Get measured interdigit time
	CJNE	A,?R6,lexit6	Possibly greater than last
	SJMP	lexit1		Same - ignore
lexit6	JC	lexit1		Less - ignore
	MOV	R6,A		Save new interdigit time
	MOV	R7,?R1		Save new end of buffer
	SJMP	lexit1		And proceed
lexit7	MOV	A,[R0]		Get OFF code
	INC	R0		Advance to next
	JNZ	lexit5		Signal has returned
	INC	R2		Advance count
	SJMP	lexit4		Keep looking
* Error occured while learning
LERROR	SETB	C		Indicate error
	RET
*
* Transmit an I/R control code
*
SEND	MOV	R3,?R5		;Tx repeat count
send1	MOV	R0,#BUFFER	;Setup pointer
* Transmit ON time (38Khz pulse)
send2	MOV	A,R0		;1 Get position
	CJNE	A,?R7,send3	;2 More to go
	AJMP	Sexit		;2 All done, exit
send3	MOV	A,[R0]		;2 Get counter
	INC	R0		;1 Advance
	MOV	R1,A		;1 Set counter
send4	SETB	IRout		;1 LED on
	ACALL	DELAY		;9 wait for delay	
	NOP			;1 line it up
	NOP			;1 line it up (24 cycles) ***
	CLR	IRout		;1 LED off
	ACALL	DELAY		;9 wait for delay
	DJNZ	R1,send4	;2 Do them all
	JZ	send2		;2 Special case - stay ON
* Output OFF time (dead air)
send5	MOV	A,R0		;1 Get position
	CJNE	A,?R7,send6	;2 More to go
	AJMP	Sexit		;2 All fone, exit
send6	MOV	A,[R0]		;2 Get counter
	INC	R0		;1 Advance
	MOV	R1,A		;1 Set counter
send7	ACALL	DELAY		;9 wait for delay
	ACALL	DELAY		;9 wait for delay
	NOP			;1 line
	NOP			;1 it
	NOP			;1 up
	NOP			;1 at 24 cycles
	DJNZ	R1,send7	;2 Do them ALL
	JZ	send5		;2 Special case - stay OFF
	SJMP	send2		;2 Continue
* Signal has been transmitted
Sexit	MOV	R2,?R6		;Set recorded count
	MOV	R1,#0		;Inner loop count
* Insert inter-signal gap
sexit1	ACALL	DELAY		;9 wait for delay
	ACALL	DELAY		;9 wait for delay
	NOP			;1 Line it up
	NOP			;1 Line it up
	NOP			;1 Line it up
	NOP			;1 Line it up
	DJNZ	R1,sexit1	;2 inner timer
	DJNZ	R2,sexit1	;Do complete timeout
	DJNZ	R3,send1	;Repeat # times
	RET
*
* Delay for 9 cycles (incl ACALL/RET)
*
DELAY	JNB	HSpin,delay1	;3-4
	NOP			;5
	NOP			;6
	NOP			;7
delay1	RET			;8-9
*
* Read a character from the serial port with timeout
*
RDCHR	CLR	A		Zero outer counter
	MOV	B,A		Zero inner counter
rdc1	JB	SCON.0,rdc2	We have a bit
	DJNZ	A,rdc1		Loop inner
	DJNZ	B,rdc1		Loop outer
	AJMP	ERROR		Report error
rdc2	CLR	SCON.0		Indicate we received it
	MOV	A,SBUF		Read the data
	RET
*
* Write a character to the serial port
*
WRCHR	JNB	SCON.1,*	Wait for the bit
	CLR	SCON.1		Indicate we are sending
	MOV	SBUF,A		Write out char
	RET
*
* Table of repeat counts for default configuration
*
REPTAB	DB	1,2,3,5
*
* Informational text
*
HELPTXT	DB	$0A,$0D
	STR	'IR-232 Release 1.0'
	DB	$0A,$0D,$0A
	STR	'?COPY.TXT 1994-2005 Dave Dunfield'
	DB	$0A,$0D
	STR	' -- see COPY.TXT --.'
	DB	$0A,$0D,$0A
	STR	'A           - Transmit last code again'
	DB	$0A,$0D
	STR	'H           - High: set 50khz mode'
	DB	$0A,$0D
	STR	'L           - Learn code, sends *<len><data><gap>'
	DB	$0A,$0D
	STR	'N           - Normal: set 38khz mode'
	DB	$0A,$0D
	STR	'R<count>    - Set repeat count: 01-FF,00=100'
	DB	$0A,$0D
	STR	'S<l><d><g>  - Send an I/R code'
	DB	$0A,$0D,0
