/*
 * Skeleton MICRO-C/PC program for transmitting I/R codes.
 *
 * ?COPY.TXT 1994-2005 Dave Dunfield
 *  -- see COPY.TXT --.
 */
#include <stdio.h>		/* General I/O definitions */
#include <comm.h>		/* Serial  I/O definitions */

#define	COMPORT		1	/* Communicate via this port */

/*
 * IR code storage buffer
 */
unsigned char IR_buffer[2500];
unsigned IR_top = 0;

/*
 * Get BIOS tick counter
 */
unsigned get_ticks(void) asm
{
	MOV	AX,40h
	MOV	ES,AX
	MOV	BX,6Ch
	MOV	AX,ES:[BX]
}

/*
 * Get serial input character with timeout (in 1/18 second ticks)
 */
int Cgett(unsigned ticks)
{
	int c;
	unsigned f;
	f = get_ticks();
	do {
		if((c = Ctestc()) != -1)
			return c; }
	while((get_ticks() - f) <= ticks);
	return -1;
}

/*
 * Transmit an IR code indicated by table index (0 ...)
 */
void transmit(unsigned key)
{
	int c;
	char *ptr, *ptr1;

	/* Search list for key data */
	ptr1 = (ptr = IR_buffer) + IR_top;
	while(key--) {
		ptr += (*ptr + 2);
		if(ptr >= ptr1)
			return; }

	/* Send command to remote */
	while(Ctestc() != -1);
	Cputc('S');
	if(Cgett(18) != 'S')
		abort("Error! no ECHO!");
	Cputc(c = *ptr++);
	++c;
	while(c--)
		Cputc(*ptr++);
	if(Cgett(18) != '.')
		abort("Error! no '.'!");
}

/*
 * Main demonstration program
 * Transmit the first 5 codes defined at 1 second intervals.
 */
main(int argc, char *argv[])
{
	int i;
	FILE *fp;

	/* Verify that an IR code filename was given */
	if(argc < 2)
		abort("Use: irdemo <filename>");

	/* Read in key definition file */
	fp = fopen(argv[1], "rvqb");
	IR_top = fget(IR_buffer, sizeof(IR_buffer), fp);
	fclose(fp);

	/* Open COMM port for binary I/O activity */
	if(Copen(COMPORT, _9600, PAR_NO|DATA_8|STOP_1, SET_DTR|SET_RTS|OUTPUT_2))
		abort("Cannot open comm port");
	Cflags |= TRANSPARENT;

	/* Transmit first five codes at 1 second intervals */
	for(i=0; i < 5; ++i) {
		printf("Transmitting code %u...\n", i);
		transmit(i);
		delay(1000); }

	Cclose();
}
