/*
 * Packet error generator
 *
 * ?COPY.TXT 2003-2005 Dave Dunfield -  -- see COPY.TXT --.
 *
 * cc packets -pofm PKT_INT=96
 * rename packets.obj packet1.obj
 * cc packets -pofm PKT_INT=97
 * rename packets.obj packet2.obj
 * cc bridge -pofm
 * lc bridge packet1 packet2
 */

#include <stdio.h>
#include <window.h>
#include "packets.h"

unsigned Pkt_type = 0;		// Type of packet to monitor

unsigned install_driver1(unsigned i, unsigned char *my_address)
{
	unsigned po, ps, h, t, alen;
	struct PD_driver_info info;					/* Info from driver */
	static char pkt_driver_id[] = { "PKT DRVR" };

	po = peekw(0, i*4) + 3;	/* Offset to packet ID text */
	ps = peekw(0, (i*4)+2);	/* Segment of packet driver */
	t = 0;
	do {
		if(pkt_driver_id[t] != peek(ps, po+t)) {
			printf("No packet driver on INT %u ($%02x) [%04x:%04x]\n", i, i, ps, po-3);
			return 0; } }
	while(pkt_driver_id[++t]);

	/* Obtain information from driver and display */
	if(t = pkt1_driver_info(info)) {
		printf("Unable to obtain packet driver information, RC=%04x\n", t);
		return 0; }
	printf("Pkt driver: version=%u ", info.version);
	printf("Class/Type/Num=%02x/%04x/%02x ", info.class, info.type, info.number);
	printf("Func=%02x ", info.functionality);
	printf("Name='%s'\n", info.name);

	/* Obtain access to our packet type */
	t = Pkt_type ? sizeof(Pkt_type) : 0;
	if(t = pkt1_access_type(info.class, info.type, 0, &Pkt_type, t, &h)) {
		printf("Unable to obtain packet access, RC=%04x\n", t);
		return 0; }

	/* Get our ethernet address */
	if(t=pkt1_get_address(h, my_address, PKT_EASIZE, &alen)) {
		printf("Unable to read ethernet address!, RC=%04x\n", t);
	do_exit:
		pkt1_release_type(h);
		return 0; }

	if(t=pkt1_set_receive_mode(h, 6)) {	// All packets
		printf("Unable to set access mode!, RC=%04x\n", t);
		goto do_exit; }

	return h;
}
unsigned install_driver2(unsigned i, unsigned char *my_address)
{
	unsigned po, ps, h, t, alen;
	struct PD_driver_info info;					/* Info from driver */
	static char pkt_driver_id[] = { "PKT DRVR" };

	po = peekw(0, i*4) + 3;	/* Offset to packet ID text */
	ps = peekw(0, (i*4)+2);	/* Segment of packet driver */
	t = 0;
	do {
		if(pkt_driver_id[t] != peek(ps, po+t)) {
			printf("No packet driver on INT %u ($%02x) [%04x:%04x]\n", i, i, ps, po-3);
			return 0; } }
	while(pkt_driver_id[++t]);

	/* Obtain information from driver and display */
	if(t = pkt2_driver_info(info)) {
		printf("Unable to obtain packet driver information, RC=%04x\n", t);
		return 0; }
	printf("Pkt driver: version=%u ", info.version);
	printf("Class/Type/Num=%02x/%04x/%02x ", info.class, info.type, info.number);
	printf("Func=%02x ", info.functionality);
	printf("Name='%s'\n", info.name);

	/* Obtain access to our packet type */
	t = Pkt_type ? sizeof(Pkt_type) : 0;
	if(t = pkt2_access_type(info.class, info.type, 0, &Pkt_type, t, &h)) {
		printf("Unable to obtain packet access, RC=%04x\n", t);
		return 0; }

	/* Get our ethernet address */
	if(t=pkt2_get_address(h, my_address, PKT_EASIZE, &alen)) {
		printf("Unable to read ethernet address!, RC=%04x\n", t);
	do_exit:
		pkt2_release_type(h);
		return 0; }

	if(t=pkt2_set_receive_mode(h, 6)) {	// All packets
		printf("Unable to set access mode!, RC=%04x\n", t);
		goto do_exit; }

	return h;
}

extern unsigned RAND_SEED;

unsigned char
	mode,
	*pptr;
unsigned
	to_count[2],
	to_errors[2],
	from_count[2],
	from_errors[2],
	skip1,
	skip2,
	next1,
	next2;
unsigned
	e1_rate = 95,	// Error insertion rate
	r1_rate = 10,	// "" random component
	e1_npkt = 4,	// # packets dropped
	r1_npkt = 1,	// "" random component
	e1_dtim = 0,	// Delay time (max)
	e1_dpkt = 0,	// Delay # packets
	e1_skip = 1;	// Skip max time
unsigned
	e2_rate = 95,	// Error insertion rate
	r2_rate = 10,	// "" random component
	e2_npkt = 4,	// # packets dropped
	r2_npkt = 1,	// "" random component
	e2_dtim = 0,	// Delay time (max)
	e2_dpkt = 0,	// Delay # packets
	e2_skip = 1;	// Skip max time
unsigned char
	h_rate[] = { "Packet interval at which errors will occur. " },
	h_npkt[] = { "Maximum number of packets dropped during error event." },
	h_skip[] = { "Maximum duration of error event." },
	h_dtim[] = { "Maximum delay between forwarded packets." },
	h_dpkt[] = { "Maximum # packets delayed through bridge." };

#define	CFG12 memcpy(&e1_rate, &e2_rate, sizeof(unsigned)*6)
#define CFG21 memcpy(&e2_rate, &e1_rate, sizeof(unsigned)*6)

#define	NCONFIG	10
struct Config {
	unsigned char F, P, N, X, Y, Z;
	unsigned char *Name;
	unsigned *Address;
	unsigned char *Help; } CFG[NCONFIG] = {
	char 0x01, 7, 4,  0,  7, 0, int "<<< Erate:",	&e1_rate,	&h_rate,	// 0
	char 0x02, 8, 5,  4,  8, 0, int "Delay:",		&e1_dtim,	&h_dtim,	// 1
	char 0x01, 5, 6,  0, 11, 0, int ">>> Erate:",	&e2_rate,	&h_rate,	// 2
	char 0x02, 9, 7,  4, 12, 0, int "Delay:",		&e2_dtim,	&h_dtim,	// 3
	char 0x01, 0, 8, 30,  7, 0, int "Pkts/Event:",	&e1_npkt,	&h_npkt,	// 4
	char 0x00, 1, 2, 30,  8, 0, int "Pkts/Delay:",	&e1_dpkt,	&h_dpkt,	// 5
	char 0x01, 2, 9, 30, 11, 0, int "Pkts/Event:",	&e2_npkt,	&h_npkt,	// 6
	char 0x00, 3, 0, 30, 12, 0, int "Pkts/Delay:",	&e2_dpkt,	&h_dpkt,	// 7
	char 0x02, 4, 1, 60,  7, 0, int "MaxTime:",		&e1_skip,	&h_skip,	// 8
	char 0x02, 6, 3, 60, 11, 0, int "MaxTime:",		&e2_skip,	&h_skip};	// 9
//	0	4   8
//	1	5
//	2	6   9
//	3	7

unsigned	// Timestamps
	t1_last,	// Last packet TX
	t2_last,	// Last packet TX
	t1_skip,	// Start of SKIP
	t2_skip;	// Start of SKIP
unsigned
	Cfg;
unsigned char
	C1,
	C2,
	H_len,		// Help length
	*H_ptr;		// Help pointer


show_value(struct Config *p)
{
	unsigned t, *v;
	v = p->Address;
	if(p->F & 1) {
		if(mode & 1) {
			wprintf("%5u+%-5u", *v, v[1]);
			return; }
		t = v[1] / 2;
		wprintf("%5u\xF1%-5u", *v + t, v[1]-t);
		return; }
	if(p->F & 0x02) {
		wprintf("%5u", *v * 55);
		return; }
	wprintf("%5u", *v);
}

unsigned get_value(unsigned *p)
{
	if(p[1])
		return *p + random(p[1]+1);
	return *p;
}

show_address(unsigned char *a)
{
	wprintf("%02x:%02x:%02x:%02x:%02x:%02x",
		a[0], a[1], a[2], a[3], a[4], a[5]);
}

void increment(unsigned *n)
{
	if(++*n >= 10000) {
		++n[1];
		*n = 0; }
}
void show_count(unsigned ct[2])
{
	if(ct[1]) {
		wprintf("%6u%04u", ct[1], *ct);
		return; }
	wprintf("%10u", *ct);
}

unsigned char *help[] = {
"\x1B\x18\x19\x1A=Select entry",
"Home/End=Adjust primary value",
"PgUp/PgDn=Adjust secondary value",
"<space>=Toggle \xF1 \x1D +",
"<=Copy >>> parms to <<<",
">=Copy <<< parms to >>>",
"R=Reset statistics",
"Q=Quit bridge",
0 };

show_help()
{
	unsigned i, x;
	unsigned char *p;
	x = 1;
	for(i=0; p = help[i]; ++i) {
		if(i == 8) x = 41;
		wgotoxy(x, (i&7)+16);
		while(*p != '=')
			wputc(*p++);
		wgotoxy(x+10, (i&7)+16);
		wputs(p); }
}

unsigned get_parm()
{
	unsigned v;
	unsigned char f;
	f = v = 0;
	while(isdigit(*pptr)) {
		v = (v * 10) + (*pptr++ - '0');
		f = 255; }
	if(!f) {
		printf("Value expected: %s\n", pptr);
		exit(-1); }
	return v;
}
testfor(unsigned char c)
{
	if(*pptr == c) {
		++pptr;
		return -1; }
	return 0;
}

unsigned get_pair(unsigned *p)
{
	unsigned v;
	*p = get_parm();
	if(testfor('+')) {
		p[1] = get_parm();
		return; }
	if(testfor('-')) {
		p[1] = (v = get_parm()) * 2;
		*p -= v; }
}
static char chelp[] = { "\n\
Use:	BRIDGE	[options]\n\n\
Opts:	E1=rate,npkts,maxtime	= Set <<< error injection\n\
	D1=delay,packets	= Set <<< delay function\n\
	E2=rate,npkts,maxtime	= Set >>> error injection\n\
	D2=delay,packets	= Set >>> error function\n\
	I1=n (decimal)		= Set <<< packet driver interrupt\n\
	I2=n (decimal)		= Set >>> packet driver interrupt\n\
\n?COPY.TXT 2003-2005 Dave Dunfield -  -- see COPY.TXT --.\n" };

/*
 * Main demonstration program
 */
main(int argc, char *argv[])
{
	unsigned h1, h2;
	unsigned x, c, t;
	unsigned char ea1[PKT_EASIZE], ea2[PKT_EASIZE];
	struct PD_queue *p;
	struct PD_packet *pp;
	static unsigned char *options[] = {
		"E1=",	// 0
		"E2=",	// 1
		"D1=",	// 2
		"D2=",	// 3
		"I1=",	// 4
		"I2=",	// 5
		0 };

	RAND_SEED = peekw(0x40, 0x6C);
	for(x=1; x < argc; ++x) {
		strupr(pptr = argv[x]);
		for(c=0; p = options[c]; ++c) {
			if(strbeg(pptr, p)) {
				pptr += strlen(p);
				break; } }
		switch(c) {
		case 0 :	// E1=
			get_pair(&e1_rate);
			if(testfor(','))
				get_pair(&e1_npkt);
			if(testfor(','))
				e1_skip = (get_parm() + 27) / 55;
			break;			
		case 1 :	// E2=
			get_pair(&e2_rate);
			if(testfor(','))
				get_pair(&e2_npkt);
			if(testfor(','))
				e2_skip = (get_parm() + 27) / 55;
			break;
		case 2 :	// D1=
			e1_dtim = (get_parm() + 27) / 55;
			if(testfor(','))
				e1_dpkt = get_parm();
			break;
		case 3 :	// D2=
			e2_dtim = (get_parm() + 27) / 55;
			if(testfor(','))
				e2_dpkt = get_parm();
			break;
		case 4 :	// I1=
			pkt1_set_interrupt(pkt1_int = get_parm());
			break;
		case 5 :	// I2=
			pkt2_set_interrupt(pkt2_int = get_parm()); }
		if(*pptr) {
			printf("Invalid option: %s\n", argv[x]);
			fputs(chelp, stdout);
			exit(-1); } }


	if(!(pkt1_seg = alloc_seg(8192)))
		abort("Not enough memory\n");
	pkt2_seg = pkt1_seg + 4096;

	/* Check that packet drivers are present */
	if(!(h1 = install_driver1(pkt1_int, ea1)))
		exit(-1);
	if(!(h2 = install_driver2(pkt2_int, ea2))) {
		pkt1_release_type(h1);
		exit(-1); }
	wopen(0, 0, 80, 25, WSAVE|WCOPEN|0x17);
	wcursor_off(); show_address(ea1);
	wgotoxy(80-17, 0); show_address(ea2);
	wgotoxy(31, 0); wputs("ETHERNET BRIDGE");

	wgotoxy(0, 2); wprintf("%s Pkts:%20sDropped:%20sBuffered:", ">>>", "", "");
	wgotoxy(0, 3); wprintf("%s Pkts:%20sDropped:%20sBuffered:", "<<<", "", "");
	for(x=0; x < NCONFIG; ++x) {
		p = CFG[x];
		wgotoxy(p->X, p->Y);
		wputs(p->Name);
		p->Z = W_OPEN->WINcurx;
		if(!x) *W_OPEN = 0x71;
		show_value(p);
		*W_OPEN = 0x17; }
	show_help();
	H_ptr = h_rate;
	H_len = 80;

// to_count[1] = to_errors[1] = from_count[1] = from_errors[1] = 10000;
	next1 = get_value(&e1_rate);
	next2 = get_value(&e2_rate);
	for(;;) {
		t = peekw(0x40, 0x6C);
		do {
			if(C1 = pkt1_head - pkt1_tail) {
// wgotoxy(0, 20); wprintf("%5u %5u %5u %5u %5u", C1, e1_dpkt, t, t1_last, e1_dtim);
				if((C1 > e1_dpkt) || ((t-t1_last) >= e1_dtim)) {
					p = pkt1_queue[pkt1_tail];
					t1_last = t;
					if(skip1) {
						if((t - t1_skip) >= e1_skip) {
							skip1 = 0;
							goto do_tx1; }
						--skip1;
						increment(to_errors); }
					else {
			do_tx1:		if(next1) {
							if(!--next1) {
								t1_skip = t;
								skip1 = get_value(&e1_npkt);
								next1 = get_value(&e1_rate); } }
						pkt2_send(pkt1_seg, pkt1_tail << 8, p->length); }
					++pkt1_tail;
					increment(to_count); } }
			if(C2 = pkt2_head - pkt2_tail) {
// wgotoxy(0, 21); wprintf("%5u %5u %5u %5u %5u", C2, e2_dpkt, t, t2_last, e2_dtim);
				if((C2 > e2_dpkt) || ((t-t2_last) >= e2_dtim)) {
					p = pkt2_queue[pkt2_tail];
					t2_last = t;
					if(skip2) {
						if((t - t2_skip) >= e2_skip) {
							skip2 = 0;
							goto do_tx2; }
						--skip2;
						increment(from_errors); }
					else {
			do_tx2:		if(next2) {
							if(!--next2) {
								t2_skip = t;
								skip2 = get_value(&e2_npkt);
								next2 = get_value(&e2_rate); } }
						pkt1_send(pkt2_seg, pkt2_tail << 8, p->length); }
					++pkt2_tail;
					increment(from_count); } }
			switch(++x) {
			case 10000 :
				wgotoxy(9, 2); show_count(to_count);
				continue;
			case 15000 :
				wgotoxy(37, 2); show_count(to_errors);
				continue;
			case 20000 :
				wgotoxy(9, 3); show_count(from_count);
				continue;
			case 25000 :
				wgotoxy(37, 3); show_count(from_errors);
				continue;
			case 30000 :
				wgotoxy(68, 2); wprintf("%3u", C1);
				continue;
			case 35000 :
				wgotoxy(68, 3); wprintf("%3u", C2);
				continue; } }
		while(x & 0xFFF);
		if(!(c = wtstc())) {
			if(H_len) {
				wgotoxy(80-H_len, 5);
				wputc(*H_ptr ? *H_ptr++ : ' ');
				--H_len; }
			continue; }
		x = Cfg;
		switch(toupper(c)) {
			case _KRA :
				Cfg = CFG[Cfg].N;
				goto do_config;
			case _KDA :
				if(++Cfg >= NCONFIG)
					Cfg = 0;
				goto do_config;
			case _KLA :
				Cfg = CFG[Cfg].P;
				goto do_config;
			case _KUA :
				Cfg = (Cfg ? Cfg : NCONFIG) - 1;
			do_config:
				p = CFG[x];
				wgotoxy(p->Z, p->Y);
				show_value(p);
				p = CFG[Cfg];
				H_ptr = p->Help;
				H_len = 80;
			update_config:
				wgotoxy(p->Z, p->Y);
				*W_OPEN = 0x71;
				show_value(p);
				*W_OPEN = 0x17;
				continue;
			case _KHO :	p=CFG[Cfg]; ++p->Address[0];	goto update_config;
			case _KEN : p=CFG[Cfg]; --p->Address[0];	goto update_config;
			case _KPU :	p = CFG[Cfg];
				if(p->F & 1) {
					if(mode & 1) {
						++p->Address[1];
						goto update_config; }
					p->Address[1] = (p->Address[1] & ~1) + 2;
					if(p->Address[0])
						--p->Address[0]; }
				goto update_config;
			case _KPD : p = CFG[Cfg];
				if(p->F & 1) {
					if(mode & 1) {
						if(p->Address[1])
							--p->Address[1];
						goto update_config; }
					if((p->Address[1] &= ~1) > 2) {
						p->Address[1] -= 2;
						++p->Address[0]; } }
				goto update_config;
			case ' ' : mode ^= 1;
	update_all:	p = CFG[Cfg];
				for(x=0; x < NCONFIG; ++x) {
					if(x == Cfg) continue;
					pp = CFG[x];
					wgotoxy(pp->Z, pp->Y);
					show_value(pp); }
				goto update_config;
			case '<' : CFG12; goto update_all;
			case '>' : CFG21; goto update_all;
			case 'r' :
			case 'R' :
				from_count[1] = from_count[0] =
				from_errors[1] = from_errors[0] = 
				to_count[1] = to_count[0] =
				to_errors[1] = to_errors[0] = 0;
				continue;
			case 'q' :
			case 'Q' : goto quit; } }

quit:
	wclose();
	pkt1_release_type(h1);
	pkt2_release_type(h2);
}
