/* AVRLOAD changes for Mega163      */
/* by Ron Groth rg57@yahoo.com      */
/* all my comments begin with rg57  */



		case 0x9303: a=8192; b=512;                     ptr="90S8535";  goto shosiz; /* rg57 90S not 80S just to be picky ;) */
		case 0x9402: a=16384; b=512;     Npage=0;       ptr="Mega163";  goto shosiz; /* rg57 */





		/* rg57 Page mode FLASH write */
			else {
				memset(buffer, -1, sizeof(buffer)); /* rg57 set buffer to FFs */
				i = 0;
				while(i < fsize) {
					if(!test_buffer(k = i)) {
						if(i += 128) /* rg57 256 for Mega103 */
							continue;
						break; }

					/* rg57 write a page of data to FLASH                   */
					/* d = data to write                                    */
					/* wa = write address                                   */
					/*            Byte 1     Byte 2     Byte 3     Byte 4   */
					/*           ---------  ---------  ---------  --------- */
					/* Mega103 = 0100 H000  xxxx xxxx  xbbb bbbb  iiii iiii */
					/* Mega163 = 0100 H000  xxxx xxxx  xxbb bbbb  iiii iiii */
					for(j=0; j < 128; ++j) { /* rg57 256 for Mega103 */
						d = peek(image, i);
						wa = (i >> 1) | hmask;
						write_spi((i & 1) ? 0x48 : 0x40);
						write_spi(wa >> 8);
						write_spi(wa & 0x3F); /* rg57 7F for Mega103 */
						write_spi(d);
						++i; }
				       
					/* rg57 write the FLASH page                            */
					/* Mega103: 512 pages x 128 words/page = 128kbytes      */
					/* Mega163: 128 pages x  64 words/page =  16kbytes      */
					/*                                                      */
					/*            Byte 1     Byte 2     Byte 3     Byte 4   */
					/*           ---------  ---------  ---------  --------- */
					/* Mega103 = 0100 1100  aaaa aaaa  bxxx xxxx  xxxx xxxx */
					/* Mega163 = 0100 1100  xxxa aaaa  bbxx xxxx  xxxx xxxx */
					wa = (k >> 1) | hmask;
					write_spi(0x4C);
					write_spi(wa >> 8);
					write_spi(wa);
					write_spi(0);
					m_delay(xpgmdel || 50000); /* rg57 wait for write to finish */
					
					/* rg57 read back the page and verify */
					for(j=0; j < 64; ++j) { /* rg57 128 for Mega103 */
						d = peek(image, k);
						wa = (k >> 1) | hmask;
						write_spi((k & 1) ? 0x28 : 0x20);
						write_spi(wa >> 8);
						write_spi(wa);
						e = read_spi();
						if(d != e)
							error("Verify error at: %04x, Expected: %02x, Found: %02x", k, d, e);
						++k; }
					if(!i) break; } }
