#include <stdio.h>
#include <window.h>

#define	CLEAR	"\xFA\x20"
#define	SOLID	"\xDB\xDB"
#define	CURSOR1	"\xB0\xB0"
#define CURSOR2 "\xB2\xB2"

#define	RCOL	52
#define	RROW	14

unsigned char
	Spc = ' ',
	Hbar = '-',
	Vbar = 179,
	Ptup = 30,
	Ptdn = 31,
	Cur = '>',
	font[4096],		/* Working font */
	font1[4096],	/* ROM bios font */
	font2[4097],	/* Original font from file */
	filename[65],
	*msg = 0;

unsigned
	Fseg,
	Foff,
	Fpoints;

struct WINDOW
	*mwin;

char *help[] = {
	"Functions:",
	"----------",
	"\x1B\x18\x19\x1A = Move cursor",
	"Space= Toggle ON/OFF pixel",
	"F1   = Display character map",
	"F2   = Clear character",
	"F3   = Reload char from file",
	"F4   = Reload char from BIOS",
	"F5   = Goto character",
	"F6   = Copy character",
	"F7   = Merge character",
	"F8   = Fill range of chars",
	"F9   = Invert character",
	"F10  = Set special char",
	"INS  = Shift line right",
	"DEL  = Shift line left",
	"ESC  = Exit",
	-1,
	"PgUp = Previous char",
	"PgDn = Next char",
	"Home = Start of line",
	"End  = End of line",
	"^PgUp= Top line",
	"^PgDn= Bottom line",
	0 };

char *wmenu1[] = {
	"SPACE/Blank",
	"Horizontal bar (divides data rows)",
	"Vertical bar  (for event pointers)",
	"Point up      (for event pointers)",
	"Point down    (for event pointers)",
	"Cursor     (Data capture position)",
	0 };

char *wmenu2[] = {
	"Continue editing",
	"Exit and save file",
	"Exit without saving",
	0 };

char command_help[] = { "\n\
Use: DLMFE <font_file>\n\n\
?COPY.TXT 2000-2005 Dave Dunfield\n\
 -- see COPY.TXT --.\n" };

/*
 * Enable the custom font
 */
font_on() asm
{
		PUSH	ES			; Save ES
		MOV		AX,1130h	; Get font information
		MOV		BH,0		; Current font
		INT		10h			; Ask BIOS
		PUSH	DS			; Get DS
		POP		ES			; ES = DS
		XOR		DX,DX		; Start with character 0
		CMP		CX,16		; Is current font > 16 points?
		JA		fo1			; Yes, special case
; Font is 16 points or less, just use one we have
		MOV		AX,1100h	; Set font
		MOV		BX,1000h	; 16 point font
		MOV		CX,0100h	; 256 charcters
		MOV		BP,OFFSET DGRP:_font ; Use font table "as is"
		INT		10h			; Ask BIOS
		JMP SHORT fo3		; And exit
; Font is greater than 16 points
; We must translate our 16 point font to match (zero pad)
fo1:	MOV		BH,CL		; BH = points
		XOR		BL,BL		; * 256
		SUB		SP,BX		; Allocate space for new font
		MOV		DI,SP		; Dest is new buffer
		MOV		SI,OFFSET DGRP:_font ; Source is our font
; Copy in our font data
fo2:	MOV		CX,16		; Copy 16 bytes
	REP	MOVSB				; Copy the character
		MOV		CL,BH		; Get point size
		SUB		CL,16		; Calculate # bytes remaining
		XOR		AX,AX		; Get zero
	REP STOSB				; Clear the end
		CMP		SI,OFFSET DGRP:_font+4096
		JB		fo2			; Do all data
		MOV		AX,1100h	; Set font
		MOV		CX,0100h	; 256 characters
		MOV		BP,SP		; Use new font table
		INT		10h			; Ask BIOS
		MOV		SP,DI		; Fix SP
fo3:	POP		ES			; Restore ES
}

/*
 * Disable the custom font
 */
font_off()
{
	asm {
		MOV		AX,1104h
		MOV		BL,00h
		INT		10h
	}
}

/*
 * Get the font table
 */
get_font(font) asm
{
		MOV		AX,1130h	; Ask for FONT information
		MOV		BH,4[BP]	; Get font ID
		INT		10h			; Ask BIOS
		MOV		DGRP:_Fseg,ES
		MOV		DGRP:_Foff,BP
		MOV		DGRP:_Fpoints,CX
}

/*
 * Prompt for and get character in ASCII
 */
get_char(char *prompt)
{
	unsigned c, c1, c2, c3;

	w_gotoxy(1, 22, mwin);
	w_puts(prompt, mwin);
	w_puts(" - 1 char or 2 hex digits/press ENTER (F1=Abort)?", mwin);
	w_cleol(mwin);
loop1:
	c = wgetc();
	if(c == _K1) {
	do_exit:
		msg = "Canceled";
		return -1; }
	if(c & 0xFF00) {
		wputc(7);
		goto loop1; }
	w_putc(c | 0x100, mwin);

loop2:
	switch(c1 = wgetc()) {
	case '\n' : msg=""; return c;
	case _K1  : goto do_exit;
	case _KBS : w_puts("\b \b", mwin); goto loop1; }

	c2 = toupper(c) - '0';
	if(c2 > 9) {
		c2 -= 7;
		if((c2 < 10) || (c2 > 15)) {
			wputc(7);
			goto loop2; } }

	c3 = toupper(c1) - '0';
	if(c3 > 9) {
		c3 -= 7;
		if((c3 < 10) || (c3 > 15)) {
			wputc(7);
			goto loop2; } }
	w_putc(c1, mwin);

loop3:
	switch(wgetc()) {
	case '\n' :
		msg = "";
		return (c2 << 4) | c3;
	case _K1  : goto do_exit;
	case _KBS : w_puts("\b \b", mwin); goto loop2; }

	wputc(7);
	goto loop3; 
}

main(int argc, char *argv[])
{
	unsigned i, j, k, l;
	unsigned char c;
	static unsigned x=0, y=0, cell=0, sc=0;
	static char changed = 0;
	FILE *fp;

	if(argc != 2) 
		abort(command_help);

	for(i=j=0; filename[i] = c = toupper(argv[1][i]); ++i) {
		if(c == '.')
			j = -1; }
	if(!j)
		strcpy(filename+i, ".DLF");

	get_font(0x06);

	for(i=0; i < 256; ++i) {
		j = i * 16;
		k = (i * 16) + Foff;
		for(l=0; l < Fpoints; ++l) {
			if(l >= 16)
				break;
			font1[j++] = peek(Fseg, k++); }
		while(l < 16) {
			font1[j++] = 0;
			++l; } }

	if(fp = fopen(filename, "rvb")) {
		if((getc(fp) != 'D') || (getc(fp) != 'L') || (getc(fp) != 'M'))
			goto badfont;
		Spc = getc(fp);
		Hbar = getc(fp);
		Vbar = getc(fp);
		Ptup = getc(fp);
		Ptdn = getc(fp);
		Cur = getc(fp);
		if(fget(font2, sizeof(font2), fp) != 4096) {
	badfont:
			abort("Invalid font file!"); }
		fclose(fp);
		memcpy(font, font2, sizeof(font)); }
	else {
		memcpy(font, font1, sizeof(font));
		msg = "Cannot read file - Working from BIOS font";
		changed = -1; }

	mwin = wopen(0, 0, 80, 25, WSAVE|WCOPEN|WBOX2|NORMAL);
	wputs("DLM FONT EDITOR 1.0 - ?COPY.TXT 2000-2005 Dave Dunfield -  -- see COPY.TXT --.");
	k = 1, l = 3;
	for(i=0; j = help[i]; ++i) {
		if(j == -1) {
			k = RCOL;
			l = 3;
			continue; }
		wgotoxy(k, ++l);
		wputs(j); }

	wgotoxy(1, 2); wprintf("File: %s", filename);
	wgotoxy(RCOL, RROW-2); wputs("Special Characters:");
	wgotoxy(RCOL, RROW-1); wputs("-------------------");

	wopen(32, 4, 18, 18, WSAVE|WCOPEN|WBOX1|NORMAL);
	wcursor_off();

reshow:
	w_gotoxy(RCOL, RROW+0, mwin);
	w_printf(mwin, "Space : %02x = ", Spc);
	w_putc((unsigned)Spc | 0x100, mwin);
	w_gotoxy(RCOL, RROW+1, mwin);
	w_printf(mwin, "Hbar  : %02x = ", Hbar);
	w_putc((unsigned)Hbar | 0x100, mwin);
	w_gotoxy(RCOL, RROW+2, mwin);
	w_printf(mwin, "Vbar  : %02x = ", Vbar);
	w_putc((unsigned)Vbar | 0x100, mwin);
	w_gotoxy(RCOL, RROW+3, mwin);
	w_printf(mwin, "Ptup  : %02x = ", Ptup);
	w_putc((unsigned)Ptup | 0x100, mwin);
	w_gotoxy(RCOL, RROW+4, mwin);
	w_printf(mwin, "Ptdn  : %02x = ", Ptdn);
	w_putc((unsigned)Ptdn | 0x100, mwin);
	w_gotoxy(RCOL, RROW+5, mwin);
	w_printf(mwin, "Cursor: %02x = ", Cur);
	w_putc((unsigned)Cur | 0x100, mwin);

redraw:
	w_gotoxy(34, 21, mwin);
	w_printf(mwin, "Code: %02x = ", j = cell / 16);
	w_putc(j | 0x100, mwin);

	for(i=0; i < 16; ++i) {
		wgotoxy(0, i);
		c = font[cell+i];
		for(j=0; j < 8; ++j) {
			if((i == y) && (j == x))
				wputs(c & 0x80 ? CURSOR2 : CURSOR1);
			else
				wputs(c & 0x80 ? SOLID : CLEAR);
			c <<= 1; } }
reprompt:
	if(msg) {
		w_gotoxy(1, 22, mwin);
		w_puts(msg, mwin);
		w_cleol(mwin); }
	i = wgetc();
	if(msg) {
		w_gotoxy(1, 22, mwin);
		w_cleol(mwin);
		msg = 0; }
	switch(i) {
		default: goto reprompt;
		case _KUA : y = (y - 1) & 15;	goto redraw;
		case _KDA : y = (y + 1) & 15;	goto redraw;
		case _KRA : x = (x + 1) & 7;	goto redraw;
		case _KLA : x = (x - 1) & 7;	goto redraw;
		case _CLA :
		case _KHO : x = 0;				goto redraw;
		case _CRA :
		case _KEN : x = 7;				goto redraw;
		case _CHO :
		case _CPU : y = 0;				goto redraw;
		case _CEN :
		case _CPD : y = 15;				goto redraw;
		case _KPD :
			cell += 16;
			if(cell > (255*16))
				cell = 0;
			goto redraw;
		case _KPU :
			cell -= 16;
			if(cell > (255*16))
				cell = 255*16;
			goto redraw;
		case ' ' :
			font[cell+y] ^= (0x80 >> x);
			changed = -1;
			goto redraw;
		case _K1 :
			j = (cell/16) | 0x100;
			wopen(0, 2, 80, 22, WSAVE|WCOPEN|NORMAL);
			font_on();
			*W_OPEN = REVERSE;
			wgotoxy(28, 20);
			wputs(" Press ESCAPE to exit ");
			*W_OPEN = NORMAL;
			wgotoxy(0, 1);
			for(i=0; i < 80; ++i)
				wputc(j);
			for(i=0; i < 256; ++i) {
				wgotoxy((i / 16) * 5, (i % 16)+3);
				wprintf("%02x=", i);
				wputc(i | 0x100); }
			while(wgetc() != 0x1B);
			wclose();
			font_off();
			goto reprompt;
		case _K2 :
			memset(font+cell, 0, 16);
			goto redraw;
		case _K3 :
			memcpy(font+cell, font2+cell, 16);
			goto redraw;
		case _K4 :
			memcpy(font+cell, font1+cell, 16);
			changed = -1;
			goto redraw;
		case _K5 :
			if((i = get_char("Goto character")) != -1)
				cell = i * 16;
			goto redraw;
		case _K6 :
			if((i = get_char("Copy character")) != -1)
				memcpy(font+cell, font+(i*16), 16);
			goto redraw;
		case _K7 :
			if((i = get_char("Merge character")) != -1) {
				i *= 16;
				for(j=0; j < 16; ++j)
					font[cell+j] |= font[i+j]; }
			goto redraw;
		case _K8 :
			if((i = get_char("Fill start")) == -1)
				goto reprompt;
			if((j = get_char("Fill end")) == -1)
				goto reprompt;
			if(j < i) {
				msg = "End must be >= start";
				goto reprompt; }
			while(i <= j)
				memcpy((i++ * 16)+font, font+cell, 16);
			goto redraw;
		case _K9 :
			for(i=0; i < 16; ++i)
				font[cell+i] ^= 0xFF;
			goto redraw;
		case _K10 :
			if(!wmenu(22, 9, WSAVE|WCOPEN|WBOX2|REVERSE, wmenu1, &sc)) {
				c = cell / 16;
				switch(sc) {
					case 0 : Spc = c;	break;
					case 1 : Hbar = c;	break;
					case 2 : Vbar = c;	break;
					case 3 : Ptup = c;	break;
					case 4 : Ptdn = c;	break;
					case 5 : Cur = c; } }
			goto reshow;
		case _KIN :
			font[cell+y] >>= 1;
			goto reshow;
		case _KDL :
			font[cell+y] <<= 1;
			goto reshow;
		case 0x1B: }

	i = 0;
	if(wmenu(30, 9, WSAVE|WCOPEN|WBOX2|REVERSE, wmenu2, &i))
		goto reprompt;
	switch(i) {
	case 0 : goto reprompt;
	case 1 :
		wclose();
		wclose();
		fp = fopen(filename, "wvqb");
		fputs("DLM", fp);
		putc(Spc, fp);
		putc(Hbar, fp);
		putc(Vbar, fp);
		putc(Ptup, fp);
		putc(Ptdn, fp);
		putc(Cur, fp);
		fput(font, sizeof(font), fp);
		fclose(fp);
		return; }

	wclose();
	wclose();
}
