#include <stdio.h>
#include <window.h>

#define	PMAX		1512		// Maximum packet size
#define	PBUF		1514		// Packet capture buffer size (PMAX+2)

unsigned
	Pseg,						// Packet RX segment (64k)
	PTread,						// Packet buffer read pointer
	PTwrite,					// Packet buffer write pointer
	PTaddr,						// Temp storage
	Pmode = 3;					// Packet receive mode
unsigned char
	Pint,						// Packet interrupt
	Pmac[6];					// Our MAC address

struct PACKET {					// Ethernet packet layout
	unsigned char 	To[6];		// To MAC address
	unsigned char	From[6];	// From MAC address
	unsigned		Type;		// Packet type
	unsigned char	Data[1520];	// Data block
	};

/*
 * Terminate packet interface
 */
void packet_close(void) asm
{
		MOV		BX,4[BP]				// Get handle
		MOV		AH,03h					// "release type" request
		CALL	doint					// Perform function
noclo:
}
asm {
doint:	INT		60h
		RET
; Called when packet ready
;	AX = flag: 0=Allocate  1=Transfer
;	BX = handle
;	CX = length
; Exit: ES:DI = buffer to RX packet (0:0 = none)
pktrdy:	PUSH	DS						// Save DS
		PUSH	CS						// Get our segment
		POP		DS						// DS = ours
		PUSH	AX						// Save AX
		AND		AX,AX					// Is this allocate?
		JNZ		pktr2					// No - try transfer
		CMP		CX,PMAX					// Within size?
		JA		pktr1					// No, toss
; Return ES:DI = address of receiving buffer
		MOV		ES,DGRP:_Pseg			// ES = destination segment
		MOV		DI,DGRP:_PTwrite		// Get write pointer
		MOV		ES:[DI],CX				// Save size
		ADD		DI,2					// Advance to data
		MOV		DGRP:_PTaddr,DI			// Save location
		POP		AX						// Restore AX
		POP		DS						// Restore DS
		DB		0CBh					// RETF
; Reject packet
pktr1:	XOR		DI,DI					// DI = 0
		MOV		ES,DI					// ES = 0
		POP		AX
		POP		DS						// Restore DS
		DB		0CBh					// RETF
; Packet has been transferred
pktr2:	PUSH	BX						// Save DI
		MOV		BX,DGRP:_PTaddr			// Get address
		PUSH	ES
		MOV		ES,DGRP:_Pseg			// Get segment
		MOV		AX,ES:12[BX]			// Get packet type
		POP		ES
; Packet is right type, and for us - accept it
pktr4:	MOV		AX,DGRP:_PTwrite		// Get write pointer
		ADD		AX,PBUF					// Adjust by buffer
		CMP		AX,-PBUF				// Out of space
		JBE		pktr5					// No overflow
		XOR		AX,AX					// Reset to zero
pktr5:	MOV		DGRP:_PTwrite,AX		// Resave
pktrx1:	POP		BX						// Restore BX
		POP		AX						// Restore AX
		POP		DS						// Restore DS
		DB		0CBh					// Far return
}

/*
 * Check for received packet
 * returns length of packet received
 */
int packet_receive(dest) asm
{
		MOV		AX,DGRP:_PTread			// Get read pointer
		MOV		SI,AX					// Save for later
		SUB		AX,DGRP:_PTwrite		// Any different?
		JZ		isp1					// No packet ready
		MOV		AX,SI					// Get back
		ADD		AX,PBUF					// Advance to next
		CMP		AX,-PBUF				// Out of space?
		JBE		pkrx1					// No
		XOR		AX,AX					// Reset to zero
pkrx1:	MOV		DGRP:_PTread,AX			// Resave read pointer
		MOV		DX,DS					// DX = our segment
		MOV		DI,4[BP]				// Get destination
		MOV		DS,DGRP:_Pseg			// Address segment
		MOV		AX,[SI]					// Get length
		MOV		CX,AX					// Set for copy
		ADD		SI,2					// Offset to data
		MOV		ES,DX					// Set destination
	rep	MOVSB							// Copy it
		MOV		DS,DX					// Restore DS
isp1:
}

/*
 * Send a packet
 *
 * Arguments:
 *	buffer		= Pointer to buffer to send
 *	length		= Length of buffer to send
 *
 * Returns:
 *	0			= Success
 *	!0			= Packet driver error code
 */
int packet_send(buffer, length) asm
{
		MOV		SI,6[BP]			; Get buffer address
		MOV		CX,4[BP]			; Get length
		MOV		AH,04h				; Indicate "send packet" request
		CALL	doint				; Ask for it
		JC		ps1					; Report error
		XOR		AX,AX				; Indicate success
ps1:
}

/*
 * Open packet interface
 *	0	= Failure
 *	!0	= Packet handle
 */
unsigned char PKT_SIG[] = { "PKT DRVR" };	// Signature
int packet_open() asm
{
		XOR		BH,BH				// Zero high
		MOV		BL,DGRP:_Pint		// BX = interrupt
		MOV		CL,2				// mul-div by 4
		SHL		BX,CL				// nultiply by 4 for int vec
		JNZ		po1					// Interrupt was specified
; Locate pack driver
		MOV		BX,0180h			// 0x60 * 4
; Retrieve interrupt vector
po1:	XOR		AX,AX				// Get zero
		MOV		ES,AX				// Set ES
		MOV		SI,ES:[BX]			// Get offset
		OR		AX,ES:2[BX]			// Get segment
		JZ		po3					// Zero segment - no driver
		MOV		ES,AX				// ES = segment
; Test for "PKT DRVR" signature
		MOV		DI,OFFSET DGRP:_PKT_SIG // Signature
po2:	MOV		AL,[DI]				// Get from sig
		AND		AL,AL				// End of string
		JZ		po5					// Found!
		INC		DI					// Next
		INC		SI					// Next in driver
		CMP		AL,ES:2[SI]			// Match?
		JZ		po2					// Yes, keep looking
; Test failed - look for next
po3:	MOV		AL,DGRP:_Pint		// Get vector
		AND		AL,AL				// Is it zero?
		JNZ		po4					// No, specified - fail
		ADD		BX,4				// Next interrupt
		CMP		BX,200h				// 0x80 * 4
		JBE		po1					// Keep looking
; No packet driver was found
po4:	JMP short pfail1
; We found packet driver
po5:	SHR		BX,CL				// divide by 4 for int vec
		MOV		byte ptr doint+1,BL	// Patch interrupt
; Get packet driver information
		MOV		AX,01FFh			// Request info
		CALL	doint				// Perform interrupt
		JC		pfail1				// Report failed
		PUSH	CS
		POP		DS
		MOV		AL,CH				// AL = class
		MOV		BX,DX				// BX = itype
		MOV		DL,CL				// DL = number
; Obtain access to packet type
;		MOV		SI,offset DGRP:_Ptype	// Type pointer
		MOV		SI,BP				// Point to stack
		ADD		SI,4				// Offset to arg
		MOV		CX,[SI]				// Get type
		AND		CX,CX				// Zero=All
		JZ		po6					// Yes
		MOV		CX,2				// Size of type
po6:	MOV		DI,offset pktrdy	// Point to handler
		PUSH	CS					// Get our segment
		POP		ES					// ES = handler segment
		MOV		AH,02h				// "Access type" requiest
		CALL	doint				// Perform the interrupt
		JC		pfail1				// Report failed
; Get our ethernet address
		MOV		BX,AX				// BX = handle
		PUSH	BX					// Save handle
		MOV		DI,offset DGRP:_Pmac	// Mac address
		MOV		CX,6				// 6 bytes
		PUSH	DS					// Save our segment
		POP		ES					// set ES
		MOV		AH,06h				// "get address" request
		CALL	doint				// Perform interrupt
		POP		BX					// BX = handle
		JC		pfail				// Failed
		PUSH	BX					// Save handle
; Set receive access mode (CX)
;	1 - Monitor NO packets (receiver off)
;	2 - Monitor normal packets to our ethernet address only
;	3 - Our packets + broadcast packets
;	4 - Our packets + broadcast + limited multicast packets
;	5 - Our packets + broadcast + all multicast packets
;	6 - All packets
		MOV		CX,DGRP:_Pmode		// Receive mode
		MOV		AH,20				// "set mode" request
		CALL	doint				// Perform request
		POP		AX					// AX = handle
		JC		pfail				// And report fail
		POP		BP					// Restore BP
		RET
pfail:	CALL	_packet_close		// Stop driver
pfail1:	XOR		AX,AX				// Failed
; MOV		AX,2				// Packet driver failed
}

// ----------
#if 0
#define	mprintf		printf
#define	mputc(x)	putc(x, stdout)
#define	mputs(x)	fputs(x, stdout)
/*
 * Dump a buffer of memory with the specified address & size
 */
void dump(unsigned char *buffer, unsigned size)
{
	unsigned i, j, c;

	for(i=0; i < size; i += 16) {
		mprintf("\n%04x ", i);
		for(j=0; j < 16; ++j) {						/* Display HEX */
			if(!(j & 0x03))
				mputc(' ');
			if((i+j) < size) {
				mprintf("%02x ", buffer[j]); }
			else
				mputs("   "); }
		mputc(' ');
		for(j=0; (j < 16) && ((i+j) < size); ++j) {	/* Display ASCII */
			c = *buffer++;
			mputc(((c >= ' ') && (c < 0x7f)) ? c : '.'); } }
}
#endif

#define	TICK	peekw(0x40,0x6C)

unsigned
	PTcount,	// Count of packets/tick
	PTfrac,		// Fractional packets/tick
	PTmask,		// TX mask
	PTslot;		// Current slot

static unsigned Masks[] = {	// Slot mask table
	0x0000,		// 1	0000000000000000
	0x0100,		// 2	0000000100000000
	0x0820,		// 3	0000100000100000
	0x2108,		// 4	0010000100001000
	0x2488,		// 5	0010010010001000
	0x4924,		// 6	0100100100100100
	0xA492,		// 7	1010010010010010
	0xAA92,		// 8	1010101010010010
	0xAAAA,		// 9	1010101010101010
	0xB6AA,		// 10	1011011010101010
	0xB6DA,		// 11	1011011011011010
	0xDB6D,		// 12	1101101101101101
	0xEEDB,		// 13	1110111011011011
	0xEF7B,		// 14	1110111101111011
	0xFBEF,		// 15	1111101111101111
	0xFF7F,		// 16	1111111101111111	
	0xFFFF };	// 17	1111111111111111

unsigned
	Prate = 18,			// Packet rate
	Plength,			// TX packet length
	Ttype = 0x5555,		// TX packet type
	Npacket,			// # packets to send
	Handle,				// Packet handle
	Tick,				// Current tick
	Rlength,			// RX packet length
	Crx,				// Receive packets
	Ccount,				// Count of packets received
	Cmiss,				// Count of missed packets
	Clate,				// Count of late packets
	Zmiss,				// Remote missed
	Zlate,				// Remote late
	ZMlast = 255,
	ZLlast = 255,
	Sh,Sm,Ss,			// Start time
	Eh,Em,Es;			// End time
unsigned char
	*Ptr,				// General pointer
	Fmiss = 255,		// Missed has changed
	Flate = 255,		// Late has changed
	Mflag;				// Mac set flag
struct WINDOW
	*mwin;
struct PKT {
	unsigned char	Pto[6];
	unsigned char	Pfrom[6];
	unsigned		Ptype;
	unsigned		Pcount;
	unsigned		Pmiss;
	unsigned		Plate;
	unsigned char	Pflag;
	unsigned char	Pdata[1536];
} TX, RX;

#define	Ymac	1
#define	Xmac	5		//Mac:-
#define	Dmac	Xmac+10
#define	Rmac	Xmac+40

#define	Ycount	3
#define	Xcount	5		//RX:-
#define	Dcount	Xcount+10
#define	Rcount	Xcount+40

#define	Ymiss	5
#define	Xmiss	5		//Missed:-
#define	Dmiss	Xmiss+10
#define	Rmiss	Xmiss+40

#define	Ylate	7
#define	Xlate	5
#define	Dlate	Xlate+10
#define	Rlate	Xlate+40

register msg(unsigned args)
{
	unsigned char buf[81];
	_format_(nargs() * 2 + &args, buf);
	w_puts(buf, mwin);
}

terminate()
{
	unsigned i;

	get_time(&Eh, &Em, &Es);
	i = TICK;
	do {
		if(Rlength = packet_receive(RX))
			receive_packet(); }
	while((TICK - i) <= 10);

	wclose();
	wclose();
	packet_close(Handle);
	printf("Start %u:%02u:%02u:  End %u:%02u:%02u\n",
		Sh, Sm, Ss, Eh, Em, Es);
	printf("Packet:%5u %-5u\n", TX.Pcount, Crx);
	printf("Missed:%5u %-5u\n", Cmiss, Zmiss);
	printf("Late  :%5u %-5u\n", Clate, Zlate);
	exit(-1);
}

// Transmit a packet
TXpacket()
{
	packet_send(TX, Plength || random(1000)+64);
	++TX.Pcount;
	if(!--Npacket)
		terminate();
}
// Process timer tick
process_tick()
{
	unsigned i;
	static unsigned m;

	if(i = PTcount) do {	// TX main count
		TXpacket(); }
	while(--i);

	switch(--PTslot) {		// TX fractionals
		case 0 :
			PTslot = 18;
			m = PTmask;
			if(PTfrac)
				TXpacket();
		case 1:
			return;
		default:
			if(m & 1)
				TXpacket();
			m >>= 1; }
}

showmac(unsigned char *m)
{
	unsigned i;
	for(i=0; i < 6; ++i) {
		if(i) wputc(':');
		wprintf("%02x", m[i]); }
}

receive_packet()
{
	unsigned i;
	if(!Mflag) {
		memcpy(TX.To, RX.From, 6);
		Mflag = 255;
		wgotoxy(Rmac, Ymac);
		showmac(TX.To); }
	if(i = RX.Pcount - Ccount) {
		if(i & 0x8000) {
msg("\n%04x %x %x", RX.Type, RX.Pcount, Ccount);
			++Clate;
			Flate = 255; }
		else {
			Cmiss += i;
			Fmiss = 255; } }
	Ccount= RX.Pcount + 1;
	Zmiss = RX.Pmiss;
	Zlate = RX.Plate;
	++Crx;
}
unsigned char Help[] = { "Help" };
main(int argc, char *argv[])
{
	unsigned i;
	unsigned char z;

	for(i=1; i < argc; ++i) {
		Ptr = argv[i];
		switch((toupper(*Ptr++) << 8) | toupper(*Ptr++)) {
		case 'L=' : Plength = atoi(Ptr);		continue;
		case 'N=' : Npacket = atoi(Ptr);		continue;
		case 'R=' : Prate = atoi(Ptr);			continue;
		case 'T=' : Ttype = atox(Ptr);			continue;
	} abort(Help); }

	if(!Prate)
		abort(Help);

	// Set control variables
	PTcount = Prate / 18;
	PTfrac = Prate % 18;
	PTmask = PTfrac && Masks[PTfrac-1];
	PTslot = 1;

	// Allocate external segments
	if(!(Pseg = alloc_seg(4096)))
		abort("No memory");

	// Open packet capture for 0x800 (IP) and 0x806 (ARP)
	if(!(Handle = packet_open(Ttype+0x0101)))
		abort("Packet driver failed!");

	memset(TX.Pto, 0xFF, 6);
	memcpy(TX.Pfrom, Pmac, 6);
	TX.Ptype = Ttype;
	TX.Pflag = 0xAA;	// Initial

	mwin = wopen(0, 9, 80, 16, WSAVE|WCOPEN|WSCROLL|WWRAP|0x07);
	wopen(0, 0, 80, 9, WSAVE|WCOPEN|0x17);
	wcursor_off();
	wgotoxy(Xmac, Ymac);		wputs("Mac:");
	wgotoxy(Xcount, Ycount);	wputs("Count:");
	wgotoxy(Xmiss, Ymiss);		wputs("Missed:");
	wgotoxy(Xlate, Ylate);		wputs("Late:");
	wgotoxy(Dmac, Ymac);		showmac(Pmac);
	msg("R=%u L=%u N=%u", Prate, Plength, Npacket);

	for(i=0; i < 10; ++i)
		packet_send(TX, 128);
	TX.Pflag = 0x55;
	Tick = TICK;
	get_time(&Sh, &Sm, &Ss);
	for(;;) {
		if(TICK != Tick) {
			process_tick();
			++Tick; }
		else switch(++z & 15) {
			case 0 :
				if(wtstc() == 0x1B)
					terminate();
				break;
			case 1 :
				if(!(z & 0xF0)) {
					wgotoxy(Dcount, Ycount);
					wprintf("%-5u", TX.Pcount); }
				break;
			case 2 :
				if(!(z & 0xF0)) {
					wgotoxy(Rcount, Ycount);
					wprintf("%-5u", Crx); }
				break;
			case 3 :
				if(Fmiss) {
					wgotoxy(Dmiss, Ymiss);
					wprintf("%-5u", Cmiss);
					Fmiss = 0; }
				break;
			case 4 :
				if(Flate) {
					wgotoxy(Dlate, Ylate);
					wprintf("%-5u", Clate);
					Flate = 0; }
				break;
			case 5 :
				if(Zmiss != ZMlast) {
					wgotoxy(Rmiss, Ymiss);
					wprintf("%-5u", ZMlast = Zmiss); }
				break;
			case 6 :
				if(Zlate != ZLlast) {
					wgotoxy(Rlate, Ylate);
					wprintf("%-5u", ZLlast = Zlate); }
				break;
		}
		if(Rlength = packet_receive(RX))
			receive_packet(); }
}
