#include <stdio.h>

unsigned
	low = -1,
	high= -1,
	size,
	bytes;
FILE
	*fp;
unsigned char
	table[256],
	buffer[32768],
	reverse,
	*db = "DB",
	*fmt = "$%02x",
	*name,
	*comment,
	*ptr;

char help[] = { "\n\
Use:	LCG filename [options] >output_file\n\n\
opts:	-I	= Intel format output\n\
	-R	= Reverse bit pattern\n\
	C=text	= Leading comment		[none]\n\
	D=text	= Define directive		[DB]\n\
	L=xx	= Low  bound character		[First found]\n\
	H=xx	= High bound character		[Last found]\n\
	N=name	= symbolic Name for table	[none]\n\
\n?COPY.TXT 2002-2005 Dave Dunfield\n -- see COPY.TXT --.\n" };

write_character(unsigned char c)
{
	unsigned i;
	unsigned char *cp;
	putc('\t', stdout);
	fputs(db, stdout);
	putc('\t', stdout);
	cp = (c * bytes) + buffer;
	for(i=0; i < bytes; ++i) {
		if(i)
			putc(',', stdout);
		printf(fmt, table[cp[i]]); }
	if(c == ' ')
		printf("\t; <space>\n");
	else if((c < ' ') || (c > 0x7E))
		printf("\t; <%02x>\n", c);
	else
		printf("\t; %c\n", c);
}

tst0(unsigned char c)
{
	unsigned i;
	unsigned char *cp;
	cp = (c * bytes) + buffer;
	for(i=0; i < bytes; ++i) {
		if(cp[i])
			return -1; }
	return 0;
}

main(int argc, char *argv[])
{
	unsigned i, j, k;
	unsigned char c, d;

	fputs("LCD Tools - Character Generator Table Builder - v1.0\n", stderr);
	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((toupper(*ptr++) << 8) | toupper(*ptr++)) {
		case '-I' : fmt = "0%02xh";		continue;
		case '-R' :	reverse = -1;		continue;
		case 'C=' : comment = ptr;		continue;
		case 'D=' : db = ptr;			continue;
		case 'H=' : high = atox(ptr);	continue;
		case 'L=' : low = atox(ptr);	continue;
		case 'N=' : name = ptr;			continue; }
		if(*buffer)
			abort(help);
		strcpy(buffer, argv[i]); }

	if(!*(ptr=buffer))
		abort(help);
	d = -1;
	while(*ptr) {
		if(*ptr++ == '.')
			d = 0; }
	if(d)
		strcpy(ptr, ".LCG");

	fp = fopen(buffer, "rvqb");
	fget(&size, sizeof(size), fp);
	j = (bytes = (size + 7) / 8) * 256;
	if((k=fget(buffer, sizeof(buffer), fp)) != j) {
		printf("Expected %u bytes, got %u bytes\n", j, k);
		exit(-1); }
	if(getc(fp) != -1)
		abort("File format error");
	fclose(fp);

	if(reverse) {
		for(i=0; i < 256; ++i)
			table[i] = i; }
	else {
		for(i=0; i < 256; ++i) {
			c = i;
			for(j=0; j < 8; ++j) {
				d = (d << 1) | (c & 1);
				c >>= 1; }
			table[i] = d; } }

	if(low == -1) {
		for(low = 0; low < 255; ++low)
			if(tst0(low))
				goto flow;
		abort("No characters defined\n"); }
flow:
	if(high == -1) {
		for(high = 255; high > 0; --high)
			if(tst0(high))
				goto fhigh;
		abort("No characters defined\n"); }
fhigh:

	if(comment) {
		fputs(";\n; ", stdout);
		while(*comment) {
			putc((*comment != '_') ? *comment : ' ', stdout);
			++comment; }
		fputs("\n;\n", stdout); }

	if(name)
		printf("%s:", name);

	for(i=low; i <= high; ++i)
		write_character(i);
}
