#include <stdio.h>
#define	LCD_MAX	1024

unsigned
	line,
	step = 1,
	Line = 50,
	high,
	used,
	format=2,
	offset = 0x20,
	map[LCD_MAX];
unsigned char
	l,
	h,
	le,
	intel,
	rb,
	*name,
	*comment,
	error,
	file[65],
	*db;

char help[] = { "\n\
Use:	LCM filename [options] >output_file\n\n\
opts:	-I	= Intel format output\n\
	-L	= Little endian (reverse bytes in words)\n\
	-R	= Reverse bit masks\n\
	C=text	= opening Comment		[none]\n\
	D=text	= Define directive		[DB/DW]\n\
	F=n	= Specify format:		[2]\n\
		1 = byte-address\n\
		2 = byte-address.bit-mask8\n\
		3 = word-address.bit-mask8\n\
		4 = word-address\n\
		5 = word-address.bit-mask16\n\
	L=n	= Max operand length on line	[50]\n\
	N=text	= symbolic Name for table	[none]\n\
	O=hex	= Offset to apply to address	[20]\n\
	S=hex	= hardware register Step	[1]\n\
\n?COPY.TXT 2002-2005 Dave Dunfield\n -- see COPY.TXT --.\n" };

split(unsigned x)
{
	if(le) {
		l = x >> 8;
		h = x; }
	else {
		h = x >> 8;
		l = x; }
}
bit(unsigned x)
{
	x &= 7;
	return rb ? 1<<(7-x) : 1<<x;
}
main(int argc, char *argv[])
{
	unsigned c, i, j, k, l;
	unsigned char *p;
	FILE *fp;

	fputs("LCD Tools - Map Table Builder - v1.0\n", stderr);

	for(i=1; i < argc; ++i) {
		p = argv[i];
		switch((toupper(*p++) << 8) | toupper(*p++)) {
		case '-I' : intel = -1;			continue;
		case '-L' : le = -1;			continue;
		case '-R' : rb = -1;			continue;
		case 'C=' : comment = p;		continue;
		case 'D=' : db=p;				continue;
		case 'F=' : format=atoi(p);		continue;
		case 'L=' : Line = atoi(p);		continue;
		case 'N=' : name = p;			continue;
		case 'O=' : offset=atox(p);		continue;
		case 'S=' : step=atox(p);		continue; }
		if(*file)
			abort(help);
		strcpy(file, argv[i]); }

	if((format < 1) || (format > 5))
		abort(help);

	if(!*(p=file))
		abort(help);

	if(!db)
		db = (format > 3) ? "DW" : "DB";

	c = -1;
	while(*p) {
		if(*p++ == '.')
			c = 0; }
	if(c)
		strcpy(p, ".LCD");

	fp = fopen(file, "rvqb");
	if(fget(map, sizeof(map), fp) != sizeof(map))
		abort("File read error");
	fclose(fp);

	for(i=0; i < LCD_MAX; ++i) {
		if(map[i]) {
			high = i+1;
			++used; } }
	fprintf(stderr, "%u segments spanning %u slots.\n", used, high);
	if((format == 1) & (high > 256))
		abort("Segment address exceeds 1 byte, cannot use F=1\n");

	if(comment) {
		fputs(";\n; ", stdout);
		while(*comment) {
			putc((*comment != '_') ? *comment : ' ', stdout);
			++comment; }
		fputs("\n;\n", stdout); }

	if(name)
		printf("%s:", name);

	for(line=i=c=0; i < high/*used*/; ++i) {
/*		l = -1;
		for(j=k=0; j < high; ++j) {
			if((m = map[j]) && (m < l)) {	// Find lowest one
				l = m;
				k = j; } } */
		l = i+1;
		for(j=k=error=0; j < high; ++j) {
			if(map[j] == l) {
				k = j;
				goto ok; } }
		fprintf(stderr, "***Map address %u is unassigned\n", l);
		error = -1;
	ok:
		if(line)
			out_comma();
		else {
			putc('\t', stdout);
			fputs(db, stdout);
			putc('\t', stdout); }
		write_item(k);
		if(line > Line) {
			line = 0;
			putc('\n', stdout); }
		map[k] = 0; }
	if(c)
		putc('\n', stdout);
}

out_byte(unsigned char x)
{
	if(error)
		x = 0;
	line += printf(intel ? "0%02xh" : "$%02x", x);
}
out_word(unsigned x)
{
	if(error)
		x = 0;
	line += printf(intel ? "0%04xh" : "$%04x", x);
}
out_comma()
{
	putc(',', stdout);
	++line;
}

write_item(unsigned k)
{
	switch(format) {
	case 1 :	// Byte address only
		out_byte(k);
		return;
	case 2 :	// Byte.bit
		out_byte(((k>>3)*step)+offset);
		out_comma();
		out_byte(bit(k));
		return;
	case 3 :	// high,low,bit
		split(((k>>3)*step)+offset);
		out_byte(h);
		out_comma();
		out_byte(l);
		out_comma();
		out_byte(bit(k));
		return;
	case 4 :	// Word address
		split((k*step)+offset);
		out_word((h<<8)|l);
		return;
	case 5 :	// Word.word-bit
		split(((k>>4)*step)+offset);
		out_word((h<<8)|l);
		out_comma();
		h = k & 15;
		out_word(rb ? 1<<(15-h) : 1<<h); }
}
