/* PKT_INT must be in DECIMAL, as it is used by C and inline assembly */
#define	PKT_DATA	242				/* Size of data area in packet */
#define	PKT_SIZE	PKT_DATA+14		/* Size of packet with overhead */
#define	PKT_EASIZE	6				/* Size of ethernet address */
/* PKT_WINDOW must be a power of 2, so we can mask with PKT_WINDOW-1 */
#define	PKT_WINDOW	256				/* Size of packet receive queue */

/*
 * Structure of information returned by pkt_driver_info()
 */
struct PD_driver_info {
	unsigned version;				/* Driver version */
	unsigned char class;			/* Interface class */
	unsigned type;					/* Interface type */
	unsigned char number;			/* Interface number */
	unsigned char functionality;	/* Driver functionality */
	unsigned char name[9]; };		/* Driver name (?) */

/*
 * Structure of packet as sent/received by driver
 */
struct PD_packet {
	unsigned char to_addr[PKT_EASIZE];
	unsigned char from_addr[PKT_EASIZE];
	unsigned ptype;
	unsigned char data[PKT_DATA]; };

/*
 * Structure of a packet receive queue entry
 */
struct PD_queue {
	unsigned handle;
	unsigned length; };

/*
 * Packet driver interface global variables
 */
extern struct PD_queue
	pkt1_queue[PKT_WINDOW];			/* Queue for received packets */

extern unsigned
	pkt1_int,						// Packet interrupt
	pkt1_seg;						// Packet segment
extern unsigned char
	pkt1_head,						// Head of RX packet queue
	pkt1_tail;						// Tail of RX packet queue

extern struct PD_queue
	pkt2_queue[PKT_WINDOW];			// Queue for received packets

extern unsigned
	pkt2_int,						// Packet interrupt
	pkt2_seg;						// Packet segment
extern unsigned char
	pkt2_head,						// Head of RX packet queue
	pkt2_tail;						// Tail of RX packet queue
