;
; LPT signal capture for PCLA
;
; ?COPY.TXT 2000-2005 Dave Dunfield
;  -- see COPY.TXT --.
;
DGRP	GROUP	DSEG,BSEG
CSEG	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CSEG, DS:DGRP, SS:DGRP
	PUBLIC	_capture
	EXTRN	_Port:WORD, _Start:Word, _End:WORD, _Seg1:WORD, _Seg2:WORD
	EXTRN	_W_BASE:WORD
	EXTRN	_Pre1:BYTE, _Pre2:BYTE, _Preview:BYTE, _Intmode:BYTE
	EXTRN	_CTmask:BYTE, _CDmask:BYTE
;
;	DB	'H','E','R','E'
;
; Main capture function
;
_capture:	;(trigger, speed)
	PUSH	BP			; Save caller
	MOV	BP,SP			; Address stack
; Patch into keyboard vector for ESCAPE abort
	MOV	AX,3509h		; Get vector command
	INT	21h			; Ask DOS
	MOV	DGRP:INT09_O,BX		; Save offset
	MOV	DGRP:INT09_S,ES		; Save segment
	MOV	DX,OFFSET INT09		; Get offset
	MOV	AX,2509h		; Set vector command
	INT	21h			; Ask DOS
; SI = Buffer pointer
; AX = Value read (Trigger:Data)
; DI = Capture mask
; BX = 0:INDEX
; CX = Delay count
; DX = I/O address
	MOV	WORD PTR DGRP:cap1,4E8Bh ; Replace trap1 (MOV CX,4[BP])
	MOV	WORD PTR DGRP:cap3,4E8Bh ; Replace trap2 (MOV CX,4[BP])
	MOV	WORD PTR DGRP:cap11,8788h ; Replace trap3 (MOV n[BX],AL)
	MOV	WORD PTR DGRP:cap31,0488h ; Replace trap4 (MOV [SI],AL)
	MOV	DX,DGRP:_Port		; Get I/O address
	MOV	SI,DGRP:_Start		; Restore SI
	MOV	AH,DGRP:_CTmask		; Get trigger mask value
	MOV	AL,DGRP:_CDmask		; Get data mask value
	MOV	DI,AX			; Set mask
	XOR	BX,BX			; Zero counter
	MOV	ES,DGRP:_W_BASE		; Get video segment
; If requested, TRAP interrupts
	MOV	AL,DGRP:_Intmode	; Get interrupt mode
	AND	AL,AL			; Disabled?
	JZ	cap0			; Yes, don't reset
	CLI
	IN	AL,0A1h			; Read secondary MASK
	MOV	DGRP:Int1,AL		; Save it
	OR	AL,0FDh			; Allow only Cascade
	OUT	0A1h,AL			; re-Write it
	NOP
	IN	AL,21h			; Read pimary MASK
	MOV	DGRP:Int2,AL		; Save it
	OR	AL,0FDh			; Allow only keyboard
	OUT	21h,AL			; re-Write it
	STI				; Re-allow interrupts
; Check delay count, and launch special high speed code if 0
cap0:	MOV	CX,4[BP]		; Get delay count
	AND	CX,CX			; Is it special versin
	JNZ	cap1			; Yes, handle it
	MOV	CX,6[BP]		; Get trigger
	JMP	SHORT cap10		; And proceed
;
; Wait for trigger - highest speed version
;
KEY10:	CALL	except
cap10:	IN	AX,DX			; Read base IO
cap11:	MOV	DGRP:_Pre1[BX],AL	; Save Data
	MOV	DGRP:_Pre2[BX],AH	; Save Trigger
	INC	BL			; Advance low byte
	AND	AX,DI			; Save only mask byte
	CMP	AX,CX			; Does it match?
	JNZ	cap10			; And proceed
;
; Capture data into buffer - highest speed version
;
	MOV	BYTE PTR ES:[2],'A'	; Indicate acquiring
	MOV	ES,DGRP:_Seg2		; Point to segment1
	MOV	DS,DGRP:_Seg1		; Point to segment2
	JMP 	SHORT cap30		; And proceed
KEY30:	CALL	except			; Handle exception
cap30:	IN	AX,DX			; Read base IO
cap31:	MOV	[SI],AL			; Write Data
	MOV	ES:[SI],AH		; Write Trigger
	INC	SI			; Advance to next
	JNZ	cap30			; Keep capturing
	JMP	SHORT endcap
;
; Wait for trigger - normal timed version
;
KEY1:	CALL	except
cap1:	MOV	CX,4[BP]		; Get delay count
cap2:	IN	AX,DX			; Read base IO
	MOV	DGRP:_Pre1[BX],AL	; Save Trigger
	MOV	DGRP:_Pre2[BX],AH	; Save data
	LOOP	cap2			; Wait for it
	INC	BL			; Advance low byte
	AND	AX,DI			; Save only mask byte
	CMP	AX,6[BP]		; Does it match?
	JNZ	cap1			; And proceed
;
; Capture data into buffer - normal timed version
;
	MOV	BYTE PTR ES:[2],'A'	; Indicate acquiring
	MOV	ES,DGRP:_Seg2		; Point to segment1
	MOV	DS,DGRP:_Seg1		; Point to segment2
	JMP 	SHORT cap3		; And proceed
KEY3:	CALL	except			; Handle exception
cap3:	MOV	CX,4[BP]		; Get delay count
cap4:	IN	AX,DX			; Read base IO
	MOV	[SI],AL			; Write Trigger
	MOV	ES:[SI],AH		; Write Dater
	LOOP	cap4			; Wait for it
	INC	SI			; Advance to next
	JNZ	cap3			; Keep capturing
; End capture
endcap:	MOV	AX,CS			; Get stack segment
	MOV	DS,AX			; Set data segment
	MOV	DGRP:_End,SI		; Save ending address
	MOV	DGRP:_Preview,BL	; Save preview address
	MOV	AL,DGRP:_Intmode	; Get interrupt mode
	AND	AL,AL			; Enabled?
	JZ	endc1			; No, don't fix
	CLI				; Disable interrupts
	MOV	AL,DGRP:Int1		; Get interrupt1
	OUT	0A1h,AL			; Restore secondary
	MOV	AL,DGRP:Int2		; Get interrupt2
	OUT	21h,AL			; Restore primary
	STI				; Re-enable interrupts
endc1:	MOV	DX,DGRP:INT09_O		; Get offset
	MOV	DS,DGRP:INT09_S		; Get segment
	MOV	AX,2509h		; Set vector 09
	INT	21h			; Ask DOS
	MOV	AX,CS			; Get stack segment
	MOV	DS,AX			; Restore DS
	MOV	SP,BP			; Restore stack
	POP	BP			; Restore BP
	RET
;
; Key is pending
;
except:	PUSH	DS			; Save DS
	PUSH	AX			; Save AX
	MOV	AX,CS			; Get stack seg
	MOV	DS,AX			; Restore data segment
	MOV	WORD PTR DGRP:cap1,4E8Bh ; Replace trap1 (MOV CX,4[BP])
	MOV	WORD PTR DGRP:cap3,4E8Bh ; Replace trap2 (MOV CX,4[BP])
	MOV	WORD PTR DGRP:cap11,8788h ; Replace trap3 (MOV n[BX],AL)
	MOV	WORD PTR DGRP:cap31,0488h ; Replace trap4 (MOV [SI],AL)
	MOV	AH,01h			; Function 1 - get status
	INT	16h			; Ask BIOS
	JZ	excep1			; No key, ignore it
	XOR	AH,AH			; Function 0 - get key
	INT	16h			; Ask BIOS
	CMP	AL,1Bh			; Escape?
	JZ	endcap			; Yes, exit
excep1:	POP	AX			; Restore AX
	POP	DS			; Restore DS
	RET
;
INT09:	MOV WORD PTR CS:cap1,(((OFFSET KEY1)-(OFFSET cap1)-2)*256)+0EBh
	MOV WORD PTR CS:cap3,(((OFFSET KEY3)-(OFFSET cap3)-2)*256)+0EBh
	MOV WORD PTR CS:cap11,(((OFFSET KEY10)-(OFFSET cap11)-2)*256)+0EBh
	MOV WORD PTR CS:cap31,(((OFFSET KEY30)-(OFFSET cap31)-2)*256)+0EBh
	JMP	CS:INT09_V
;
CSEG	ENDS
;
DSEG	SEGMENT BYTE PUBLIC 'IDATA'
DSEG	ENDS
;
BSEG	SEGMENT BYTE PUBLIC 'UDATA'
INT09_V	LABEL	DWORD			; Saved INT09 vector
INT09_O	DW	1 DUP(?)		; INT 9 offset
INT09_S	DW	1 DUP(?)		; INT 9 segment
Int1	DB	1 DUP(?)		; Saved secondary mask
Int2	DB	1 DUP(?)		; Saved primary mask
BSEG	ENDS
	END
