#include <stdio.h>
#include <window.h>

#define	TICK	peekw(0x40, 0x6C)

#define	X1	6
#define	X2	32
#define	X3	64
#define	Y1	5
#define	Y2	15

#define	OFFL	0x17
#define	OFFH	0x1F
#define	OFFS	0x67
#define	ONL		0x13
#define	ONH		0x1B

unsigned
	Lpt,
	base,
	Ptimeout = 18,
	Ptimer[25];
unsigned char
	Hpr,
	Data,
	basewarn = 255,
	Flags = 0x05,
	Reverse,
	Pset[25];

unsigned char *Iname1[] = {
	"",			// 0
	"",			// 1
	"",			// 2
	"-ERROR",	// 3
	"SLCT",		// 4
	"PE",		// 5
	"-ACK",		// 6
	"BUSY" };	// 7
unsigned char *Iname2[] = {
	"-STROBE",	// 0
	"-AutoFD",	// 1
	"-Init",	// 2
	"-SLCTIN",	// 3
	"IRQ",		// 4
	"DataIn",	// 5
	"",			// 6
	"" };		// 7

#include "R:\\Help.h"

unsigned char P0[] = {  2,  3,  4,  5,  6,  7,  8,  9 };
unsigned char P1[] = {  0,  0,  0, 15, 13, 12, 10, 11 };
unsigned char P2[] = {  1, 14, 16, 17,  0,  0,  0,  0 };

#if 0
unsigned char LPT[] = {
 80,105,110,132, 83,105,103,110, 97,108,134, 68,105,114,131, 66,105,
116,132, 83,101,110,115,101, 10, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 10, 49,134, 45, 83, 84,
 82, 79, 66, 69,133, 79, 85, 84,131, 76, 80, 84, 43, 50, 46, 48,132,
 45,133, 83,116, 97,110,100, 97,114,100, 32, 65,100,100,114,101,115,
115,101,115, 58, 10, 50,134, 68, 48,138, 79, 85, 84,131, 76, 80, 84,
 46, 48,134, 43,142, 48, 51, 66, 67, 10, 51,134, 68, 49,138, 79, 85,
 84,131, 76, 80, 84, 46, 49,134, 43,142, 48, 51, 55, 56, 10, 52,134,
 68, 50,138, 79, 85, 84,131, 76, 80, 84, 46, 50,134, 43,142, 48, 50,
 55, 56, 10, 53,134, 68, 51,138, 79, 85, 84,131, 76, 80, 84, 46, 51,
134, 43, 10, 54,134, 68, 52,138, 79, 85, 84,131, 76, 80, 84, 46, 52,
134, 43, 10, 55,134, 68, 53,138, 79, 85, 84,131, 76, 80, 84, 46, 53,
134, 43, 10, 56,134, 68, 54,138, 79, 85, 84,131, 76, 80, 84, 46, 54,
134, 43,133, 76, 80, 84, 43, 50, 46, 52, 32, 61, 32, 73, 82, 81, 10,
 57,134, 68, 55,138, 79, 85, 84,131, 76, 80, 84, 46, 55,134, 43,136,
 49, 61, 69,110, 97, 98,108,101, 32, 73, 82, 81, 32,111,110, 32, 65,
 67, 75, 10, 49, 48,133, 45, 65, 67, 75,136, 73, 78,132, 76, 80, 84,
 43, 49, 46, 54,132, 43, 10, 49, 49,133, 66, 85, 83, 89,136, 73, 78,
132, 76, 80, 84, 43, 49, 46, 55,132, 45, 10, 49, 50,133, 80, 69,138,
 73, 78,132, 76, 80, 84, 43, 49, 46, 53,132, 43,133, 76, 80, 84, 43,
 50, 46, 53, 32, 61, 32, 73, 78, 80, 10, 49, 51,133, 83, 76, 67, 84,
136, 73, 78,132, 76, 80, 84, 43, 49, 46, 52,132, 43,136, 49, 61, 68,
105,115, 97, 98,108,101, 32,111,117,116,112,117,116, 32,100,114,105,
118,101,114,115, 10, 49, 52,133, 45, 65,117,116,111, 70, 68,133, 79,
 85, 84,131, 76, 80, 84, 43, 50, 46, 49,132, 45, 10, 49, 53,133, 45,
 69, 82, 82, 79, 82,134, 73, 78,132, 76, 80, 84, 43, 49, 46, 51,132,
 43, 10, 49, 54,133, 45, 73, 78, 73, 84,135, 79, 85, 84,131, 76, 80,
 84, 43, 50, 46, 50,132, 43, 10, 49, 55,133, 45, 83, 76, 67, 84, 73,
 78,133, 79, 85, 84,131, 76, 80, 84, 43, 50, 46, 51,132, 45,133, 49,
 56, 45, 50, 53,130, 71,114,111,117,110,100, 10, 0 };

unsigned char CMD[] = {
 80, 80, 68, 69, 66, 85, 71, 32, 45, 32, 67,111,112,121,114,105,103,
104,116, 32, 50, 48, 48, 51, 45, 50, 48, 48, 54, 32, 68, 97,118,101,
 32, 68,117,110,102,105,101,108,100, 32, 45, 32, 65,108,108, 32,114,
105,103,104,116,115, 32,114,101,115,101,114,118,101,100, 46, 10, 10,
 75,101,121, 98,111, 97,114,100, 32, 99,111,109,109, 97,110,100,115,
 58, 10, 10,132, 48, 45, 55, 32, 61, 32, 84,111,103,103,108,101, 32,
 68, 65, 84, 65, 45, 66, 73, 84, 32,111,117,116,112,117,116, 10, 10,
133, 65,130, 61, 32, 84,111,103,103,108,101, 32, 45, 83, 84, 82, 79,
 66, 69, 32,111,117,116,112,117,116, 10,133, 66,130, 61, 32, 84,111,
103,103,108,101, 32, 45, 65,117,116,111, 70, 68, 32,111,117,116,112,
117,116, 10,133, 67,130, 61, 32, 84,111,103,103,108,101, 32, 45, 73,
 78, 73, 84, 32,111,117,116,112,117,116, 10,133, 68,130, 61, 32, 84,
111,103,103,108,101, 32, 45, 83, 76, 67, 84, 73, 78, 32,111,117,116,
112,117,116, 10,133, 69,130, 61, 32, 84,111,103,103,108,101, 32, 73,
 82, 81, 32,101,110, 97, 98,108,101, 10,133, 70,130, 61, 32, 84,111,
103,103,108,101, 32,111,117,116,112,117,116, 32,100,114,105,118,101,
114, 32,101,110, 97, 98,108,101, 10,133, 71,130, 61, 32, 84,111,103,
103,108,101, 32,117,110,117,115,101,100, 32, 76, 80, 84, 43, 50, 32,
 98,105,116, 32, 54, 10,133, 72,130, 61, 32, 84,111,103,103,108,101,
 32,117,110,117,115,101,100, 32, 76, 80, 84, 43, 50, 32, 98,105,116,
 32, 55, 10, 10,133, 73,130, 61, 32, 68,105,115,112,108, 97,121, 32,
 76, 80, 84, 32,112,111,114,116, 32,105,110,102,111,114,109, 97,116,
105,111,110, 10,133, 82,130, 61, 32, 82,101,118,101,114,115,101, 32,
 76, 80, 84, 32,112,105,110, 32,100,105,115,112,108, 97,121, 10,132,
 69, 83, 67, 32, 61, 32, 69,120,105,116, 32,112,114,111,103,114, 97,
109, 10,  0 };
#endif

void draw_pin(unsigned pin)
{
	if(pin < 13)
		wgotoxy(Reverse ? 69-(pin*5) : (pin*5)+9, 1);
	else
		wgotoxy(Reverse ? 66-((pin-13)*5) : ((pin-13)*5)+11, 2);
	wprintf("%u", pin+1);
}

void draw_input(unsigned char b, unsigned char f, unsigned x, unsigned y, unsigned char *old, unsigned char pins[])
{
	unsigned i, p;
	unsigned char c, m;
	c = b ^ *old;
	*old = b;
	for(i=0; i < 8; ++i) {
		m = 1 << i;
		if(c & m) {
			if(p = pins[i]) {
				--p;
				if((b ^ f) & m) {
					*W_OPEN = ONH;
					Pset[p] = 15; }
				else {
					*W_OPEN = OFFH;
					Pset[p] = 255; }
				draw_pin(p);
				Ptimer[p] = TICK;
				*W_OPEN = OFFL; }
			wgotoxy(x, i+y);
			wputc((b & m) ? '1' : '0'); } }
}


void Hpc(unsigned char c)
{
	if(W_OPEN)
		wputc(c);
	else
		putc(c, stdout);
}

void help(unsigned char *p)
{
	unsigned char c;
	while(c = *p++) {
		if(c & 0x80) {
			do {
				Hpc(' ');
			} while(--c > 128);
			continue; }
		Hpc(c); }
}

void WCend(unsigned a)
{
	wgotoxy(0, 4);
	*W_OPEN = a;
	wcleow();
}

main(int argc, char *argv[])
{
	unsigned i, pin;
	unsigned char *p, c, b0, b1, b2, d0, f0;

	while(++Lpt < 4) {
		if(base = peekw(0x40, (Lpt+Lpt)+6))
			goto a1; }
	Lpt = 0;
a1:
	for(i=1; i < argc; ++i) {
		p = argv[i];
		switch((toupper(*p++) << 8) | toupper(*p++)) {
/*ChtTxt R:\Help.h

Use:	PPDEBUG	[options]

opts:	/I				display lpt Information
		/R				Reverse pin display
		P=1-3/address	select lpt Port 1-3 or HEX address				[1-3]
		T=milliseconds	set change highlight Timer						[1000]

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
		case '-R' :
		case '/R' : Reverse = 255;	continue;
		case '-I' :
		case '/I' :
			help(LPT);
			return;
		case 'P=' :
			if(!(Lpt = base = atox(p)))
				abort("P= must be 1-3 or address");
			if(base < 4)
				base = peekw(0x40, (base*2)+6);
			switch(base) {
			default: basewarn = 0;
			case 0x378:
			case 0x278:
			case 0x3BC: }
			continue;
		case 'T=' : Ptimeout = atoi(p) / 55;	continue;
		}
he:		help(Help);
		exit(-1); }
	if(!base) {
		if(Lpt) *Pset = Lpt+'0';
		printf("No LPT%s port found!\n", Pset);
		goto he; }

	wopen(pin=0, 0, 80, 25, WSAVE|WCOPEN|OFFL);
redraw:
	wcursor_off();
	for(i=17; i < 25; ++i)
		draw_pin(i);
	wgotoxy(15, Y1-1); wputs("--- INPUT SIGNALS FROM LPT PORT ---");
	wgotoxy(15, Y2-1); wputs("---  OUTPUT SIGNALS TO LPT PORT ----");
	for(i=0; i < 8; ++i) {
		wgotoxy(X1-4, i+Y1); wprintf("%u:", i);
		wgotoxy(X1-4, i+Y2); wprintf("%u:", i);
		wgotoxy(X2-11, i+Y1); wprintf("%8s:", Iname1[i]);
		wgotoxy(X3-11, i+Y1); wprintf("%8s:", Iname2[i]);
		wgotoxy(X3-11, i+Y2); wprintf("%8s:", Iname2[i]);
		wgotoxy(X3+3, i+Y2); wprintf(":%c", i+'A'); }
	wgotoxy(X1-1, 24); wprintf("%04x", base);
	if(!basewarn) wputs("     **Warning**");
	wgotoxy(X2-1, 24); wprintf("%04x", base+1);
	if(!basewarn) wputs("    Non-standard address");
	wgotoxy(X3-1, 24); wprintf("%04x", base+2);
	if(!Hpr)
		wputs("      ?=help");

//	Data = in(base);
//	Flags = in(base+2);
	out(base, Data);
	out(base+2, Flags);
	Hpr = b0 = b1 = b2 = 255;
	draw_input(0, 0x00, X1, Y1, &b0, P0);
	draw_input(0, 0x80, X2, Y1, &b1, P1);
	draw_input(0, 0x0B, X3, Y1, &b2, P2);
	d0 = ~Data;
	f0 = ~Flags;
	draw_input(Data,	0x00, X1, Y2, &d0, P0);
	draw_input(Flags,	0x0B, X3, Y2, &f0, P2);

	for(;;) {
		draw_input(in(base),   0x00, X1, Y1, &b0, P0);
		draw_input(in(base+1), 0x80, X2, Y1, &b1, P1);
		draw_input(in(base+2), 0x0B, X3, Y1, &b2, P2);
		switch(c = toupper(wtstc())) {
		case 0 :
			if(Pset[pin]) {
				if((TICK-Ptimer[pin]) > Ptimeout) {
					*W_OPEN = (Pset[pin] == 15) ? ONL : OFFL;
					draw_pin(pin);
					*W_OPEN = OFFL;
					Pset[pin] = 0; } }
			if(++pin >= 18) pin = 0;
			continue;
		case 'I' :
			p = LPT;
dohelp:		wgotoxy(0, 4);
			WCend(OFFS);
			help(p);
			wgotoxy(65, 24);
			wputs("Press any key.");
			wgetc();
			WCend(OFFL);
			goto redraw;
		case 'R' : wclwin(); Reverse = Reverse ? 0 : 255; goto redraw;
		case 0x1B :
			wclose();
			return; }
		if((c >= '0') && (c <= '7')) {
			Data ^= 1 << (c - '0');
			draw_input(Data, 0x00, X1, Y2, &d0, P0);
			out(base, Data);
			continue; }
		if((c >= 'A') && (c <= 'H')) {
			Flags ^= 1 << (c - 'A');
			draw_input(Flags, 0x0B, X3, Y2, &f0, P2);
			out(base+2, Flags);
			continue; }
		p = CMD; goto dohelp; }
}
/*ChtTxt CMD
Keyboard commands:

   0-7		Toggle DATA-BIT output

	A		Toggle -STROBE output
	B		Toggle -AutoFD output
	C		Toggle -INIT output
	D		Toggle -SLCTIN output
	E		Toggle IRQ enable
	F		Toggle output driver enable
	G		Toggle unused LPT+2 bit 6
	H		Toggle unused LPT+2 bit 7

	I		Display LPT port information
	R		Reverse LPT pin display
	ESC		Exit program


							for command help: PPDEBUG ?
*/
/*ChtTxt LPT
Pin		Signal		Dir		Bit		Sense
-----------------------------------------
1		-STROBE		OUT		LPT+2.0	-		Standard Addresses:
2		D0			OUT		LPT.0	+			03BC
3		D1			OUT		LPT.1	+			0378
4		D2			OUT		LPT.2	+			0278
5		D3			OUT		LPT.3	+
6		D4			OUT		LPT.4	+
7		D5			OUT		LPT.5	+
8		D6			OUT		LPT.6	+		LPT+2.4 = IRQ
9		D7			OUT		LPT.7	+			1=Enable IRQ on ACK
10		-ACK		IN		LPT+1.6	+
11		BUSY		IN		LPT+1.7	-
12		PE			IN		LPT+1.5	+		LPT+2.5 = INP
13		SLCT		IN		LPT+1.4	+			1=Disable output drivers
14		-AutoFD		OUT		LPT+2.1	-
15		-ERROR		IN		LPT+1.3	+
16		-INIT		OUT		LPT+2.2	+
17		-SLCTIN		OUT		LPT+2.3	-		18-25  Ground
*/
