#include <stdio.h>

#define	MAXM	10		// Maximum # matches
#define	MAXPACK	4096	// Maximum packet size
#define	POOL	4096	// Size of string pool

#define	F_NOT	0x01	// Not flag
FILE
	*fpi,
	*fpo;

unsigned
	Icount,				// Input count
	Ocount,				// Output count
	Ptop,				// Top of pool
	Mtop;				// Top of match stack

unsigned char
	*ptr,				// General pointer
	*Ifile,				// Input file
	*Ofile,				// Output file
	Packet[MAXPACK],	// Received packet
	Pool[POOL];			// String pool

struct MATCH {
	unsigned char	*Offset;		// Offset in packet
	unsigned char	*Address;		// Address in pool
	unsigned char	Length;			// Length of string
	unsigned char	Flags; }	Match[MAXM];

register terminate(unsigned args)
{
	unsigned char buffer[100];
	_format_(nargs() * 2 + & args, buffer);
	fputs(buffer, stderr);
	putc('\n', stderr);
	if(fpo)
		fclose(fpo);
	if(fpi)
		fclose(fpi);
	exit(0);
}

void expect(unsigned char c)
{
	if(*ptr++ != c) {
		fprintf(stderr, "'%c' expected", c);
		exit(-1); }
}

unsigned getnum(unsigned b, unsigned l)
{
	unsigned c, v;
	unsigned char f;

	switch(*ptr) {
	case '$' : b = 16;	v=2; 	goto incp;
	case '@' : b = 8;	v=3;  	goto incp;
	case '%' : b = 2;	v = 8;	goto incp;
	incp: ++ptr;
		if(l) l = v; }

	v = f = 0;
	do {
		c = *ptr;
		if((c >= '0') && (c <= '9'))
			c -= '0';
		else if((c >= 'a') && (c <= 'f'))
			c -= ('a'-10);
		else if((c >= 'A') && (c <= 'F'))
			c -= ('A'-10);
		else
			break;
		if(c >= b)
			break;
		v = (v * b) + c;
		f = 255;
		++ptr; }
	while(--l);
	if(!f)
		abort("Number expected");
	return v;
}

unsigned getstring(void)
{
	unsigned b;
	unsigned char c, d;

	b = Ptop;
	switch(d = *ptr) {
	case '\'':
	case '"':
		++ptr;
		while((c = *ptr++) != d) {
			if(!c)
				abort("Unterminated string");
			if(Ptop >= POOL)
				abort("String pool exhausted");
			Pool[Ptop++] = c; }
		return Ptop - b; }
	do {
		if(Ptop >= POOL)
			abort("String pool exhausted");
		Pool[Ptop++] = getnum(16,2); }
	while(*ptr);
	return Ptop-b;
}


unsigned char Help[] = { "\nError\n" };

main(int argc, char *argv[])
{
	unsigned i, j, l;
	unsigned char *p, f;
	struct MATCH *m;

	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		m = Match[Mtop];
		if(*ptr == '@') {
			++ptr;
			j = getnum(16, 0)+14;
			expect('=');
setval:		m->Offset = Packet + j;
			m->Address = Pool+Ptop;
			m->Flags = 0;
			if(*ptr == '!') {
				m->Flags |= F_NOT;
				++ptr; }
			m->Length = getstring();
			++Mtop;
			continue; }

		switch((toupper(*ptr++) << 8) | *ptr++) {
		case 'T=' :	j = 0;	goto setval;
		case 'F=' :	j = 6;	goto setval; }

		if(!Ifile) {
			Ifile = ptr-2;
			continue; }
		if(!Ofile) {
			Ofile = ptr-2;
			continue; }
		abort(Help); }

	for(i=0; i < Mtop; ++i) {
		m = Match[i];
		printf("Offset=%x", m->Offset);
		printf(" Address=%x", m->Address);
		printf(" Length=%u", m->Length);
		printf(" Flags=%x\n", m->Flags); }

	if(!Ofile)
		abort(Help);

	fpi = fopen(Ifile, "rvqb");
	fpo = fopen(Ofile, "wvqb");
	while(fget(&l, sizeof(l), fpi) == 2) {
		if((l < 14) || (l > MAXPACK))
			terminate("Bad length: %u\n", l);
		if(fget(Packet, l, fpi) != l)
			abort("Format error");
		++Icount;
		for(i=0; i < Mtop; ++i) {
			m = Match[i];
			p = m->Offset;
			ptr = m->Address;
			j = m->Length;
			f = 255;
			while(j--) {
				if(*p++ != *ptr++) {	// Mismatch
					f = 0;
					break; } }
			if(f) { 		// Matched
				if(!(m->Flags & F_NOT))
					goto ok; }
			else {			// Didn't match
				if(m->Flags & F_NOT)
					goto ok; } }
		continue;
ok:		fput(&l, sizeof(l), fpo);
		fput(Packet, l, fpo);
		++Ocount; }
	printf("In=%u Out=%u\n", Icount, Ocount);
	fclose(fpo);
	fclose(fpi);
}
