#include <stdio.h>
#include <math.h>

#define MAX 127

main(int argc, char *argv[])
{
	int i, j, r;
	double x, y, z, inc;
	char xf;
	FILE *fp;

	if((argc < 2) || !(r = atoi(argv[1]))) {
		printf("Use: SINE <resolution>\n");
		return; }

	if(!(fp = fopen("S", "w"))) {
		printf("Can't open file");
		exit(-1); }
	inc = 6.283185 / r;
	printf("Resolution=%lf\n", inc);
	xf = x = 0;
r /= 4;
	for(i=0; i < r; ++i) {
		y = sin(x);
		x += inc;
		j = (y * MAX);
/*		printf("%-5u %-10lf %-10lf %d\n", i, x, y, j); */
		if(xf)
			putc(',', fp);
		if(!(i & 7))
			putc('\n', fp);
		fprintf(fp, " %4d", j);
		xf = -1; }
	fclose(fp);
}
