/*
 * VT-100 checkup program
 *
 * ?COPY.TXT 1989-2005 Dave Dunfield
 *  -- see COPY.TXT --.
 */
#include C:\mc\stdio.h
#include C:\mc\video.h

char mode = 1,  /* 1 = VT100, 0 = VT52 */
	cflag = 0,	/* 1 = local, 0 = remote */
	buffer[80];

/* communications port status & data registers */
unsigned com_base = 0x3f8, com_stat = 0x03fd;

/* 8250 uart baud rate conversion table */
unsigned baud[] = { 1047, 384, 96,   48,   24,   12,   6 };
unsigned rate[] = { 110,  300, 1200, 2400, 4800, 9600, 19200, 0 };

char *partab[] = { "Odd", "Even", "Mark", "Space", "None", 0 };

char baud_rate = 5, parity = 4, dbits = 3, sbits = 0;

/* color name table */
char *colors[] = { "Black", "Red", "Green", "Yellow",
	"Blue", "Magenta", "Cyan", "White" };

/*
 * Special "getc" to bypass DOS.
 * Read a character directly from the COM port
 */
cgetc()
{
	char c;

	if(cflag) {
		if((c = vgetc()) == '\n')
			c = '\r';
		return c; }
	asm {
		MOV		DX,_com_stat; Point to status register
cgetc1:	IN		AL,DX		; Read uart status
		TEST	AL,01h		; Character received?
		JZ		cgetc1		; No, wait for it
		MOV		DX,_com_base; Point to data register
		IN		AL,DX		; Read character
		MOV		AH,0		; Clear high byte
	}
}

/*
 * Special "putc" to bypass DOS.
 * Write a character directly to the COM port
 */
cputc(chr) asm
{
cputc1:	MOV		DX,_com_stat; Point to status port
cputc2:	IN		AL,DX		; Read uart status
		TEST	AL,01h		; Character received?
		JNZ		cputc3		; Special case, handle
		AND		AL,20h		; Ok to transmit?
		JZ		cputc2		; No, wait for it
		MOV		AX,4[bp]	; Get character
		MOV		DX,_com_base; Point to data port
		OUT		DX,AL		; Write the character
		JMP		SHORT cputc6; And exit
; character has been received
cputc3: MOV		DX,_com_base; point to data port
		IN		AL,DX		; Read the data
		CMP		AL,'S'-40h	; Is it XOFF?
		JNZ		cputc1		; No, its not
; XOFF received, wait for an XON
cputc4:	MOV		DX,_com_stat; Point to status port
cputc5:	IN		AL,DX		; Read uart status
		TEST	AL,01h		; Receiver ready?
		JZ		cputc5		; No, wait for it
		MOV		DX,_com_base; Point to data port
		IN		AL,DX		; Read the character
		CMP		AL,'Q'-40h	; is it XON?
		JNZ		cputc4		; No, keep looking
		JMP		cputc1		; Send data char
cputc6:
}

/*
 * Special "printf" to write to the COM port
 */
register cprintf(args)
	unsigned args;
{
	char *ptr, buffer[100];

	_format_(nargs() * 2 + &args, buffer);
	for(ptr = buffer; *ptr; ++ptr)
		cputc(*ptr);
}

/*
 * Set the terminal mode (VT100 / VT52)
 */
setmode(m)
    int m;
{
    if(m != mode) {
        cls();
        tty_box(20, 10, 40, 2);
        tty_xy(30, 11);
        cprintf("Now entering %s mode", m ? "VT100" : "VT52");
		wait_prompt();
		cprintf((mode = m) ? "\x1b<" : "\x1b[?2l"); }
}

/*
 * Clear terminal screen
 */
cls()
{
    cprintf(mode ? "\x1b[H\x1b[J" : "\x1bH\x1bJ");
}

/*
 * Position terminal cursor
 */
tty_xy(x, y)
    int x, y;
{
    if(mode)
        cprintf("\x1b[%u;%uH", y, x);
    else
        cprintf("\x1bY%c%c", y+0x1f, x+0x1f);
}

/*
 * Draw a box in VT100 graphics characters
 */
tty_box(x, y, w, h)
    int x, y, w, h;
{
    int i;
	char c1, c2;

	c1 = (mode < 2) ? 'q' : '-';
	c2 = (mode < 2) ? 'x' : '|';

    tty_xy(x, y);
	if(mode < 2)
		cprintf(mode ? "\x1b)0\x0el" : "\x1bFl");
    else
		cputc('+');
    for(i=1; i < w; ++i)
        cputc(c1);
	cputc((mode < 2) ? 'k' : '+');
    tty_xy(x, y+h);
	cputc((mode < 2) ? 'm' : '+');
    for(i=1; i < w; ++i)
        cputc(c1);
	cputc((mode < 2) ? 'j' : '+');
    --h; ++y;
    for(i=0; i < h; ++i) {
        tty_xy(x, i+y);   cputc(c2);
        tty_xy(x+w, i+y); cputc(c2); }
	if(mode < 2);
		cprintf(mode ? "\x0f" : "\x1bG");
}

/*
 * Display a test screen title
 */
title(string)
    char *string;
{
    cls();
    tty_xy(38-(strlen(string)/2), 1);
    cprintf(mode ? "\x1b[7m %s \x1b[0m" : "* %s *", string);
}

/*
 * Draw a test screen
 */
draw_test()
{
    int i, j;

    cls();
    for(i=1; i < 24; i += 4) {
        tty_xy(1, i);
        for(j=0; j < 80; ++j)
            cputc(j+'1'); }
}

/*
 * Wait for <return> key before proceeding.
 */
wait_return()
{
	char c;

	vgotoxy(0, 0);
	for(;;) {	/* forever loop */
		do {
			if((c = cgetc()) == '\r')
				return; }
		while(c != 0x1b);
		tty_xy(50, 24); cprintf(" Exit \"VT100 - Checkup\"(Y/N)?");
		if(toupper(cgetc()) == 'Y') {
			cls();
			message("*** \"VT100 - Checkup\" has been aborted ***", -1); }

		tty_xy(50, 24); cprintf("\x1b%s", mode ? "[K" : "K"); }
}

/*
 * Prompt and wait for return key before proceeding
 */
wait_prompt()
{
    tty_xy(1, 24);
    cprintf("Press <return> to proceed...");
	wait_return();
    cprintf(mode ? "\x1b[2K" : "\r\x1bK");
}

/*
 * Match a string to uppercase command
 */
match(str1, str2, n)
	char *str1, *str2;
	int n;
{
	do {
		if(!*str1)
			return n <= 0;
		--n; }
	while(toupper(*str1++) == *str2++);
	return 0;
}

/*
 * Display a message in a BOX on the PC screen
 */
message(ptr, eflag)
	char *ptr, eflag;
{
	vmessage(39-(strlen(ptr)/2), 16, ptr);
	if(eflag) {
		vgotoxy(0, 22);
		vcursor_line();
		exit(0); }
}

/*
 * Initialize uart after allowing change to parameters
 */
init()
{
	int i;

	vdraw_box(30, 15, 20, 7);
	for(;;) {
		vgotoxy(31, 16); vprintf("(B)audrate:  %5u", rate[baud_rate]);
		vgotoxy(31, 17); vprintf("(P)arity:    %5s", partab[parity]);
		vgotoxy(31, 18); vprintf("(D)ata bits: %5u", dbits+5);
		vgotoxy(31, 19); vprintf("(S)top bits: %5u", sbits+1);
		vgotoxy(31, 21); vprintf("(return) to start?");
		switch(toupper(vgetc())) {
			case 'B' :
				if(!rate[++baud_rate])
					baud_rate = 0;
				break;
			case 'P' :
				if(!partab[++parity])
					parity = 0;
				break;
			case 'D' :
				if(++dbits > 3)
					dbits = 0;
				break;
			case 'S' :
				if(++sbits > 1)
					sbits = 0;
				break;
			case '\n':
				i = ((parity << 4) & 0x30)	|	/* parity bits */
					(dbits & 0x03)			|	/* # data bits */
					((sbits << 2) & 0x04)	|	/* # stop bits */
					((parity < 4) << 3) ;

				out(com_base+3, i | 0x80);
				out(com_base, baud[baud_rate]);
				out(com_base+1, baud[baud_rate] >> 8);
				out(com_base+3, i);
				out(com_base+1, 0);	/* disable all interrupts */
				out(com_base+4, 3);	/* Enable DTR and RTS */

				for(i=0; i < 8; ++i) {
					vgotoxy(30, i+15);
					vprintf("%25s", "" ); }
				return;
			default:
				vputc(7); } }
}

/*
 * Main program, set up uart and terminal, and execxute the tests
 */
main(argc, argv)
	int argc;
	char *argv[];
{
	char *ptr;

	vopen();
	vdraw_box(12, 5, 56, 7);
	vgotoxy(13, 6);  vprintf("                   \"VT100 - Checkup\"");
	vgotoxy(13, 8);  vprintf("ANSI/VT100 Terminal demonstration and checkout utility.");
	vgotoxy(13, 10); vprintf("?COPY.TXT 1989-2005 Dave Dunfield");
	vgotoxy(13, 11); vprintf(" -- see COPY.TXT --.");

	vgotoxy(15, 20);
	if(argc < 2)
		message("Use: vtest COM1 | COM2 [LOCAL]", -1);

/* select com port */
	if(match(argv[1], ptr = "COM1", 4)) {
		com_stat = 0x3fd,
		com_base = 0x3f8; }
	else if(match(argv[1], ptr = "COM2", 4)) {
		com_stat = 0x2fd,
		com_base = 0x2f8; }
	else
		message("Invalid COM port", -1);

	if(argc > 2) {
		if(!match(argv[2], "LOCAL", 1))
			message("Invalid argument", -1);
		cflag = -1; }

	init();
	vcursor_off();
	sprintf(buffer, "\"VT100 - Checkup\" is running on %s", ptr);
	message(buffer, 0);
    cls();
	tty_box(12, 5, 56, 7);
	tty_xy(13, 6);  cprintf("                   \"VT100 - Checkup\"");
	tty_xy(13, 8);  cprintf("ANSI/VT100 Terminal demonstration and checkout utlity.");
	tty_xy(13, 10); cprintf("?COPY.TXT 1989-2005 Dave Dunfield");
	tty_xy(13, 11); cprintf(" -- see COPY.TXT --.");
	tty_box(14, 18, 51, 2);
	tty_xy(15, 19); cprintf("Press ESCAPE at any prompt to exit VT100 - Checkup");
    wait_prompt();

/* vt100 tests */
    test_xy();
    test_udfb();
    test_clear();
	test_attrs();
	test_color();
	test_csr();
	test_tabs();
	test_double();
    test_index();
    test_scroll();
    test_graph();
	test_mode();

/* VT52 tests */
    vt52_xy();
    vt52_udfb();
    vt52_clear();
    vt52_revlf();

    setmode(1);
	cls();
	message("*** \"VT100 - Checkup\" has terminated ***", -1);
}

/*
 * Test X/Y cursor positioning
 */
test_xy()
{
    int i, j;
    char c;

    setmode(1);
    c = 'H';
    for(j=0; j < 2; ++j) {
        cls();
        for(i=1; i < 25; ++i) {
            cprintf("\x1b[%u;%uH%c", i, i*2, c);
            cprintf("\x1b[%u;%uH%c", i, 49-(i*2), c); }
        tty_box(39, 10, 34, 5);
        tty_xy(40, 11); cprintf("VT100 - Cursor movement using '%c'", c);
        tty_xy(40, 12); cprintf("Display should show a perfect 'X'");
        tty_xy(40, 13); cprintf("Press  <return>  to  proceed with");
        tty_xy(40, 14); cprintf("the next test....................");
        tty_xy(50, 20);
		wait_return();
        c = 'f'; }
}

/*
 * Test UP, RIGHT, DOWN and LEFT movement
 */
test_udfb()
{
    setmode(1);
    title("UP, DOWN, FORWARD, BACKWARD");
    tty_xy(20, 10); cprintf("A   (Up)");
    tty_xy(50, 10); cprintf("B   (Down)");
    tty_xy(20, 15); cprintf("C   (Forward)");
    tty_xy(50, 15); cprintf("D   (Backward)");
    tty_xy(20, 10); cprintf("\x1b[A^");
    tty_xy(50, 10); cprintf("\x1b[Bv");
    tty_xy(20, 15); cprintf("\x1b[C>");
    tty_xy(50, 15); cprintf("\x1b[D<");
    wait_prompt();
}

/*
 * Test screen clear routines
 */
test_clear()
{
    setmode(1);
    draw_test();
    cls();
    tty_xy(30, 10); cprintf("Erase ENTIRE screen");
    wait_prompt();
    draw_test();
	tty_xy(20,  9); cprintf("\x1b[1JErase from START of screen ");
    tty_xy(20, 17); cprintf(" Erase to END of screen\x1b[0J");
    wait_prompt();
    draw_test();
	tty_xy(20,  9); cprintf("\x1b[1KErase from START of line ");
    tty_xy(20, 17); cprintf(" Erase to END of line\x1b[0K");
    wait_prompt();
}

/*
 * Test screen attrbutes
 */
test_attrs()
{
    setmode(1);
    title("SCREEN ATTRIBUTES");
	tty_xy(15,  4); cprintf("Normal");
	tty_xy(15,  5); cprintf("\x1b[1mBold\x1b[0m");
	tty_xy(15,  6); cprintf("\x1b[4mUnderscore\x1b[0m");
	tty_xy(15,  7); cprintf("\x1b[5mBlinking\x1b[0m");
	tty_xy(15,  8); cprintf("\x1b[7mReverse\x1b[0m");
	tty_xy(15,  9); cprintf("\x1b[1;4mBold+Underscore\x1b[0m");
    tty_xy(15, 10); cprintf("\x1b[1;5mBold+Blink\x1b[0m");
    tty_xy(15, 11); cprintf("\x1b[1;7mBold+Reverse\x1b[0m");
    tty_xy(15, 12); cprintf("\x1b[1;4;5mBold+Underscore+Blink\x1b[0m");
    tty_xy(15, 13); cprintf("\x1b[1;4;7mBold+Underscore+Reverse\x1b[0m");
    tty_xy(15, 14); cprintf("\x1b[1;5;7mBold+Blink+Reverse\x1b[0m");
    tty_xy(15, 15); cprintf("\x1b[1;4;5;7mBold+Underscore+Blink+Reverse\x1b[0m");
    tty_xy(15, 16); cprintf("\x1b[4;5mUnderscore+Blink\x1b[0m");
    tty_xy(15, 17); cprintf("\x1b[4;7mUnderscore+Reverse\x1b[0m");
    tty_xy(15, 18); cprintf("\x1b[4;5;7mUnderscore+Blink+Reverse\x1b[0m");
    tty_xy(15, 19); cprintf("\x1b[5;7mBlink+Reverse\x1b[0m");
    wait_prompt();
    title("CLEAR ATTRIBUTES");
    tty_xy(20, 10); cprintf("Press <return> to clear screen with all");
    tty_xy(20, 11); cprintf("attributes enabled \x1b[1;4;5;6m*****>");
	wait_return();
    cls();
    tty_xy(20, 11); cprintf("*****>\x1b[0m The screen should be cleared to");
    tty_xy(27, 12); cprintf("NORMAL (ie: NO ATTRIBUTES) blank spaces.");
    wait_prompt();
}

/*
 * Test cursor save/restore
 */
test_csr()
{
    int i;

    setmode(1);
    title("CURSOR SAVE/RESTORE");
	tty_xy(40, 10); cprintf("Restore & print text ->\x1b7");
	tty_xy(40, 20); cprintf("\x1b(0\x1b)0\x0e\x1b[1;4;5;7m");
	cprintf(" tqGRAPHICS TESTqu \x1b8Here\x1b(B\x0f\x1b[0m");
    tty_xy(40, 15); cprintf("Cursor should return here ->\x1b7");
    for(i=1; i < 23; ++i) {
        tty_xy(i, i);
        cputc('X'); }
    tty_xy(1, 24); cprintf("Press <return> to proceed...\x1b8");
	wait_return();
}

/*
 * Test setting/clearing tab stops
 */
test_tabs()
{
    int i;

    setmode(1);
    title("TAB SETTINGS");
    cprintf("\x1b[3g");
    tty_xy(1, 8); cprintf("Set tab stops every 10 spaces\n\r");
    for(i=10; i < 80; i += 10) {
        tty_xy(i, 9);
        cprintf("\x1bHT"); }
    tty_xy(1, 10); cprintf("Verify the tabs...\n\r");
    for(i=1; i < 8; ++i)
        cprintf("\t%d", i);
    tty_xy(50, 12); cprintf("\x1b[0g");
    tty_xy(1, 12); cprintf("Clear tab stop 5...\n\r");
    for(i=1; i < 8; ++i)
        cprintf("\t%d", i);
    tty_xy(1, 15); cprintf("Clear all tab stops...\x1b[3g\n\r");
    for(i=1; i < 8; ++i)
		cprintf("\t%d", i);
	for(i=9; i < 80; i += 8) {	/* restore 8 space tab stops */
		tty_xy(i, 2);
		cprintf("\x1bH"); }
    wait_prompt();
}

/*
 * Test double height/width characters
 */
test_double()
{
    setmode(1);
    title("DOUBLE SIZED LINES");
    tty_xy(1, 10);
	cprintf("Normal width line ....................\n\n\r");
	cprintf("Double width line ....................\x1b#6\n\n\r");
	cprintf("Double height line ...................\x1b#3\n\r");
	cprintf("Double height line ...................\x1b#4\n\r");
    wait_prompt();
}

/*
 * Test forward & reverse index
 */
test_index()
{
    int i;

    setmode(1);
    title("NEXT LINE & INDEX");
    tty_xy(1, 1);
    for(i=1; i < 24; ++i)
        cprintf("\x1bEX");
    for(i=1; i < 24; ++i)
        cprintf("\x1bMX");
    tty_xy(40, 20); cprintf("Press <return> to test");
    tty_xy(40, 21); cprintf("Reverse scrolling.....");
	wait_return();
    tty_xy(25, 1);
    for(i=0; i < 23; ++i)
        cprintf("\x1bMX");
    wait_prompt();
}

/*
 * Test scrolling region
 */
test_scroll()
{
    int i;

    setmode(1);
    title("SCROLLING REGION");
	tty_box(1, 7, 79, 11);
    cprintf("\x1b[8;17r");
    tty_xy(1, 8);
    for(i=0; i <= 50; ++i)
        cprintf("\x1b[C%37u\n\r", i);
	tty_box(1, 7, 79, 11);
    wait_prompt();
    tty_xy(1, 17);
    for(i=0; i <= 50; ++i)
        cprintf("\x1b[C%37u\r\x1bM", i);
    cprintf("\x1b[1;24r");
	tty_box(1, 7, 79, 11);
    wait_prompt();
}

/*
 * Test VT100 special graphics character set
 */
test_graph()
{
    int i;

    setmode(1);
    title("GRAPHICS CHARACTERS");
    cprintf("\x1b(B\x1b)0");
    for(i=0; i < 32; ++i) {
        tty_xy(3 + ((i/8)*20), 5+((i%8)*2));
        cprintf("%02x '%c' = \x0e'%c'\x0f", i+95, i+95, i+95); }
    cprintf("\x1b)A");
    tty_xy(20,22);
    cprintf("Pound sign: Uk=\x0e'#', \x0fUsASCII='#'");
    wait_prompt();
}

/*
 * Test set/reset mode commands
 */
test_mode()
{
    int i;

    setmode(1);
    title("SET/RESET MODES");
    tty_xy(1,5);
    cprintf("\x1b[20hLinefeed/newline Set:\nOne\nTwo\nThree\n\n\r");
    cprintf("\x1b[20lLinefeed/newline Reset:\nOne\nTwo\nThree\n\n\r");
    cprintf("\x1b[?7hAuto wrap Set:\n\r");
    for(i=0; i < 100; ++i)
        cputc('-');
    cprintf("\n\r\x1b[?7lAuto wrap Reset:\n\r");
    for(i=0; i < 100; ++i)
        cputc('-');
    wait_prompt();
    title("ORIGIN MODE");
    tty_xy(1, 11);
    for(i=0; i < 79; ++i)
        cputc('-');
    tty_xy(1, 22);
    for(i=0; i < 79; ++i)
        cputc('-');
    for(i=1; i <= 10; ++i) {
        tty_xy(i,i);
        cputc('A');
        tty_xy(11-i, i);
        cputc('A'); }
    cprintf("\x1b[12;21r\x1b[?6h");
    for(i=1; i <= 10; ++i) {
        tty_xy(i,i);
        cputc('B');
        tty_xy(11-i, i);
        cputc('B'); }
    cprintf("\x1b[1;24r\x1b[?6l");
    tty_xy(40, 3); cprintf("'A' X should be at upper left");
    tty_xy(40, 4); cprintf("corner of the terminal screen");
    tty_xy(40, 6); cprintf("'B' X should be at the left of");
    tty_xy(40, 7); cprintf("the area between the two lines");
    wait_prompt();
}

/*
 * Test colors
 */
test_color()
{
	int i, j;

	cprintf("\x1b7\x1b[40m"); /* ??? \25\ */
	title("COLOR ATTRIBUTES");
	for(i=0; i < 8; ++i) {
		tty_xy(0, i+9); cprintf("%s", colors[i]); }
	tty_xy(10, 8);
	for(i=0; i < 8; ++i)
		cprintf("%-8s", colors[i]);
	for(i=0; i < 8; ++i) {
		tty_xy(9, i+9);
		cprintf("\x1b[%um", i+40);
		for(j=0; j < 8; ++j)
			cprintf("\x1b[%um %2u,%2u  ", j+30, j+30, i+40); }
	cprintf("\x1b8");
	wait_prompt();
}

/*
 * Test VT52 Cursor positioning
 */
vt52_xy()
{
    int i;

    setmode(0);
    cls();
    for(i=1; i < 25; ++i) {
        tty_xy(i*2, i);
        cputc('X');
        tty_xy(49-(i*2), i);
        cputc('X'); }
    tty_box(39, 10, 23, 5);
    tty_xy(40, 11); cprintf("VT52 - Cursor movement");
    tty_xy(40, 12); cprintf("Display should show  a");
    tty_xy(40, 13); cprintf("perfect 'X'.     Press");
    tty_xy(40, 14); cprintf("<return> to proceed...");
    tty_xy(50, 20);
	wait_return();
}

/*
 * Test VT52 UP, RIGHT, DOWN and LEFT movement
 */
vt52_udfb()
{
    setmode(0);
    title("VT52 - UP, DOWN, FORWARD, BACKWARD");
    tty_xy(20, 10); cprintf("A   (Up)");
    tty_xy(50, 10); cprintf("B   (Down)");
    tty_xy(20, 15); cprintf("C   (Forward)");
    tty_xy(50, 15); cprintf("D   (Backward)");
    tty_xy(20, 10); cprintf("\x1bA^");
    tty_xy(50, 10); cprintf("\x1bBv");
    tty_xy(20, 15); cprintf("\x1bC>");
    tty_xy(50, 15); cprintf("\x1bD<");
    wait_prompt();
}

/*
 * Test VT52 screen clear routines
 */
vt52_clear()
{
    setmode(0);
    draw_test();
	tty_xy(20,  9); cprintf(" VT52 Erase to end of line.\x1bK");
    tty_xy(20, 17); cprintf(" VT52 Erase to end of screen\x1bJ");
    wait_prompt();
}

/*
 * Test reverse line-feed
 */
vt52_revlf()
{
    int i;

    setmode(0);
    title("VT52 reverse line feed");
    tty_xy(1, 24);
    for(i=0; i < 47; ++i)
	cprintf("\x1bIX");
    wait_prompt();
}
