/*
 * This is a handy little program to display the IBM PC character set.
 *
 * If HOTKEYS are specified on the command line, CSET will install
 * itself as a TSR (Ram-Resident) program, which can be invoked at
 * any time by pressing the HOTKEYS. Available HOTKEYS are:
 *		L - Left SHIFT
 *		R - Right SHIFT
 *		A - ALT
 *		C - CONTROL
 *		S - SysRq (Caution: some systems may not like this one)
 *
 *		eg: CSET LR	(Install with LEFT+RIGHT SHIFT for hotkeys)
 *
 * To exit the character set display, press the ESCAPE key.
 *
 * ?COPY.TXT 1990-2003 Dave Dunfield
 *  -- see COPY.TXT --.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc cset -fop
 */
#include <stdio.h>
#include <video.h>
#include <tsr.h>

char video_save_area[4006];

/*
 * Display the IBM PC Character set
 */
charset()
{
	int i;

	save_video(video_save_area);
	vopen();
	vcursor_off();
	V_ATTR = REVERSE;
	vmsg(29,  0, " IBM PC CHARACTER SET ");
	vmsg(29, 21, " Press ESCAPE to exit ");
	V_ATTR = NORMAL;
	for(i=0; i < 256; ++i) {
		vgotoxy((i/16)*5, i%16+3);
		hexout(i / 16);
		hexout(i & 15);
		vputc('=');
		vputc(i | 0xff00); }
	while(vgetc() != 0x1B);
	restore_video(video_save_area);
}

/*
 * Display a number
 */
hexout(int value)
{
	vputc(value <= 9 ? value + '0' : value + '7');
}

/*
 * Output message at X and Y coordinates
 */
vmsg(int x, int y, char *string)
{
	vgotoxy(x, y);
	while(*string)
		vputc(*string++);
}

/*
 * Main program, either TSR or execute main tty program menu
 */
main(int argc, char *argv[])
{
	int hot_keys;
	char *ptr;

/* If RAM-resident, print startup message & TSR */
	if(argc > 1) {
		fputs("POP-UP Character set\n\n?COPY.TXT 1990-2003 Dave Dunfield\n -- see COPY.TXT --.", stderr);
		hot_keys = 0;
		ptr = argv[1];
		while(*ptr) switch(toupper(*ptr++)) {
			case 'A' : hot_keys |= ALT;		break;
			case 'C' : hot_keys |= CONTROL;	break;
			case 'L' : hot_keys |= L_SHIFT;	break;
			case 'R' : hot_keys |= R_SHIFT; break;
			case 'S' : hot_keys |= SYS_REQ;	break;
			default: abort("\n\nInvalid HOTKEY"); }
		tsr(&charset, hot_keys, 500); }

/* Not RAM-resident, execute the program */
	charset();
}
