/*
 * Auto set the DOS year to a absolute or relative value
 *
 * Useful to set year on machines with BIOS that cannot go to 2000.
 * Also useful to set year back and forth in batch files running
 * non-Y2K compliant software which fails in years >1999.
 *
 * ?COPY.TXT 2000-2003 Dave Dunfield
 * Freely distributable.
 *
 * Compile command: cc fixyear -fop
 */
#include <stdio.h>

main(int argc, char *argv[])
{
	int day, month, year, hour, minite, second;

	if(argc != 2)
		abort("\nUse: fixyear [+/-]number\n");

	/*
	 * If clock should tick just after we get_date(), but before we
	 * set_date(), we will inadvertantly reset day and possibly month
	 * to incorrect values... Easy hack is to detect that we are close
	 * to midnight, and wait till day rolls over before we proceed.
	 */
	get_time(&hour, &minite, &second);
	if((hour == 23) && (minite == 59) && (second == 59))
		delay(1500);
		
	get_date(&day, &month, &year);

	switch(*argv[1]) {
		case '+' :		/* Positive offset */
			year += atoi(argv[1]+1);
			break;
		case '-' :		/* Negative offset */
			year -= atoi(argv[1]+1);
			break;
		default:		/* Set year directly */
			year =  atoi(argv[1]); }

	if((year < 1980) || (year > 2099))
		abort("New year value falls outside of DOS allowed range.\n");

	if(set_date(day, month, year))
		abort("Unable to set new date.\n");
}
