/*
 * MORE command for MS-DOS
 *
 * This version of MORE is pretty much the same as the original MS-DOS MORE
 * command except that it does not add an extra blank line to the start of
 * the output.
 *
 * ?COPY.TXT 1998-2003 Dave Dunfield
 * Freely distributable.
 *
 * Compile command: cc more -fop
 */
#include <stdio.h>

char help[] = { "Displays output one screen at a time.\n\n\
MORE <[drive:][path]filename\ncommand-name | MORE\n\n\
  [drive:][path]filename  Specifies a file to display one screen at a time.\n\
  command-name            Specifies a command whose output will be displayed.\n\
\n?COPY.TXT 1998-2003 Dave Dunfield - Freely Distributable.\n" };

main(int argc, char *argv[])
{
	int c, line, lines;

	/* Get #lines from bios */
	lines = 24;		/* Default to 24 */
	switch(c = peek(0x40, 0x84)) {
		case 42 :	/* EGA 43 line mode */
		case 49 :	/* VGA 50 line mode */
			lines = c; }

	if(argc > 1) {
		if(!strcmp(argv[1], "/?"))
			abort(help);
		abort("Too many arguments"); }

	line = 0;
	while((c = getc(stdin)) != EOF) {
		putc(c, stdout);
		if((c == '\n') && (++line >= lines)) {
			line = 0;
			fputs("-- More --", stderr);
			switch(kbget()) {
				case 3 :		/* Control-C */
					fputs("^C", stderr);
				case 0x1B :		/* Escape */
					return; }
			putc('\n', stderr); } }
}
