/*
 * This program checks the contents of an OPUS/MAXIMUS FILES.BBS file and
 * reports any filesnames that do not actually exist, as well as any files
 * that exist and are not listed in FILES.BBS. I use this to maintain the
 * file areas on my MAXIMUS 2.0 BBS.
 * FILES.BBS has the format: filename.ext Description
 *
 * ?COPY.TXT 1996-2003 Dave Dunfield
 *  -- see COPY.TXT --.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc bchk -fop
 */
#include <stdio.h>
#include <file.h>

#define	MAX_FILES 1000		/* Maximum number of files listed */

char *filenames[MAX_FILES][13], found[MAX_FILES];
unsigned file_count, dir_count;
char flag, flag1;

main()
{
	unsigned i, a;
	char buffer[500], *ptr, *ptr1;
	FILE *fp;

	fp = fopen("FILES.BBS", "rvq");
	while(fgets(ptr = buffer, sizeof(buffer)-1, fp)) {
		switch(*buffer) {
			case ' ' :
			case '\t' :
			case 0 :
				continue; }
		ptr1 = filenames[file_count++];
		while(*ptr && !isspace(*ptr))
			*ptr1++ = toupper(*ptr++);
		*ptr1 = 0; }
	fclose(fp);

	if(find_first("*.*", 0x3F, buffer, &i, &i, &a, &i, &i))
		abort("No files found!");
	do {
		if(*buffer == '.') continue;
		if(a & VOLUME) continue;
		++dir_count;
		for(i=0; i < file_count; ++i)
			if(!strcmp(buffer, filenames[i])) {
				found[i] = -1;
				goto found_file; }
		if(!strcmp(buffer, "FILES.BBS"))
			goto found_file;
		if(a & DIRECTORY)		/* Don't complain about subdirs */
			goto found_file;
		if(!flag) {
			printf("The following files are NOT cataloged in FILES.BBS:\n");
			flag = -1; }
		printf(" %s\n", buffer);
	found_file: }
	while(!find_next(buffer, &i, &i, &a, &i, &i));

	for(i=0; i < file_count; ++i)
		if(!found[i]) {
			if(!flag1) {
				printf("The following files are cataloged but NOT present:\n");
				flag1 = -1; }
			printf(" %s\n", filenames[i]); }

	if(!flag)
		printf("All files present are cataloged.\n");
	if(!flag1)
		printf("All cataloged files are accounted for.\n");

	printf("FILES.BBS has %u entries, there are %u files (counting FILES.BBS)\n",
		file_count, dir_count);
}
