/*
 * This program finds the internal "errorlevel" variable within COMMAND.COM
 * by scanning for the changing errorlevel value within it's segment.
 *
 * This was a "Quick & Dirty" solution for a program which **HAD** to
 * preserve the existing ERRORLEVEL when run from a batch file. Normally,
 * COMMAND.COM sets it's new errorlevel to the value set at our termination.
 * In order to set the right value, we need to know what it is currently
 * set to.
 *
 * To complicate matters, the previous DOS errorlevel value is destroyed
 * when it is retrieved by COMMAND.COM via INT 21, Function 4D, making it
 * impossible to obtain it from "normal" sources. The only way to obtain
 * this value is to read the COMMAND.COM internal data variable directly.
 *
 * This method of obtaining the previous command errorlevel relies on
 * completely undocumented/unsupported data structures within COMMAND.COM
 * This is highly dependant on the version of COMMAND.COM, and is therefore
 * UNSUITABLE AS A GENERAL TECHNIQUE.
 *
 * This command must be run three times from the COMMAND.COM prompt:
 *	1st = Create segment bitmap file and set first exit code
 *	2nd = Scan for first exit code and set for next exit code
 *	3rd = Scan for next exit code (should only be one match)
 * If by chance, another variable changing in memory happens to match
 * the exit codes, you can continue running SCANEXIT as many times as
 * required to find the unique location which contains the exit code.
 * (To restart the scan, delete the SCANEXIT.DAT file)
 *
 * Compile with DDS Micro-C/PC (http://www.dunfield.com): cc SCANEXIT -fop
 */
#include <stdio.h>

#define	FILENAME "SCANEXIT.DAT"	// Name of file to store transient data

main()
{
	unsigned s, s1, s2, s3, s4, o, i, r;
	unsigned char b;
	static char failmap[8192];	// Bitmap of failed locations
	FILE *fp;

	/* Read segments from vectors which should point to COMMAND.COM */
	s1 = peekw(0, (0x22*4)+2);	// Terminate handler
	s2 = peekw(0, (0x23*4)+2);	// Control-C handler
	s3 = peekw(0, (0x24*4)+2);	// Critical error handler
	s4 = peekw(0, (0x2E*4)+2);	// COMMAND.COM backdoor

	/* Vote best 2 of three for COMMAND.COM segment */
	if(s1 == s2) {
		s = s1;
		if(s != s3)
			printf("Critical error handler has been re-vectored\n"); }
	else if(s1 == s3) {
		s = s1;
		printf("Control-C handler has been re-vectored\n"); }
	else if(s2 == s3) {
		s = s2;
		printf("Terminate handler has been re-vectored\n"); }
	else {
		printf("Cannot determine COMMAND.COM segment!\n");
		exit(-1); }

	printf("COMMAND.COM segment is: %04x\n", s);

	/* Report if this is not the top level COMMAND.COM */
	if(s != s4)
		printf("Active COMMAND.COM is NOT top level!\n");

	/* If data file exists, read and scan for last exit code */
	if(fp = fopen(FILENAME, "rb")) {
		fget(&s1, sizeof(s1), fp);
		fget(&r, sizeof(r), fp);
		s2 = fget(failmap, sizeof(failmap), fp);
		fclose(fp);
		if(s2 != sizeof(failmap)) {
			printf("%s is incorrect size! - retry\n", FILENAME);
			delete(FILENAME);
			exit(-2); }
		if(s1 != s) {
			printf("%s has wrong segment! - retry\n", FILENAME);
			delete(FILENAME);
			exit(-2); }
		printf("Scanning for %u... ", r);
		o = s3 = 0;
		do {
			i = o >> 3;
			b = 1 << (o & 7);
			if(peek(s, o) != r)
				failmap[i] |= b;
			else if(!(failmap[i] & b)) {
				++s3;
				s4 = o; } }
		while(++o);
		printf("%u match%s.\n", s3, (s3 == 1) ? "" : "es");
		if(s3 == 1)		// Only one location found
			printf("Location is %04x\n", s4);
		else if(!s3) {	// No matches
			printf("No matchs! - retry\n");
			delete(FILENAME); }
		else			// Too many matches yet.
			printf("Need another pass - Run program again.\n"); }
	else {				// First run - reset exit code.
		printf("Creating data file: %s - Run program again.\n", FILENAME);
		r = 0; }

	/* Rewrite the data file with new match masks and exit code */
	++r;				// Advance to next return code
	if(fp = fopen(FILENAME, "wb")) {
		fput(&s, sizeof(s), fp);
		fput(&r, sizeof(r), fp);
		fput(failmap, sizeof(failmap), fp);
		fclose(fp); }
	else
		printf("Could not open output flie: %s\n", FILENAME);

	/* Terminate with next exit code */
	exit(r);
}
