// LZSS Huffman decompression
#define	PRINT_STEP	1024

// LZSS parameters
#define	SBSIZE		4096		// Size of string buffer
#define	LASIZE		60			// Size of look-ahead buffer
#define	THRESHOLD	2

//  Huffmas codeing parameters
#define	N_CHAR		(256-THRESHOLD+LASIZE)	// Char code (= 0..N_CHAR-1)
#define	TSIZE		((N_CHAR*2)-1)			// Size of table
#define	ROOT		(TSIZE-1)				// Root position
#define	MAX_FREQ	0x8000					// Update when cumulitive freq.
											// reaches this value
#define	Uint	unsigned
#define	Ushort	unsigned
#define	Uchar	unsigned char
#define	Ulong	unsigned

Ulong
	Usize[2],		// Size of decoded data
	Csize[2],		// Size of encoded data
	printcount[2];		// Step to print
Ushort
	prnt[TSIZE+N_CHAR],	// hft parent
	son[TSIZE],			// hft son
	getbuf,				// input bit buffer
	freq[TSIZE+1],		// hft
	text_buf[SBSIZE+LASIZE-1];	// decode buffer
Uchar
	Verbose,
	getlen,				// length on getbuf
	aprefix,			// special file prefix
	filename[128];		// filename buffer
Uchar
	pcount, print_chars[] = { '-', '\\', '|', '/' };
// decoder tables
Uchar d_code[256] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
	0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
	0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
	0x0C, 0x0C, 0x0C, 0x0C, 0x0D, 0x0D, 0x0D, 0x0D,
	0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x0F, 0x0F, 0x0F,
	0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0x11,
	0x12, 0x12, 0x12, 0x12, 0x13, 0x13, 0x13, 0x13,
	0x14, 0x14, 0x14, 0x14, 0x15, 0x15, 0x15, 0x15,
	0x16, 0x16, 0x16, 0x16, 0x17, 0x17, 0x17, 0x17,
	0x18, 0x18, 0x19, 0x19, 0x1A, 0x1A, 0x1B, 0x1B,
	0x1C, 0x1C, 0x1D, 0x1D, 0x1E, 0x1E, 0x1F, 0x1F,
	0x20, 0x20, 0x21, 0x21, 0x22, 0x22, 0x23, 0x23,
	0x24, 0x24, 0x25, 0x25, 0x26, 0x26, 0x27, 0x27,
	0x28, 0x28, 0x29, 0x29, 0x2A, 0x2A, 0x2B, 0x2B,
	0x2C, 0x2C, 0x2D, 0x2D, 0x2E, 0x2E, 0x2F, 0x2F,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F };

Uchar d_len[256] = {
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 };

// Compare long numbers: !0 = a < b
Ushort long_compare(Ushort *a, Ushort *b)
{
	if(a[1] != b[1]) {
		if(a[1] > b[1])
			goto rz;
		return 255; }
	if(*a < *b)
		return 255;
rz:	return 0;
}

// Reconstruct freq tree
void reconst(void)
{
	Ushort i, j, k, f, l;

	// halve cumulative freq for leaf nodes
	j = 0;
	for(i = 0; i < TSIZE; ++i) {
		if(son[i] >= TSIZE) {
			freq[j] = (freq[i] + 1) / 2;
			son[j] = son[i];
			++j; } }
	// make a tree : first, connect children nodes
	for(i = 0, j = N_CHAR; j < TSIZE; i += 2, ++j) {
		k = i + 1;
		f = freq[j] = freq[i] + freq[k];
		for(k = j - 1; f < freq[k]; --k);
		l = (j - ++k) * 2;
		memmove(&freq[k + 1], &freq[k], l);
		freq[k] = f;
		memmove(&son[k + 1], &son[k], l);
		son[k] = i; }

	// connect parent nodes 
	for(i = 0; i < TSIZE; ++i) {
		if((k = son[i]) >= TSIZE)
			prnt[k] = i;
		else
			prnt[k] = prnt[k + 1] = i; }
}

// update freq tree
void update(Ushort c)
{
	Ushort i, k, j, l;

	if(freq[ROOT] == MAX_FREQ)
		reconst();
	c = prnt[c + TSIZE];
	do {
		k = ++freq[c];
		if(k > freq[l = c + 1]) {	// swap nodes to keep the tree freq-ordered
			while(k > freq[++l]);
			--l;
			freq[c] = freq[l];
			freq[l] = k;
			i = son[c];
			prnt[i] = l;
			if(i < TSIZE)
				prnt[i + 1] = l;
			j = son[l];
			son[l] = i;
			prnt[j] = c;
			if(j < TSIZE)
				prnt[j + 1] = c;
			son[c] = j;
			c = l; } }
	while(c = prnt[c]);		// do until we reach root
}

Ushort GetBit(void)		// get one bit
{
	Ushort i;

	if(!getlen)
		getbuf = getc(fpi) << (getlen = 8);
	i = getbuf;
	getbuf <<= 1;
	--getlen;
	return (i >> 15) & 1;	//? i < 0;
}

Ushort GetByte(void)	// get a byte
{
	Ushort i;

	if(getlen < 8) {
		getbuf |= getc(fpi) << (8 - getlen);
		getlen += 8; }
	i = getbuf;
	getbuf <<= 8;
	getlen -= 8;
	return i >> 8;
}

Ushort DecodeChar(void)
{
	Ushort c;

	// search the tree from root to leaves.
	// choose node #(son[]) if input bit == 0
	// else choose #(son[]+1) (input bit == 1)
	c = son[ROOT];
	while(c < TSIZE) {
		c += GetBit();
		c = son[c]; }
	c -= TSIZE;
	update(c);
	return c;
}

Ushort DecodePosition(void)
{
	Ushort i, j, c;

	// decode upper 6 bits from given table
	i = GetByte();
	c = (Ushort)d_code[i] << 6;
	j = d_len[i] - 2;
	// input lower 6 bits directly
	while(j--)
		i = (i << 1) + GetBit();
	return c | (i & 0x3F);
}

// Main decompression routine
void Decode(void)
{
	Ushort i, k, j, r, c;
	Ulong count[2];

	printcount[1] = *printcount = count[1] = *count = 0;

	// Initialize Huffman frequency tree
	getlen = getbuf = 0;
	for(i = 0; i < N_CHAR; ++i) {
		freq[i] = 1;
		son[i] = i + TSIZE;
		prnt[i + TSIZE] = i; }
	i = 0; j = N_CHAR;
	while(j <= ROOT) {
		freq[j] = freq[i] + freq[i + 1];
		son[j] = i;
		prnt[i] = prnt[i + 1] = j;
		i += 2; ++j; }
	freq[TSIZE] = 0xFFFF;
	prnt[ROOT] = 0;

	for(i = 0; i < (SBSIZE-LASIZE); ++i)
		text_buf[i] = 0;	//DD was ' '
	r = SBSIZE - LASIZE;
	while(long_compare(count, Usize)) {
		if((c = DecodeChar()) < 256) {
			putc(text_buf[r] = c, fpo);
			r = (r + 1) & (SBSIZE - 1);
			if(!++*count)
				++count[1]; }
		else {
			i = (r - DecodePosition() - 1) & (SBSIZE - 1);
			j = c - 255 + THRESHOLD;
			k = 0;
			while(k < j) {
				putc(text_buf[r] = text_buf[(i + k) & (SBSIZE - 1)], fpo);
				r = (r + 1) & (SBSIZE - 1);
				if(!++*count)
					++count[1];
				++k; } }
		if(long_compare(printcount, count)) {
			if(Verbose) {
				putc('\b', stderr);
				putc(print_chars[--pcount & 0x03], stderr); }
			i = *printcount + PRINT_STEP;
			if(i < *printcount)
				++printcount[1];
			*printcount = i; } }
}
