/*
 * MKPKG - MaKe distributable PacKaGe
 *
 * Builds an simple/single <pkage>.EXE containing multiple compressed files,
 * allowing the user to easily select which ones are installed.
 *
 * Dave Dunfield   -   https://dunfield.themindfactory.com
 */ 
#include <stdio.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;
#define	MemTst(a)

//#define	ITEMS	120
#define	POOL	12000

unsigned
	Line,			// Inout line
	Tus[2],Tcs[2],	// TotalUsize, TotalCsize
	Ifo,			// IdirFileOffset
	Ppos, Ptop;		// Pool position/top
FILE
	*fp,
	*fpi,
	*fpo;
unsigned char
	*Ptr,			// General pointer
//	Opt,			// Command options
	Ena,			// Enabled flag
	Ityp,			// Item type (Dir/File/Enab)
	Tfile[64],
	Fname[64],
	Odir[64],		// Output Directory/File
	Idir[64],		// Input Direcrory/File
	Buffer[128],	// General buiffer
	Temp[64],		// Temp buffer
	Pool[POOL];		// memory storage pool

#include "R:\\Help.h"

#define	PK_DIR	0xA0
#define	PK_FIL	0x50

#include "compress.ch"

unsigned char ExeImg[] =
#include "R:\PKGUNPK.H"
unsigned char _MARK_[] = { 0xAA, 0x55 };

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	exit(-1);
}

void Pc(unsigned char c)	{	putc(c, stdout);	}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
void Sp(void)				{	Pc(' ');			}
void Nl(void)				{	Pc('\n');			}
#define	Pr	printf

// Skip to non-blank
int Skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

//Trim spaces from string
unsigned Trim(void)
{
	unsigned i;
	i = 0;
	while(Ptr[i])					++i;
	while(i && isspace(Ptr[i-1]))	--i;
	Ptr[i] = 0;
	return i;
}

// Parse a value from [Ptr] to dst[]
unsigned Parse(unsigned char dst[])
{
	unsigned i;
	unsigned char e;
	switch(e = Skip()) {
	case '`':
	case'\'':
	case '"':	++Ptr;	break;
	default	:	e = 0; }
	i = 0;
a1:	switch(dst[i] = *Ptr) {
	case '`':
	case'\'':
	case '"':
		if(*Ptr == e) {
			++Ptr;
			break; }
	default	:
a2:		++Ptr;
		++i;
		goto a1;
	case ' ':
	case'\t':
		if(e) goto a2;
	case 0	:
		if(e)
			Error("?Parse%c", e); }
	dst[i] = 0;
	return i;
}

unsigned PPbyte(unsigned char b)
{
	if(Ptop >= POOL)
		Error("?PoolOver1");
	Pool[Ptop++] = b;
	return b;
}
unsigned PPword(unsigned w)
{
	PPbyte(w);
	PPbyte(w >> 8);
}
// Add a string to the pool
unsigned char *PPstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	while(PPbyte(*p++));
	return t;
}

#if 0
unsigned char PGbyte(void)
{
	if(Ppos >= Ptop)
		Error("?PoolOver2");
	return Pool[Ppos++];
}
unsigned PGword(void)
{
	unsigned w;
	w = PGbyte();
	return (PGbyte() << 8) | w;
}
unsigned char PGstring(unsigned *dst)
{
	unsigned char *p;
	p = dst;
	while(*p++ = PGbyte());
	return dst;
}

unsigned RDitem(void)
{
	Ityp = 0;
	if(Ppos < Ptop) {
		switch((Ityp = PGbyte()) & 0xF0) {
		default	:	Error("?PkCorr%02x", Ityp);
		case PK_DIR:
			PGstring(Odir);
			break;
		case PK_FIL:
			PGstring(Temp);
			Usize[0] = PGword();
			Usize[1] = PGword();
			Csize[0] = PGword();
			Csize[1] = PGword(); }
		PGstring(Buffer); }
	return Ityp & 0xF0;
}
#endif

unsigned
	L10[] = { 10, 0 },
extern unsigned Longreg[];
void ShowLN(unsigned char *p, unsigned ln[])
{
	unsigned i, lv[2];
	unsigned char buf[13];
	buf[i = sizeof(buf)-1] = 0;
	longcpy(lv, ln);
	do {
		longdiv(lv, L10);
		buf[--i] = *Longreg + '0'; }
	while longtst(lv);
//	while(i) buf[--i] = ' ';
	Ps(p);
	Ps(buf+i);
}
void TstEna(void)
{
	switch(Skip()) {
	default	:	return;
	case '+':	Ena = 1;	break;
	case '-':	Ena = 0;	}
	++Ptr;
}

#ifndef MemTst
	void MemTst(unsigned char x)
	{
		unsigned i, j;
		unsigned char *p, *p1;
		static unsigned char *mp;

		if(x) {
			p1 = &i - 16;
			free(mp = p = malloc(8));
			while(p < p1)
				*p++ = 0xA5;
			return; }

		i = 0;
		p1 = &x;
		printf("Mem: %04x-", mp);
	a1:	j = 0;
		while(mp < p1) {
			if(*mp++ != 0xA5) {
				if(j > i) {
					i = j;
					p = mp; }
				goto a1; }
			++j; }
		printf("%04x %u\n", p, i);
	}
#endif


main(int argc, char *argv[])
{
	unsigned i, j, k;
	unsigned char c;
	MemTst(7);
	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:	goto he;
/*ChtTxt R:\Help.H
use:	MKPKG	file[.PKG] [options]

opts:	-Tfile		set Temp file							[%TEMP%$PKG$.TMP]

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
			case 'T':
				strcpy(Tfile, Ptr);
				continue;
			} if(*Ptr) goto o1;
			continue; }
		if(*Fname) goto he;
		strcpy(Fname, Ptr); }

	if(!*Fname) {
he:		Ptr = Help;
		while(c = *Ptr++) {
			if(c & 0x80) {
				while(c-- & 0x7F)
					Sp();
				continue; }
			Pc(c); }
		return; }

	i = j = 0;
o3:	k = 0;
o4:	switch(Fname[i++]) {
	case ':':
	case'\\':	j = i;	goto o3;
	case '.':	k = i;
	default	:			goto o4;
	case 0	:	--i; }
	if(!k)
		strcpy((k=i)+Fname, ".PKG");

	i = 0;
	if(!*Tfile) {
		if(getenv("TEMP", Tfile)) {
			if(i = strlen(Tfile)) {
				if(Tfile[i-1] != '\\')
					Tfile[i++] = '\\'; } } }
	strcpy(Tfile+i, "$PKG$.TMP");
	Debug(("'%s'%u\n", Tfile, i))

	Rinit();

	fp = fopen(Fname, "rvq");
	strcpy(Fname+k, ".EXE");
	fpo = fopen(Tfile, "wbvq");
	while(fgets(Ptr = Buffer, sizeof(Buffer)-1, fp)) {
		++Line;
		switch(Skip()) {
		case ';':
		case 0	:	continue;
		case ':':	goto e1;
		case '=':	++Ptr;
			TstEna();
			if(!Parse(Temp))
				Error("?=");
			Skip(); Trim();
			Debug(("='%s'%s'\n", Temp, Ptr))
			PPbyte(PK_DIR | Ena);
			PPstring(Temp);
			PPstring(Ptr);
			continue; }
		TstEna();
		Parse(Temp);
		Skip(); Trim();
		i = j = 0;
a1:		k = 0;
a2:		switch(Temp[i++]) {
		case'\\':	j = i;	goto a1;
		case '.':	k = i;
		default	:			goto a2;
		case 0	:	--i; }
		Debug(("'%s'%s'%s'\n", Temp+j, Temp, Ptr))
		if(j) {
			strcpy(Idir, Temp);
			Ifo = j; }
		else
			strcpy(Idir+Ifo, Temp);
		Debug(("F'%s'\n", Idir))

		Ps(Idir);
		{
			fpi = fopen(Idir, "rbvq");
			Encode();
			ShowLN(" ", Usize);
			if(Csize[1] < Usize[1]) goto b1;
			if(Csize[1] > Usize[1]) goto b2;
			if(Csize[0] < Usize[0]) {
b1:				ShowLN("->", Csize);
				while((i = Rread()) != EOF) {
					putc(i, fpo); } }
			else {
b2:				longcpy(Csize, Usize);
				rewind(fpi);
				while((i = getc(fpi)) != EOF) {
					putc(i, fpo); } } //?
			fclose(fpi); }
		longadd(Tus, Usize);
		longadd(Tcs, Csize);
		Debug(("T%04x%04x=%04x%04x", Usize[1], *Usize, Tus[1], *Tus))
		Debug((" C%04x%04x=%04x%04x", Csize[1], *Csize, Tcs[1], *Tcs))
		Nl();

		PPbyte(PK_FIL|Ena);
		PPstring(Temp+j);
		PPword(*Usize); PPword(Usize[1]);
		PPword(*Csize); PPword(Csize[1]);
		PPstring(Ptr);
	}
e1:	fclose(fpo);
	fclose(fp);

#if 0
z1:	switch(RDitem() & 0xF0) {
	case PK_DIR:
		Pr("D'%s'%s'\n", Odir, Buffer);
		goto z1;
	case PK_FIL:
		Pr("F'%s'%s'", Temp, Buffer);
		Ps("T=");	ShowLN(Usize[1], *Usize);
		Ps(" C=");	ShowLN(Csize[1], *Csize);
		Nl();
		goto z1; }
#endif
	fpo = fopen(Fname, "wbvq");
	fput(ExeImg, sizeof(ExeImg)+2, fpo);
	fput(&Ptop, sizeof(Ptop), fpo);
	fput(Pool, Ptop, fpo);
	fpi = fopen(Tfile, "rvbq");
	while((i = getc(fpi)) != EOF)
		putc(i, fpo);
	fclose(fpi);
	fclose(fpo);
	delete(Tfile);

	ShowLN("Tu=", Tus);
	ShowLN(" Tc=", Tcs);
	longset(Tus, sizeof(ExeImg)+Ptop+4);
	longadd(Tcs, Tus);
	printf(" Exe%u+%u", sizeof(ExeImg), Ptop+4);
	ShowLN("=", Tcs);
	MemTst(0);
}
//  CHT builds HELP.H from //Cht commands
//BuildD cht mkpkg
//BuildD tasm/ml ramfile;
//BuildD cc mkpkg -pofm
//  DosBox has a bug: CALing a second BATCH doesn't always return: LC.BAT
//  DBC is a .COM that performs system(args);
//BuildD dbc lc mkpkg ramfile
//BuildD del mkpkg.obj
//BuildD del ramfile.obj
//  COMPAK compress a .COM - you could use something like UPX
//BuildD compak MKPKG R:\MKPKG.COM
//BuildD del MKPKG.COM
