/*
 * PacKaGe UnPacK
 *
 * This is the core client which is contained within MKPKG which it
 * uses when creating <package>.EXE
 *
 * Dave Dunfield   -   https://dunfield.themindfactory.com
 */
#include <stdio.h>
#include <window.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#define	ITEMS	128			// Max number of items
#define	POOL	16384		// Memorystorage pool

#define	IDIR	0x10		// Item is directory
#define	SYES	0x04		// Select Enabled
#define	SNO		' '			// "" disabled

#define	COLS	80			// Working columns
#define	LINES	24			// "" lines

unsigned
	ExeOff[2],
	Ofo,					// OutputFileOffset
	Imax, Itop, Isel, Ipos,	// Item max, top-of-streen, selected, position
	Ppos, Ptop;				// Pool position/top
FILE
	*fp,
	*fpi,
	*fpo,
	*Vfp;
unsigned char
	*Ptr,
	Vnor, Vhil,				// Video attributes
	Ityp,					// Item type read
	Iflg[ITEMS],			// Item flags
	Odir[128],				// Outpout directory/file
	Buffer[256],			// General buffer
	Temp[128],				// Temp buffer
	Pool[POOL];				// Memory storage pool

#define	PK_DIR	0xA0		// Directory type
#define	PK_FIL	0x50		// File type

#include "decomprs.ch"

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
	if(!Vfp) wclose();
	fputs(buf, stdout);
	exit(-1);
}

void Pc(unsigned char c)
{
	if(Vfp) {
		putc(c, Vfp);
		return; }
	wputc(c);
}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
void Sp(void)				{	Pc(' ');			}
void Nl(void)				{	Pc('\n');			}
register Pr(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Ps(buf);
}

unsigned PPbyte(unsigned char b)
{
	if(Ptop >= POOL)
		Error("?PoolOver1");
	Pool[Ptop++] = b;
	return b;
}
unsigned PPword(unsigned w)
{
	PPbyte(w);
	PPbyte(w >> 8);
}
// Add a string to the pool
unsigned char *PPstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	while(PPbyte(*p++));
	return t;
}
unsigned char PGbyte(void)
{
	if(Ppos >= Ptop)
		Error("?PoolOver2");
	return Pool[Ppos++];
}
unsigned PGword(void)
{
	unsigned w;
	w = PGbyte();
	return (PGbyte() << 8) | w;
}
unsigned char PGstring(unsigned *dst)
{
	unsigned char *p;
	p = dst;
	while(*p++ = PGbyte());
	return dst;
}

unsigned RDitem(void)
{
	Ityp = 0;
	if(Ppos < Ptop) {
		switch((Ityp = PGbyte()) & 0xF0) {
		default	:	Error("?PkCorr%02x", Ityp);
		case PK_DIR:
			PGstring(Odir);
			if(Ofo = strlen(Odir)) {
				if(Odir[Ofo-1] != '\\') {
					Odir[Ofo]	= '\\';
					Odir[++Ofo] = 0; } }
			break;
		case PK_FIL:
			PGstring(Odir+Ofo);
			Usize[0] = PGword();
			Usize[1] = PGword();
			Csize[0] = PGword();
			Csize[1] = PGword(); }
		PGstring(Buffer); }
	return Ityp & 0xF0;
}

unsigned
	L10[] = { 10, 0 },
extern unsigned Longreg[];
void ShowLN(unsigned h, unsigned l)
{
	unsigned i, lv[2];
	unsigned char buf[13];
	buf[i = sizeof(buf)-1] = 0;
	lv[1] = h;
	*lv = l;
	do {
		longdiv(lv, L10);
		buf[--i] = *Longreg + '0'; }
	while longtst(lv);
//	while(i) buf[--i] = ' ';
	Ps(buf+i);
}

void Wscol(unsigned x)
{
	while(W_OPEN->WINcurx < x)
		Sp();
}
void Qsel(void)
{
	Pc((Iflg[Ipos] & 0x01) ? SYES : SNO);
	Sp();
}

void Imenu(void)
{
	unsigned i, k;
	unsigned char c, d;
	wopen(Vfp = 0, 0, COLS, LINES+1, WSAVE|WCOPEN|0x07);
	if(!Vnor) {
		if(W_BASE == 0xB800) {
			*W_OPEN = Vnor = 0x17;
			Vhil = 0x71; }
		else {
			*W_OPEN = Vnor = 0x07;
			Vhil = 0x70; } }
a1:	if(Isel & 0x8000)	Isel = 0;
	if(Isel > Imax)		Isel = Imax;
	if(Isel < Itop)		Itop = Isel;
	while((Itop + LINES) <= Isel) ++Itop;
	Ppos = i = 0;
	while(i < Itop) {
		RDitem();
		++i; }
	for(i=0; i < LINES; ++i) {
		wgotoxy(0, i);
		if((Ipos = Itop+i) == Isel)	*W_OPEN = Vhil;
		if(Ipos >= Imax) {
			Ps("[END]");
			*W_OPEN = Vnor;
			wcleow();
			break; }
		switch(k = RDitem()) {
		default	:	Error("?RDtype%02x (%u,%u)", Ityp, Itop, i);
		case PK_DIR:
			Pc(IDIR);
			Qsel();
			Ps(Buffer);
			Wscol(50);
			Ps(Odir);
			break;
		case PK_FIL:
			Sp(); Qsel();
			Sp(); Sp();
			Ps(Odir+Ofo);
			if(*Buffer) {
				Wscol(20);
				Ps(Buffer); } }
		*W_OPEN = Vnor;
		wcleol(); }
	wgotoxy(0, LINES);
//	wprintf("%u-%u-%u-", Isel, Itop, Imax);
	wputs("Unpack: \x1A\x18\x19\x1BPg\x18\x19HomeEnd=move ' '=\x12select Enter=Accept ESC=quit");
	wcleol();
b1:	switch(k = wgetc()) {
	case _KUA:	i = 1;	goto b2;
	case _KPU:	i = (LINES-1);
b2:		Isel -= i;
		goto a1;
	case _KDA:	i = 1;	goto b3;
	case _KPD:	i = (LINES-1);
b3:		Isel += i;
		goto a1;
	case _KHO:	Isel = 0;		goto a1;
	case _KEN:	Isel = Imax;	goto a1;
	case 0x1B:	Error("Abort");
	case '\r':
	case '\n':
		wclose();
		Vfp = stdout;
		return; }
	if(Isel >= Imax) goto b1;
	switch(k) {
	default	:	goto b1;
	case ' ':
		switch(c = (Iflg[Isel] ^= 0x01)) {
		case PK_DIR:			// If direcrory
		case PK_DIR+1:			// Set all within
			i = Isel;
			while(++i < Imax) {
				if((d = Iflg[i] & 0xF0) != PK_FIL)
					break;
				Iflg[i] = (c & 0x0F) | d; } }
		for(i=0; i < Imax; ++i) {	// Sel dir if any subfiles
			if((Iflg[i] & 0xF0) == PK_DIR) {
				Iflg[k=i] &= 0xF0;
				continue; }
			if(Iflg[i] & 0x01)
				Iflg[k] |= 0x01; }
		goto a1; }
}

main(int argc, char *argv[])
{
	unsigned i, h, l;
	unsigned char c, d;

	Vfp = stdout;

	i = 0;
	while(++i < argc) {
		Ptr = argv[1];
o1:		switch(toupper(*Ptr++)) {
		case '-':
		case '/':	goto o1;
		case 'C':	Vnor=0x17; Vhil=0x71;	continue;
		case 'M':	Vnor=0x07; Vhil=0x70;	continue;
		}
		Ps(argv[0]);
		Ps(" -Color -Mono\n Dave Dunfield -https://dunfield.themindfactory.com");
		return; }


	fpi = fopen(argv[0], "rbvq");
	while((c = getc(fpi)) != EOF) {
		if((d == 0xAA) && (c == 0x55))
			goto a1;
		d = c; }
	Error("?AA55");
a1:	//Debug1(("=%04x%04x\n", Eh, El))
	fget(&Ptop, sizeof(Ptop), fpi);
	fget(Pool, Ptop, fpi);
	ftell(fpi, &h, &l);
	fclose(fpi);
	ExeOff[1] = h;	*ExeOff = l;
	Debug1(("EXE=%04x%04x\n", h,  l))

	while(RDitem()) {
		if(Imax >= ITEMS)
			Error("?#Items");
		Iflg[Imax++] = Ityp; }
	if(!Imax) Error("?NoItems");
	Debug1(("Imax=%u\n", Imax))

	Imenu();

//	set_drive('R'-'A'); cd("\\");

	fpi = fopen(argv[0], "rbvq");
	fseek(fpi, ExeOff[1], *ExeOff, 0);
	Ppos = i = 0;
	while(RDitem()) {
		switch(Iflg[i]) {
		case PK_DIR|1:
			Ps("D '");
			strcpy(Temp, Odir);
			if(Ofo) Temp[Ofo-1] = 0;
			Ps(Temp);
			Ps("' ");
			Ps(Buffer);
			Nl();
			mkdir(Temp);
			break;
		case PK_FIL|1:
			Ps("F'");
			Ps(Odir);
//		Pr("' %04x%04x-%04x%04x ", Usize[1], *Usize, Csize[1], *Csize);
//		Pr("%04x%04x", ExeOff[1], *ExeOff);
			Pc('\'');
			Ps(Buffer);
			fpo = fopen(Odir, "wbvq");
			fseek(fpi, ExeOff[1], *ExeOff, 0);
			if(longcmp(Csize, Usize)) {
				Debug((" C%u %u", Csize[1], *Csize))
				Nl();
				Decode(); }
			else {
				h = Usize[1];
				l = *Usize;
				Debug(("U%u %u\n", h, l))
				Nl();
				while(h|l) {
					putc(getc(fpi), fpo);
					if(--l == -1)
						--h; } }
			fclose(fpo);
		case PK_FIL:
			longadd(ExeOff, Csize); }
		++i; }
	fclose(fpi);
}
//BuildD cc pkgunpk -pof
//BuildD compak pkgunpk
//BuildD com2exe pkgunpk.COM R:\pkgunpk.EXE
//BuildD del pkgunpk.com
//BuildD bin2c R:\pkgunpk.EXE R:\PKGUNPK.H
//BuildD del R:\pkgunpk.EXE
