*
* 8096 Debug Monitor
*
* ?COPY.TXT 1991-2007 Dave Dunfield
*  -- see COPY.TXT --.
*
* Memory configuration
VECTORS	EQU	$2000		Actual interrupt vectors go here
CODE	EQU	$2080		Monitor code placed here (in ROM)
DATA	EQU	$8000-54	Monitor data placed here (in RAM)
REGS	EQU	$001A		Monitor regs placed here (in reg file)
STACK	EQU	DATA+54		Monitor stack goes here
USERRAM	EQU	$4000		Beginning of user RAM area.
USERSP	EQU	DATA		Default user Stack Pointer
NBREAK	EQU	8		Max. number of breakpoints
GODEL	EQU	1000		Delay loops to wait for interrupt
* 8096 Hardware register definitions
INTEN	EQU	$0008		Interrupt enable
IOC1	EQU	$0016		I/O control 1
SPDATA	EQU	$0007		Serial port DATA register
SPCTRL	EQU	$0011		Serial port CONTROL register
SPBAUD	EQU	$000E		Serial port BAUDRATE register
SP	EQU	$0018		Stack pointer
* General register definitions (Similar to 8086)
	ORG	REGS
AX	DS	2		Accumulator
BX	DS	2		Temporary register
CX	DS	2		Temporary register
SI	DS	2		Index register
* MON96 Control byte (MONCTL)
* 7 - SER: 1=Redirect interrupt to user program
* 6 - SER: 1=RX ready
* 5 - SER: 1=TX ready
* 4 - OUT: 1=Paused
* 3 - OUT: 1=Disabled
* 2 - STP: 0=Return to prompt, 1=Return to GO
* 1 - Unused
* 0 - Unused
MONCTL	DS	1		MON96 Control byte
*
* External RAM locations for MON96
*
	ORG	DATA
UPC	DS	2		User program counter
UPSW	DS	2		User PSW
USP	DS	2		User stack pointer
BRKTAB	DS	NBREAK*4	Breakpoint table
TBUFF	DS	10		Temporary buffer
*
* Interrupt vectors
*
	ORG	VECTORS
	DW	TOVVEC		00: Timer Overflow
	DW	ADCVEC		02: A/D Conversion Complete
	DW	HSIVEC		04: HSI Data Available
	DW	HSOVEC		06: High Speed Outputs
	DW	HS0VEC		08: HSI.0
	DW	TIMVEC		0A: Software Timers
	DW	SERINT		0C: Serial Port
	DW	EXTINT		0E: External
	DW	BRKTRAP		10: TRAP (breakpoint)
*
* Startup code for Intel EV80C196KB Evaluation board
*
	ORG	CODE
	LD	SP,#STACK		Initial stack pointer
* Initialize the serial port
	LDB	IOC1,#%00100000	Set P2.0 to TXD
	LDB	SPBAUD,#$4D	12Mhz (196) = 9600
	LDB	SPBAUD,#$80	Enable XCLK
	LDB	SPCTRL,#%01001001 Enable Mode-1
	LDB	AX,SPDATA	Clear TX port
	LDB	MONCTL,#%00100000 Fake TX set
	LDB	INTEN,#%01000000 Enable serial INTERRUPT
	EI
* Zero MON96 external memory
	LD	SI,#UPC		Point to external
	CLRB	AX		Get a zero
INIT1	STB	AX,[SI]+	Write to memory
	CMP	SI,#TBUFF	At end?
	JNC	INIT1		No, keep going
* Set initial defaults
	LD	AX,#USERSP	Get default user SP
	ST	AX,USP		Set user SP
	LD	AX,#USERRAM+$80	Start of user code
	ST	AX,UPC		Set user PC
* Main startup code
BEGIN	LCALL	WRMSG			Output message
	STR	'MON96 Version 1.0'
	DB	$0A,$0D,$0A
	STR	'?COPY.TXT 1991-2007 Dave Dunfield'
	DB	$0A,$0D
	STR	' -- see COPY.TXT --.'
	DB	$0A,0
PROMPT	LD	SP,#STACK	Reset stack incase error
	ANDB	MONCTL,#%01100000 Reset control byte
	LCALL	WRLFCR		New line
	LDB	AX,#'*'		Prompt character
	LCALL	WRCHR		Output prompt
	CLRB	AX		Zero initial
cmd1	LDB	AX+1,AX		Copy high
	LCALL	RDCHRE		Get character
	LD	SI,#CTABLE	Point to table
cmd2	LD	BX,[SI]+	Get address
	AND	BX,BX		End of table?
	JE	cmd3		Yes, handle it
	CMP	AX,[SI]+	Test for condition
	JNE	cmd2		Command does not match
	LCALL	WRSPACE		Output separator
	BR	BX		Execute command
cmd3	ANDB	AX+1,AX+1	More than two chars?
	JNE	ERROR		Invalid
	LD	SI,#CTABLE	Point to table
cmd4	LD	BX,[SI]+	Get data
	AND	BX,BX		End of table
	JE	ERROR		Report error
	CMPB	AX,1[SI]	Partial match?
	JE	cmd1		Its OK
	INC	SI		Advance
	INC	SI		Advance
	SJMP	cmd4		And proceed
* An error has occured
ERROR	LCALL	WRMSG		Output message
	STRZ	' ?'		Output message
	SJMP	PROMPT		And proceed
*
* Dump memory command
*
DISPLAY	LCALL	RDRANGE		Get range into SI:BX
dis1	LCALL	WRLFCR		New line
* Display HEX dump
	LCALL	WRADDR		Display address
	PUSH	SI		Save pointer
	LDB	AX+1,#16	Initial count
dis2	LDB	AX,AX+1		Get count
	ANDB	AX,#%00000011	4 byte interval?
	JNE	dis3		No, its OK
	LCALL	WRSPACE		Output extra space
dis3	LCALL	WRSPACE		Output space
	LDB	AX,[SI]+	Get byte value
	LCALL	WRHEX		output value
	DJNZ	AX+1,dis2	Output them all
* Display ASCII text
	POP	SI		Restore SI
	LCALL	WRSPACE		Separator
	LCALL	WRSPACE		Separator
	LDB	AX+1,#16	Reset count
dis4	LDB	AX,[SI]+	Get value
	CMPB	AX,#' '		Space?
	JNC	dis5		Non-printable
	CMPB	AX,#$7E		Highest?
	JNC	dis6		Ok to display
dis5	LDB	AX,#'.'		Convert to DOT
dis6	LCALL	WRCHR		Output
	DJNZ	AX+1,dis4	Display it all
	CMP	SI,BX		Are we over?
	JNC	dis1		No, keep going
	SJMP	PROMPT		Back for more
*
* Fill memory command
*
FILL	LCALL	RDRANGE		Get address range
	LCALL	WRSPACE		Seperator
	LCALL	RDHEX		Get value
	JC	ERROR		Report error
fill1	STB	AX,[SI]+	Write to memory
	CMP	SI,BX		At end?
	JNC	fill1		No, keep going
	SJMP	prompt		Exit to monitor
*
* Move memory command
*
MOVE	LCALL	RDRANGE		Get address range
	LCALL	WRSPACE		New line
	LCALL	RDWORD		Get new address
	JC	ERROR		Report error
move1	LDB	CX,[SI]+	Get byte
	STB	CX,[AX]+	Write to dest
	CMP	SI,BX		At end?
	JNC	move1		No, its OK
	SJMP	prompt		And exit
*
* Disassemble command
*
DISASM	LCALL	RDRANGE		Get address range
disas1	LCALL	WRLFCR		New line
	LCALL	DISASS		Output line
	CMP	SI,BX		Are we over?
	JNC	disas1		No, keep going
	SJMP	prompt		And proceed
*
* Edit memory command
*
EDIT	LCALL	RDWORD		Get address
	JC	error1		Report error
	LD	SI,AX		SI = address
edit1	LCALL	WRLFCR		New line
	LCALL	WRADDR		Display the address
	LDB	AX+1,#8		Byte count
edit2	LCALL	WRSPACE		Output space
	LDB	AX,[SI]		Get address
	LCALL	WRHEX		Output byte
	LDB	AX,#'-'		Prompt
	LCALL	WRCHR		Output
	LCALL	RDHEX		Get byte
	JC	edit4		special case
	STB	AX,[SI]		Set new value
edit3	INC	SI		Advance to next
	DJNZ	AX+1,edit2	Next in line
	SJMP	edit1		new line
* Special edit commands
edit4	CMPB	AX,#' '-'0'	Space to next
	JNE	edit5		No, try next
	LCALL	WRSPACE		Space over
	SJMP	edit3		Advance
edit5	CMPB	AX,#$08-'0'	Backspace?
	JNE	edit6		No, try next
	DEC	SI		Backup
	SJMP	edit1		And proceed
edit6	CMPB	AX,#$0D-'0'	Carriage-return?
	JE	prompt1		Report OK
error1	LJMP	ERROR		Report error
*
* Change registers
*
CREGS	LCALL	RDCHRE		Get register
	LD	BX,#UPC		Point to user PC
	CMPB	AX,#'P'		PC?
	JE	cregs1		Yes, handle it
	INC	BX		Advance to flags
	INC	BX		Twice for words
	CMPB	AX,#'F'		Flags?
	JE	cregs1		Yes, handle
	INC	BX		Advance
	INC	BX		ADvance
	CMPB	AX,#'S'		SP?
	JNE	error1		No, report error
cregs1	LCALL	WRSPACE		Seperator
	LD	AX,[BX]		Get value
	LCALL	WRWORD		Output it
	LDB	AX,#'-'		Prompt
	LCALL	WRCHR		Output
	LCALL	RDWORD		Get a word
	JC	error1		Report error
	ST	AX,[BX]		Write new value
prompt1	LJMP	prompt
*
* Set a breakpoint
*
SETBRK	LCALL	RDCHRE		Get character
	SUBB	AX,#'0'		Convert to ASCII
	CMPB	AX,#NBREAK	Are we over?
	JC	error1		Yes, report error
	CLRB	AX+1		Zero high
	SHL	AX,#2		X4 bytes/entry
	ADD	SI,AX,#BRKTAB	Point to table
	LCALL	WRSPACE		Space over
	LCALL	RDWORD		Get a value
	JC	error1		Report error
	ST	AX,[SI]		Write to table
	ST	0,2[SI]		Zero flags
	LJMP	prompt		Exit
*
* Display breakpoints
*
DISBRK	LD	SI,#BRKTAB	Point to breakpoint table
	CLRB	BX		Zero indicator
disbr1	LCALL	WRSPACE		Space over
	LDB	AX,#'B'		Indicator
	LCALL	WRCHR		Output
	ADDB	AX,BX,#'0'	Get ASCII indicator
	LCALL	WRCHR		Output
	LDB	AX,#'='		Seperator
	LCALL	WRCHR		Output
	LD	AX,[SI]		Get address
	LCALL	WRWORD		Display it
	ADD	SI,#4		Offset to next
	INCB	BX		Advance
	CMPB	BX,#NBREAK	Are we over?
	JNC	disbr1		No, keep going
	LJMP	PROMPT		Back to monitor
*
* Get a HEX byte for download (without echo)
*
DLHEX	LCALL	RDHEX		Get character
	JC	DLERROR		Report error
	RET
*
* Download command
*
LOAD	LCALL	WRLFCR		New line
	CLR	CX		Zero count
	ORB	MONCTL,#%00001000 Inhibit output
DLREC	LCALL	RDCHR		Character ready?
	CMPB	AX,#':'		INTEL?
	JE	DLINT		Yes, download intel
	CMPB	AX,#'S'		MOTOROLA?
	JNE	DLREC		No, wait for it
*
* Download a motorola HEX format record
*
DLMOT	LCALL	RDCHR		Get character
	CMPB	AX,#'0'		S0 record?
	JE	DLREC		Ignore
	CMPB	AX,#'9'		EOF record?
	JE	DLEOF		Yes, handle
	CMPB	AX,#'1'		S1 record?
	JNE	DLERROR		No, report error
* Get record count
	SCALL	DLHEX		Get count
	LDB	BX,AX		Start CHECKSUM
	SUBB	AX,#3		Adjust for length
	LDB	BX+1,AX		Save length
	CLRB	AX+1		Zero HIGH
	ADD	CX,AX		Include in total
* Get record address
	SCALL	DLHEX		Get HIGH address
	LDB	SI+1,AX		Set HIGH
	ADDB	BX,AX		Include in checksum
	SCALL	DLHEX		Get LOW address
	LDB	SI,AX		Set HIGH
	ADDB	BX,AX		Include in checksum
* Get data bytes
DLMOT1	SCALL	DLHEX		Get data byte
	STB	AX,[SI]+	Write to memory
	ADDB	BX,AX		Include in checksum
	DJNZ	BX+1,DLMOT1	Do them all
* Get checksum
	SCALL	DLHEX		Get data byte
	ADDB	AX,BX		Include calculated
	INCB	AX		Adjust
	JE	DLREC		OK, get next
*
* Download error has occured
*
DLERROR	ANDB	MONCTL,#%11110111 Allow output
	LCALL	WRMSG		Output message
	STRZ	'?Load error'
dlerr1	CLRB	AX+1,#0		zero count
dlerr2	LCALL	TSTCHR		Any characters?
	ANDB	AX,AX		Yes?
	JNE	dlerr1		Reset count
	DJNZ	AX+1,dlerr2	Wait for clear
	LJMP	PROMPT		Report error
* End of file
DLEOF	ANDB	MONCTL,#%11110111 Allow output
	LD	AX,CX		Get count
	LCALL	WRWORD		Output
	SJMP	dlerr1		Flush & exit
*
* Download record in INTEL format
*
DLINT	SCALL	DLHEX		Get count
	LDB	BX,AX		Start checksum
	LDB	BX+1,AX		Set length
	ANDB	AX,AX		End of file?
	JE	DLEOF		Yes, handle it
	CLRB	AX+1		Zero HIGH
	ADD	CX,AX		Include in total
* Get address
	SCALL	DLHEX		Get HIGH address
	LDB	SI+1,AX		Set HIGH
	ADDB	BX,AX		Include in checksum
	SCALL	DLHEX		Get LOW address
	LDB	SI,AX		Set LOW
	ADDB	BX,AX		Include in checksum
* Get record type
	SCALL	DLHEX		Get type
	ADDB	BX,AX		Include in checksum
* Get data bytes
DLINT1	SCALL	DLHEX		Get data byte
	STB	AX,[SI]+	Write to memory
	ADDB	BX,AX		Include in checksum
	DJNZ	BX+1,DLINT1	Do them all
* Get checksum
	SCALL	DLHEX		Read a byte
	ADDB	AX,BX		Include checksum
	ANDB	AX,AX		Zero
	JNE	DLERROR		Report error
	LJMP	DLREC		Get next
*
* Go (begin execution)
*
GO	LCALL	RDWORD		Get word
	JC	go1		Error
	ST	AX,UPC		Set new PC
	SJMP	go2		And proceed
error2	LJMP	ERROR		Report error
go1	CMPB	AX,#' '-'0'	Special case?
	JNE	error2		No, report error
	LCALL	WRMSG		Output string
	STRZ	'->'		Message
	LD	AX,UPC		Get value
	LCALL	WRWORD		Output
go2	ORB	MONCTL,#%00001100 Inhibit output + redirect STEP
*
* Single-Step one instruction
*
STEP	LD	SI,UPC		Get user PC
	LD	CX,SI		Save SI
	LCALL	DISASS		Disassemble it
	SUB	SI,CX		Calculate length
* Copy instruction into temp buffer
	LDB	AX+1,SI		Get length
	LD	SI,CX		Copy back
	LD	BX,#TBUFF	Point to temp buff
step1	LDB	AX,[CX]+	Get a byte
	STB	AX,[BX]+	Write to buffer
	DJNZ	AX+1,step1	Do them all
* Wait for TX interrupt, and redirect serial int to user
	JBC	MONCTL,5,*	Wait for TX interrupt
	ORB	MONCTL,#%10000000 Redirect serial interrupt to user
* Check for 'transfer' instructions
	LDB	AX,[SI]		Get opcode
* 'BR' branch to register
	CMPB	AX,#$E3		'BR'?
	JNE	step4		No, its NOT
	LDBZE	AX,1[SI]	Get Value
	LD	AX,[AX]		Get address
* Set new PC and exit
step2	ST	AX,UPC		Set user PC
	SJMP	stepend
* 'LJMP' and 'LCALL' long jump/call
step4	CMPB	AX,#$E7		'LJMP'?
	JE	step5		Yes, handle it
	CMPB	AX,#$EF		'LCALL'?
	JNE	step10		No, try next
	LD	BX,USP		Get user SP
	DEC	BX		Backup
	DEC	BX		Backup
	ST	BX,USP		Resave
	ST	CX,[BX]		Write new value
step5	LDB	AX,1[SI]	Get LOW
	LDB	AX+1,2[SI]	Get HIGH
	ADD	AX,CX		Offset
	SJMP	step2		Set PC & exit
* 'RET'
step10	CMPB	AX,#$F0		'RET'?
	JNE	step11		No, try next
	LD	BX,USP		Get user SP
	LD	AX,[BX]+	Get value
	ST	BX,USP		Resave
	SJMP	step2		Set PC & exit
* 'DJNZ'
step11	CMPB	AX,#$E0		'DJNZ'?
	JE	step20		Handle as conditional
* 'SJMP' and 'SCALL' short jump/call
	ANDB	AX,#%11111000	mask XXX address
	CMPB	AX,#$20		'SJMP?'
	JE	step12		Yes, handle it
	CMPB	AX,#$28		'SCALL'?
	JNE	step14		No, try next
	LD	BX,USP		Get user SP
	DEC	BX		Backup
	DEC	BX		Backup
	ST	BX,USP		Resave
	ST	CX,[BX]		Save new address
step12	LDB	AX,1[SI]	Get LOW
	LDB	AX+1,[SI]	Get HIGH
	ANDB	AX+1,#%00000111	Save only address
	JBC	AX+1,2,step13	Not negative
	ORB	AX+1,#%11111000	Sign extend
step13	ADD	AX,CX		Offset
	SJMP	step2		Set PC & exit
* 'JBC' and 'JBS'
step14	CMPB	AX,#$30		'JBC'?
	JE	step20		Handle as conditional
	CMPB	AX,#$38		'JBS'?
	JE	step20		Handle as conditional
* All other conditional jumps
	ANDB	AX,#%11110000	Save only high
	CMPB	AX,#$D0		Conditional jump?
	JNE	step30		No, normal stuff
* Handle conditional jumps by adjusting target address
step20	LDBSE	AX,-1[BX]	Get jump offset
	ADD	AX,CX		Convert to actual address
	ST	AX,UPC		Assume jump taken
	LD	AX,#$0217	New offset + 'INCB'
	STB	AX+1,-1[BX]	Write it
	STB	AX,[BX]+	Write it
	LDB	AX,#AX		Point to our AX
	STB	AX,[BX]+	Write it
	LDB	AX,#$E3		'BR' instruction
	STB	AX,[BX]+	Write it
	LDB	AX,#SI		Use SI register
	STB	AX,[BX]		Write it
	CLRB	AX		Zero LOW
	LD	SI,#step21	Return address
	LD	BX,UPSW		Get user PSW
	PUSH	BX		Save on stack
	POPF			Restore flags
	LJMP	TBUFF		Execute user code
* User code will return here
step21	ANDB	AX,AX		If zero
	JE	stepend		Then jump taken
	ST	CX,UPC		Adjust for no jump
	SJMP	stepend		And go home
* All other instruction are simply executed
step30	ST	CX,UPC		Set new PC
	LDB	AX,#$E3		'BR' instruction
	STB	AX,[BX]+	Write it
	LDB	AX,#SI		Use SI register
	STB	AX,[BX]		Write it
	LD	SP,USP		Get user SP
	LD	SI,#step31	Return address
	LD	AX,UPSW		Get user PSW
	PUSH	AX		Save for later
	POPF			Restore flags
	LJMP	TBUFF		Execute user code
* User code will return here
step31	PUSHF			Save flags
	LD	AX,[SP]		Get value
	POPF			Maintain user flags
	ST	AX,UPSW		Save user PSW
	ST	SP,USP		Save new Stack pointer
* End of stepping
stepend	JBS	MONCTL,2,go3	We are actually 'GO'ing
	LD	AX,#GODEL	Get delay value
step32	DEC	AX		Reduce count
	JNE	step32		Wait for user interrupts
	ANDB	MONCTL,#%01100000 Reclaim serial interrupt
	LDB	INTEN,#%01000000 Insure serial interrupt only enabled
	EI			Insure interrupts enabled
	LJMP	prompt		And proceed
* Proceed to execute at full speed
* First, insert ANY breakpoints
go3	ANDB	MONCTL,#%11110011 Clear inhibit & step redirect flags
	LD	SI,#BRKTAB	Point to breakpoint table
go4	LD	BX,[SI]		Get address
	AND	BX,BX		Breakpoint here?
	JE	go5		No, ignore it
	LDB	AX,[BX]		Get opcode
	STB	AX,2[SI]	Write in table
	LDB	AX,#$F7		Get 'TRAP' opcide
	STB	AX,[BX]		Write in user code
go5	ADD	SI,#4		Skip to next entry
	CMP	SI,#BRKTAB+(NBREAK*4) End of table?
	JNC	go4		No, keep going
* Load user flags & execute
	LD	BX,UPC		Get user PC
	LD	AX,UPSW		Get user PSW
	LD	SP,USP		Get user SP
	PUSH	AX		Save flags
	POPF			Set flags
	BR	BX		Execute user program
*
* Help command
*
HELP	LD	SI,#HTABLE	Point to help table
help1	LCALL	WRLFCR		New line
	LDB	AX+1,#25	Min width
help2	LDB	AX,[SI]+	Get byte
	ANDB	AX,AX		At end?
	JE	help5		Yes, handle ot
	CMPB	AX,#'-'		Separator
	JNE	help4		No, its OK
help3	LCALL	WRSPACE		At least one space
	DJNZ	AX+1,help3	Do them all
	LDB	AX,#'-'		Get it back
	LCALL	WRCHR		Output
	LDB	AX,#' '		Get space
help4	LCALL	WRCHR		Output character
	DECB	AX+1		Reduce count
	SJMP	help2		And proceed
help5	LDB	AX,[SI]		Get next
	ANDB	AX,AX		End of table?
	JNE	help1		No, keep going
	LJMP	prompt		Exit
*
* Serial I/O functions for 8096 family processor
*
* Write message [PC] to serial port
WRMSG	POP	SI		Get register
	SCALL	WRSTR		Output the string
	BR	SI		And proceed
* Write a string [SI] to serial port
WRSTR	LDB	AX,[SI]+	Get char
	ANDB	AX,AX		End of string?
	JE	wrchr1		Yes, exit
	SCALL	WRCHR		Write it
	SJMP	WRSTR		Do it all
* Write a space to the serial port
WRSPACE	LDB	AX,#' '		Get space
	SJMP	WRCHR		Output
* Write address in SI to serial port
WRADDR	LD	AX,SI		Copy addres
* Write word in AX to serial port
WRWORD	PUSH	AX		Save AX
	LDB	AX,AX+1		Get HIGH
	SCALL	WRHEX		Output
	POP	AX		Restore LOW
* Write BYTE in AL to serial port
WRHEX	PUSH	AX		Save for later
	SHRB	AX,#4		Get upper
	SCALL	wrhex1		Write the character
	POP	AX		Restore lower nibble
wrhex1	ANDB	AX,#$0F		Save only lower
	ADDB	AX,#'0'		Convert to ASCII
	CMPB	AX,#'9'+1	In range?
	JNC	WRCHR		Ok to output
	ADDB	AX,#7		Adjust alphas
* Write char in AX
WRCHR	JBS	MONCTL,3,wrchr1	Output is inhibited
	JBC	MONCTL,5,*	Wait till empty
	ANDB	MONCTL,#%11011111 Clear flag
	LDB	SPDATA,AX	Write char to uart
wrchr1	RET
*
* Write a newline (LFCR) to the serial port
*
WRLFCR	SCALL	TSTCHR		Any characters received?
	CMPB	AX,#$1B		Escape?
	JNE	wrlfcr1		No, continue
	LJMP	prompt		Exit
wrlfcr1	CMPB	AX,#' '		Halt output
	JNE	wrlfcr2		No, continue
	JBS	MONCTL,4,wrlfcr4 Already paused
	ORB	MONCTL,#%00010000 Set flag
	SJMP	WRLFCR		And wait
wrlfcr2	CMPB	AX,#$0D		Return?
	JNE	wrlfcr3		No, wait for it
	ANDB	MONCTL,#%11101111 Clear flag
wrlfcr3	JBS	MONCTL,4,WRLFCR	Wait if paused
wrlfcr4	LDB	AX,#$0A		LINE-FEED
	SCALL	WRCHR		Output
	LDB	AX,#$0D		CARRIAGE-RETURN
	SJMP	WRCHR		Output
*
* Read a character with echo
*
RDCHRE	SCALL	RDCHR		Read the character
	CMP	AX,#' '		Printable?
	JC	WRCHR		Echo if so
	RET
*
* Read a HEX range into SI,BX
*
RDRANGE	SCALL	RDWORD		Get first word
	JC	rdrang2		Report error
	LD	SI,AX		Set SI
	LDB	AX,#','		Separator
	SCALL	WRCHR		Echo it
	SCALL	RDWORD		Get second word
	JNC	rdrang1		Its OK
	CMPB	AX,#' '-'0'	Special case?
	JNE	rdrang2		No, error
	LD	AX,#-1		Get -1
	LD	BX,AX		Set BX
	SJMP	WRWORD		Echo it
rdrang1	INC	AX		Advance
	LD	BX,AX		Get result
	RET
rdrang2	LJMP	ERROR		Report error
*
* Read a hex WORD from the serial port
*
RDWORD	SCALL	RDHEX		Get high byte
	JC	wrchr1		Report error
	LDB	AX+1,AX		Set HIGH
*
* Get a HEX byte from the serial port
*
RDHEX	PUSH	BX		Save BX
	SCALL	RDNIB		Get nibble
	JC	rdhex1		Error
	SHLB	AX,#4		Shift it over
	LDB	BX,AX		Save HIGH
	SCALL	RDNIB		Get nibble
	JC	rdhex1		Error
	ORB	AX,BX		Include remaining
rdhex1	POP	BX		Restore BX
	RET
*
* Get a HEX NIBBLE from the serial port
*
RDNIB	SCALL	RDCHRE		Read a character
	SUBB	AX,#'0'		Convert?
	JNC	rdnib3		Error
	CMPB	AX,#10		In range?
	JNC	rdnib2		Yes, its OK
	SUBB	AX,#7		Convert alphas
	CMPB	AX,#10		In range?
	JNC	rdnib3		No, error
	CMPB	AX,#16		In range?
	JC	rdnib3		No, error
rdnib2	CLRC			Clear carry - OK
	RET
rdnib3	SETC			Set carry - Error
	RET
*
* Receive char from the serial port
*
RDCHR	JBC	MONCTL,6,*	Wait for RX bit
rdchr1	ANDB	MONCTL,#%10111111 Clear flag
	LDB	AX,SPDATA	Read char
	CMPB	AX,#'a'		Lower?
	JNC	rdchr2		No, its OK
	CMPB	AX,#'z'+1	Lower?
	JC	rdchr2		No, its ok
	ANDB	AX,#%11011111	Convert to upper
rdchr2	RET
*
* Test for character from serial port
*
TSTCHR	CLRB	AX		Zero value
	JBS	MONCTL,6,rdchr1	Character is ready
	RET
*
* Interrupt handler for serial port...
* Simulates "normal" RX and TX ready bits by setting bits in our
* own status register when the Receive or Transmit interrupt occurs.
*
SERINT	JBS	MONCTL,7,serin1	Redirect to user
	PUSHF			Save flags
	PUSH	AX		Save AX
	ANDB	AX,SPCTRL,#%01100000 Get flags
	ORB	MONCTL,AX	Set interrupt state
	POP	AX		Restore AX
	POPF			Restore flags
	RET
*
* General Interrupt handlers, simple re-direct the interrupt through
* a vector at the corresponding offset into user RAM
*
serin1	LD	AX,USERRAM+$0C	Get user vector
	BR	AX		And execute
TOVVEC	LD	AX,USERRAM+$00	Get user vector
	BR	AX		And execute
ADCVEC	LD	AX,USERRAM+$02	Get user vector
	BR	AX		And execute
HSIVEC	LD	AX,USERRAM+$04	Get user vector
	BR	AX		And execute
HSOVEC	LD	AX,USERRAM+$06	Get user vector
	BR	AX		And execute
HS0VEC	LD	AX,USERRAM+$08	Get user vector
	BR	AX		And execute
TIMVEC	LD	AX,USERRAM+$0A	Get user vector
	BR	AX		And execute
EXTINT	LD	AX,USERRAM+$0E	Get user vector
	BR	AX		And execute
*
* Breakpoint handler...
* Save user Program Counter, Flags and Stack Pointer
* Scan breakpoint table and replace any patched opcodes
* Report breakpoint encountered & register contents
*
BRKTRAP	POP	CX		Get return address
	PUSHF			Save flags
	LD	BX,[SP]		Get value
	POPF			Maintain user flags
	ST	SP,USP		Save User stack
	LD	SP,#STACK	Switch to our stack
	ST	BX,UPSW		Save user flags
	DEC	CX		Backup to 'trap'
	ST	CX,UPC		Save user PC
* Search breakpoint table & see if this is our "trap"
	LD	BX,#BRKTAB	Point to table
	LDB	AX,#NBREAK	Get # breakpts
brkt1	LD	SI,[BX]		Get address
	CMP	SI,CX		Is this a breakpoint?
	JE	brkt2		Yes it is
	ADD	BX,#4		Advance
	DJNZ	AX,brkt1	Search entire table
* This TRAP is not a breakpoint, vector to user
	LD	AX,USERRAM+$10	Get user TRAP vector
	LD	BX,UPSW		Get user flags
	PUSH	BX		Make then addressable
	POPF			Restore user flags
	PUSH	CX		Resave return address
	BR	AX		Execute user handler
* Proceed with breakpoint handling
brkt2	LD	AX,#GODEL	Delay for interrupts
brkt3	DEC	AX		Reduce
	JNE	brkt3		Wait for user interrupts
	ANDB	MONCTL,#%01100000 Switch to our interrupt
	LDB	INTEN,#%01000000 Enable serial INTERRUPT
	EI			Re-enable interrupts
* Replace breakpoint code
	LD	BX,#BRKTAB	Point to breakpoint table
	CLRB	AX+1		Zero indicator
brkt4	LD	SI,[BX]		Get address
	ANDB	SI,SI		Breakpoint in use?
	JE	brkt5		No, go to next
	LDB	AX,2[BX]	Get opcode
	STB	AX,[SI]		Replace in user code
	CMPB	SI,CX		Is this one?
	JNE	brkt5		No, continue
* Report that we are on a breakpoint
	LCALL	WRMSG		Output message
	DB	$0A,$0D		New line
	STRZ	'**Breakpoint '
	ADDB	AX,AX+1,#'0'	Get ASCII indicator
	LCALL	WRCHR		Output
brkt5	ADD	BX,#4		Skip to next
	INCB	AX+1		Advance
	CMPB	AX+1,#NBREAK	Are we at end?
	JNC	brkt4		No, keep going
	LCALL	WRMSG		Output message
	STRZ	' : '		Separator
*
* Display Processor registers
*
RDISP	LD	SI,#RTABLE	Point at register table
	LD	BX,#UPC		Point to user PC
	SCALL	rdisp1		Display PC
	SCALL	rdisp1		Display FLAGS
	SCALL	rdisp1		Display SP
	LJMP	prompt
rdisp1	LCALL	WRSTR		Output string
	LD	AX,[BX]+	Get char
	LJMP	WRWORD		Display value
*
* Dis-assemble
*
* First, lookup opcode in table
DISASS	PUSH	BX		Save BX
	PUSH	CX		Save CX
	LCALL	WRADDR		Output address in SI
	LCALL	WRSPACE		Output space
	LDB	CX,#7		Max size of instruction
	LD	BX,#DTABLE	Point to DISASS table
	LDB	AX,[SI]		Get opcode
	CMPB	AX,#$FE		"Magic" prefix?
	JNE	disa1		Nom, ignore it
	LCALL	WRHEX		Output
	LCALL	WRSPACE		Seperator
	LD	BX,#PTABLE	New table
	INC	SI		Advance address
	DECB	CX		Reduce count
disa1	LDB	AX+1,[BX]+	Get flag byte
disa2	LDB	AX,[SI]		Get opcode
	JBS	AX+1,7,disa3	Hack off lower two
	JBC	AX+1,5,disa4	Nothing special
	ANDB	AX,#%11111000	Remove lower three
disa3	ANDB	AX,#%11111100	Remove lower two
disa4	CMPB	AX,[BX]+	Is this it?
	JE	disa6		Yes, proceed
disa5	LDB	AX,[BX]+	Get next byte
	ANDB	AX,AX		End of entry?
	JNE	disa5		No, keep trying
	LDB	AX+1,[BX]+	Get flag byte
	ANDB	AX+1,AX+1	End of table?
	JNE	disa2		No, keep going
	INCB	AX+1		Advance it
* Determine length of instruction
disa6	JBC	AX+1,7,disa9	No special case
	LDB	CX+1,[SI]	Get opcode back
	ANDB	CX+1,#%00000011	Register direct?
	JE	disa9		No extra length
	CMPB	CX+1,#%00000010	Indirect?
	JE	disa9		No extra length
	CMPB	CX+1,#%00000001	Immediate
	JNE	disa7		No, try next
	JBC	AX+1,6,disa8	16 bit
	SJMP	disa9		And proceed
* Indexed, use either 8 or 16 bit offset
disa7	LDB	AX,1[SI]	Get operand byte
	JBC	AX,0,disa8	Only +1
	INCB	AX+1		Offset two
	ORB	AX+1,#%00100000	Indicate +2
disa8	INCB	AX+1		Add another
	ORB	AX+1,#%00010000	Indicate +1
* Display opcode bytes
disa9	LDB	CX+1,AX+1	Get length
	ANDB	CX+1,#%00001111	Save only length
	PUSH	SI		Save pointer
disa10	LDB	AX,[SI]+	Get byte
	LCALL	WRHEX		Display it
	LCALL	WRSPACE		Output space
	DECB	CX		Reduce count
	DJNZ	CX+1,disa10	And proceed
disa11	ANDB	CX,CX		End of list
	JE	disa12		Yes, proceed
	DECB	CX		Reduce count
	LCALL	WRSPACE		Space over
	LCALL	WRSPACE		Space over
	LCALL	WRSPACE		Space over
	SJMP	disa11		And go again
disa12	POP	SI		Restore pointer
* Display disassembly text
	LDB	CX,#6		Max length of instruction
disa13	LDB	AX,[BX]+	Get data byte
	CMPB	AX,#' '		Space?
	JE	disa14		Yes, handle it
	JBS	AX,7,disa16	Special case
	ANDB	AX,AX		End of table?
	JE	disa15		Yes, exit
	DECB	CX		Reduce count
	LCALL	WRCHR		Output character
	SJMP	disa13		and proceed
* Space over to command
disa14	LCALL	WRSPACE		Output space
	DJNZ	CX,disa14	Do them all
	SJMP	disa13		Line it up
disa15	LDB	AX,AX+1		Get length
	AND	AX,#%00001111	Save only length
	ADD	SI,AX		Skip to next
	POP	CX		Restore CX
	POP	BX		Restore BX
	RET
* Special case, output a disass operand
disa16	PUSH	AX		Save
	AND	AX,#%00001111	Offset only
	ADD	CX,SI,AX	Offset to value
	POP	AX		Restore type/length
	PUSH	AX		Resave AX
	ANDB	AX,#%11110000	Save only type
* Addressable operand
	CMPB	AX,#$80		Wprd operand?
	JNE	disa21		No, try next
	LDB	AX,[SI]		Get opcode
	ANDB	AX,#%00000011	Register direct?
	JE	disa22		Yes, handle it
* Handle IMMEDIATE addressing
	CMPB	AX,#%00000001	Immediate?
	JNE	disa17		No, try next
	LDB	AX,#'#'		Immediate indicator
	LCALL	WRCHR		Output
	JBC	AX+1,4,disa22	Output 8 bit
	LDB	AX,1[CX]	Get HIGH
	LCALL	WRHEX		Output
	SJMP	disa22		Do LOW
* Handle INDIRECT addressing
disa17	CMPB	AX,#%00000010	Indirect?
	JNE	disa19		No, try next
	LDB	AX,#'['		Indirection
	LCALL	WRCHR		Output
	LDB	AX,[CX]		Get address
	ANDB	AX,#%11111110	Even it out
	LCALL	WRHEX		Output
	LDB	AX,#']'		Closing
	LCALL	WRCHR		Output
	LDB	AX,[CX]		Get opcode back
	JBC	AX,0,disa23	No inc.
	LDB	AX,#'+'		Auto-inc
	LCALL	WRCHR		Output
disa18	SJMP	disa23		And proceed
* Handle INDEXED addressing
disa19	JBC	AX+1,5,disa20	Long
	LDB	AX,2[CX]	Get HIGH
	LCALL	WRHEX		Output
disa20	LDB	AX,1[CX]	Get LOW
	LCALL	WRHEX		Output 8 bits
	LDB	AX,#'['		Indicator
	LCALL	WRCHR		Output
	LDB	AX,[CX]		Get value
	ANDB	AX,#%11111110	Drop LOW
	LCALL	WRHEX		Output
	LDB	AX,#']'		Get closing
	LCALL	WRCHR		Output
	SJMP	disa23		And proceed
* Register file address
disa21	CMPB	AX,#$90		Register file?
	JNE	disa24		No, try next
	JBC	AX+1,4,disa22	No special
	INC	CX		Skip extra
	JBC	AX+1,5,disa22	No special
	INC	CX		Skip extra
disa22	LDB	AX,[CX]		Get value
	LCALL	WRHEX		Write it
disa23	POP	AX		Restore AX
	SJMP	disa13
* 8 bit displacement
disa24	CMPB	AX,#$A0		Just dsplacement?
	JNE	disa25		No, try next
	LDBSE	AX,[CX]+	Get displacement
	ADD	AX,CX		Calculate address
	LCALL	WRWORD		Output word
	SJMP	disa23		And proceed
* 16 bit displacement
disa25	CMPB	AX,#$B0		Long displacement
	JNE	disa26		No, try next
	LDB	AX,[CX]+	Get LOW
	LDB	AX+1,[CX]+	Get HIGH
	ADD	AX,CX		Calculate address
	LCALL	WRWORD		Output word
	SJMP	disa23		And proceed
* Special register
disa26	CMPB	AX,#$C0		Special register?
	JNE	disa27		No, try next
	LDB	AX,[CX]		Get value
	CMPB	AX,#16		In range?
	JC	disa22		Yes, its OK
	LDB	AX,#'#'		Immediate
	LCALL	WRCHR		Output
	SJMP	disa22		And proceed
* 11 Bit displacement
disa27	CMPB	AX,#$D0		11 bit displacement?
	JNE	disa29		No, try bit address
	LDB	AX,[CX]+	Get LOW value
	LDB	AX+1,[SI]	Get HIGH value
	ANDB	AX+1,#%00000111	Save only displacement
	JBC	AX+1,2,disa28	Not negative
	ORB	AX+1,#%11111000	Sign extend
disa28	ADD	AX,CX		Calculate address
	LCALL	WRWORD		Output word
	SJMP	disa23		And proceed
* Bit address
disa29	LDB	AX,[SI]		Get opcode
	ANDB	AX,#%00000111	Save BIT number
	ADDB	AX,#'0'		Convert to ASCII
	LCALL	WRCHR		Output value
	SJMP	disa23		And proceed
*
* Disassembly table
* Prefix:	80 = Word OP
*		40 = Byte OP
* Operands:	$8x - Addressable operand
*		$9x - Register op
*		$Ax - 8-bit displacement
*		$Bx - 16-bit displacement
*		$Cx - Special register (immediate for shifts)
*		$Dx - 11 bit displacement
*		$Ex - bit address
*
DTABLE	DB	$83,$64,'A','D','D',' ',$92,',',$81,0
	DB	$84,$44,'A','D','D',' ',$93,',',$92,',',$81,0
	DB	$C3,$74,'A','D','D','B',' ',$92,',',$81,0
	DB	$C4,$54,'A','D','D','B',' ',$93,',',$92,',',$81,0
	DB	$83,$A4,'A','D','D','C',' ',$92,',',$81,0
	DB	$C3,$B4,'A','D','D','C','B',' ',$92,',',$81,0
	DB	$83,$60,'A','N','D',' ',$92,',',$81,0
	DB	$84,$40,'A','N','D',' ',$93,',',$92,',',$81,0
	DB	$C3,$70,'A','N','D','B',' ',$92,',',$81,0
	DB	$C4,$50,'A','N','D','B',' ',$93,',',$92,',',$81,0
	DB	$02,$E3,'B','R',' ',$91,0
	DB	$02,$01,'C','L','R',' ',$91,0
	DB	$02,$11,'C','L','R','B',' ',$91,0
	DB	$01,$F8,'C','L','R','C',0
	DB	$01,$FC,'C','L','R','V','T',0
	DB	$83,$88,'C','M','P',' ',$92,',',$81,0
	DB	$C3,$98,'C','M','P','B',' ',$92,',',$81,0
	DB	$02,$05,'D','E','C',' ',$91,0
	DB	$02,$15,'D','E','C','B',' ',$91,0
	DB	$01,$FA,'D','I',0
* DIV + DIVB
	DB	$83,$8C,'D','I','V','U',' ',$92,',',$81,0
	DB	$C3,$9C,'D','I','V','U','B',' ',$92,',',$81,0
	DB	$03,$E0,'D','J','N','Z',' ',$91,',',$A2,0
	DB	$01,$FB,'E','I',0
	DB	$02,$06,'E','X','T',' ',$91,0
	DB	$02,$16,'E','X','T','B',' ',$91,0
	DB	$02,$07,'I','N','C',' ',$91,0
	DB	$02,$17,'I','N','C','B',' ',$91,0
	DB	$23,$30,'J','B','C',' ',$91,',',$E0,',',$A2,0
	DB	$23,$38,'J','B','S',' ',$91,',',$E0,',',$A2,0
	DB	$02,$DB,'J','C',' ',$A1,0
	DB	$02,$DF,'J','E',' ',$A1,0
	DB	$02,$D6,'J','G','E',' ',$A1,0
	DB	$02,$D2,'J','G','T',' ',$A1,0
	DB	$02,$D9,'J','H',' ',$A1,0
	DB	$02,$DA,'J','L','E',' ',$A1,0
	DB	$02,$DE,'J','L','T',' ',$A1,0
	DB	$02,$D3,'J','N','C',' ',$A1,0
	DB	$02,$D7,'J','N','E',' ',$A1,0
	DB	$02,$D1,'J','N','H',' ',$A1,0
	DB	$02,$D0,'J','N','S','T',' ',$A1,0
	DB	$02,$D5,'J','N','V',' ',$A1,0
	DB	$02,$D4,'J','N','V','T',' ',$A1,0
	DB	$02,$D8,'J','S','T',' ',$A1,0
	DB	$02,$DD,'J','V',' ',$A1,0
	DB	$02,$DC,'J','V','T',' ',$A1,0
	DB	$03,$EF,'L','C','A','L','L',' ',$B1,0
	DB	$83,$A0,'L','D',' ',$92,',',$81,0
	DB	$C3,$B0,'L','D','B',' ',$92,',',$81,0
	DB	$C3,$BC,'L','D','B','S','E',' ',$92,',',$81,0
	DB	$C3,$AC,'L','D','B','Z','E',' ',$92,',',$81,0
	DB	$03,$E7,'L','J','M','P',' ',$B1,0
	DB	$83,$6C,'M','U','L','U',' ',$92,',',$81,0
	DB	$84,$4C,'M','U','L','U',' ',$93,',',$92,',',$81,0
	DB	$C3,$7C,'M','U','L','U','B',' ',$92,',',$81,0
	DB	$C4,$5C,'M','U','L','U','B',' ',$93,',',$92,',',$81,0
	DB	$02,$03,'N','E','G',' ',$91,0
	DB	$02,$13,'N','E','G','B',' ',$91,0
	DB	$01,$FD,'N','O','P',0
	DB	$03,$0F,'N','O','R','M','L',' ',$92,',',$91,0
	DB	$02,$02,'N','O','T',' ',$91,0
	DB	$02,$12,'N','O','T','B',' ',$91,0
	DB	$83,$80,'O','R',' ',$92,',',$81,0
	DB	$C3,$90,'O','R','B',' ',$92,',',$81,0
	DB	$82,$CC,'P','O','P',' ',$81,0
	DB	$01,$F3,'P','O','P','F',0
	DB	$82,$C8,'P','U','S','H',' ',$81,0
	DB	$01,$F2,'P','U','S','H','F',0
	DB	$01,$F0,'R','E','T',0
	DB	$01,$FF,'R','S','T',0
	DB	$22,$28,'S','C','A','L','L',' ',$D1,0
	DB	$01,$F9,'S','E','T','C',0
	DB	$03,$09,'S','H','L',' ',$92,',',$C1,0
	DB	$03,$19,'S','H','L','B',' ',$92,',',$C1,0
	DB	$03,$0D,'S','H','L','L',' ',$92,',',$C1,0
	DB	$03,$08,'S','H','R',' ',$92,',',$C1,0
	DB	$03,$18,'S','H','R','B',' ',$92,',',$C1,0
	DB	$03,$0C,'S','H','R','L',' ',$92,',',$C1,0
	DB	$03,$0A,'S','H','R','A',' ',$92,',',$C1,0
	DB	$03,$1A,'S','H','R','A','B',' ',$92,',',$C1,0
	DB	$03,$0E,'S','H','R','A','L',' ',$92,',',$C1,0
	DB	$22,$20,'S','J','M','P',' ',$D1,0
	DB	$02,$00,'S','K','I','P',' ',$91,0
	DB	$83,$C0,'S','T',' ',$92,',',$81,0
	DB	$C3,$C4,'S','T','B',' ',$92,',',$81,0
	DB	$83,$68,'S','U','B',' ',$92,',',$81,0
	DB	$84,$48,'S','U','B',' ',$93,',',$92,',',$81,0
	DB	$C3,$78,'S','U','B','B',' ',$92,',',$81,0
	DB	$C4,$58,'S','U','B','B',' ',$93,',',$92,',',$81,0
	DB	$83,$A8,'S','U','B','C',' ',$92,',',$81,0
	DB	$C3,$B8,'S','U','B','C','B',' ',$92,',',$81,0
	DB	$01,$F7,'T','R','A','P',0
	DB	$83,$84,'X','O','R',' ',$92,',',$81,0
	DB	$C3,$94,'X','O','R','B',' ',$92,',',$81,0
	DB	0,'?','?','?',0
* Table of prefixed opcodes
PTABLE	DB	$83,$8C,'D','I','V',' ',$92,',',$81,0
	DB	$C3,$9C,'D','I','V','B',' ',$92,',',$81,0
	DB	$83,$6C,'M','U','L',' ',$92,',',$81,0
	DB	$84,$4C,'M','U','L',' ',$93,',',$92,',',$81,0
	DB	$C3,$7C,'M','U','L','B',' ',$92,',',$81,0
	DB	$C4,$5C,'M','U','L','B',' ',$93,',',$92,',',$81,0
	DB	0,'?','?','?',0
*
* Register display table
*
RTABLE	STRZ	'PC='
	STRZ	' Flags='
	STRZ	' SP='
*
* Help text table
*
HTABLE	STR	'MON96 Commands:'
	DB	$0A,0
	STRZ	'B <b> <addr>-Set breakpoint'
	STRZ	'CR <r> <value>-Change register'
	STRZ	'DB-Display breakpoints'
	STRZ	'DI <addr>,[addr]-Disassemble memory'
	STRZ	'DM <addr],[addr]-Dump memory (hex/ASCII)'
	STRZ	'DR-Display registers'
	STRZ	'E <addr>-Edit memory'
	STRZ	'FM <addr>,[addr] <value>-Fill memory'
	STRZ	'G [addr]-Go (begin execution)'
	STRZ	'L-Load from host'
	STRZ	'MM <addr>,<addr> <addr>-Move memory'
	STRZ	'S-Step one instruction'
	DB	0
*
* Command handler table
*
	ORG	(*+1)&$FFFE
CTABLE	DW	DISPLAY,'DM'	Dump memory
	DW	DISASM,'DI'	Disassemble
	DW	DISBRK,'DB'	Display breakpoints
	DW	RDISP,'DR'	Display registers
	DW	MOVE,'MM'	Move Memory
	DW	EDIT,'E'	Edit memory
	DW	FILL,'FM'	Fill memory
	DW	GO,'G'		Go (execute)
	DW	LOAD,'L'	Load from port
	DW	STEP,'S'	Step
	DW	CREGS,'CR'	Change registers
	DW	SETBRK,'B'	Set breakpoint
	DW	HELP,'?'	Help request
	DW	0		End of table
