#include <stdio.h>
#include <window.h>
#define	NAME	PC100

unsigned char instructions[] = { "\
This program helps you to search for a 132x25 text mode supported by your\n\
video card that is compatible with "#NAME". Although there is no standard PC\n\
132x25 text mode, some card manufacturers provide proprietary mode settings\n\
which provide this capability.\n\n\
This program will try all of the video modes which your video card accepts,\n\
stopping only on ones which appear to be text modes. What you are looking\n\
for is a white box which completely fills the screen, with two unbroken black\n\
lines running around the outer edge - similar to the one you should see on\n\
your screen now.\n\n\
You should also see the currently active mode displayed (in decimal, the same\n\
way "#NAME" requires it), and a scale running from columns 1 to 130.\n\n\
When each mode has been set, the PC will sound a short beep. Press SPACE to\n\
try the next mode, or ESC to restore the original mode and exit the program.\n\n\
NOTE: Monitors may take a moment to adjust to a new mode, and may not display\n\
immediately. There is also a potential that SOME MODES MAY DAMAGE YOUR MONITOR\n\
if left active for two long. If you do not see video within a couple seconds\n\
of hearing the beep, press SPACE immediately to continue to the next mode.\n\n\
Press SPACE to proceed, or ESC to cancel." };

unsigned char help[] = { "\n\
Use: FIND132 [starting mode]\n\n\
  Modes 0-255 are standard modes.\n\
	256-511 are VESA modes.\n\
\nDave Dunfield - "#__DATE__"\n" };

unsigned
	om,
	m;
unsigned char
	buffer[1024];

setmode(c) asm
{
		MOV		AX,4[BP]
		AND		AH,AH				; Vesa?
		JNZ		vesa				; Handle it
		INT		10h					; Ask BIOS
		MOV		AH,0Fh				; Get mode
		INT		10h					; Ask BIOS
		CMP		AL,4[BP]			; Does it match?
		JNZ		ret0				; No
ret1:	MOV		AX,255				; Indicate success
		POP		BP
		RET
vesa:	MOV		BX,AX				; New mode
		MOV		AX,4F02h			; VESA set-mode
		INT		10h					; Ask BIOS
		CMP		AX,004Fh			; Success?
		JZ		ret1				; Yes
ret0:	XOR		AX,AX				; Return 0		
}
getmode() asm
{
	MOV		AH,0Fh
	INT		10h
	XOR		AH,AH
}
testvesa() asm
{
	MOV		AX,DS
	MOV		ES,AX
	MOV		DI,OFFSET DGRP:_buffer
	MOV		AX,4F00h
	INT		10h
	SUB		AX,004Fh
}
main(int argc, char *argv[])
{
	unsigned i;
	unsigned char f, vesa;

	if(argc > 1) {
		if((argc > 2) || !isdigit(*argv[1]))
			abort(help);
		m = atoi(argv[1]); }

	om = getmode();

	wopen(f=vesa=0, 0, 80, 25, WSAVE|WBOX2|WCOPEN|REVERSE);
	wputs(instructions);
	for(;;) switch(wgetc()) {
		case ' ' :
			wclose();
			f = 0;
			goto next;
		case 0x1B:
			wclose();
			return; }

next:
	if((m & 0xFF00) && !vesa) {
		setmode(om);
		if(testvesa()) {
			printf("VESA modes not supported by this card.\n");
			return; }
		printf("Trying VESA modes... Press SPACE to proceed, ESC to exit.\n");
		for(;;) switch(kbget()) {
		case ' ' : goto vok;
		case 0x1B:
			return; }
vok:	vesa = 255; }
	if(m >= 0x200) {
		setmode(om);
		printf("No more video modes available.\n");
		return; }
	if(kbtst() == 0x1B) {
		setmode(om);
		printf("Last mode tried: %u\n", m-1);
		return; }
	for(i=0; i < 256; ++i) {
		poke(0xB000, i, 0xAA);
		poke(0xB800, i, 0xAA); }
	if(setmode(m)) {
		f = 255;
		if((peek(0xB000,0) != ' ') && (peek(0xB800,0) != ' ')) {
			++m;
			goto next; }
		wopen(0, 0, 132, 25, WSAVE|WBOX2|WCOPEN|REVERSE);
		wprintf("Mode: %u\n", m, m);
		for(i=1; i < 131; ++i)
			wputc((i%10)+'0');
		for(i=10; i < 132; i += 10) {
			wgotoxy(i-1, 2);
			wputc(0xB3);
			wgotoxy(i-3, 3);
			wprintf("%3u", i); }
		beep(1000, 55);
		for(;;) switch(wgetc()) {
		case ' ' :
			wclose();
			++m;
			goto next;
		case 0x1B:
			wclose();
			setmode(om);
			return; } }
	if(f)
		setmode(om);
	printf("Trying: %u\n", ++m);
	delay(55);
	goto next;
}

