/*
 * VT-100 checkup program
 *
 * ?COPY.TXT 1989-2008 Dave Dunfield
 *  -- see COPY.TXT --.
 */
#include <stdio.h>
#include <video.h>
#define	TICK	peekw(0x40,0x6C)

char mode = 1,  /* 1 = VT100, 0 = VT52 */
	buffer[80];

/* communications port status & data registers */
unsigned com_base = 0x3f8, com_stat = 0x03fd;

/* 8250 uart baud rate conversion table */
unsigned baud[] = {
	2304,	1536,	1047,	857,	768,	576,	384,	192,	96, 	64,
	58,		48,		32,		24,		12,
	6 };
unsigned rate[] = {
	50,		75,		110, 	135, 	150, 	200, 	300, 	600, 	1200, 	1800,
	2000, 2400, 3600, 4800, 9600,
	19200, 0 };

char *partab[] = { "Odd", "Even", "Mark", "Space", "None", 0 };

char baud_rate = 14, parity = 4, dbits = 3, sbits = 0;

/* color name table */
char *colors[] = { "Black", "Red", "Green", "Yellow",
	"Blue", "Magenta", "Cyan", "White" };

unsigned *run_ptr;

/*
 * Special "getc" to bypass DOS.
 * Read a character directly from the COM port
 */
ctestc()
{
	char c;

	asm {
		MOV		DX,_com_stat; Point to status register
		XOR		AH,AH		; Zero high
		IN		AL,DX		; Read uart status
		AND		AL,01h		; Character received?
		JZ		cgetc1		; No, wait for it
		MOV		DX,_com_base; Point to data register
		IN		AL,DX		; Read character
		MOV		SP,BP
		POP		BP
		RET
cgetc1:
	}
	if(c = vtstc())
		return (c == '\n') ? '\r' : c;
}

cgetc()
{
	int c;
	while(!(c = ctestc()));
	return c;
}

unsigned
	Parms,
	Value[10];
unsigned char
	String[100];

cgets()
{
	char c;
	unsigned t, l, t1;
	l = 0;
	t = TICK;
	t1 = 10;
	for(;;) {
		if(c = ctestc()) {
			String[l++] = c;
			if(l > 98)
				break;
			t = TICK;
			t1 = 3;
			continue; }
		if((TICK - t) > t1)
			break; }
	String[l] = 0;
}


/*
 * Special "putc" to bypass DOS.
 * Write a character directly to the COM port
 */
cputc(chr) asm
{
cputc1:	MOV		DX,_com_stat; Point to status port
cputc2:	IN		AL,DX		; Read uart status
		TEST	AL,01h		; Character received?
		JNZ		cputc3		; Special case, handle
		AND		AL,20h		; Ok to transmit?
		JZ		cputc2		; No, wait for it
		MOV		AX,4[bp]	; Get character
		MOV		DX,_com_base; Point to data port
		OUT		DX,AL		; Write the character
		JMP		SHORT cputc6; And exit
; character has been received
cputc3: MOV		DX,_com_base; point to data port
		IN		AL,DX		; Read the data
		CMP		AL,'S'-40h	; Is it XOFF?
		JNZ		cputc1		; No, its not
; XOFF received, wait for an XON
cputc4:	MOV		DX,_com_stat; Point to status port
cputc5:	IN		AL,DX		; Read uart status
		TEST	AL,01h		; Receiver ready?
		JZ		cputc5		; No, wait for it
		MOV		DX,_com_base; Point to data port
		IN		AL,DX		; Read the character
		CMP		AL,'Q'-40h	; is it XON?
		JNZ		cputc4		; No, keep looking
		JMP		cputc1		; Send data char
cputc6:
}

/*
 * Special "printf" to write to the COM port
 */
register cprintf(args)
	unsigned args;
{
	char *ptr, buffer[100];

	_format_(nargs() * 2 + &args, buffer);
	for(ptr = buffer; *ptr; ++ptr)
		cputc(*ptr);
}

showstring()
{
	unsigned char c, *p;
	p = String;
	while(c = *p++) {
		if(c < ' ') {
			cputc('^');
			c += '@'; }
		cputc(c); }
}

// Parse input string into values
parse(unsigned char *match)
{
	unsigned v;
	unsigned char c, *p;
	Parms = 0;
	p = String;
	for(;;)	switch(c = *match++) {
		case 0 :
			return *p ? 0 : 255;
		case '#' :
			v = 0;
			while(isdigit(*p))
				v = (v * 10) + (*p++ - '0');
			Value[Parms++] = v;
			continue;
		default:
			if(*p++ != c)
				return 0; }
}

/*
 * Set the terminal mode (VT100 / VT52)
 */
setmode(m)
	int m;
{
	if(m != mode) {
		cls();
		tty_box(20, 10, 40, 2);
		tty_xy(30, 11);
		cprintf("Now entering %s mode", m ? "VT100" : "VT52");
		wait_prompt();
		cprintf((mode = m) ? "\x1b<" : "\x1b[?2l"); }
}

/*
 * Clear terminal screen
 */
cls()
{
	cprintf(mode ? "\x1b[H\x1b[J" : "\x1bH\x1bJ");
}

/*
 * Position terminal cursor
 */
tty_xy(x, y)
		int x, y;
{
	if(mode)
		cprintf("\x1b[%u;%uH", y, x);
	else
		cprintf("\x1bY%c%c", y+0x1f, x+0x1f);
}

/*
 * Draw a box in VT100 graphics characters
 */
tty_box(x, y, w, h)
		int x, y, w, h;
{
	int i;
	char c1, c2;

	c1 = (mode < 2) ? 'q' : '-';
	c2 = (mode < 2) ? 'x' : '|';

	tty_xy(x, y);
	if(mode < 2)
		cprintf(mode ? "\x1b)0\x0el" : "\x1bFl");
	else
		cputc('+');
	for(i=1; i < w; ++i)
		cputc(c1);
	cputc((mode < 2) ? 'k' : '+');
	tty_xy(x, y+h);
	cputc((mode < 2) ? 'm' : '+');
	for(i=1; i < w; ++i)
		cputc(c1);
	cputc((mode < 2) ? 'j' : '+');
	--h; ++y;
	for(i=0; i < h; ++i) {
		tty_xy(x, i+y);   cputc(c2);
		tty_xy(x+w, i+y); cputc(c2); }
	if(mode < 2);
		cprintf(mode ? "\x0f" : "\x1bG");
}

tty_text(unsigned x, unsigned y, unsigned char *string)
{
	int c;
	unsigned w, h, l;

	l = w = 0;
	h = 1;
repo:	tty_xy(x+1, y+h);
	for(;;) switch(c = *string++) {
		case 0 :
			if(l > w)
				w = l;
			tty_box(x, y, w+1, h+1);
			return;
		case '\n' :
			if(l > w)
				w = l;
			l = 0;
			++h;
			goto repo;
		default:
			cputc(c);
			++l; }
}

tty_ceol()
{
	cprintf(mode ? "\x1B[K" : "\x1BK");
}

/*
 * Display a test screen title
 */
title(string)
	char *string;
{
	cls();
	tty_xy(38-(strlen(string)/2), 1);
	cprintf(mode ? "\x1b[7m %s \x1b[0m" : "* %s *", string);
}

/*
 * Draw a test screen
 */
draw_test()
{
	int i, j;

	cls();
	for(i=1; i < 24; i += 4) {
		tty_xy(1, i);
		for(j=0; j < 80; ++j)
			cputc(j+'1'); }
}

/*
 * Wait for <return> key before proceeding.
 */
wait_return()
{
	char c;

	vgotoxy(0, 0);
	for(;;) {	/* forever loop */
		do {
			if((c = ctestc()) == '\r')
				return;
			if(run_ptr)
				(*run_ptr)(); }
		while(c != 0x1B);
		tty_xy(50, 24); cprintf(" Exit \"VT100 - Checkup\"(Y/N)?");
		if(toupper(cgetc()) == 'Y') {
			cls();
			message("*** \"VT100 - Checkup\" has been aborted ***", -1); }

		tty_xy(50, 24); tty_ceol(); }
}

/*
 * Prompt and wait for return key before proceeding
 */
wait_prompt()
{
	tty_xy(1, 24);
	cprintf("Press <return> to proceed...");
	wait_return();
	cprintf(mode ? "\x1b[2K" : "\r\x1bK");
}

/*
 * Match a string to uppercase command
 */
match(str1, str2, n)
	char *str1, *str2;
	int n;
{
	do {
		if(!*str1)
			return n <= 0;
		--n; }
	while(toupper(*str1++) == *str2++);
	return 0;
}

/*
 * Display a message in a BOX on the PC screen
 */
message(ptr, eflag)
	char *ptr, eflag;
{
	vmessage(39-(strlen(ptr)/2), 16, ptr);
	if(eflag) {
		vgotoxy(0, 22);
		vcursor_line();
		exit(0); }
}

/*
 * Initialize uart after allowing change to parameters
 */
init()
{
	int i;

	vdraw_box(30, 15, 20, 7);
	for(;;) {
		vgotoxy(31, 16); vprintf("(B)audrate:  %5u", rate[baud_rate]);
		vgotoxy(31, 17); vprintf("(P)arity:    %5s", partab[parity]);
		vgotoxy(31, 18); vprintf("(D)ata bits: %5u", dbits+5);
		vgotoxy(31, 19); vprintf("(S)top bits: %5u", sbits+1);
		vgotoxy(31, 21); vprintf("(return) to start?");
		switch(toupper(vgetc())) {
			case 'B' :
				if(!rate[++baud_rate])
					baud_rate = 0;
				break;
			case 'P' :
				if(!partab[++parity])
					parity = 0;
				break;
			case 'D' :
				if(++dbits > 3)
					dbits = 0;
				break;
			case 'S' :
				if(++sbits > 1)
					sbits = 0;
				break;
			case '\n':
				i = ((parity << 4) & 0x30)	|	/* parity bits */
					(dbits & 0x03)			|	/* # data bits */
					((sbits << 2) & 0x04)	|	/* # stop bits */
					((parity < 4) << 3) ;

				out(com_base+3, i | 0x80);
				out(com_base, baud[baud_rate]);
				out(com_base+1, baud[baud_rate] >> 8);
				out(com_base+3, i);
				out(com_base+1, 0);	/* disable all interrupts */
				out(com_base+4, 3);	/* Enable DTR and RTS */

				for(i=0; i < 8; ++i) {
					vgotoxy(30, i+15);
					vprintf("%25s", "" ); }
				return;
			default:
				vputc(7); } }
}

/*
 * Test X/Y cursor positioning
 */
test_xy()
{
	int i, j;
	char c;

	setmode(1);
	c = 'H';
	for(j=0; j < 2; ++j) {
		cls();
		for(i=1; i < 25; ++i) {
			cprintf("\x1b[%u;%uH%c", i, i*2, c);
			cprintf("\x1b[%u;%uH%c", i, 49-(i*2), c); }
		tty_box(39, 10, 34, 5);
		tty_xy(40, 11); cprintf("VT100 - Cursor movement using '%c'", c);
		tty_xy(40, 12); cprintf("Display should show a perfect 'X'");
		tty_xy(40, 13); cprintf("Press  <return>  to  proceed with");
		tty_xy(40, 14); cprintf("the next test....................");
		tty_xy(50, 20);
		wait_return();
			c = 'f'; }
}

/*
 * Test UP, RIGHT, DOWN and LEFT movement
 */
test_udfb()
{
	setmode(1);
	title("UP, DOWN, FORWARD, BACKWARD");
	tty_xy(20, 10); cprintf("A   (Up)");
	tty_xy(50, 10); cprintf("B   (Down)");
	tty_xy(20, 15); cprintf("C   (Forward)");
	tty_xy(50, 15); cprintf("D   (Backward)");
	tty_xy(20, 10); cprintf("\x1b[A^");
	tty_xy(50, 10); cprintf("\x1b[Bv");
	tty_xy(20, 15); cprintf("\x1b[C>");
	tty_xy(50, 15); cprintf("\x1b[D<");
	wait_prompt();
}

/*
 * Test screen clear routines
 */
test_clear()
{
	setmode(1);
	draw_test();
	cls();
	tty_xy(30, 13); cprintf("Erase ENTIRE screen");
	wait_prompt();
	draw_test();
	tty_xy(20,  9); cprintf("\x1b[1JErase from START of screen ");
	tty_xy(20, 17); cprintf(" Erase to END of screen\x1b[0J");
	wait_prompt();
	draw_test();
	tty_xy(20,  5); cprintf("\x1b[1KErase from START of line ");
	tty_xy(30, 13); cprintf("\x1B[2KErase ENTIRE line");
	tty_xy(20, 21); cprintf(" Erase to END of line\x1b[0K");
	wait_prompt();
}

/*
 * Test screen attrbutes
 */
test_attrs()
{
	setmode(1);
	title("SCREEN ATTRIBUTES");
	tty_xy(15,  4); cprintf("Normal");
	tty_xy(15,  5); cprintf("\x1b[1mBold\x1b[0m");
	tty_xy(15,  6); cprintf("\x1b[4mUnderscore\x1b[0m");
	tty_xy(15,  7); cprintf("\x1b[5mBlinking\x1b[0m");
	tty_xy(15,  8); cprintf("\x1b[7mReverse\x1b[0m");
	tty_xy(15,  9); cprintf("\x1b[1;4mBold+Underscore\x1b[0m");
	tty_xy(15, 10); cprintf("\x1b[1;5mBold+Blink\x1b[0m");
	tty_xy(15, 11); cprintf("\x1b[1;7mBold+Reverse\x1b[0m");
	tty_xy(15, 12); cprintf("\x1b[1;4;5mBold+Underscore+Blink\x1b[0m");
	tty_xy(15, 13); cprintf("\x1b[1;4;7mBold+Underscore+Reverse\x1b[0m");
	tty_xy(15, 14); cprintf("\x1b[1;5;7mBold+Blink+Reverse\x1b[0m");
	tty_xy(15, 15); cprintf("\x1b[1;4;5;7mBold+Underscore+Blink+Reverse\x1b[0m");
	tty_xy(15, 16); cprintf("\x1b[4;5mUnderscore+Blink\x1b[0m");
	tty_xy(15, 17); cprintf("\x1b[4;7mUnderscore+Reverse\x1b[0m");
	tty_xy(15, 18); cprintf("\x1b[4;5;7mUnderscore+Blink+Reverse\x1b[0m");
	tty_xy(15, 19); cprintf("\x1b[5;7mBlink+Reverse\x1b[0m");
	tty_xy(05, 21); cprintf("\Attributes set separately: ");
	cprintf("\x1B[1mBold\x1b[4m+Underscore\x1b[5m+Blink\x1b[7m+Reverse\x1B[0m");
	wait_prompt();
	title("CLEAR ATTRIBUTES");
	tty_xy(20, 10); cprintf("Press <return> to clear screen with all");
	tty_xy(20, 11); cprintf("attributes enabled \x1b[1;4;5;7m*****>");
	wait_return();
	cls();
	tty_xy(20, 11); cprintf("*****>\x1b[0m The screen should be cleared to");
	tty_xy(27, 12); cprintf("NORMAL (ie: NO ATTRIBUTES) blank spaces.");
	wait_prompt();
}

/*
 * Test cursor save/restore
 */
test_csr()
{
	int i;

	setmode(1);
	title("CURSOR SAVE/RESTORE");
	tty_xy(40, 10); cprintf("Restore & print text ->\x1b7");
	tty_xy(40, 20); cprintf("\x1b(0\x1b)0\x0e\x1b[1;4;5;7m");
	cprintf(" tqGRAPHICS TESTqu \x1b8Here\x1b(B\x0f\x1b[0m");
	tty_xy(40, 15); cprintf("Cursor should return here ->\x1b7");
	for(i=1; i < 23; ++i) {
		tty_xy(i, i);
		cputc('X'); }
	tty_xy(1, 24); cprintf("Press <return> to proceed...\x1b8");
	wait_return();
}

/*
 * Test setting/clearing tab stops
 */
test_tabs()
{
	int i;

	setmode(1);
	title("TAB SETTINGS");
	cprintf("\x1b[3g");
	tty_xy(1, 8); cprintf("Set tab stops every 10 spaces\n\r");
	for(i=10; i < 80; i += 10) {
		tty_xy(i, 9);
		cprintf("\x1bHT"); }
	tty_xy(1, 10); cprintf("Verify the tabs...\n\r");
	for(i=1; i < 8; ++i)
		cprintf("\t%d", i);
	tty_xy(50, 12); cprintf("\x1b[0g");
	tty_xy(1, 12); cprintf("Clear tab stop 5...\n\r");
	for(i=1; i < 8; ++i)
		cprintf("\t%d", i);
	tty_xy(1, 15); cprintf("Clear all tab stops...\x1b[3g\n\r");
	for(i=1; i < 8; ++i)
	cprintf("\t%d", i);
	for(i=9; i < 80; i += 8) {	/* restore 8 space tab stops */
		tty_xy(i, 2);
		cprintf("\x1bH"); }
	wait_prompt();
}

/*
 * Test double height/width characters
 */
test_double()
{
	setmode(1);
	title("DOUBLE SIZED LINES");
	tty_xy(1, 10);
	cprintf("Normal width line ....................\n\n\r");
	cprintf("Double width line ....................\x1b#6\n\n\r");
	cprintf("Double height line ...................\x1b#3\n\r");
	cprintf("Double height line ...................\x1b#4\n\r");
	wait_prompt();
}

test_132()
{
	unsigned i;
	setmode(1);
	cprintf("\x1B[?3h");
	delay(500);
	title("132 COLUMN MODE");
	tty_xy(1, 10);
	for(i=1; i < 133; ++i) {
		cputc((i%10)+'0');
		/* if(!(i & 7))
			delay(55); */ }
	for(i=10; i < 132; i += 10) {
		tty_xy(i, 11);
		cputc('|');
		tty_xy(i-2, 12);
		cprintf("%3u", i); }
	wait_prompt();
	cprintf("\x1B[?3l");
}

/*
 * Test forward & reverse index
 */
test_index()
{
	int i;

	setmode(1);
	title("NEXT LINE & INDEX");
	tty_xy(1, 1);
	for(i=1; i < 24; ++i)
		cprintf("\x1bEX");
	for(i=1; i < 24; ++i)
		cprintf("\x1bMX");
	tty_xy(40, 20); cprintf("Press <return> to test");
	tty_xy(40, 21); cprintf("Reverse scrolling.....");
	wait_return();
	tty_xy(25, 1);
	for(i=0; i < 23; ++i)
		cprintf("\x1bMX");
	wait_prompt();
}

/*
 * Test scrolling region
 */
test_scroll()
{
	int i;

	setmode(1);
	title("SCROLLING REGION");
	tty_box(1, 7, 79, 11);
	cprintf("\x1B[?4l\x1b[8;17r");
	tty_xy(1, 16);
	for(i=0; i <= 10; ++i)
		cprintf("\r\n%37u", i);
	tty_box(1, 7, 79, 11);
	wait_prompt();
	tty_xy(1, 9);
	for(i=0; i <= 10; ++i)
		cprintf("\r\x1BM%37u", i);
	tty_box(1, 7, 79, 11);
	wait_prompt();

	title("SMOOTH SCROLLING");
	tty_box(1, 7, 79, 11);
	cprintf("\x1B[?4h");
	tty_xy(1, 16);
	for(i=0; i <= 10; ++i)
		cprintf("\r\n%37u", i);
	tty_box(1, 7, 79, 11);
	wait_prompt();
	tty_xy(1, 9);
	for(i=0; i <= 10; ++i)
		cprintf("\r\x1BM%37u", i);
	tty_box(1, 7, 79, 11);
	cprintf("\x1b[1;24r\x1B[?4l");
	wait_prompt();
}

/*
 * Test VT100 special graphics character set
 */
test_graph()
{
	int i;

	setmode(1);
	title("GRAPHICS CHARACTERS");
	cprintf("\x1b(B\x1b)0");
	for(i=0; i < 32; ++i) {
		tty_xy(3 + ((i/8)*20), 5+((i%8)*2));
		cprintf("%02x '%c' = \x0e'%c'\x0f", i+95, i+95, i+95); }
	cprintf("\x1b)A");
	tty_xy(20,22);
	cprintf("Pound sign: Uk=\x0e'#', \x0fUsASCII='#'");
	wait_prompt();
}

/*
 * Test set/reset mode commands
 */
test_mode()
{
	int i;

	setmode(1);
	title("SET/RESET MODES");
	tty_xy(1,5);
	cprintf("\x1b[20hLinefeed/newline Set:\nOne\nTwo\nThree\n\n\r");
	cprintf("\x1b[20lLinefeed/newline Reset:\nOne\nTwo\nThree\n\n\r");
	cprintf("\x1b[?7hAuto wrap Set:\n\r");
	for(i=0; i < 100; ++i)
		cputc('-');
	cprintf("\n\r\x1b[?7lAuto wrap Reset:\n\r");
	for(i=0; i < 100; ++i)
		cputc('-');
	wait_prompt();
	title("ORIGIN MODE");
	tty_xy(1, 11);
	for(i=0; i < 79; ++i)
		cputc('-');
	tty_xy(1, 22);
	for(i=0; i < 79; ++i)
		cputc('-');
	for(i=1; i <= 10; ++i) {
		tty_xy(i,i);
		cputc('A');
		tty_xy(11-i, i);
		cputc('A'); }
	cprintf("\x1b[12;21r\x1b[?6h");
	for(i=1; i <= 10; ++i) {
		tty_xy(i,i);
		cputc('B');
		tty_xy(11-i, i);
		cputc('B'); }
	cprintf("\x1b[1;24r\x1b[?6l");
	tty_xy(40, 3); cprintf("'A' X should be at upper left");
	tty_xy(40, 4); cprintf("corner of the terminal screen");
	tty_xy(40, 6); cprintf("'B' X should be at the left of");
	tty_xy(40, 7); cprintf("the area between the two lines");
	wait_prompt();
}

/*
 * Test colors
 *
test_color()
{
	int i, j;

	setmode(1);
	cprintf("\x1b7\x1b[40m"); /* ??? \25\ */
	title("COLOR ATTRIBUTES");
	for(i=0; i < 8; ++i) {
		tty_xy(0, i+9); cprintf("%s", colors[i]); }
	tty_xy(10, 8);
	for(i=0; i < 8; ++i)
		cprintf("%-8s", colors[i]);
	for(i=0; i < 8; ++i) {
		tty_xy(9, i+9);
		cprintf("\x1b[%um", i+40);
		for(j=0; j < 8; ++j)
			cprintf("\x1b[%um %2u,%2u  ", j+30, j+30, i+40); }
	cprintf("\x1b8");
	wait_prompt();
} */

unsigned LED_tick, LED_count;
LED_func()
{
	unsigned x;
	x = TICK;
	if((x - LED_tick) > 9) {
		LED_tick = x;
		cprintf("\x1B[0;%uq", ++LED_count);
		if(LED_count >= 4)
			LED_count = 0; }
}

test_leds()
{
	static char prompt[] = { "\
Keyboard LEDS should be cycling\n\
From 1-4 at 1/2 second intervals." };

	setmode(1);
	title("LED TEST");
	tty_text(20, 9, prompt);

	LED_tick = TICK-10;
	LED_count = 0;
	run_ptr = &LED_func;
	wait_prompt();
	run_ptr = 0;
	cprintf("\x1B[0q");
}	

/*
 * Test VT52 Cursor positioning
 */
vt52_xy()
{
	int i;

	setmode(0);
	cls();
	for(i=1; i < 25; ++i) {
		tty_xy(i*2, i);
		cputc('X');
		tty_xy(49-(i*2), i);
		cputc('X'); }
	tty_box(39, 10, 23, 5);
	tty_xy(40, 11); cprintf("VT52 - Cursor movement");
	tty_xy(40, 12); cprintf("Display should show  a");
	tty_xy(40, 13); cprintf("perfect 'X'.     Press");
	tty_xy(40, 14); cprintf("<return> to proceed...");
	tty_xy(50, 20);
	wait_return();
}

/*
 * Test VT52 UP, RIGHT, DOWN and LEFT movement
 */
vt52_udfb()
{
	setmode(0);
	title("VT52 - UP, DOWN, FORWARD, BACKWARD");
	tty_xy(20, 10); cprintf("A   (Up)");
	tty_xy(50, 10); cprintf("B   (Down)");
	tty_xy(20, 15); cprintf("C   (Forward)");
	tty_xy(50, 15); cprintf("D   (Backward)");
	tty_xy(20, 10); cprintf("\x1bA^");
	tty_xy(50, 10); cprintf("\x1bBv");
	tty_xy(20, 15); cprintf("\x1bC>");
	tty_xy(50, 15); cprintf("\x1bD<");
	wait_prompt();
}

/*
 * Test VT52 screen clear routines
 */
vt52_clear()
{
	setmode(0);
	draw_test();
	tty_xy(20,  9); cprintf(" VT52 Erase to end of line.\x1bK");
	tty_xy(20, 17); cprintf(" VT52 Erase to end of screen\x1bJ");
	wait_prompt();
}

/*
 * Test reverse line-feed
 */
vt52_revlf()
{
	int i;

	setmode(0);
	title("VT52 reverse line feed");
	tty_xy(1, 24);
	for(i=0; i < 47; ++i)
	cprintf("\x1bIX");
	wait_prompt();
}

show_table(unsigned y, unsigned v, char *text, unsigned char *table[])
{
	unsigned i;
	unsigned char *p;
	tty_xy(15, y); cprintf("%-10s: ", text);
	for(i=0; p = table[i]; ++i) {
		if(*p == v) {
			cprintf(p+1);
			return; } }
	cprintf("?unknown (%u)", v);
}

test_reports()
{
	unsigned x, y, e;
	static unsigned char *Parity[] = {
		"\x01None",
		"\x04Odd",
		"\x05Even",
		0 };
	static unsigned char *Nbits[] = {
		"\x018",
		"\x027",
		0 };
	static unsigned char *Speed[] = {
		"\x0050",
		"\x0875",
		"\x10110",
		"\x18134.5",
		"\x20150",
		"\x28200",
		"\x30300",
		"\x38600",
		"\x401200",
		"\x481800",
		"\x502000",
		"\x582400",
		"\x603600",
		"\x684800",
		"\x709600",
		"\x7819200",
		0 };
	static unsigned char *Clkmult[] = {
		"\x011",
		0 };

	setmode(1);
	title("CURSOR POSITION REPORT");
	e = 2;
	for(y = 1; y < 24; y += 7) {
		for(x=1; x < 80; x += 26) {
			tty_xy(x, y);
			cprintf("\x1B[6n");		// Cursor position report
			cgets();
			if(!parse("\x1B[#;#R")) {
				tty_xy(0, ++e);
				cprintf("%u,%u - Failed to receive proper response.", y, x);
				continue; }
			if((Value[0]!=y)||(Value[1]!=x)) {
				tty_xy(0, ++e);
				cprintf("%u,%u - Incorrect position: %u,%u", y, x, Value[0], Value[1]); }

			} }
	if(e == 2) {
		tty_xy(20, 9);
		cprintf("All positions reported correctly"); }
	wait_prompt();

	title("DEVICE STATUS REPORT");
	cprintf("\x1B[5n");
	cgets();
	if(parse("\x1B[0n")) {
		tty_xy(15, 9);
		cprintf("Device Status Report OK - no malfunction"); }
	else {
		tty_xy(15, 9);
		cprintf("Improper response received: "); showstring(); }
	wait_prompt();

	title("DEVICE ATTRIBUTES REPORT via IDENTIFY");
	cprintf("\x1BZ");
	e = 255;
getda:
	cgets();
	if(parse("\x1B[?1;#c")) {
		tty_xy(15, 9);
		cprintf("Device Attributes Report OK, value=%u", x = Value[0]);
		tty_xy(15, 10); cprintf("Indicated hardware:");
		if(x & 1) cprintf(" STP");
		if(x & 2) cprintf(" AVO");
		if(x & 4) cprintf(" GPO"); }
	else {
		tty_xy(15, 9);
		cprintf("Improper response received: "); showstring(); }
	wait_prompt();
	if(e) {
		e = 0;
		title("DEVICE ATTRIBUTES REPORT via DA");
		cprintf("\x1B[c");
		goto getda; }

	title("TERMINAL PARAMETERS REPORT");
	cprintf("\x1B[1x");
	cgets();
	if(parse("\x1B[#;#;#;#;#;#;#x")) {
		tty_xy(10, 9);
		cprintf("Terminal Parameters Report OK, Values:");
		for(x=0; x < 7; ++x)
			cprintf(" %u", Value[x]);
		show_table(10, Value[1], "Parity", Parity);
		show_table(11, Value[2], "Nbits", Nbits);
		show_table(12, Value[3], "Tspeed", Speed);
		show_table(13, Value[4], "Rspeed", Speed);
		show_table(14, Value[5], "ClkMult", Clkmult);
		tty_xy(15, 15); cprintf("%-10s: %u", "Flags", Value[6]); }
	else {
		tty_xy(15, 9);
		cprintf("Improper response received: "); showstring(); }
	wait_prompt();
}

test_reset(char f)
{
	static char prompt[] = { "\
About to RESET terminal .....\n\
After reset, text should appear in upper left\n\
corner with normal attributes and character\n\
set selected as default." };

	setmode(1);
	title(f ? "RESET via CONFIDENCE TEST" : "RESET via RESET");
	tty_text(15, 8, prompt);
	tty_xy(1, 24); cprintf("Press <return> to reset terminal.");
	tty_xy(10, 20);
	cprintf("Attributes & Graphics set: \x1B[1;4;5;7m\x1B(0\x0Eaaaaaa");
	while(ctestc() != '\r');
	cprintf(f ? "\x1B[2y" : "\x1Bc");
	delay(3000);
	cprintf("This should be normal video/characters in upper left corner. Shift-3='#'");
	wait_prompt();
}

showcode(unsigned char *table[], int c)
{
	unsigned i;
	unsigned char *p;
	for(i=0; p = table[i]; ++i) {
		if(*p++ == c) {
			while(c = *p++) switch(c) {
				case '!' : cprintf("VT52: "); 	continue;
				case '@' : cprintf("VT100: ");	continue;
				default: cputc(c); }
			return 0; } }
	return 255;
}

test_key(unsigned char *prompt)
{
	int c;
	unsigned char *p;
	static unsigned char *cnames[] = {
		"ESC", "FS", "GS", "RS", "US", "SPACE" };
	static unsigned char *esc1[] = {		// {ESC}
		"A!Up",
		"B!Down",
		"C!Right",
		"D!Left",
		"P!PF1",
		"Q!PF2",
		"R!PF3",
		"S!PF4",
		0 };
	static unsigned char *esc2[] = {			// {ESC}[
		"A@Up",
		"B@Down",
		"C@Right",
		"D@Left",
		0 };
	static unsigned char *esc3[] = {			// {ESC}O
		"A@App-Up",
		"B@App-Down",
		"C@App-Right",
		"D@App-Left",
		"P@PF1",
		"Q@PF2",
		"R@PF3",
		"S@PF4",
		"p@Keypad-0",
		"q@Keypad-1",
		"r@Keypad-2",
		"s@keypad-3",
		"t@Keypad-4",
		"u@Keypad-5",
		"v@Keypad-6",
		"w@Keypad-7",
		"x@Keypad-8",
		"y@Keypad-9",
		"m@Keypad-Dash",
		"l@Keypad-Comma",
		"n@Keypad-Dot",
		"M@Keypad-Enter",
		0 };
	static unsigned char *esc4[] = {			// {ESC}?
		"p!Keypad-0",
		"q!Keypad-1",
		"r!Keypad-2",
		"s!keypad-3",
		"t!Keypad-4",
		"u!Keypad-5",
		"v!Keypad-6",
		"w!Keypad-7",
		"x!Keypad-8",
		"y!Keypad-9",
		"m!Keypad-Dash",
		"l!Keypad-Comma",
		"n!Keypad-Dot",
		"M!Keypad-Enter",
		0 };

	title(prompt);
	tty_xy(10, 5); cprintf("Press keys to see codes.");
	tty_xy(10, 6); cprintf("Press ESC twice quickly to exit.");
	for(;;) {
		cgets();
		if(!*String)
			continue;
		p = String;
		tty_xy(10, 10); cprintf("Code: ");
		while(c = *p & 0x7F) {
			*p++ = c;
			if(c <= ' ') {
				if(c < 0x1B) {
					cprintf("^%c", c + '@');
					continue; }
				cprintf("{%s}", cnames[c-0x1B]);
				continue; }
			if(c == 0x7F) {
				cprintf("{DEL}");
				continue; }
			cputc(c); }
		tty_ceol();

		tty_xy(16, 11); tty_ceol();
		if(String[0] == 0x1B) {
			switch(String[1]) {
			case '[' : c=showcode(esc2, String[2]);	break;
			case 'O' : c=showcode(esc3, String[2]);	break;
			case '?' : c=showcode(esc4, String[2]);	break;
			default: c =showcode(esc1, String[1]); }
			if(c) cprintf("?Unknown {ESC} sequence!"); }

		if((String[0] == 0x1B) && (String[1] == 0x1B))
			break; }

	wait_prompt();
}

/*
 * Main program, set up uart and terminal, and execxute the tests
 */
main(argc, argv)
	int argc;
	char *argv[];
{
	char *ptr;

	vopen();
	vdraw_box(12, 5, 56, 7);
	vgotoxy(13, 6);  vprintf("                   \"VT100 - Checkup\"");
	vgotoxy(13, 8);  vprintf("ANSI/VT100 Terminal demonstration and checkout utility.");
	vgotoxy(13, 10); vprintf("?COPY.TXT 1989-2008 Dave Dunfield");
	vgotoxy(13, 11); vprintf(" -- see COPY.TXT --.");

	vgotoxy(15, 20);
	if(argc < 2)
		message("Use: vtest COM1 | COM2", -1);

/* select com port */
	if(match(argv[1], ptr = "COM1", 4)) {
		com_stat = 0x3fd,
		com_base = 0x3f8; }
	else if(match(argv[1], ptr = "COM2", 4)) {
		com_stat = 0x2fd,
		com_base = 0x2f8; }
	else
		message("Invalid COM port", -1);

	init();
	vcursor_off();
	sprintf(buffer, "\"VT100 - Checkup\" is running on %s", ptr);
	message(buffer, 0);
	cls();
	tty_box(12, 5, 56, 7);
	tty_xy(13, 6);  cprintf("                   \"VT100 - Checkup\"");
	tty_xy(13, 8);  cprintf("ANSI/VT100 Terminal demonstration and checkout utlity.");
	tty_xy(13, 10); cprintf("?COPY.TXT 1989-2008 Dave Dunfield");
	tty_xy(13, 11); cprintf(" -- see COPY.TXT --.");
	tty_box(14, 18, 51, 2);
	tty_xy(15, 19); cprintf("Press ESCAPE at any prompt to exit VT100 - Checkup");
	wait_prompt();

/* vt100 tests */
	test_xy();
	test_udfb();
	test_clear();
	test_attrs();
//	test_color();
	test_csr();
	test_tabs();
	test_double();
	test_132();
	test_index();
	test_scroll();
	test_graph();
	test_mode();
	test_leds();
	test_reports();
	cprintf("\x1B>");	test_key("ANSI/VT100 Normal Keypad");
	cprintf("\x1B=");	test_key("VT100 Application Keypad / ANSI Cursor");
	cprintf("\x1B[?1h");test_key("VT100 Application Keypad / Application Cursor");
	cprintf("\x1B[?1l\x1B>");
	test_reset(0);
	test_reset(1);

/* VT52 tests */
	vt52_xy();
	vt52_udfb();
	vt52_clear();
	vt52_revlf();
	cprintf("\x1B>");	test_key("VT52 Normal Keypad");
	cprintf("\x1B=");	test_key("VT52 Application Keypad");
	cprintf("\x1B>");

	setmode(1);
	cls();
	message("*** \"VT100 - Checkup\" has terminated ***", -1);
}
