;
; 6809 simulator
;
; Registers:
;  DI = PC
;  SI = SP
;  DX = D
;  CX = General
;  BX = General
;  AX = General
;  
DGRP	GROUP	DSEG,BSEG
CSEG	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CSEG, DS:DGRP, SS:DGRP
	EXTRN	_RD6809:near, _WR6809:near
	EXTRN	?temp:WORD
	PUBLIC	_step, _go, _doIRQ
; Main instruction decode table
ITABLE1	LABEL	WORD
	DW	?NEG_D		; 00
	DW	?BADINS		; 01
	DW	?BADINS		; 02
	DW	?COM_D		; 03
	DW	?LSR_D		; 04
	DW	?BADINS		; 05
	DW	?ROR_D		; 06
	DW	?ASR_D		; 07
	DW	?LSL_D		; 08
	DW	?ROL_D		; 09
	DW	?DEC_D		; 0A
	DW	?BADINS		; 0B
	DW	?INC_D		; 0C
	DW	?TST_D		; 0D
	DW	?JMP_D		; 0E
	DW	?CLR_D		; 0F
	DW	PAGE1		; 10
	DW	PAGE2		; 11
	DW	?NOP		; 12
	DW	?SYNC		; 13
	DW	?BADINS		; 14
	DW	?BADINS		; 15
	DW	?LBRA		; 16
	DW	?LBSR		; 17
	DW	?BADINS		; 18
	DW	?DAA		; 19
	DW	?ORCC		; 1A
	DW	?BADINS		; 1B
	DW	?ANDCC		; 1C
	DW	?SEX		; 1D
	DW	?EXG		; 1E
	DW	?TFR		; 1F
	DW	?BRA		; 20
	DW	?BRN		; 21
	DW	?BHI		; 22
	DW	?BLS		; 23
	DW	?BCC		; 24
	DW	?BCS		; 25
	DW	?BNE		; 26
	DW	?BEQ		; 27
	DW	?BVC		; 28
	DW	?BVS		; 29
	DW	?BPL		; 2A
	DW	?BMI		; 2B
	DW	?BGE		; 2C
	DW	?BLT		; 2D
	DW	?BGT		; 2E
	DW	?BLE		; 2F
	DW	?LEAX		; 30
	DW	?LEAY		; 31
	DW	?LEAS		; 32
	DW	?LEAU		; 33
	DW	?PSHS		; 34
	DW	?PULS		; 35
	DW	?PSHU		; 36
	DW	?PULU		; 37
	DW	?BADINS		; 38
	DW	?RTS		; 39
	DW	?ABX		; 3A
	DW	?RTI		; 3B
	DW	?CWAI		; 3C
	DW	?MUL		; 3D
	DW	?BADINS		; 3E
	DW	?SWI		; 3F
	DW	?NEGA		; 40
	DW	?BADINS		; 41
	DW	?BADINS		; 42
	DW	?COMA		; 43
	DW	?LSRA		; 44
	DW	?BADINS		; 45
	DW	?RORA		; 46
	DW	?ASRA		; 47
	DW	?LSLA		; 48
	DW	?ROLA		; 49
	DW	?DECA		; 4A
	DW	?BADINS		; 4B
	DW	?INCA		; 4C
	DW	?TSTA		; 4D
	DW	?BADINS		; 4E
	DW	?CLRA		; 4F
	DW	?NEGB		; 50
	DW	?BADINS		; 51
	DW	?BADINS		; 52
	DW	?COMB		; 53
	DW	?LSRB		; 54
	DW	?BADINS		; 55
	DW	?RORB		; 56
	DW	?ASRB		; 57
	DW	?LSLB		; 58
	DW	?ROLB		; 59
	DW	?DECB		; 5A
	DW	?BADINS		; 5B
	DW	?INCB		; 5C
	DW	?TSTB		; 5D
	DW	?BADINS		; 5E
	DW	?CLRB		; 5F
	DW	?NEG_M		; 60
	DW	?BADINS		; 61
	DW	?BADINS		; 62
	DW	?COM_M		; 63
	DW	?LSR_M		; 64
	DW	?BADINS		; 65
	DW	?ROR_M		; 66
	DW	?ASR_M		; 67
	DW	?LSL_M		; 68
	DW	?ROL_M		; 69
	DW	?DEC_M		; 6A
	DW	?BADINS		; 6B
	DW	?INC_M		; 6C
	DW	?TST_M		; 6D
	DW	?JMP_M		; 6E
	DW	?CLR_M		; 6F
	DW	?NEG_E		; 70
	DW	?BADINS		; 71
	DW	?BADINS		; 72
	DW	?COM_E		; 73
	DW	?LSR_E		; 74
	DW	?BADINS		; 75
	DW	?ROR_E		; 76
	DW	?ASR_E		; 77
	DW	?LSL_E		; 78
	DW	?ROL_E		; 79
	DW	?DEC_E		; 7A
	DW	?BADINS		; 7B
	DW	?INC_E		; 7C
	DW	?TST_E		; 7D
	DW	?JMP_E		; 7E
	DW	?CLR_E		; 7F
	DW	?SUBA_I		; 80
	DW	?CMPA_I		; 81
	DW	?SBCA_I		; 82
	DW	?SUBD_I		; 83
	DW	?ANDA_I		; 84
	DW	?BITA_I		; 85
	DW	?LDA_I		; 86
	DW	?BADINS		; 87
	DW	?EORA_I		; 88
	DW	?ADCA_I		; 89
	DW	?ORA_I		; 8A
	DW	?ADDA_I		; 8B
	DW	?CMPX_I		; 8C
	DW	?BSR		; 8D
	DW	?LDX_I		; 8E
	DW	?BADINS		; 8F
	DW	?SUBA_D		; 90
	DW	?CMPA_D		; 91
	DW	?SBCA_D		; 92
	DW	?SUBD_D		; 93
	DW	?ANDA_D		; 94
	DW	?BITA_D		; 95
	DW	?LDA_D		; 96
	DW	?STA_D		; 97
	DW	?EORA_D		; 98
	DW	?ADCA_D		; 99
	DW	?ORA_D		; 9A
	DW	?ADDA_D		; 9B
	DW	?CMPX_D		; 9C
	DW	?JSR_D		; 9D
	DW	?LDX_D		; 9E
	DW	?STX_D		; 9F
	DW	?SUBA_M		; A0
	DW	?CMPA_M		; A1
	DW	?SBCA_M		; A2
	DW	?SUBD_M		; A3
	DW	?ANDA_M		; A4
	DW	?BITA_M		; A5
	DW	?LDA_M		; A6
	DW	?STA_M		; A7
	DW	?EORA_M		; A8
	DW	?ADCA_M		; A9
	DW	?ORA_M		; AA
	DW	?ADDA_M		; AB
	DW	?CMPX_M		; AC
	DW	?JSR_M		; AD
	DW	?LDX_M		; AE
	DW	?STX_M		; AF
	DW	?SUBA_E		; B0
	DW	?CMPA_E		; B1
	DW	?SBCA_E		; B2
	DW	?SUBD_E		; B3
	DW	?ANDA_E		; B4
	DW	?BITA_E		; B5
	DW	?LDA_E		; B6
	DW	?STA_E		; B7
	DW	?EORA_E		; B8
	DW	?ADCA_E		; B9
	DW	?ORA_E		; BA
	DW	?ADDA_E		; BB
	DW	?CMPX_E		; BC
	DW	?JSR_E		; BD
	DW	?LDX_E		; BE
	DW	?STX_E		; BF
	DW	?SUBB_I		; C0
	DW	?CMPB_I		; C1
	DW	?SBCB_I		; C2
	DW	?ADDD_I		; C3
	DW	?ANDB_I		; C4
	DW	?BITB_I		; C5
	DW	?LDB_I		; C6
	DW	?BADINS		; C7
	DW	?EORB_I		; C8
	DW	?ADCB_I		; C9
	DW	?ORB_I		; CA
	DW	?ADDB_I		; CB
	DW	?LDD_I		; CC
	DW	?BADINS		; CD
	DW	?LDU_I		; CE
	DW	?BADINS		; CF
	DW	?SUBB_D		; D0
	DW	?CMPB_D		; D1
	DW	?SBCB_D		; D2
	DW	?ADDD_D		; D3
	DW	?ANDB_D		; D4
	DW	?BITB_D		; D5
	DW	?LDB_D		; D6
	DW	?STB_D		; D7
	DW	?EORB_D		; D8
	DW	?ADCB_D		; D9
	DW	?ORB_D		; DA
	DW	?ADDB_D		; DB
	DW	?LDD_D		; DC
	DW	?STD_D		; DD
	DW	?LDU_D		; DE
	DW	?STU_D		; DF
	DW	?SUBB_M		; E0
	DW	?CMPB_M		; E1
	DW	?SBCB_M		; E2
	DW	?ADDD_M		; E3
	DW	?ANDB_M		; E4
	DW	?BITB_M		; E5
	DW	?LDB_M		; E6
	DW	?STB_M		; E7
	DW	?EORB_M		; E8
	DW	?ADCB_M		; E9
	DW	?ORB_M		; EA
	DW	?ADDB_M		; EB
	DW	?LDD_M		; EC
	DW	?STD_M		; ED
	DW	?LDU_M		; EE
	DW	?STU_M		; EF
	DW	?SUBB_E		; F0
	DW	?CMPB_E		; F1
	DW	?SBCB_E		; F2
	DW	?ADDD_E		; F3
	DW	?ANDB_E		; F4
	DW	?BITB_E		; F5
	DW	?LDB_E		; F6
	DW	?STB_E		; F7
	DW	?EORB_E		; F8
	DW	?ADCB_E		; F9
	DW	?ORB_E		; FA
	DW	?ADDB_E		; FB
	DW	?LDD_E		; FC
	DW	?STD_E		; FD
	DW	?LDU_E		; FE
	DW	?STU_E		; FF
; Scondary table - 10 prefix
ITABLE2	LABEL	WORD
	DW	?BADINS1	; 00
	DW	?BADINS1	; 01
	DW	?BADINS1	; 02
	DW	?BADINS1	; 03
	DW	?BADINS1	; 04
	DW	?BADINS1	; 05
	DW	?BADINS1	; 06
	DW	?BADINS1	; 07
	DW	?BADINS1	; 08
	DW	?BADINS1	; 09
	DW	?BADINS1	; 0A
	DW	?BADINS1	; 0B
	DW	?BADINS1	; 0C
	DW	?BADINS1	; 0D
	DW	?BADINS1	; 0E
	DW	?BADINS1	; 0F
	DW	?BADINS1	; 10
	DW	?BADINS1	; 11
	DW	?BADINS1	; 12
	DW	?BADINS1	; 13
	DW	?BADINS1	; 14
	DW	?BADINS1	; 15
	DW	?BADINS1	; 16
	DW	?BADINS1	; 17
	DW	?BADINS1	; 18
	DW	?BADINS1	; 19
	DW	?BADINS1	; 1A
	DW	?BADINS1	; 1B
	DW	?BADINS1	; 1C
	DW	?BADINS1	; 1D
	DW	?BADINS1	; 1E
	DW	?BADINS1	; 1F
	DW	?BADINS1	; 20
	DW	?LBRN		; 21
	DW	?LBHI		; 22
	DW	?LBLS		; 23
	DW	?LBCC		; 24
	DW	?LBCS		; 25
	DW	?LBNE		; 26
	DW	?LBEQ		; 27
	DW	?LBVC		; 28
	DW	?LBVS		; 29
	DW	?LBPL		; 2A
	DW	?LBMI		; 2B
	DW	?LBGE		; 2C
	DW	?LBLT		; 2D
	DW	?LBGT		; 2E
	DW	?LBLE		; 2F
	DW	?BADINS1	; 30
	DW	?BADINS1	; 31
	DW	?BADINS1	; 32
	DW	?BADINS1	; 33
	DW	?BADINS1	; 34
	DW	?BADINS1	; 35
	DW	?BADINS1	; 36
	DW	?BADINS1	; 37
	DW	?BADINS1	; 38
	DW	?BADINS1	; 39
	DW	?BADINS1	; 3A
	DW	?BADINS1	; 3B
	DW	?BADINS1	; 3C
	DW	?BADINS1	; 3D
	DW	?BADINS1	; 3E
	DW	?SWI2		; 3F
	DW	?BADINS1	; 40
	DW	?BADINS1	; 41
	DW	?BADINS1	; 42
	DW	?BADINS1	; 43
	DW	?BADINS1	; 44
	DW	?BADINS1	; 45
	DW	?BADINS1	; 46
	DW	?BADINS1	; 47
	DW	?BADINS1	; 48
	DW	?BADINS1	; 49
	DW	?BADINS1	; 4A
	DW	?BADINS1	; 4B
	DW	?BADINS1	; 4C
	DW	?BADINS1	; 4D
	DW	?BADINS1	; 4E
	DW	?BADINS1	; 4F
	DW	?BADINS1	; 50
	DW	?BADINS1	; 51
	DW	?BADINS1	; 52
	DW	?BADINS1	; 53
	DW	?BADINS1	; 54
	DW	?BADINS1	; 55
	DW	?BADINS1	; 56
	DW	?BADINS1	; 57
	DW	?BADINS1	; 58
	DW	?BADINS1	; 59
	DW	?BADINS1	; 5A
	DW	?BADINS1	; 5B
	DW	?BADINS1	; 5C
	DW	?BADINS1	; 5D
	DW	?BADINS1	; 5E
	DW	?BADINS1	; 5F
	DW	?BADINS1	; 60
	DW	?BADINS1	; 61
	DW	?BADINS1	; 62
	DW	?BADINS1	; 63
	DW	?BADINS1	; 64
	DW	?BADINS1	; 65
	DW	?BADINS1	; 66
	DW	?BADINS1	; 67
	DW	?BADINS1	; 68
	DW	?BADINS1	; 69
	DW	?BADINS1	; 6A
	DW	?BADINS1	; 6B
	DW	?BADINS1	; 6C
	DW	?BADINS1	; 6D
	DW	?BADINS1	; 6E
	DW	?BADINS1	; 6F
	DW	?BADINS1	; 70
	DW	?BADINS1	; 71
	DW	?BADINS1	; 72
	DW	?BADINS1	; 73
	DW	?BADINS1	; 74
	DW	?BADINS1	; 75
	DW	?BADINS1	; 76
	DW	?BADINS1	; 77
	DW	?BADINS1	; 78
	DW	?BADINS1	; 79
	DW	?BADINS1	; 7A
	DW	?BADINS1	; 7B
	DW	?BADINS1	; 7C
	DW	?BADINS1	; 7D
	DW	?BADINS1	; 7E
	DW	?BADINS1	; 7F
	DW	?BADINS1	; 80
	DW	?BADINS1	; 81
	DW	?BADINS1	; 82
	DW	?CMPD_I		; 83
	DW	?BADINS1	; 84
	DW	?BADINS1	; 85
	DW	?BADINS1	; 86
	DW	?BADINS1	; 87
	DW	?BADINS1	; 88
	DW	?BADINS1	; 89
	DW	?BADINS1	; 8A
	DW	?BADINS1	; 8B
	DW	?CMPY_I		; 8C
	DW	?BADINS1	; 8D
	DW	?LDY_I		; 8E
	DW	?BADINS1	; 8F
	DW	?BADINS1	; 90
	DW	?BADINS1	; 91
	DW	?BADINS1	; 92
	DW	?CMPD_D		; 93
	DW	?BADINS1	; 94
	DW	?BADINS1	; 95
	DW	?BADINS1	; 96
	DW	?BADINS1	; 97
	DW	?BADINS1	; 98
	DW	?BADINS1	; 99
	DW	?BADINS1	; 9A
	DW	?BADINS1	; 9B
	DW	?CMPY_D		; 9C
	DW	?BADINS1	; 9D
	DW	?LDY_D		; 9E
	DW	?STY_D		; 9F
	DW	?BADINS1	; A0
	DW	?BADINS1	; A1
	DW	?BADINS1	; A2
	DW	?CMPD_M		; A3
	DW	?BADINS1	; A4
	DW	?BADINS1	; A5
	DW	?BADINS1	; A6
	DW	?BADINS1	; A7
	DW	?BADINS1	; A8
	DW	?BADINS1	; A9
	DW	?BADINS1	; AA
	DW	?BADINS1	; AB
	DW	?CMPY_M		; AC
	DW	?BADINS1	; AD
	DW	?LDY_M		; AE
	DW	?STY_M		; AF
	DW	?BADINS1	; B0
	DW	?BADINS1	; B1
	DW	?BADINS1	; B2
	DW	?CMPD_E		; B3
	DW	?BADINS1	; B4
	DW	?BADINS1	; B5
	DW	?BADINS1	; B6
	DW	?BADINS1	; B7
	DW	?BADINS1	; B8
	DW	?BADINS1	; B9
	DW	?BADINS1	; BA
	DW	?BADINS1	; BB
	DW	?CMPY_E		; BC
	DW	?BADINS1	; BD
	DW	?LDY_E		; BE
	DW	?STY_E		; BF
	DW	?BADINS1	; C0
	DW	?BADINS1	; C1
	DW	?BADINS1	; C2
	DW	?BADINS1	; C3
	DW	?BADINS1	; C4
	DW	?BADINS1	; C5
	DW	?BADINS1	; C6
	DW	?BADINS1	; C7
	DW	?BADINS1	; C8
	DW	?BADINS1	; C9
	DW	?BADINS1	; CA
	DW	?BADINS1	; CB
	DW	?BADINS1	; CC
	DW	?BADINS1	; CD
	DW	?LDS_I		; CE
	DW	?BADINS1	; CF
	DW	?BADINS1	; D0
	DW	?BADINS1	; D1
	DW	?BADINS1	; D2
	DW	?BADINS1	; D3
	DW	?BADINS1	; D4
	DW	?BADINS1	; D5
	DW	?BADINS1	; D6
	DW	?BADINS1	; D7
	DW	?BADINS1	; D8
	DW	?BADINS1	; D9
	DW	?BADINS1	; DA
	DW	?BADINS1	; DB
	DW	?BADINS1	; DC
	DW	?BADINS1	; DD
	DW	?LDS_D		; DE
	DW	?STS_D		; DF
	DW	?BADINS1	; E0
	DW	?BADINS1	; E1
	DW	?BADINS1	; E2
	DW	?BADINS1	; E3
	DW	?BADINS1	; E4
	DW	?BADINS1	; E5
	DW	?BADINS1	; E6
	DW	?BADINS1	; E7
	DW	?BADINS1	; E8
	DW	?BADINS1	; E9
	DW	?BADINS1	; EA
	DW	?BADINS1	; EB
	DW	?BADINS1	; EC
	DW	?BADINS1	; ED
	DW	?LDS_M		; EE
	DW	?STS_M		; EF
	DW	?BADINS1	; F0
	DW	?BADINS1	; F1
	DW	?BADINS1	; F2
	DW	?BADINS1	; F3
	DW	?BADINS1	; F4
	DW	?BADINS1	; F5
	DW	?BADINS1	; F6
	DW	?BADINS1	; F7
	DW	?BADINS1	; F8
	DW	?BADINS1	; F9
	DW	?BADINS1	; FA
	DW	?BADINS1	; FB
	DW	?BADINS1	; FC
	DW	?BADINS1	; FD
	DW	?LDS_E		; FE
	DW	?STS_E		; FF
; Third table - 11 prefix
ITABLE3	LABEL	WORD
	DW	?BADINS1	; 00
	DW	?BADINS1	; 01
	DW	?BADINS1	; 02
	DW	?BADINS1	; 03
	DW	?BADINS1	; 04
	DW	?BADINS1	; 05
	DW	?BADINS1	; 06
	DW	?BADINS1	; 07
	DW	?BADINS1	; 08
	DW	?BADINS1	; 09
	DW	?BADINS1	; 0A
	DW	?BADINS1	; 0B
	DW	?BADINS1	; 0C
	DW	?BADINS1	; 0D
	DW	?BADINS1	; 0E
	DW	?BADINS1	; 0F
	DW	?BADINS1	; 10
	DW	?BADINS1	; 11
	DW	?BADINS1	; 12
	DW	?BADINS1	; 13
	DW	?BADINS1	; 14
	DW	?BADINS1	; 15
	DW	?BADINS1	; 16
	DW	?BADINS1	; 17
	DW	?BADINS1	; 18
	DW	?BADINS1	; 19
	DW	?BADINS1	; 1A
	DW	?BADINS1	; 1B
	DW	?BADINS1	; 1C
	DW	?BADINS1	; 1D
	DW	?BADINS1	; 1E
	DW	?BADINS1	; 1F
	DW	?BADINS1	; 20
	DW	?BADINS1	; 21
	DW	?BADINS1	; 22
	DW	?BADINS1	; 23
	DW	?BADINS1	; 24
	DW	?BADINS1	; 25
	DW	?BADINS1	; 26
	DW	?BADINS1	; 27
	DW	?BADINS1	; 28
	DW	?BADINS1	; 29
	DW	?BADINS1	; 2A
	DW	?BADINS1	; 2B
	DW	?BADINS1	; 2C
	DW	?BADINS1	; 2D
	DW	?BADINS1	; 2E
	DW	?BADINS1	; 2F
	DW	?BADINS1	; 30
	DW	?BADINS1	; 31
	DW	?BADINS1	; 32
	DW	?BADINS1	; 33
	DW	?BADINS1	; 34
	DW	?BADINS1	; 35
	DW	?BADINS1	; 36
	DW	?BADINS1	; 37
	DW	?BADINS1	; 38
	DW	?BADINS1	; 39
	DW	?BADINS1	; 3A
	DW	?BADINS1	; 3B
	DW	?BADINS1	; 3C
	DW	?BADINS1	; 3D
	DW	?BADINS1	; 3E
	DW	?SWI3		; 3F
	DW	?BADINS1	; 40
	DW	?BADINS1	; 41
	DW	?BADINS1	; 42
	DW	?BADINS1	; 43
	DW	?BADINS1	; 44
	DW	?BADINS1	; 45
	DW	?BADINS1	; 46
	DW	?BADINS1	; 47
	DW	?BADINS1	; 48
	DW	?BADINS1	; 49
	DW	?BADINS1	; 4A
	DW	?BADINS1	; 4B
	DW	?BADINS1	; 4C
	DW	?BADINS1	; 4D
	DW	?BADINS1	; 4E
	DW	?BADINS1	; 4F
	DW	?BADINS1	; 50
	DW	?BADINS1	; 51
	DW	?BADINS1	; 52
	DW	?BADINS1	; 53
	DW	?BADINS1	; 54
	DW	?BADINS1	; 55
	DW	?BADINS1	; 56
	DW	?BADINS1	; 57
	DW	?BADINS1	; 58
	DW	?BADINS1	; 59
	DW	?BADINS1	; 5A
	DW	?BADINS1	; 5B
	DW	?BADINS1	; 5C
	DW	?BADINS1	; 5D
	DW	?BADINS1	; 5E
	DW	?BADINS1	; 5F
	DW	?BADINS1	; 60
	DW	?BADINS1	; 61
	DW	?BADINS1	; 62
	DW	?BADINS1	; 63
	DW	?BADINS1	; 64
	DW	?BADINS1	; 65
	DW	?BADINS1	; 66
	DW	?BADINS1	; 67
	DW	?BADINS1	; 68
	DW	?BADINS1	; 69
	DW	?BADINS1	; 6A
	DW	?BADINS1	; 6B
	DW	?BADINS1	; 6C
	DW	?BADINS1	; 6D
	DW	?BADINS1	; 6E
	DW	?BADINS1	; 6F
	DW	?BADINS1	; 70
	DW	?BADINS1	; 71
	DW	?BADINS1	; 72
	DW	?BADINS1	; 73
	DW	?BADINS1	; 74
	DW	?BADINS1	; 75
	DW	?BADINS1	; 76
	DW	?BADINS1	; 77
	DW	?BADINS1	; 78
	DW	?BADINS1	; 79
	DW	?BADINS1	; 7A
	DW	?BADINS1	; 7B
	DW	?BADINS1	; 7C
	DW	?BADINS1	; 7D
	DW	?BADINS1	; 7E
	DW	?BADINS1	; 7F
	DW	?BADINS1	; 80
	DW	?BADINS1	; 81
	DW	?BADINS1	; 82
	DW	?CMPU_I		; 83
	DW	?BADINS1	; 84
	DW	?BADINS1	; 85
	DW	?BADINS1	; 86
	DW	?BADINS1	; 87
	DW	?BADINS1	; 88
	DW	?BADINS1	; 89
	DW	?BADINS1	; 8A
	DW	?BADINS1	; 8B
	DW	?CMPS_I		; 8C
	DW	?BADINS1	; 8D
	DW	?BADINS1	; 8E
	DW	?BADINS1	; 8F
	DW	?BADINS1	; 90
	DW	?BADINS1	; 91
	DW	?BADINS1	; 92
	DW	?CMPU_D		; 93
	DW	?BADINS1	; 94
	DW	?BADINS1	; 95
	DW	?BADINS1	; 96
	DW	?BADINS1	; 97
	DW	?BADINS1	; 98
	DW	?BADINS1	; 99
	DW	?BADINS1	; 9A
	DW	?BADINS1	; 9B
	DW	?CMPS_D		; 9C
	DW	?BADINS1	; 9D
	DW	?BADINS1	; 9E
	DW	?BADINS1	; 9F
	DW	?BADINS1	; A0
	DW	?BADINS1	; A1
	DW	?BADINS1	; A2
	DW	?CMPU_M		; A3
	DW	?BADINS1	; A4
	DW	?BADINS1	; A5
	DW	?BADINS1	; A6
	DW	?BADINS1	; A7
	DW	?BADINS1	; A8
	DW	?BADINS1	; A9
	DW	?BADINS1	; AA
	DW	?BADINS1	; AB
	DW	?CMPS_M		; AC
	DW	?BADINS1	; AD
	DW	?BADINS1	; AE
	DW	?BADINS1	; AF
	DW	?BADINS1	; B0
	DW	?BADINS1	; B1
	DW	?BADINS1	; B2
	DW	?CMPU_E		; B3
	DW	?BADINS1	; B4
	DW	?BADINS1	; B5
	DW	?BADINS1	; B6
	DW	?BADINS1	; B7
	DW	?BADINS1	; B8
	DW	?BADINS1	; B9
	DW	?BADINS1	; BA
	DW	?BADINS1	; BB
	DW	?CMPS_E		; BC
	DW	?BADINS1	; BD
	DW	?BADINS1	; BE
	DW	?BADINS1	; BF
	DW	?BADINS1	; C0
	DW	?BADINS1	; C1
	DW	?BADINS1	; C2
	DW	?BADINS1	; C3
	DW	?BADINS1	; C4
	DW	?BADINS1	; C5
	DW	?BADINS1	; C6
	DW	?BADINS1	; C7
	DW	?BADINS1	; C8
	DW	?BADINS1	; C9
	DW	?BADINS1	; CA
	DW	?BADINS1	; CB
	DW	?BADINS1	; CC
	DW	?BADINS1	; CD
	DW	?BADINS1	; CE
	DW	?BADINS1	; CF
	DW	?BADINS1	; D0
	DW	?BADINS1	; D1
	DW	?BADINS1	; D2
	DW	?BADINS1	; D3
	DW	?BADINS1	; D4
	DW	?BADINS1	; D5
	DW	?BADINS1	; D6
	DW	?BADINS1	; D7
	DW	?BADINS1	; D8
	DW	?BADINS1	; D9
	DW	?BADINS1	; DA
	DW	?BADINS1	; DB
	DW	?BADINS1	; DC
	DW	?BADINS1	; DD
	DW	?BADINS1	; DE
	DW	?BADINS1	; DF
	DW	?BADINS1	; E0
	DW	?BADINS1	; E1
	DW	?BADINS1	; E2
	DW	?BADINS1	; E3
	DW	?BADINS1	; E4
	DW	?BADINS1	; E5
	DW	?BADINS1	; E6
	DW	?BADINS1	; E7
	DW	?BADINS1	; E8
	DW	?BADINS1	; E9
	DW	?BADINS1	; EA
	DW	?BADINS1	; EB
	DW	?BADINS1	; EC
	DW	?BADINS1	; ED
	DW	?BADINS1	; EE
	DW	?BADINS1	; EF
	DW	?BADINS1	; F0
	DW	?BADINS1	; F1
	DW	?BADINS1	; F2
	DW	?BADINS1	; F3
	DW	?BADINS1	; F4
	DW	?BADINS1	; F5
	DW	?BADINS1	; F6
	DW	?BADINS1	; F7
	DW	?BADINS1	; F8
	DW	?BADINS1	; F9
	DW	?BADINS1	; FA
	DW	?BADINS1	; FB
	DW	?BADINS1	; FC
	DW	?BADINS1	; FD
	DW	?BADINS1	; FE
	DW	?BADINS1	; FF
; Table of addressing mode handlers
MATAB1	LABEL	WORD
	DW	RPLUS1		; 00000	,R+
	DW	RPLUS2		; 00001	,R++
	DW	RMINUS1		; 00010 ,-R
	DW	RMINUS2		; 00011 ,--R
	DW	R0OFF		; 00100 ,R
	DW	RBOFF		; 00101 B,R
	DW	RAOFF		; 00110 A,R
	DW	?BADMEM		; 00111
	DW	R8OFF		; 01000 xx,R
	DW	R16OFF		; 01001 xxxx,R
	DW	?BADMEM		; 01010
	DW	RDOFF		; 01011 D,R
	DW	RPCR8		; 01100	xx,PCR
	DW	RPCR16		; 01101	xxxx,PCR
	DW	?BADMEM		; 01110
	DW	?BADMEM		; 01111
;
	DW	?BADMEM		; 10000
	DW	IPLUS2		; 10001	[,R++]
	DW	?BADMEM		; 10010
	DW	IMINUS2		; 10011	[,--R]
	DW	I0OFF		; 10100	[,R]
	DW	IBOFF		; 10101	[B,R]
	DW	IAOFF		; 10110	[A,R]
	DW	?BADMEM		; 10111
	DW	I8OFF		; 11000	[xx,R]
	DW	I16OFF		; 11001	[xxxx,R]
	DW	?BADMEM		; 11010
	DW	IDOFF		; 11011	[D,R]
	DW	IPCR8		; 11100	[xx,PCR]
	DW	IPCR16		; 11101	[xxxx,PCR]
	DW	?BADMEM		; 11110
	DW	IEXTND		; 11111
; Auto-increment/Decrement handlers
RPLUS1:	CALL	R0OFF		; Get address
	MOV	AX,1		; Inc by 1
	JMP	ADDREG		; Adjust register
RPLUS2:	CALL	R0OFF		; Get address
	MOV	AX,2		; Inc by 2
	JMP	ADDREG		; Adjust register
RMINUS1: MOV	AX,-1		; Get -1
	CALL	ADDREG		; Adjust register
	JMP	SHORT R0OFF	; And get address
RMINUS2: MOV	AX,-2		; Get -2
	CALL	ADDREG		; Adjust register
; Offset handlers
R0OFF:	XOR	BX,BX		; Zero offset
	JMP	GETREG		; Get address
RBOFF:	MOV	AL,DL		; B offset
	JMP	GETRAL		; Extend & get address
RAOFF:	MOV	AL,DH		; A offset
	JMP	GETRAL		; Extend & get address
RDOFF:	MOV	BX,DX		; D offset
	JMP	GETREG		; Get address
R8OFF:	MOV	AL,ES:[DI]	; 8-bit offset
	INC	DI		; Skip to next
	JMP	GETRAL		; Extend & get address
R16OFF:	MOV	BH,ES:[DI]	; 16-bit offset
	MOV	BL,ES:1[DI]	; Get low
	ADD	DI,2		; Skip
	JMP	GETREG		; Get address
; PCR handlers
RPCR8:	MOV	AL,ES:[DI]	; 8-bit,PCR
	INC	DI		; Skip to next
	CBW			; Extend
	ADD	AX,DI		; Offset from PC
	MOV	BX,AX		; BX = result
	RET
RPCR16:	MOV	AH,ES:[DI]	; 16-bit,PCR
	MOV	AL,ES:1[DI]	; Get low
	ADD	DI,2		; Skip
	ADD	AX,DI		; Offset from PC
	MOV	BX,AX		; BX = result
	RET
; Indirect offset handlers
I0OFF:	CALL	R0OFF		; Get address
INDGO:	MOV	AH,ES:[BX]	; Get high
	MOV	AL,ES:1[BX]	; Get LOW
	MOV	BX,AX		; BX = address
	RET
I8OFF:	CALL	R8OFF
	JMP	SHORT INDGO
I16OFF:	CALL	R16OFF
	JMP	SHORT INDGO
IAOFF:	CALL	RAOFF
	JMP	SHORT INDGO
IBOFF:	CALL	RBOFF
	JMP	SHORT INDGO
IDOFF:	CALL	RDOFF
	JMP	SHORT INDGO
IPCR8:	CALL	RPCR8
	JMP	SHORT INDGO
IPCR16:	CALL	RPCR16
	JMP	SHORT INDGO
IPLUS2:	CALL	RPLUS2
	JMP	SHORT INDGO
IMINUS2: CALL	RMINUS2
	JMP	SHORT INDGO
IEXTND:	MOV	BH,ES:[DI]	; Get high
	MOV	BL,ES:1[DI]	; Get low
	ADD	DI,2		; Skip
	JMP	SHORT INDGO	; Indirect
;
; Interprete memory addressing postbyte
;
MEMOP:	MOV	AL,ES:[DI]	; Get post byte
	MOV	CL,AL		; Copy to AH
	INC	DI		; Skip to next
	AND	AL,AL		; Test for 5-bit
	JNS	R5OFF		; 5-bit addressing
; Handle remaining addressing modes
	SHL	AL,1		; Shift
	AND	AL,3Eh		; Save only relavant bits
	MOV	BL,AL		; Copy
	XOR	BH,BH		; Zero high
	JMP	MATAB1[BX]	; Execute handler
; 5-bit offset
R5OFF:	AND	AL,1Fh		; Save only 5-bit range
	TEST	AL,10h		; Negative?
	JZ	GETRAL		; No
	OR	AL,0E0h		; Convert to negative
; Calculate register from bits in Cl
GETRAL:	CBW			; Convert to work
GETRAW:	MOV	BX,AX		; Copy address to BX
GETREG:	AND	CL,60h		; Save only register bits
	JZ	getrx		; It's X
	CMP	CL,20h		; Is it Y
	JZ	getry		; Yes, it's Y
	CMP	CL,40h		; Is it U?
	JZ	getru		; Yes, it's U
	ADD	BX,SI		; Get SP
	RET
getrx:	ADD	BX,DGRP:_X	; Add in X
	RET
getry:	ADD	BX,DGRP:_Y	; Add in Y
	RET
getru:	ADD	BX,DGRP:_U	; Add in U
	RET
; Add AX to register
ADDREG:	AND	CL,60h		; X?
	JZ	addrx		; Yes
	CMP	CL,20h		; Y?
	JZ	addry		; Yes
	CMP	CL,40h		; U
	JZ	addru		; Yes
	ADD	SI,AX		; SI += AX
	RET
addrx:	ADD	DGRP:_X,AX	; X += AX
	RET
addry:	ADD	DGRP:_Y,AX	; Y += AX
	RET
addru:	ADD	DGRP:_U,AX	; U += AX
	RET
;
; Step a single 6809 instruction
;
_step:	PUSH	BP		; Save callers BP
	MOV	DGRP:STK,SP	; Save SP
	CALL	L6809		; Load registers
	CALL	I6809		; Step one instructino
	CALL	S6809		; Save registers
	JMP	SHORT go0	; And exit
;
; Run at full speed
;
_go:	PUSH	BP		; Save callers BP
	MOV	DGRP:STK,SP	; Save SP
	CALL	L6809		; Load registers
	MOV	AX,_SPSTOP	; Get stack check flag
	AND	AX,AX		; Are we monitoring?
	JNZ	go4		; Yes, handle it
go1:	CALL	I6809		; One instruction
	CMP	DI,DGRP:_BREAK	; At breakpoint?
	JZ	go2		; Yes, stop
	DEC	WORD PTR DGRP:_STEP ; Reduce count
	JNZ	go1		; Do them all
; Return to caller
go0:	CALL	S6809		; Save flags
	POP	BP		; Restore BP
	XOR	AX,AX		; 0 = Success
	RET
go2:	CALL	S6809		; Save registers
	POP	BP		; Restore BP
	MOV	AX,255		; Indicate breakpoint
	RET
go3:	CALL	S6809		; Save registers
	POP	BP		; Restore BP
	MOV	AX,254		; Indicate stack check
	RET
; Run at full speed with stack monitor
go4:	CALL	I6809		; One instruction
	CMP	DI,DGRP:_BREAK	; At breakpoint?
	JZ	go2		; Yes, stop
	CMP	SI,DGRP:_SPSTOP	; At upper SP
	JAE	go3		; Yes, stop
	DEC	WORD PTR DGRP:_STEP ; Reduce count
	JNZ	go4		; Do them all
	JMP	SHORT go0	; Exit
; Save 6809 registers
S6809:	MOV	WORD PTR DGRP:_B,DX	; Save D
	MOV	DGRP:_S,SI	; Save SP
	MOV	DGRP:_P,DI	; Save PC
	MOV	DGRP:_TRCPTR,BP	; Save trace pointer
; Update CC from _FLAGS
UPCC:	PUSH	CX
	MOV	CL,DGRP:_CC	; Get CC
	MOV	AX,DGRP:_FLAGS	; Get FLAGS
	AND	CL,0D0h		; Save E+F+I
	TEST	AL,01h		; CF?
	JZ	upcc1		; No
	OR	CL,01h		; Set C
upcc1:	TEST	AL,10h		; AF?
	JZ	upcc2		; No
	OR	CL,20h		; Set H
upcc2:	TEST	AL,40h		; ZF?
	JZ	upcc3		; No
	OR	CL,04h		; Set Z
upcc3:	TEST	AL,80h		; SF?
	JZ	upcc4		; No
	OR	CL,08h		; Set N
upcc4:	TEST	AH,08h		; OF?
	JZ	upcc5		; No
	OR	CL,02h		; Set V
upcc5:	MOV	DGRP:_CC,CL	; Resave
	MOV	AL,CL		; Get flags
	POP	CX
	RET
;
; Load 6809 registers
;
L6809:	MOV	ES,DGRP:_SEG	; Get memory
	MOV	BP,DGRP:_TRCPTR	; Get trace pointer
	MOV	DX,WORD PTR DGRP:_B ; Get D
	MOV	SI,DGRP:_S	; Get SP
	MOV	DI,DGRP:_P	; Get PC
; Update _FLAGS from CC
UPFLG:	PUSH	CX
	MOV	AX,DGRP:_FLAGS	; Get flags
	MOV	CL,DGRP:_CC	; Get CC
	AND	AX,0F72Eh	; Clear V+M+Z+H+C
	TEST	CL,01h		; C?
	JZ	upfl1		; No
	OR	AL,01h		; Set CF
upfl1:	TEST	CL,02h		; V?
	JZ	upfl2		; No
	OR	AH,08h		; Set OF
upfl2:	TEST	CL,04h		; Z?
	JZ	upfl3		; No
	OR	AL,40h		; Set Z
upfl3:	TEST	CL,08h		; N?
	JZ	upfl4		; No
	OR	AL,80h		; Set SF
upfl4:	TEST	CL,20h		; H?
	JZ	upfl5		; Np
	OR	AL,10h		; Set AC
upfl5:	MOV	DGRP:_FLAGS,AX	; Resave flags
	POP	CX
	RET
;
; Step a single 6809 instruction
;
I6809:	MOV	DGRP:_TRCBUF[BP],DI ; Save trace
	INC	BP		; Advance
	INC	BP		; Advance
	AND	BP,1FFFh	; Save BP
	MOV	BL,ES:[DI]	; Get opcode
	INC	DI		; Skip
	XOR	BH,BH		; Zero high
	SHL	BX,1		; x2
	JMP	ITABLE1[BX]	; Execute
PAGE1:	MOV	BL,ES:[DI]	; Get opcode
	INC	DI		; Skip
	XOR	BH,BH		; Zero high
	SHL	BX,1		; x2
	JMP	ITABLE2[BX]	; Execute
PAGE2:	MOV	BL,ES:[DI]	; Get opcode
	INC	DI		; Skip
	XOR	BH,BH		; Zero high
	SHL	BX,1		; x2
	JMP	ITABLE3[BX]	; Execute
;
?BADMEM: MOV	AX,2		; Indicate bad addressing mode
	JMP	SHORT ?ABORT	; Abort
?SYNC:
?CWAI:
?BADINS1:
?BADINS: MOV	AX,1		; Indicate bad opcode
?ABORT:	PUSH	AX		; Save return code
	DEC	BP		; Backup
	DEC	BP		; Backup
	AND	BP,1FFFh	; Mask
	MOV	DI,DGRP:_TRCBUF[BP] ; Retire program counter
	CALL	S6809		; Save registers
	POP	AX		; Restore return code
	MOV	SP,DGRP:STK	; Restore Stack
	POP	BP		; Restore BP
	RET
;
; x x x x   V x x x   M Z x H   x x x C
;
; Set Z+M based on AL, Clear V
B_ZMV:	MOV	CX,DGRP:_FLAGS	; Get flags
	AND	CX,0F73Fh	; Mask V+Z+M
	AND	AL,AL		; Set flags
	PUSHF			; Get flags
	POP	AX		; into AX
	AND	AX,00C0h	; Save only Z+M
	OR	AX,CX		; Include previous
	MOV	DGRP:_FLAGS,AX	; Save
	RET
; Set Z+M based on AX, Clear V
W_ZMV:	MOV	CX,DGRP:_FLAGS	; Get flags
	AND	CX,0F73Fh	; Mask V+Z+M
	AND	AX,AX		; Set flags
	PUSHF			; Get flags
	POP	AX		; into AX
	AND	AX,00C0h	; Save only Z+M
	OR	AX,CX		; Include previous
	MOV	DGRP:_FLAGS,AX	; Save
	RET
; Set Z based on AX
W_Z:	MOV	CX,DGRP:_FLAGS
	AND	AX,AX
	JZ	w_z1
	AND	CL,0BFh
	MOV	DGRP:_FLAGS,CX
	RET
w_z1:	OR	CL,40h
	MOV	DGRP:_FLAGS,CX
	RET
;
; *** Instruction Handlers ***
;
; MISC.
?ABX:	MOV	AL,DL
	XOR	AH,AH
	ADD	WORD PTR DGRP:_X,AX
?NOP:	RET
?SEX:	MOV	AX,DX
	CBW
	MOV	DX,AX
	JMP	W_ZMV
;
?MUL:	MOV	AL,DH
	MUL	DL
	MOV	DX,AX
	MOV	AX,DGRP:_FLAGS
	AND	AX,0BE0h	; Clear Z + C
	AND	DX,DX		; Zero?
	JNZ	MUL1
	OR	AL,40h		; Set 'Z'
	JMP	SHORT MUL2
MUL1:	AND	DL,DL
	JNS	MUL2
	OR	AL,01h
MUL2:	MOV	DGRP:_FLAGS,AX
	RET
;
?DAA:	MOV	AL,DH
	PUSH	DGRP:_FLAGS
	POPF
	DAA
	PUSHF
	POP	DGRP:_FLAGS
	MOV	DH,AL
	RET
; LDA
?LDA_I:	MOV	AL,ES:[DI]
	INC	DI
	MOV	DH,AL
	JMP	B_ZMV
?LDA_M:	CALL	MEMOP
	CALL	RDBXB
	MOV	DH,AL
	JMP	B_ZMV
?LDA_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	CALL	RDBXB
	MOV	DH,AL
	JMP	B_ZMV
?LDA_D:	MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	MOV	DH,AL
	JMP	B_ZMV
; LDB
?LDB_I:	MOV	AL,ES:[DI]
	INC	DI
	MOV	DL,AL
	JMP	B_ZMV
?LDB_M:	CALL	MEMOP
	CALL	RDBXB
	MOV	DL,AL
	JMP	B_ZMV
?LDB_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	CALL	RDBXB
	MOV	DL,AL
	JMP	B_ZMV
?LDB_D:	MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	MOV	DL,AL
	JMP	B_ZMV
; LDD
?LDD_I:	MOV	AH,ES:[DI]
	MOV	AL,ES:1[DI]
	ADD	DI,2
	MOV	DX,AX
	JMP	W_ZMV
?LDD_M:	CALL	MEMOP
	CALL	RDBXW
	MOV	DX,AX
	JMP	W_ZMV
?LDD_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	CALL	RDBXW
	MOV	DX,AX
	JMP	W_ZMV
?LDD_D:	MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXWD
	MOV	DX,AX
	JMP	W_ZMV
; LDX
?LDX_I:	MOV	AH,ES:[DI]
	MOV	AL,ES:1[DI]
	ADD	DI,2
	MOV	DGRP:_X,AX
	JMP	W_ZMV
?LDX_M:	CALL	MEMOP
	CALL	RDBXW
	MOV	DGRP:_X,AX
	JMP	W_ZMV
?LDX_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	CALL	RDBXW
	MOV	DGRP:_X,AX
	JMP	W_ZMV
?LDX_D:	MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXWD
	MOV	DGRP:_X,AX
	JMP	W_ZMV
; LDY
?LDY_I:	MOV	AH,ES:[DI]
	MOV	AL,ES:1[DI]
	ADD	DI,2
	MOV	DGRP:_Y,AX
	JMP	W_ZMV
?LDY_M:	CALL	MEMOP
	CALL	RDBXW
	MOV	DGRP:_Y,AX
	JMP	W_ZMV
?LDY_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	CALL	RDBXW
	MOV	DGRP:_Y,AX
	JMP	W_ZMV
?LDY_D:	MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXWD
	MOV	DGRP:_Y,AX
	JMP	W_ZMV
; LDU
?LDU_I:	MOV	AH,ES:[DI]
	MOV	AL,ES:1[DI]
	ADD	DI,2
	MOV	DGRP:_U,AX
	JMP	W_ZMV
?LDU_M:	CALL	MEMOP
	CALL	RDBXW
	MOV	DGRP:_U,AX
	JMP	W_ZMV
?LDU_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	CALL	RDBXW
	MOV	DGRP:_U,AX
	JMP	W_ZMV
?LDU_D:	MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXWD
	MOV	DGRP:_U,AX
	JMP	W_ZMV
; LDS
?LDS_I:	MOV	AH,ES:[DI]
	MOV	AL,ES:1[DI]
	ADD	DI,2
	MOV	SI,AX
	JMP	W_ZMV
?LDS_M:	CALL	MEMOP
	CALL	RDBXW
	MOV	SI,AX
	JMP	W_ZMV
?LDS_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	CALL	RDBXW
	MOV	SI,AX
	JMP	W_ZMV
?LDS_D:	MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXWD
	MOV	SI,AX
	JMP	W_ZMV
; STA
?STA_M:	CALL	MEMOP
	MOV	AL,DH
	CALL	WRBXB
	JMP	B_ZMV
?STA_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	MOV	AL,DH
	CALL	WRBXB
	JMP	B_ZMV
?STA_D:	MOV	BL,ES:[DI]
	INC	DI
	MOV	AL,DH
	CALL	WRBXBD
	JMP	B_ZMV
; STB
?STB_M:	CALL	MEMOP
	MOV	AL,DL
	CALL	WRBXB
	JMP	B_ZMV
?STB_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	MOV	AL,DL
	CALL	WRBXB
	JMP	B_ZMV
?STB_D:	MOV	BL,ES:[DI]
	INC	DI
	MOV	AL,DL
	CALL	WRBXBD
	JMP	B_ZMV
; STD
?STD_M:	CALL	MEMOP
	MOV	AX,DX
	CALL	WRBXW
	JMP	W_ZMV
?STD_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	MOV	AX,DX
	CALL	WRBXW
	JMP	W_ZMV
?STD_D:	MOV	BL,ES:[DI]
	INC	DI
	MOV	AX,DX
	CALL	WRBXWD
	JMP	W_ZMV
; STX
?STX_M:	CALL	MEMOP
	MOV	AX,DGRP:_X
	CALL	WRBXW
	JMP	W_ZMV
?STX_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	MOV	AX,DGRP:_X
	CALL	WRBXW
	JMP	W_ZMV
?STX_D:	MOV	BL,ES:[DI]
	INC	DI
	MOV	AX,DGRP:_X
	CALL	WRBXWD
	JMP	W_ZMV
; STY
?STY_M:	CALL	MEMOP
	MOV	AX,DGRP:_Y
	CALL	WRBXW
	JMP	W_ZMV
?STY_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	MOV	AX,DGRP:_Y
	CALL	WRBXW
	JMP	W_ZMV
?STY_D:	MOV	BL,ES:[DI]
	INC	DI
	MOV	AX,DGRP:_Y
	CALL	WRBXWD
	JMP	W_ZMV
; STU
?STU_M:	CALL	MEMOP
	MOV	AX,DGRP:_U
	CALL	WRBXW
	JMP	W_ZMV
?STU_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	MOV	AX,DGRP:_U
	CALL	WRBXW
	JMP	W_ZMV
?STU_D:	MOV	BL,ES:[DI]
	INC	DI
	MOV	AX,DGRP:_U
	CALL	WRBXWD
	JMP	W_ZMV
; STS
?STS_M:	CALL	MEMOP
	MOV	AX,SI
	CALL	WRBXW
	JMP	W_ZMV
?STS_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	MOV	AX,SI
	CALL	WRBXW
	JMP	W_ZMV
?STS_D:	MOV	BL,ES:[DI]
	INC	DI
	MOV	AX,SI
	CALL	WRBXWD
	JMP	W_ZMV
; LEA
?LEAX:	CALL	MEMOP
	MOV	AX,BX
	MOV	DGRP:_X,AX
	JMP	W_Z
?LEAY:	CALL	MEMOP
	MOV	AX,BX
	MOV	DGRP:_Y,AX
	JMP	W_Z
?LEAU:	CALL	MEMOP
	MOV	DGRP:_U,BX
	RET
?LEAS:	CALL	MEMOP
	MOV	SI,BX
	RET
; JMP/JSR
?JMP_D:	MOV	AL,ES:[DI]
	MOV	AH,DGRP:_DP
	MOV	DI,AX
	RET
?JMP_M:	CALL	MEMOP
	MOV	DI,BX
	RET
?JMP_E:	MOV	AH,ES:[DI]
	MOV	AL,ES:1[DI]
	MOV	DI,AX
	RET
?JSR_D:	MOV	AL,ES:[DI]
	INC	DI
	MOV	AH,DGRP:_DP
	JMP	SHORT gojsr
?JSR_M:	CALL	MEMOP
	XCHG	BX,DI
	SUB	SI,2
	MOV	ES:[SI],BH
	MOV	ES:1[SI],BL
	RET
?JSR_E:	MOV	AH,ES:[DI]
	MOV	AL,ES:1[DI]
	ADD	DI,2
gojsr:	XCHG	AX,DI
	SUB	SI,2
	MOV	ES:[SI],AH
	MOV	ES:1[SI],AL
	RET
;
?RTI:	MOV	AL,ES:[SI]
	INC	SI
	MOV	DGRP:_CC,AL
	SHL	AL,1
	JNC	?RTIX
	CALL	RPOP
	MOV	DX,AX
	MOV	AL,ES:[SI]
	INC	SI
	MOV	DGRP:_DP,AL
	CALL	RPOP
	MOV	DGRP:_X,AX
	CALL	RPOP
	MOV	DGRP:_Y,AX
	CALL	RPOP
	MOV	DGRP:_U,AX
?RTIX:	CALL	UPFLG
?RTS:	MOV	AH,ES:[SI]
	MOV	AL,ES:1[SI]
	ADD	SI,2
	MOV	DI,AX
	RET
RPOP:	MOV	AH,ES:[SI]
	MOV	AL,ES:1[SI]
	ADD	SI,2
	RET
; SWI
?SWI:	MOV	BX,0FFFAh	; SWi vector
doswi:	CALL	UPCC
	OR	AL,80h		; Set 'E'
	MOV	DGRP:_CC,AL	; Resave
	SUB	SI,12
	MOV	ES:[SI],AL	; Save CC
	MOV	ES:1[SI],DH	; Save A
	MOV	ES:2[SI],DL	; Save B
	MOV	AL,DGRP:_DP	; Get DP
	MOV	ES:3[SI],AL	; Save DP
	MOV	AX,DGRP:_X	; Get X
	MOV	ES:4[SI],AH
	MOV	ES:5[SI],AL
	MOV	AX,DGRP:_Y	; Get Y
	MOV	ES:6[SI],AH
	MOV	ES:7[SI],AL
	MOV	AX,DGRP:_U	; Get Y
	MOV	ES:8[SI],AH
	MOV	ES:9[SI],AL
	MOV	AX,DI		; Get PC
	MOV	ES:10[SI],AH
	MOV	ES:11[SI],AL
	MOV	AH,ES:[BX]	; Jump to vector
	MOV	AL,ES:1[BX]
	MOV	DI,AX
	RET
?SWI2:	MOV	BX,0FFF4h
	JMP	SHORT doswi
?SWI3:	MOV	BX,0FFF2h
	JMP	SHORT doswi
; CLR
?CLRA:	XOR	DH,DH
	JMP	SHORT F_CLR_Z
?CLRB:	XOR	DL,DL
	JMP	SHORT F_CLR_Z
?CLR_D:	MOV	BL,ES:[DI]
	INC	DI
	MOV	BH,DGRP:_DP
	JMP	SHORT BX_CLR
?CLR_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT BX_CLR
?CLR_M:	CALL	MEMOP
BX_CLR:	XOR	AL,AL
	CALL	WRBXB
; Clear V+N, Set Z
F_CLR_Z: MOV	AX,DGRP:_FLAGS
	AND	AX,0F77Eh	; Clr V + M + C
	OR	AL,40h		; Set Z
	MOV	DGRP:_FLAGS,AX
	RET
; COM
?COMA:	NOT	DH
	MOV	AL,DH
	JMP	SHORT F_ZM_C
?COMB:	NOT	DL
	MOV	AL,DL
	JMP	SHORT F_ZM_C
?COM_D:	MOV	BL,ES:[DI]
	INC	DI
	MOV	BH,DGRP:_DP
	JMP	SHORT combx
?COM_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT combx
?COM_M:	CALL	MEMOP
combx:	CALL	RDBXB
	NOT	AL
	CALL	WRBXB
; Set Z+M, Set C + Clr V
F_ZM_C: MOV	CX,DGRP:_FLAGS
	AND	CX,0F72Fh	; Clr V, Z, M
	OR	CL,01h		; Set C
	AND	AL,AL		; Test result
	JS	com1		; Negative
	JNZ	com2		; Not zero
	OR	CL,40h		; Set 'Z'
	JMP	SHORT com2	; and exit
com1:	OR	CL,80h		; Set 'N'
com2:	MOV	DGRP:_FLAGS,CX
	RET
; NEG
?NEGA:	NEG	DH
	JMP	F_ALL
?NEGB:	NEG	DL
	JMP	F_ALL
?NEG_D:	MOV	BL,ES:[DI]
	INC	DI
	MOV	BH,DGRP:_DP
	JMP	SHORT negbx
?NEG_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT negbx
?NEG_M:	CALL	MEMOP
negbx:	CALL	RDBXB
	NEG	AL
	PUSHF
	CALL	WRBXB
	JMP	F_ALL1
; INC
?INCA:	INC	DH
	PUSHF
	JMP	SHORT	F_NZV
?INCB:	INC	DL
	PUSHF
	JMP	SHORT	F_NZV
?INC_D:	MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT	XINC
?INC_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT	XINCBX
?INC_M:	CALL	MEMOP
XINCBX:	CALL	RDBXB
XINC:	INC	AL
	PUSHF
	CALL	WRBXB
F_NZV:	POP	CX
	MOV	AX,DGRP:_FLAGS
	AND	AX,0F73Fh	; Remove V, S, Z
	AND	CX,08C0h	; Save V, S, Z
	OR	AX,CX
	MOV	DGRP:_FLAGS,AX
	RET
; DEC
?DECA:	DEC	DH
	PUSHF
	JMP	SHORT	F_NZV
?DECB:	DEC	DL
	PUSHF
	JMP	SHORT	F_NZV
?DEC_D:	MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT	XDEC
?DEC_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT	XDECBX
?DEC_M:	CALL	MEMOP
XDECBX:	CALL	RDBXB
XDEC:	DEC	AL
	PUSHF
	CALL	WRBXB
	JMP	SHORT F_NZV
; ADD-8
?ADDA_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT ADDA
?ADDA_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT ADDA
?ADDA_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT ADDABX
?ADDA_M: CALL	MEMOP
ADDABX:	CALL	RDBXB
ADDA:	ADD	DH,AL
	JMP	SHORT F_ALL
;
?ADDB_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT ADDB
?ADDB_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT ADDB
?ADDB_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT ADDBBX
?ADDB_M: CALL	MEMOP
ADDBBX:	CALL	RDBXB
ADDB:	ADD	DL,AL
	JMP	SHORT F_ALL
; ADD-16
?ADDD_I: MOV	AH,ES:[DI]
	MOV	AL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT ADDD
?ADDD_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXWD
	JMP	SHORT ADDD
?ADDD_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT ADDDBX
?ADDD_M: CALL	MEMOP
ADDDBX:	CALL	RDBXW
ADDD:	ADD	DX,AX
; Update V,M,Z,H,C
F_ALL:	PUSHF			; Save flags
F_ALL1:	POP	CX		; CX = new flags
	MOV	AX,DGRP:_FLAGS	; Get old flags
	AND	AX,0F72Eh	; Clear H, S, Z, A, C
	OR	AX,CX		; Set new flags
	MOV	DGRP:_FLAGS,AX	; Resave
	RET
; ADC-8
?ADCA_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT ADCA
?ADCA_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT ADCA
?ADCA_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT ADCABX
?ADCA_M: CALL	MEMOP
ADCABX:	CALL	RDBXB
ADCA:	PUSH	DGRP:_FLAGS
	POPF
	ADC	DH,AL
	JMP	SHORT F_ALL
;
?ADCB_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT ADCB
?ADCB_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT ADCB
?ADCB_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT ADCBBX
?ADCB_M: CALL	MEMOP
ADCBBX:	CALL	RDBXB
ADCB:	PUSH	DGRP:_FLAGS
	POPF
	ADC	DL,AL
	JMP	SHORT F_ALL
; SUB-8
?SUBA_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT SUBA
?SUBA_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT SUBA
?SUBA_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT SUBABX
?SUBA_M: CALL	MEMOP
SUBABX:	CALL	RDBXB
SUBA:	SUB	DH,AL
	JMP	F_ALL
;
?SUBB_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT SUBB
?SUBB_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT SUBB
?SUBB_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT SUBBBX
?SUBB_M: CALL	MEMOP
SUBBBX:	CALL	RDBXB
SUBB:	SUB	DL,AL
	JMP	F_ALL
; SUB-16
?SUBD_I: MOV	AH,ES:[DI]
	MOV	AL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT SUBD
?SUBD_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXWD
	JMP	SHORT SUBD
?SUBD_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT SUBDBX
?SUBD_M: CALL	MEMOP
SUBDBX:	CALL	RDBXW
SUBD:	SUB	DX,AX
	JMP	F_ALL
; SBC-8
?SBCA_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT SBCA
?SBCA_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT SBCA
?SBCA_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT SBCABX
?SBCA_M: CALL	MEMOP
SBCABX:	CALL	RDBXB
SBCA:	PUSH	DGRP:_FLAGS
	POPF
	SBB	DH,AL
	JMP	F_ALL
;
?SBCB_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT SBCB
?SBCB_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT SBCB
?SBCB_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT SBCBBX
?SBCB_M: CALL	MEMOP
SBCBBX:	CALL	RDBXB
SBCB:	PUSH	DGRP:_FLAGS
	POPF
	SBB	DL,AL
	JMP	F_ALL
; AND
?ANDA_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT ANDA
?ANDA_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT ANDA
?ANDA_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT ANDABX
?ANDA_M: CALL	MEMOP
ANDABX:	CALL	RDBXB
ANDA:	AND	AL,DH
	MOV	DH,AL
	JMP	B_ZMV
;
?ANDB_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT ANDB
?ANDB_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT ANDB
?ANDB_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT ANDBBX
?ANDB_M: CALL	MEMOP
ANDBBX:	CALL	RDBXB
ANDB:	AND	AL,DL
	MOV	DL,AL
	JMP	B_ZMV
; OR
?ORA_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT ORA
?ORA_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT ORA
?ORA_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT ORABX
?ORA_M: CALL	MEMOP
ORABX:	CALL	RDBXB
ORA:	OR	AL,DH
	MOV	DH,AL
	JMP	B_ZMV
;
?ORB_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT ORB
?ORB_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT ORB
?ORB_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT ORBBX
?ORB_M: CALL	MEMOP
ORBBX:	CALL	RDBXB
ORB:	OR	AL,DL
	MOV	DL,AL
	JMP	B_ZMV
; EOR
?EORA_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT EORA
?EORA_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT EORA
?EORA_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT EORABX
?EORA_M: CALL	MEMOP
EORABX:	CALL	RDBXB
EORA:	XOR	AL,DH
	MOV	DH,AL
	JMP	B_ZMV
;
?EORB_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT EORB
?EORB_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT EORB
?EORB_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT EORBBX
?EORB_M: CALL	MEMOP
EORBBX:	CALL	RDBXB
EORB:	XOR	AL,DL
	MOV	DL,AL
	JMP	B_ZMV
;
?ANDCC:	CALL	UPCC
	AND	AL,ES:[DI]
	INC	DI
	MOV	DGRP:_CC,AL
	JMP	UPFLG
?ORCC:	CALL	UPCC
	OR	AL,ES:[DI]
	INC	DI
	MOV	DGRP:_CC,AL
	JMP	UPFLG
; BIT
?BITA_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT BITA
?BITA_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT BITA
?BITA_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT BITABX
?BITA_M: CALL	MEMOP
BITABX:	CALL	RDBXB
BITA:	AND	AL,DH
	JMP	B_ZMV
;
?BITB_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT BITB
?BITB_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT BITB
?BITB_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT BITBBX
?BITB_M: CALL	MEMOP
BITBBX:	CALL	RDBXB
BITB:	AND	AL,DL
	JMP	B_ZMV
; TST
?TSTA:	MOV	AL,DH
	JMP	B_ZMV
?TSTB:	MOV	AL,DL
	JMP	B_ZMV
?TST_D:	MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	B_ZMV
?TST_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT TSTBX
?TST_M:	CALL	MEMOP
TSTBX:	CALL	RDBXB
	JMP	B_ZMV
; CMP-8
?CMPA_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT CMPA
?CMPA_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT CMPA
?CMPA_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT CMPABX
?CMPA_M: CALL	MEMOP
CMPABX:	CALL	RDBXB
CMPA:	CMP	DH,AL
	JMP	F_ALL
;
?CMPB_I: MOV	AL,ES:[DI]
	INC	DI
	JMP	SHORT CMPB
?CMPB_D: MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXBD
	JMP	SHORT CMPB
?CMPB_E: MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT CMPBBX
?CMPB_M: CALL	MEMOP
CMPBBX:	CALL	RDBXB
CMPB:	CMP	DL,AL
	JMP	F_ALL
; CMP-16
?CMPX_I: PUSH	WORD PTR DGRP:_X
	JMP	SHORT CMPI
?CMPX_D: PUSH	WORD PTR DGRP:_X
	JMP	SHORT CMPD
?CMPX_E: PUSH	WORD PTR DGRP:_X
	JMP	SHORT CMPE
?CMPX_M: PUSH	WORD PTR DGRP:_X
	JMP	SHORT CMPM
?CMPY_I: PUSH	WORD PTR DGRP:_Y
	JMP	SHORT CMPI
?CMPY_D: PUSH	WORD PTR DGRP:_Y
	JMP	SHORT CMPD
?CMPY_E: PUSH	WORD PTR DGRP:_Y
	JMP	SHORT CMPE
?CMPY_M: PUSH	WORD PTR DGRP:_Y
	JMP	SHORT CMPM
?CMPU_I: PUSH	WORD PTR DGRP:_U
	JMP	SHORT CMPI
?CMPU_D: PUSH	WORD PTR DGRP:_U
	JMP	SHORT CMPD
?CMPU_E: PUSH	WORD PTR DGRP:_U
	JMP	SHORT CMPE
?CMPU_M: PUSH	WORD PTR DGRP:_U
	JMP	SHORT CMPM
?CMPD_I: PUSH	DX
CMPI:	MOV	AH,ES:[DI]
	MOV	AL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT XCMP
?CMPD_D: PUSH	DX
CMPD:	MOV	BL,ES:[DI]
	INC	DI
	CALL	RDBXWD
	JMP	SHORT XCMP
?CMPD_E: PUSH	DX
CMPE:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT XCMPBX
?CMPD_M: PUSH	DX
CMPM:	CALL	MEMOP
XCMPBX:	CALL	RDBXW
XCMP:	POP	CX
	CMP	CX,AX
	JMP	F_ALL
?CMPS_I: PUSH	SI
	JMP	SHORT CMPI
?CMPS_D: PUSH	SI
	JMP	SHORT CMPD
?CMPS_E: PUSH	SI
	JMP	SHORT CMPE
?CMPS_M: PUSH	SI
	JMP	SHORT CMPM
; Shifts & Rotates
?LSLA:	SHL	DH,1
	JMP	F_ALL
?LSLB:	SHL	DL,1
	JMP	F_ALL
?LSL_D:	MOV	BL,ES:[DI]
	INC	DI
	MOV	BH,DGRP:_DP
	JMP	SHORT LSLBX
?LSL_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT LSLBX
?LSL_M:	CALL	MEMOP
LSLBX:	CALL	RDBXB
	SHL	AL,1
	PUSHF
	CALL	WRBXB
	JMP	F_ALL1
;
?LSRA:	SHR	DH,1
	JMP	F_ALL
?LSRB:	SHR	DL,1
	JMP	F_ALL
?LSR_D:	MOV	BL,ES:[DI]
	INC	DI
	MOV	BH,DGRP:_DP
	JMP	SHORT LSRBX
?LSR_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT LSRBX
?LSR_M:	CALL	MEMOP
LSRBX:	CALL	RDBXB
	SHR	AL,1
	PUSHF
	CALL	WRBXB
	JMP	F_ALL1
;
?ASRA:	SAR	DH,1
	JMP	F_ALL
?ASRB:	SAR	DL,1
	JMP	F_ALL
?ASR_D:	MOV	BL,ES:[DI]
	INC	DI
	MOV	BH,DGRP:_DP
	JMP	SHORT ASRBX
?ASR_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT ASRBX
?ASR_M:	CALL	MEMOP
ASRBX:	CALL	RDBXB
	SAR	AL,1
	PUSHF
	CALL	WRBXB
	JMP	F_ALL1
;
?ROLA:	PUSH	DGRP:_FLAGS
	POPF
	RCL	DH,1
	JMP	F_ALL
?ROLB:	PUSH	DGRP:_FLAGS
	POPF
	RCL	DL,1
	JMP	F_ALL
?ROL_D:	MOV	BL,ES:[DI]
	INC	DI
	MOV	BH,DGRP:_DP
	JMP	SHORT ROLBX
?ROL_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT ROLBX
?ROL_M:	CALL	MEMOP
ROLBX:	CALL	RDBXB
	PUSH	DGRP:_FLAGS
	POPF
	RCL	AL,1
	PUSHF
	CALL	WRBXB
	JMP	F_ALL1
;
?RORA:	PUSH	DGRP:_FLAGS
	POPF
	RCR	DH,1
	JMP	F_ALL
?RORB:	PUSH	DGRP:_FLAGS
	POPF
	RCR	DL,1
	JMP	F_ALL
?ROR_D:	MOV	BL,ES:[DI]
	INC	DI
	MOV	BH,DGRP:_DP
	JMP	SHORT RORBX
?ROR_E:	MOV	BH,ES:[DI]
	MOV	BL,ES:1[DI]
	ADD	DI,2
	JMP	SHORT RORBX
?ROR_M:	CALL	MEMOP
RORBX:	CALL	RDBXB
	PUSH	DGRP:_FLAGS
	POPF
	RCR	AL,1
	PUSHF
	CALL	WRBXB
	JMP	F_ALL1

; TFR / EXG
?TFR:	MOV	CL,ES:[DI]
	MOV	CH,CL
	INC	DI
	CALL	RDREGH
	MOV	CL,CH
	JMP	WRREG
?EXG:	MOV	CL,ES:[DI]
	MOV	CH,CL
	INC	DI
	CALL	RDREG
	PUSH	AX
	CALL	RDREGH
	MOV	CL,CH
	CALL	WRREG
	POP	AX
	JMP	WRREGH
; 8-bit relative branchs
?BEQ:	PUSH	DGRP:_FLAGS
	POPF
	JZ	?BRA
?BRN:	INC	DI
	RET
?BNE:	PUSH	DGRP:_FLAGS
	POPF
	JNZ	?BRA
	INC	DI
	RET
?BCS:	PUSH	DGRP:_FLAGS
	POPF
	JC	?BRA
	INC	DI
	RET
?BCC:	PUSH	DGRP:_FLAGS
	POPF
	JNC	?BRA
	INC	DI
	RET
?BHI:	PUSH	DGRP:_FLAGS
	POPF
	JA	?BRA
	INC	DI
	RET
?BLS:	PUSH	DGRP:_FLAGS
	POPF
	JBE	?BRA
	INC	DI
	RET
?BGE:	PUSH	DGRP:_FLAGS
	POPF
	JGE	?BRA
	INC	DI
	RET
?BLE:	PUSH	DGRP:_FLAGS
	POPF
	JLE	?BRA
	INC	DI
	RET
?BGT:	PUSH	DGRP:_FLAGS
	POPF
	JG	?BRA
	INC	DI
	RET
?BLT:	PUSH	DGRP:_FLAGS
	POPF
	JL	?BRA
	INC	DI
	RET
?BPL:	PUSH	DGRP:_FLAGS
	POPF
	JNS	?BRA
	INC	DI
	RET
?BMI:	PUSH	DGRP:_FLAGS
	POPF
	JS	?BRA
	INC	DI
	RET
?BVS:	PUSH	DGRP:_FLAGS
	POPF
	JO	?BRA
	INC	DI
	RET
?BVC:	PUSH	DGRP:_FLAGS
	POPF
	JNO	?BRA
	INC	DI
	RET
?BRA:	MOV	AL,ES:[DI]
	INC	DI
	CBW
	ADD	DI,AX
	RET
; 16-bit relative branchs
?LBEQ:	PUSH	DGRP:_FLAGS
	POPF
	JZ	?LBRA
?LBRN:	INC	DI
	INC	DI
	RET
?LBNE:	PUSH	DGRP:_FLAGS
	POPF
	JNZ	?LBRA
	INC	DI
	INC	DI
	RET
?LBCS:	PUSH	DGRP:_FLAGS
	POPF
	JC	?LBRA
	INC	DI
	INC	DI
	RET
?LBCC:	PUSH	DGRP:_FLAGS
	POPF
	JNC	?LBRA
	INC	DI
	INC	DI
	RET
?LBHI:	PUSH	DGRP:_FLAGS
	POPF
	JA	?LBRA
	INC	DI
	INC	DI
	RET
?LBLS:	PUSH	DGRP:_FLAGS
	POPF
	JBE	?LBRA
	INC	DI
	INC	DI
	RET
?LBGE:	PUSH	DGRP:_FLAGS
	POPF
	JGE	?LBRA
	INC	DI
	INC	DI
	RET
?LBLE:	PUSH	DGRP:_FLAGS
	POPF
	JLE	?LBRA
	INC	DI
	INC	DI
	RET
?LBGT:	PUSH	DGRP:_FLAGS
	POPF
	JG	?LBRA
	INC	DI
	INC	DI
	RET
?LBLT:	PUSH	DGRP:_FLAGS
	POPF
	JL	?LBRA
	INC	DI
	INC	DI
	RET
?LBPL:	PUSH	DGRP:_FLAGS
	POPF
	JNS	?LBRA
	INC	DI
	INC	DI
	RET
?LBMI:	PUSH	DGRP:_FLAGS
	POPF
	JS	?LBRA
	INC	DI
	INC	DI
	RET
?LBRA:	MOV	AH,ES:[DI]
	MOV	AL,ES:1[DI]
	ADD	DI,2
	ADD	DI,AX
	RET
?LBVS:	PUSH	DGRP:_FLAGS
	POPF
	JO	?LBRA
	INC	DI
	INC	DI
	RET
?LBVC:	PUSH	DGRP:_FLAGS
	POPF
	JNO	?LBRA
	INC	DI
	INC	DI
	RET
;
?BSR:	MOV	AL,ES:[DI]
	INC	DI
	CBW
	JMP	SHORT LBS1
?LBSR:	MOV	AH,ES:[DI]
	MOV	AL,ES:1[DI]
	ADD	DI,2
LBS1:	ADD	AX,DI
	XCHG	AX,DI
	SUB	SI,2
	MOV	ES:[SI],AH
	MOV	ES:1[SI],AL
	RET
; PUSH/POP
?PSHS:	MOV	CL,ES:[DI]
	INC	DI
	MOV	BX,SI
	MOV	AX,DI
	CALL	XPUSH2
	MOV	AX,DGRP:_U
	CALL	XPUSH2
	MOV	AX,DGRP:_Y
	CALL	XPUSH2
	MOV	AX,DGRP:_X
	CALL	XPUSH2
	MOV	AL,DGRP:_DP
	CALL	XPUSH1
	MOV	AL,DL
	CALL	XPUSH1
	MOV	AL,DH
	CALL	XPUSH1
	SHL	CL,1
	JNC	PSHSX
	CALL	UPCC
	DEC	BX
	MOV	ES:[BX],AL
PSHSX:	MOV	SI,BX
	RET
;
?PSHU:	MOV	CL,ES:[DI]
	INC	DI
	MOV	BX,DGRP:_U
	MOV	AX,DI
	CALL	XPUSH2
	MOV	AX,SI
	CALL	XPUSH2
	MOV	AX,DGRP:_Y
	CALL	XPUSH2
	MOV	AX,DGRP:_X
	CALL	XPUSH2
	MOV	AL,DGRP:_DP
	CALL	XPUSH1
	MOV	AL,DL
	CALL	XPUSH1
	MOV	AL,DH
	CALL	XPUSH1
	SHL	CL,1
	JNC	PSHUX
	CALL	UPCC
	DEC	BX
	MOV	ES:[BX],AL
PSHUX:	MOV	DGRP:_U,BX
	RET
; Push AX onto stack [BX]
XPUSH1: SHL	CL,1
	JNC	XPUSHX
	DEC	BX
	MOV	ES:[BX],AL
	RET
XPUSH2:	SHL	CL,1
	JNC	XPUSHX
	SUB	BX,2
	MOV	ES:[BX],AH
	MOV	ES:1[BX],AL
XPUSHX:	RET
;
?PULS:	MOV	CL,ES:[DI]
	INC	DI
	MOV	BX,SI
	CALL	POP1
	JNC	ps1
	MOV	DGRP:_CC,AL
	CALL	UPFLG
ps1:	CALL	POP1
	JNC	ps2
	MOV	DH,AL
ps2:	CALL	POP1
	JNC	ps3
	MOV	DL,AL
ps3:	CALL	POP1
	JNC	ps4
	MOV	DGRP:_DP,AL
ps4:	CALL	POP2
	JNC	ps5
	MOV	DGRP:_X,AX
ps5:	CALL	POP2
	JNC	ps6
	MOV	DGRP:_Y,AX
ps6:	CALL	POP2
	JNC	ps7
	MOV	DGRP:_U,AX
ps7:	CALL	POP2
	JNC	ps8
	MOV	DI,AX
ps8:	MOV	SI,BX
	RET
;
?PULU:	MOV	CL,ES:[DI]
	INC	DI
	MOV	BX,DGRP:_U
	CALL	POP1
	JNC	pu1
	MOV	DGRP:_CC,AL
	CALL	UPFLG
pu1:	CALL	POP1
	JNC	pu2
	MOV	DH,AL
pu2:	CALL	POP1
	JNC	pu3
	MOV	DL,AL
pu3:	CALL	POP1
	JNC	pu5
	MOV	DGRP:_DP,AL
pu5:	CALL	POP2
	JNC	pu6
	MOV	DGRP:_X,AX
pu6:	CALL	POP2
	JNC	pu7
	MOV	DGRP:_Y,AX
pu7:	CALL	POP2
	JNC	pu8
	MOV	SI,AX
pu8:	CALL	POP2
	JNC	pu9
	MOV	DI,AX
pu9:	MOV	DGRP:_U,BX
	RET
;
POP1:	SHR	CL,1
	JNC	POPX
	MOV	AL,ES:[BX]
	INC	BX
	STC
	RET
POP2:	SHR	CL,1
	JNC	POPX
	MOV	AH,ES:[BX]
	MOV	AL,ES:1[BX]
	ADD	BX,2
	STC
POPX:	RET
; Read TFR/EXG register
RDREGH:	MOV	CL,CH
	SHR	CL,1
	SHR	CL,1
	SHR	CL,1
	SHR	CL,1
RDREG:	AND	CL,0Fh
	JZ	RDRD
	DEC	CL
	JZ	RDRX
	DEC	CL
	JZ	RDRY
	DEC	CL
	JZ	RDRU
	DEC	CL
	JZ	RDRS
	DEC	CL
	JZ	RDRP
	SUB	CL,3
	JZ	RDRA
	DEC	CL
	JZ	RDRB
	DEC	CL
	JZ	RDRCC
	DEC	CL
	JZ	RDRDP
; Undefined RD register
	MOV	AX,3		; Indicate bad register
	JMP	?ABORT		; Abort
RDRD:	MOV	AX,DX
	RET
RDRX:	MOV	AX,DGRP:_X
	RET
RDRY:	MOV	AX,DGRP:_Y
	RET
RDRU:	MOV	AX,DGRP:_U
	RET
RDRS:	MOV	AX,SI
	RET
RDRP:	MOV	AX,DI
	RET
RDRA:	MOV	AL,DH
	RET
RDRB:	MOV	AL,DL
	RET
RDRCC:	JMP	UPCC		; Update CC & retrieve
RDRDP:	MOV	AL,DGRP:_DP
	RET
; Write TFR/EXG register
WRREGH:	MOV	CL,CH
	SHR	CL,1
	SHR	CL,1
	SHR	CL,1
	SHR	CL,1
WRREG:	AND	CL,0Fh
	JZ	WRRD
	DEC	CL
	JZ	WRRX
	DEC	CL
	JZ	WRRY
	DEC	CL
	JZ	WRRU
	DEC	CL
	JZ	WRRS
	DEC	CL
	JZ	WRRP
	SUB	CL,3
	JZ	WRRA
	DEC	CL
	JZ	WRRB
	DEC	CL
	JZ	WRRCC
	DEC	CL
	JZ	WRRDP
; Undefined WR register
	MOV	AX,3		; Indicate bad register
	JMP	?ABORT		; And abort
WRRD:	MOV	DX,AX
	RET
WRRX:	MOV	DGRP:_X,AX
	RET
WRRY:	MOV	DGRP:_Y,AX
	RET
WRRU:	MOV	DGRP:_U,AX
	RET
WRRS:	MOV	SI,AX
	RET
WRRP:	MOV	DI,AX
	RET
WRRA:	MOV	DH,AL
	RET
WRRB:	MOV	DL,AL
	RET
WRRCC:	MOV	DGRP:_CC,AL
	JMP	UPFLG
WRRDP:	MOV	DGRP:_DP,AL
	RET
;
; Read a byte from memory
;
RDBXBD:	MOV	BH,DGRP:_DP
RDBXB:	AND	BH,BH
	JZ	rdiob
	MOV	AL,ES:[BX]
	RET
; Read a word from BX
RDBXWD:	MOV	BH,DGRP:_DP
RDBXW:	AND	BH,BH
	JZ	rdiow
	MOV	AH,ES:[BX]
	MOV	AL,ES:1[BX]
	RET
; Byte I/O read
rdiob:	MOV	WORD PTR DGRP:_B,DX
	MOV	DGRP:_S,SI
	MOV	DGRP:_P,DI
	PUSH	BX
	CALL	_RD6809
	POP	BX
iox1:	MOV	ES,DGRP:_SEG
	MOV	DI,DGRP:_P
	MOV	SI,DGRP:_S
	MOV	DX,WORD PTR DGRP:_B
	RET
; Word I/O read
rdiow:	MOV	WORD PTR DGRP:_B,DX
	MOV	DGRP:_S,SI
	MOV	DGRP:_P,DI
	PUSH	BX
	CALL	_RD6809
	POP	BX
	MOV	BYTE PTR DGRP:?temp,AL
	INC	BX
	PUSH	BX
	CALL	_RD6809
	POP	BX
	DEC	BX
	MOV	AH,BYTE PTR DGRP:?temp
	JMP	SHORT iox1
;
; Write a byte to memory
;
WRBXBD:	MOV	BH,DGRP:_DP
WRBXB:	AND	BH,BH
	JZ	wriob
	CMP	BH,0E0h
	JNC	wrbxx
	MOV	ES:[BX],AL
wrbxx:	RET
WRBXWD:	MOV	BH,DGRP:_DP
WRBXW:	AND	BH,BH
	JZ	wriow
	CMP	BH,0E0h
	JNC	wrbxx
	MOV	ES:[BX],AH
	MOV	ES:1[BX],AL
	RET
; Write byte to I/O
wriob:	MOV	ES:[BX],AL
	MOV	WORD PTR DGRP:_B,DX
	MOV	DGRP:_S,SI
	MOV	DGRP:_P,DI
	PUSH	BX
	PUSH	AX
	CALL	_WR6809
	POP	AX
	POP	BX
iox2:	MOV	ES,DGRP:_SEG
	MOV	DI,DGRP:_P
	MOV	SI,DGRP:_S
	MOV	DX,WORD PTR DGRP:_B
	RET
; Write a word to I/O
wriow:	MOV	ES:[BX],AH
	MOV	ES:1[BX],AL
	MOV	WORD PTR DGRP:_B,DX
	MOV	DGRP:_S,SI
	MOV	DGRP:_P,DI
	XCHG	AH,AL
	PUSH	BX
	PUSH	AX
	CALL	_WR6809
	POP	AX
	POP	BX
	XCHG	AH,AL
	INC	BX
	PUSH	BX
	PUSH	AX
	CALL	_WR6809
	POP	AX
	POP	BX
	DEC	BX
	JMP	SHORT	iox2
; CC,A,B,DP,XH,XL,YH,YL,UH,UL,PH,PL
_doIRQ:	MOV	SI,SP		;Get vector
	MOV	BX,2[SI]
	MOV	ES,DGRP:_SEG
	MOV	DI,DGRP:_S	;Get SP
	MOV	AX,DGRP:_P	;PC
	CALL	STK2
	MOV	AX,ES:[BX]	;handler
	XCHG	AH,AL
	MOV	DGRP:_P,AX
	CMP	BX,0FFF6h	;FIRQ
	JZ	a1
	MOV	AX,DGRP:_U
	CALL	STK2
	MOV	AX,DGRP:_Y
	CALL	STK2
	MOV	AX,DGRP:_X
	CALL	STK2
	MOV	AL,DGRP:_DP
	CALL	STK1
	MOV	AL,DGRP:_B
	CALL	STK1
	MOV	AL,DGRP:_A
	CALL	STK1
a1:	MOV	AL,DGRP:_CC
	CALL	STK1
	MOV	DGRP:_S,DI
	RET
STK2:	DEC	DI
	MOV	ES:[DI],AL
	MOV	AL,AH
STK1:	DEC	DI
	MOV	ES:[DI],AL
	RET
; PH,PL
CSEG	ENDS
;
; Initialized data
;
DSEG	SEGMENT	BYTE PUBLIC 'IDATA'
	PUBLIC	_CC, _DP, _A, _B, _X, _Y, _U, _S, _P
	PUBLIC	_SEG, _STEP, _BREAK, _TRCPTR, _SPSTOP
_CC	DB	0
_DP	DB	0
_B	DB	0
_A	DB	0
_X	DW	0
_Y	DW	0
_U	DW	0
_S	DW	0
_P	DW	0
_SEG	DW	0
_STEP	DW	0
_TRCPTR	DW	0
_BREAK	DW	0
_FLAGS	DW	0200h
_SPSTOP	DW	0
DSEG	ENDS
;
; Uninitialized data
;
BSEG	SEGMENT	BYTE PUBLIC 'UDATA'
	PUBLIC	_TRCBUF
STK	DW	1 DUP(?)
_TRCBUF	DW	4096 DUP (?)
BSEG	ENDS
	END
