/*
 * Virtual Horizon - Z80 disassembler
 *
 * ?COPY.TXT 2003-2008 Dave Dunfield
 */

/*
Disassembly table:
 0 = Mask
 1 = Match
 2 = Instruction name (8x = table)
 3+=
	00	= end
	p=	Register pair	(bits 4-5)
	s=	Source register	(bits 0-3)
	d=	dest register	(bits 3-5)
	b=	byte value
	w=	word value
	c=	condition code
	i=	bit number
	r=	relative address
*/
unsigned char XXtable[] = {
	0xF8, 0x88,128, 'A',',','s', 0,			// ADC A,r
	0xFF, 0xCE,128, 'A',',','b', 0,			// ADC A,bb
	0xF8, 0x80,129, 'A',',','s', 0,			// ADD A,
	0xFF, 0xC6,129, 'A',',','b', 0,			// ADD A,bb
	0xCF, 0x09,129, 'h',',','p', 0,			// ADD HL,rp
	0xF8, 0xA0,130, 's', 0,					// AND r
	0xFF, 0xE6,130, 'b', 0,					// AND bb
	0xFF, 0xCD,131, 'w', 0,					// CALL wwww
	0xC7, 0xC4,131, 'c',',','w', 0,			// CALL cc,wwww
	0xF8, 0xB8,132, 's', 0,					// CP r
	0xFF, 0xFE,132, 'b', 0,					// CP bb
	0xC7, 0x05,133, 'd', 0,					// DEC r
	0xCF, 0x0B,133, 'p', 0,					// DEC rp
	0xFF, 0x10,'D','J','N','Z',' ', 'r',0,	// DJNZ r
	0xFF, 0xE3,134, '(','S','P',')',',','h',0,// EX (SP),rp
	0xFF, 0xEB,134, 'D','E',',','H','L',0,	// EX DE,HL
	0xFF, 0x08,134, 'A','F',',','A','F','\'',0,// EX AF,AF'
	0xFF, 0xD9,'E','X','X', 0,				// EXX
	0xFF, 0xDB,136, 'A',',','(','b',')', 0,	// IN A,(bb)
	0xC7, 0x04,137, 'd', 0,					// INC r
	0xCF, 0x03,137, 'p', 0,					// INC rp
	0xFF, 0xC3,138, 'w', 0,					// JP wwww
	0xC7, 0xC2,138, 'c',',','w', 0,			// JP cc,wwww
	0xFF, 0xE9,138, '(','h',')', 0,			// JP (HL)
	0xFF, 0x18,139, 'r', 0,					// JR rel
	0xFF, 0x20,139, 'N','Z',',','r', 0,		// JR NZ,rel
	0xFF, 0x28,139, 'Z',',','r', 0,			// JR Z,rel
	0xFF, 0x30,139, 'N','C',',','r', 0,		// JR NC,rel
	0xFF, 0x38,139, 'C',',','r', 0,			// JR C,rel
	0xFF, 0x76,'H','A','L','T', 0,
	0xC0, 0x40,140, 'd',',','s', 0,			// LD reg,reg		MOV
	0xC7, 0x06,140, 'd',',','b', 0,			// LD reg,bb		MVI
	0xFF, 0x3A,140, 'A',',','(','w',')', 0,	// LD A,wwww		LDA
	0xFF, 0x32,140, '(','w',')',',','A', 0,	// LD wwww,A		STA
	0xFF, 0x2A,140, 'h',',','(','w',')', 0,	// LD HL,wwww		LHLD
	0xFF, 0x22,140, '(','w',')',',','h', 0,	// LD wwww,HL		SHLD
	0xCF, 0x01,140, 'p',',','w', 0,			// LD rp,wwww		LXI
	0xEF, 0x0A,140, 'A',',','(','p',')', 0,	// LD A,(rp)		LDAX
	0xEF, 0x02,140, '(','p',')',',','A', 0,	// LD (rp),A		STAX
	0xFF, 0xF9,140, 'S','P',',','h', 0,		// LD SP,HL			SPHL
	0xF8, 0xB0,141, 's', 0,					// OR r
	0xFF, 0xF6,141, 'b', 0,					// OR bb
	0xFF, 0xD3,142, '(','b',')',',','A', 0,	// OUT  (bb),A
	0xCF, 0xC1,'P','O','P',' ', 'q', 0,		// POP rp
	0xCF, 0xC5,'P','U','S','H',' ', 'q', 0,	// PUSH rp
	0xFF, 0xC9,143, 0,						// RET
	0xC7, 0xC0,143, 'c', 0,					// RET cc
	0xFF, 0x17,'R','L','A', 0,				// RLA
	0xFF, 0x07,'R','L','C','A', 0,			// RLCA
	0xFF, 0x1F,'R','R','A', 0,				// RRA
	0xFF, 0x0F,'R','R','C','A', 0,			// RRCA
	0xC7, 0xC7,'R','S','T',' ', 'i', 0,		// RST
	0xF8, 0x98,144, 'A',',','s', 0,			// SBC A,r
	0xFF, 0xDE,144, 'A',',','b', 0,			// SBC A,bb
	0xF8, 0x90,145, 's', 0,					// SUB
	0xFF, 0xD6,145, 'b', 0,					// SUB bb
	0xF8, 0xA8,146, 's', 0,					// XOR r
	0xFF, 0xEE,146, 'b', 0,					// XOR bb
	0xFF, 0x3F,'C','C','F', 0,
	0xFF, 0x2F,'C','P','L', 0,
	0xFF, 0x27,'D','A','A', 0,
	0xFF, 0xF3,'D','I', 0,
	0xFF, 0xFB,'E','I', 0,
	0xFF, 0x37,'S','C','F', 0,
	0xFF, 0x00,'N','O','P', 0,
	0x00, 0x00,'?', 0 };

// Disassembly table for opcodes prefixed by ED
unsigned char EDtable[] = {
	0xCF, 0x4A,128, 'H','L',',','p', 0,		// ADC HL,rp
	0xFF, 0x46,135, '0', 0,					// IM 0
	0xFF, 0x56,135, '1', 0,					// IM 1
	0xFF, 0x5E,135, '2', 0,					// IM 2
	0xC7, 0x40,136, 'd',',','(','C',')',0,	// IN r,(C)
	0xCF, 0x43,140, '(','w',')',',','p', 0,	// LD (wwww),rp
	0xCF, 0x4B,140, 'p',',','(','w',')', 0,	// LD rp,(wwww)
	0xFF, 0x57,140, 'A',',','I', 0,			// LD A,I
	0xFF, 0x5F,140, 'A',',','R', 0,			// LD A,R
	0xFF, 0x47,140, 'I',',','A', 0,			// LD I,A
	0xFF, 0x4F,140, 'R',',','A', 0,			// LD R,A
	0xC7, 0x41,142, '(','C',')',',','d', 0,	// OUT (C),r
	0xFF, 0x4D,'R','E','T','I', 0,			// RETI
	0xFF, 0x45,'R','E','T','N', 0,			// RETN
	0xFF, 0x6F,'R','L','D', 0,				// RLD
	0xFF, 0x67,'R','R','D', 0,				// RRD
	0xCF, 0x42,144, 'H','L',',','p', 0,		// SBC HL,rp
	0xFF, 0xA1,'C','P','I', 0,
	0xFF, 0xB1,'C','P','I','R', 0,
	0xFF, 0xA9,'C','P','D', 0,
	0xFF, 0xB9,'C','P','D','R', 0,
	0xFF, 0xA2,'I','N','I', 0,
	0xFF, 0xB2,'I','N','I','R', 0,
	0xFF, 0xAA,'I','N','D', 0,
	0xFF, 0xBA,'I','N','D','R', 0,
	0xFF, 0xA0,'L','D','I', 0,
	0xFF, 0xB0,'L','D','I','R', 0,
	0xFF, 0xA8,'L','D','D', 0,
	0xFF, 0xB8,'L','D','D','R', 0,
	0xFF, 0x44,'N','E','G', 0,
	0xFF, 0xA3,'O','U','T','I', 0,
	0xFF, 0xB3,'O','T','I','R', 0,
	0xFF, 0xAB,'O','U','T','D', 0,
	0xFF, 0xBB,'O','T','D','R', 0,
	0x00, 0x00,'?', 0 };

// Disassembly table for opcodes prefixed by CB
unsigned char CBtable[] = {
	0xC0, 0x40,'B','I','T',' ','i',',','s',0,	// BIT bit,r
	0xC0, 0x80,'R','E','S',' ','i',',','s',0,	// RES bit,r
	0xC0, 0xC0,'S','E','T',' ','i',',','s',0,	// SET BIT,r
	0xF8, 0x10,'R','L',' ','s', 0,				// RL r
	0xF8, 0x00,'R','L','C',' ','s', 0,			// RLC r
	0xF8, 0x18,'R','R',' ', 's', 0,				// RR r
	0xF8, 0x08,'R','R','C',' ','s', 0,			// RRC r
	0xF8, 0x20,'S','L','A',' ','s', 0,			// SLA r
	0xF8, 0x28,'S','R','A',' ','s', 0,			// SRA r
	0xF8, 0x38,'S','R','L',' ','s', 0,			// SRL r
	0x00, 0x00,'?', 0 };

// Table of instruction names
unsigned char Inames[] = {
	'A','D','C',' ',		// 128
	'A','D','D',' ',		// 129
	'A','N','D',' ',		// 130
	'C','A','L','L',		// 131
	'C','P',' ',' ',		// 132
	'D','E','C',' ',		// 133
	'E','X',' ',' ',		// 134
	'I','M',' ',' ',		// 135
	'I','N',' ',' ',		// 136
	'I','N','C',' ',		// 137
	'J','P',' ',' ',		// 138
	'J','R',' ',' ',		// 139
	'L','D',' ',' ',		// 140
	'O','R',' ',' ',		// 141
	'O','U','T',' ',		// 142
	'R','E','T',' ',		// 143
	'S','B','C',' ',		// 144
	'S','U','B',' ',		// 145
	'X','O','R',' ',		// 146
	0 };

// Tables of register names
unsigned char *SDreg[] = { "B", "C", "D", "E", "H", "L", "(HL)", "A" };
unsigned char *RPreg[] = { "BC", "DE", "HL", "SP", "AF" };
unsigned char *CCtab[] = { "NZ", "Z", "NC", "C", "PO", "PE", "P", "M" };

/*
 * Add string to disassembly output line
 */
void Ds(unsigned char *s)
{
	while(*s)
		*ptr++ =  *s++;
}

/*
 * Formatted print to disassembly output line
 */
register Dprint(unsigned args)
{
	unsigned char buf[50];
	_format_(nargs() * 2 + &args, buf);
	Ds(buf);
}

/*
 * Add a byte value (hex) to disassembly output line
 */
void Db(unsigned char x)
{
	Dprint("%02x", x);
}

/*
 * Disassemble Z80 instruction & return length
 * Input address is Daddress
 */
void disassemble(unsigned length, unsigned char display)
{
	unsigned i, j, a, aa, t, ll;
	unsigned char o, o1, op, *p;
	static char Temp[64];

	for(i=ll=0; i < length; ++i) {
		if(daddress[i] == Daddress) {
			a = daddress[0];
			goto dodis; } }
	a = Daddress;
dodis:
	if(ll >= length) return;
	ptr = Temp;
	p = XXtable;
	j = -1;
	switch(o = Mread(daddress[ll] = aa = a++)) {
	case 0xDD : op = 1; goto refetch;
	case 0xFD : op = 2;
	refetch: o = Mread(a++); break;
	case 0xED : p = EDtable; goto refetch;
	default: op = 0; p = XXtable; }

	*awin = (aa == Daddress) ? 0x76 : 0x67;

	if(o == 0xCB) {		// Register or bit
		if(op) j = Mread(a++);
		o = Mread(a++);
		p = CBtable; }

	t = 0;
lookup:
	o1 = *p++ & o;
	if(*p++ != o1) {
		while(*p++);
		goto lookup; }
	if(*p & 0x80) {
		i = (*p++ << 2) &  0x7F;		// Point to name
			o1 = 4; do {
			*ptr++ = Inames[i++]; }
		while(--o1);
		*ptr++ = ' '; }
	for(;;) switch(i = *p++) {
		case 'd' : i = (o >> 3) & 0x07; goto sdgo;	// Dest register
		case 's' : i = o & 0x07;					// Source register
		sdgo:
			if((i == 6) && op) {
				Ds((op == 2) ? "(IY" : "(IX");
				if(j == -1)
					j = Mread(a++);
				if(j & 0x80) {
					j = -(j | 0xFF00);
					*ptr++ = '-'; }
				else
					*ptr++ = '+';
				Db(j);
				*ptr++ = ')'; }
			else
				Ds(SDreg[i]);
			continue;
		case 'q' :									// RP / AF
			if((o & 0x30) == 0x30) {
				i = 4;
				goto xreg; }
		case 'p' :									// Register pair
			i = (o >> 4) & 3;
			if((i == 2) && op) {
				Ds((op == 2) ? "IY" : "IX");
				continue; }
	xreg:	Ds(RPreg[i]);
			continue;
		case 'h' :									// HL/IX/IY
			switch(op) {
			case 1 : Ds("IX");	continue;
			case 2 : Ds("IY");	continue;
			default: Ds("HL");	continue; }
		case 'i' :									// bIt
			*ptr++ = ((o >> 3) & 7) + '0';
			continue;
		case 'c' :									// Condition
			Ds(CCtab[(o >> 3) &7]);
			continue;
		case 'b' :									// Byte
			Db(Mread(a++));
			continue;
		case 'w' :									// Word
			j = Mread(a++);
			Db(Mread(a++));
			Db(j);
			continue;
		case 'r' :
			if((i = Mread(a++)) & 0x80)
				i |= 0xFF00;
			i += a;
			Db(i >> 8);
			Db(i & 255);
			continue;
		case 0 :
			if(display && !Cmode) {
				w_gotoxy(0, ll, awin);
				*ptr = 0;
				j = (a - aa);
				w_printf(awin, "%04x ", aa);
				for(i=0; i < 4; ++i) {
					if(j) {
						w_printf(awin, "%02x ", Mread(aa+i));
						--j; }
					else
						w_puts("   ", awin); }
				w_cleol(awin);
				w_puts(Temp, awin); }
			++ll;
			goto dodis;
		case ' ' :
			while(t++ < 4)
				*ptr++ = ' ';
		default: *ptr++ = i; ++t; }
}
