/*
 * Virtual Horizon - I/O handlers
 *
 * ?COPY.TXT 2003-2008 Dave Dunfield
 */
#define	PORTS	32

unsigned char Imap[256], Omap[256];
static unsigned nline;

/*
 * I/O port defining structure
 */
struct PORT {					//	Ustat	Udat	Cstat	Fstat	Fdata
	unsigned			W1;		// 1 Addr	Addr	Init	Init	Nfile
	unsigned 	char	B1;		// 2 Init	Xor		RX		TX		Eof
	unsigned	char	B2;		// 3 TX						RX
	unsigned	char	B3;		// 4 RX						Flg
	unsigned	char	B4;		// 5 BRK					Ct
	unsigned	char	B5;		// 6 FE
	unsigned	char	B6;		// 7 PE
	unsigned	char	B7;		// 8 OE
	unsigned	char	B8;		// 9 DSR
	unsigned	char	B9;		//10 CTS
	unsigned	char	B10;	//11 DCD
	unsigned	char	B11;	//12 RI						Tmp
	} Iports[PORTS], Oports[PORTS];


/*
 * Write serial UART control register
 */
void uartctrl(PORT, DATA) asm
{
		MOV		BX,6[BP]		// Address structure
		MOV		DX,[BX]			// Get address
		ADD		DX,4			// Advance to Modem Control
		MOV		AX,4[BP]		// Get data
		XOR		AH,AH			// Assume nothing
		XOR		AL,2[BX]		// Adjust bits
		TEST	AL,3[BX]		// DTR set?
		JZ		wu1
		OR		AH,01h
wu1:	TEST	AL,4[BX]		// RTS set?
		JZ		wu2
		OR		AH,02h
wu2:	MOV		AL,AH			// Get final value
		OUT		DX,AL			// Output
}

/*
 * Read serial UART status register
 */
int uartstat(PORT) asm
{
		MOV		BX,4[BP]		// Address structure
		MOV		DX,[BX]			// Get address
		ADD		DX,5			// Advance to status
		XOR		AH,AH			// Begin with Zero
		IN		AL,DX			// Read status
		TEST	AL,20h			// TX ready
		JZ		ru1
		OR		AH,3[BX]
ru1:	TEST	AL,01h			// RX ready
		JZ		ru2
		OR		AH,4[BX]
ru2:	TEST	AL,10h			// BREAK
		JZ		ru3
		OR		AH,5[BX]
ru3:	TEST	AL,08h			// FE
		JZ		ru4
		OR		AH,6[BX]
ru4:	TEST	AL,04h			// PE
		JZ		ru5
		OR		AH,7[BX]
ru5:	TEST	AL,02h			// OE
		JZ		ru6
		OR		AH,8[BX]
ru6:	INC		DX				// Advance to modem status
		IN		AL,DX			// Read modem status
		TEST	AL,20h			// DSR
		JZ		ru7
		OR		AH,9[BX]
ru7:	TEST	AL,10h			// CTS
		JZ		ru8
		OR		AH,10[BX]
ru8:	TEST	AL,80h			// DCD
		JZ		ru9
		OR		AH,11[BX]
ru9:	TEST	AL,40h			// RI
		JZ		ru10
		OR		AH,12[BX]
ru10:	MOV		AL,AH
		XOR		AL,2[BX]		// Set initial value
		XOR		AH,AH
}

/*
 * Filter status input file based on conditions
 */
int filestat(FILE *fp, unsigned filter, unsigned char *data)
{
	int c;
	if(!data[1]) {								// No pending data
again:	if((c = getc(fp)) & 0xFF00)				// EOF
			return 255;
		switch((filter << 8) | c) {
		case 0x010A :							// Remove LF
		case 0x020D :							// Remove CR
		case 0x030A :							// Remove LF - CR=CRLF
		case 0x040D :							// Remove CR - LF=CRLF
			goto again;
		} *data = c;
		data[1] = 255; }
	return 0;
}

/*
 * Filter data input based on conditions
 */
unsigned filedata(unsigned filter, unsigned char *data)
{
	switch((filter << 8) | *data) {
	case 0x030D :		// CR = CRLF
		*data = 0x0A;
		return 0x0D;
	case 0x040A :		// LF = CRLF
		if(data[1] == 255) {
			data[1] = 127;
			return 0x0D; }
	} data[1] = 0;
	return *data;
}


/*
 * Write to a virtual 8080/Z80 I/O port
 */
int OUT8080(unsigned Oport, unsigned char A)
{
	unsigned port;
	struct PORT *p;

	port = Omap[Oport];
	p = Oports[port & 0x1F];
	switch(port >> 5) {
	case 2 :				// Console data
		if(fpc) {
			if(Fconsole == 0xAA)
				putc(A, fpc); }
		cputc(A);
		break;
	case 3 :				// Uart status
		uartctrl(p, A);
		break;
	case 4 :				// Uart / Parallel Data
		out(p->W1, A ^ p->B1);
		break;
	case 6 :				// File data
		if(fpo)
			putc(A, fpo);
		break;
	case 0 :
	asm {
		MOV		AX,word ptr DGRP:Cseg2	// IO segment
		AND		AX,AX			// Defined?
		JZ		out1			// No external
		MOV		AX,4[BP]		// Get A
		MOV		BX,6[BP]		// Get port
		DB		09Ah			// FAR call
		DW		3				// offset 3 (OUT handler)
Cseg2:	DW		0				// Segment (to be filled in)
		AND		AX,AX			// Success?
		JZ		out2			// Yes.
		XOR		AH,AH			// Zero high
out1:	MOV		AL,DGRP:_Bport	// Bad port?
out2:	MOV		SP,BP
		POP		BP
		RET
	} }
	return 0;
}

/*
 * Read from a virtual 8080/Z80 I/O port
 */
int IN8080(unsigned Iport)
{
	unsigned port;
	struct PORT *p;
	unsigned char c;

	port = Imap[Iport];
	p = Iports[port & 0x1F];
	switch(port >> 5) {
	case 1 :				// Console status
		c = p->W1;
		if(fpc) {
			if(Fconsole == 0x55) {
				if(filestat(fpc, CFilter, &Cdata)) {
					fclose(fpc);
					*Cname = fpc = 0; } } }
		if(Cdata1)
			c ^= p->B1;
		return c;
	case 2 :				// Console data
		return filedata(CFilter, &Cdata);
	case 3 :				// Uart status
		return uartstat(p);
	case 4 :				// Uart / Parallel Data
		return in(p->W1) ^ p->B1;
	case 5 :				// File status
		c = p->W1;
		if(fpi) {
			if(p->B4) {
				if(p->B11) {
					--p->B11;
					goto skipf; }
				p->B11 = p->B4; }
			if(filestat(fpi, IFilter, &Fdata)) {
				if(p->B3 & 1)
					Fdata1 = 0x55;
				if(p->B3 & 2)
					rewind(fpi);
				else {
					fclose(fpi);
					*Iname = fpi = 0; } } }
skipf:	if(fpo)
			c ^= p->B1;
		if(Fdata1)
			c ^= p->B2;
		return c;
	case 6 :				// File data
		if(Fdata1 == 0x55) {
			Fdata1 = 0;
			return p->B1; }
		return fpi ? filedata(IFilter, &Fdata) : p->W1;
	default:				// Dummy ports
		return p->W1;
	case 0: }
	asm {
		MOV		AX,word ptr DGRP:Cseg3	// IO segment
		AND		AX,AX			// Defined?
		JZ		in1				// No external
		MOV		BX,4[BP]		// Get port
		DB		09Ah			// FAR call
		DW		6				// Offset 6 (OUT)
Cseg3:	DW		0				// Segment (to be filled in)
		AND		AH,AH			// Success?
		JZ		in2				// Yes
in1:	MOV		AH,DGRP:_Bport	// Bad port?
in2:
	}
}

static unsigned
	Pip,		// Input port top of list
	Pop;		// Output port top of list

/*
 * Define an I/O port from input line description
 */
void defineport(void)
{
	struct PORT *p;
	unsigned a, b, i;
	unsigned char c;
	unsigned char *cp;

	PC = 16;
	switch(toupper(*ptr++)) {
	case '!' :
		p = cdata[nline++];
		while(*p++ = *ptr)
			++ptr;
		return;
	case 'I' :
		a = getval(255);
		if((b = getval(7)) == 6)
			Finput = 255;
		Imap[a] = (b << 5) | Pip;
		p = Iports[Pip++];
		goto xport;
	case 'O' :
		a = getval(255);
		if((b = getval(7)) == 6)
			Foutput = 255;
		Omap[a] = (b << 5) | Pop;
		if(b > 5)
			return;
		p = Oports[Pop++];
xport:	memset(p, 0, sizeof(struct PORT));
		p->W1 = getval(65535);
		cp = &p->B1;
		do {
			*cp++ = getval(255); }
		while(skip());
		return;
	case 'S' :
		a = getval(65535);
		PC = 10;
		b = getval(65535)/2;
		b = 57600 / b;
		switch(toupper(*ptr++)) {
		default: error("Bad fmt");
		case 'N' : c = 0x00;	break;
		case 'O' : c = 0x08;	break;
		case 'E' : c = 0x18;	break;
		case 'M' : c = 0x28;	break;
		case 'S' : C = 0x38; }
		i = *ptr++ - '5';
		if(i > 3) error("Bad fmt");
		c |= i;
		i = *ptr++ - '1';
		if(i > 1) error("Bad fmt");
		c += (i << 2);
		out(a+3, c|0x80);
		out(a+1, b >> 8);
		out(a, b & 255);
		out(a+3, c);
		out(a+1, 0);	// No interrupts
		out(a+4, 3);	// Enable DTR+RTS
		return;
	case 'P' :
		a = getval(65535);
		out(a, getval(255));
		return;
	case 'E' :
		skip();
		b = alloc_seg(4096);
		asm " MOV word ptr DGRP:Cseg1,AX";
		asm " MOV word ptr DGRP:Cseg2,AX";
		asm " MOV word ptr DGRP:Cseg3,AX";
		filename(ptr, ".HIO", a=0);
		fp = fopen(Dbuffer, "rvqb");
		while((i = getc(fp)) != EOF)
			poke(b, a++, i);
		fclose(fp);
		asm {
			DB	09Ah	// Far call
			DW	0		// Offset 0 for init
Cseg1:		DW	0		// Segment (to be filled in)
		}
		return;
	} error("Bad port: %s", ptr-1);
}

/*
 * Default HORIZON I/O port definitions
 */
// UART STATUS: INITIAL TX RX BRK FE PE OE DSR CTS DCD RI
// UART CONTROL: XOR DTR RTS
unsigned char *DPhorizon[] = {
	"I2 2",				// Console data
	"O2 2",				// Console data
	"I3 1 5 2",			// Console status
	"O3 1",				// Console control
//	"I4 4 3F8",			// Uart data
//	"O4 4 3F8",			// Uart data
//	"I5 3 3F8 0 5 2 00 20 8 10 80",	// Uart status
//	"O5 3 3F8 0 2 20",				// Uart control
	"I4 6 1A 1A",		// Uart data (file)
	"O4 6",				// Uart data (file)
	"I5 5 5 80 2 1",	// Uart status (file)
	"O5 5",				// Uart control (ignore)
	"I0 7",				// Parallel input
	"O0 7",				// Parallel output
	"I1 7",				// mirrored parallel input
	"O1 7",				// mirrored parallel output
	"I6 7",				// Mainboard status
	"O6 7",				// Mainboard control
	"I7 7",				// mirrored mainboard status
	"O7 7",				// mirrored mainboard control
	"OC0 7",			// RAM bank select
//	"S3F8 9600 N81",
	0 };
unsigned char *DPvector[] = {
	"I0 1 80 40",
	"O0 1",
	"I1 2",
	"O1 2",
	0 };

/*
 * Draw disk drive
 */
void draw_drive(unsigned x)
{
	unsigned i;
	wopen(x, 1, 10, 9, WCOPEN|0x08);
	for(i=0; i < 9;++i) {
		wgotoxy(5, i); wputc(0xBA); }
	wopen(x+2, 4, 7, 3, WCOPEN|WBOX1|0x08);
	wclose();
	wgotoxy(5, 3); wputc(0xD0);
	wgotoxy(5, 5); wputc(0xD2);
	wgotoxy(2, 1); *W_OPEN = 0x04; wputc(0x04);
	wclose();
}

/*
 * Initialize the I/O subsystem
 */
void initio(void)
{
	unsigned i, j;
	unsigned char **dp;

	wopen(0, 0, 80, 11, WCOPEN|0x72);
	dp = DPhorizon;
	if(nline) {		// I/O definition comments - display
		*W_OPEN = 0x71;
		for(i=0; i < 11; ++i) {
			wgotoxy(0, i);
			wputs(cdata[i]); }
		wclose(); }
	else if(*CPUname == 'V') {		// VECTOR mode
		dp = DPvector;
		j = 9;
		for(i=0; i < 40; ++i) {
			*W_OPEN = 0x76;
			wgotoxy(i, j-3); wputc('/');
			wgotoxy(i, j-2); wputc('/');
			*W_OPEN = 0x72;
			wgotoxy(i, j); wputc('/');
			wgotoxy(i, j+1); wputc('/');
			if(!(i % 7)) --j; }
		while(i > 25) {
			--i;
			if(!(i % 7)) --j;
			wgotoxy(i, j-1); wputc('\\');
			wgotoxy(i, j); wputc('\\'); }
		wgotoxy(3, 10); wputs("Vector Graphics Inc.");
		*W_OPEN = 0x71;
		wgotoxy(43, 2); wputs("V E C T O R  1 \xC4\xC5\xC4"); wclose();
		wopen(56, 4, 7, 3, WCOPEN|WBOX1|0x70); wputs("Reset"); wclose();
		wopen(56, 7, 7, 3, WCOPEN|WBOX1|0x70); wputs("Power"); wclose();
		draw_drive(66); }
	else {							// HORIZON mode
		wopen(2, 8, 24,  2, WCOPEN|0x17);
		wputs(" North Star * Computers\n");
		wputs("     H O R I Z O N");
		wclose();
		draw_drive(56);
		draw_drive(67);
		*W_OPEN = 0x08;
		for(i=1; i < 10; ++i) {
			wgotoxy(66, i); wputc(0xB3); }
		wclose(); }

	// If no user definitions, install default I/O ports
	if(!(Pip | Pop)) {
		for(i=0; ptr = dp[i]; ++i)
			defineport(); }
}
