#include <stdio.h>
#include <file.h>

unsigned
	Line,
	ocount;

unsigned char
	Nonoct,
	Cflag,
	obuf[10];

FILE
	*fpi,
	*fpo;

static unsigned char help[] = { "\n\
ASM2WF converts a .ASM file containing split-byte 16-bit octal numbers\n\
to an equivalent file containing word-format 16-bit octal numbers.\n\n\
This is compatible with the DDS XASM cross assemblers - Octal numbers\n\
must be identified by a preceeding '@'.\n\n\
Use:	ASM2WF input-file output-file [/N]\n\n\
Opts:	/N	- error if Non-octal numbers are found in the input.\n\
\nDave Dunfield - "#__DATE__"\n" };

/*
 * Report an error
 */
register error(unsigned args)
{
	unsigned char temp[80];
	_format_(nargs() * 2 + &args, temp);
	fprintf(stderr, "%u: %s\n", Line+1, temp);
	exit(-1);
}

/*
 * Decode an octal value
 */
unsigned getoct(unsigned char *b)
{
	unsigned v;
	v = 0;
	while(*b)
		v = (v * 8) + (*b++ - '0');
	return v;
}

main(int argc, char *argv[])
{
	int c;
	unsigned h, l;
	unsigned char *ptr;

	IOB_size = 4096;
	for(l=1; l < argc; ++l) {
		ptr = argv[l];
		switch((toupper(*ptr++)<<8)|toupper(*ptr++)) {
		case '-N' :
		case '/N' : Nonoct = 255;	continue;
		} if(!fpi) {
			fpi = fopen(ptr-2, "rvq");
			continue; }
		if(!fpo) {
			fpo = fopen(ptr-2, "wvq");
			continue; }
		abort(help); }

	if(!fpo)
		abort(help);

	while((c = getc(fpi)) != EOF) {
again:
		putc(c, fpo);
		switch(c) {
		case '\n' :
			++Line;
			Cflag = 0;
			continue;
		case ';' :
			Cflag = 255;
			continue;
		case '0' :
		case '1' :
		case '2' :
		case '3' :
		case '4' :
		case '5' :
		case '6' :
		case '7' :
		case '8' :
		case '9' :
			if(Nonoct && !Cflag) {
				obuf[0] = c;
				obuf[1] = getc(fpi);
				obuf[2] = getc(fpi);
				obuf[3] = getc(fpi);
				obuf[4] = getc(fpi);
				obuf[5] = getc(fpi);
				obuf[6] = 0;
				error("Not-Octal value: %s", obuf); }
			continue;
		case '@' :
			ocount = 0;
			for(;;) {
				c = getc(fpi);
				if((c < '0') || (c > '7'))
					break;
				obuf[ocount++] = c;
				if(ocount > 6)
					error("More than 6 digits"); }
			obuf[ocount] = 0;
			switch(ocount) {
			default: error("Not 3 or 6 digits");
			case 3 :
				h = getoct(obuf);
				if(h > 255)
					error("out of range");
				fprintf(fpo, "%03o", h);
				break;
			case 6 :
				l = getoct(obuf+3);
				obuf[3] = 0;
				h = getoct(obuf);
				if((l > 255) || (h > 255))
					error("Out of range");
				fprintf(fpo, "%06o", (h << 8) | l); }
			goto again; } }
	fclose(fpo);
	fclose(fpi);
}
