#include <stdio.h>

unsigned
	Line,
	opos,
	tabsize = 8;

unsigned char
	nonAddr = 255,
	nonCode = 0,
	buffer[200],
	*ptr;

FILE
	*fpi,
	*fpo;

unsigned char help[] = { "\n\
LST2SB reads the .LST file produced by a DDS XASM cross assembler, and\n\
produces an equivalent file with the address/code display and octal 16-bit\n\
constants in the source converted to split-byte octal format.\n\n\
Use:	LST2SB input-file output-file [/C]\n\n\
opts:	/A	- exclude non-Address lines from output (page/line breaks)\n\
	/C	- exclude non-Code lines from the output (EQU, ORG, Comment)\n\
	T=n	- specify output Tab spacing				[8]\n\
\nDave Dunfield - "#__DATE__"\n" };

register error(unsigned args)
{
	unsigned char temp[80];
	_format_(nargs() * 2 + &args, temp);
	printf("%u: %s\n", Line, temp);
	exit(-1);
}

int skip()
{
	while(isspace(*ptr))
		++ptr;
	return *ptr;
}

unsigned gethex()
{
	unsigned v, c;
	unsigned char f;
	v = f = 0;
	for(;;) {
		c = *ptr;
		if((c >= '0') && (c <= '9'))
			c -= '0';
		else if((c >= 'A') && (c <= 'F'))
			c -= ('A'-10);
		else if((c >= 'a') && (c <= 'f'))
			c -= ('a'-10);
		else {
			if(f) switch(c) {
				case ' ' :
				case '\t':
				case 0 :
					return v; }
			error("Bad number"); }
		++ptr;
		f = 255;
		v = (v << 4) | c; }
}

tstdig(unsigned c, unsigned v)
{
	return ((c >= '0') && (c <= v));
}

// hh mmm lll hh mmm lll
fixoct(unsigned char *p)
{
	unsigned i, c, v;
	for(i=v=0; i < 6; ++i) {
		c = p[i] - '0';
		if(c > 7)
			return;
		v = (v << 3) | c; }
	c = p[6];
	sprintf(p, "%03o", v >> 8);
	sprintf(p+3, "%03o", v & 255);
	p[6] = c;
}

writebuf(unsigned char *p)
{
	int c;
	unsigned o;
	o = 0;
	while(c = *p++) {
		if(c == '\t') {
			do {
				putc(' ', fpo); }
			while(++o % tabsize);
			continue; }
		putc(c, fpo);
		++o; }
}

main(int argc, char *argv[])
{
	unsigned i;

	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((toupper(*ptr++) << 8) | toupper(*ptr++)) {
		case '-A' :
		case '/A' : nonAddr = 0;			continue;
		case '-C' :
		case '/C' : nonCode = 255;			continue;
		case 'T=' : tabsize = atoi(ptr);	continue;
		} if(!fpi) {
			fpi = fopen(ptr-2, "rvq");
			continue; }
		if(!fpo) {
			fpo = fopen(ptr-2, "wvq");
			continue; }
		abort(help); }

	if(!fpo)
		abort(help);

	while(fgets(ptr = buffer, sizeof(buffer)-1, fpi)) {
		++Line;
		opos = 0;
		if(strlen(buffer) < 25) {
raw:		if(nonAddr) {
				writebuf(buffer);
				putc('\n', fpo); }
			continue; }
		if(!isxdigit(buffer[0])) goto raw;
		if(!isxdigit(buffer[1])) goto raw;
		if(!isxdigit(buffer[2])) goto raw;
		if(!isxdigit(buffer[3])) goto raw;
		buffer[22] = 0;
		i = gethex();
		if(nonCode && !skip())
			continue;
		fprintf(fpo, "%03o%03o ", i >> 8, i & 255);
		opos += 6;
		for(i=0; i < 3; ++i) {
			if(skip())
				fprintf(fpo,"%03o ", gethex());
			else
				fputs("    ", fpo);
			opos += 4; }
		for(i=24; buffer[i]; ++i) {
			if(buffer[i] == '@')
				fixoct(buffer+i+1); }
		writebuf(buffer+24);
		putc('\n', fpo); }
	fclose(fpo);
	fclose(fpi);
}
