;
; MIL MOD8 - Monitor-8 ROM listing
;
; Retyped Dec 2006 by Dave Dunfield.
;
; Notes:
; ------
; 1.	This files uses split-byte format for 16-bit octal constants.
;	To assemble with DDS ASM88, you must convert to word-format
;	octal constants:
;		ASM2WF mon8.asm mon8wf.asm
;		ASM88 mon8wf.asm -F
;		LST2SB mon8wf.lst mon8.lst
;	The last line converts the listing back to split-byte display for
;	easier comparison with the listing from the MIL documentation.
;
; 2.	Unused bits occur in unconditional JMP/CAL/RET instructions. These
;	are somewhat "randomly" coded by the assembler used by MIL - my
;	assembler always sets them to zero - therefore, the encoding of
;	some of these instructions differs from the MIL listing, however
;	the code remains functionally identical. see (4)
;
; 3.	Like the MIL listings, this file contains NO symbols - all memory
;	references are by absolute constants - any changes to this file
;	which affect the position of instruction are very likely to render
;	the code unusable. see (4)
;
; 4.	Given the above, it seems likely that this code was originally
;	assembled by hand! - Much of my code written in the mid-70s was
;	also created this way - just a reminder of how much things have
;	changed. (Many programmers these days have never coded assembly
;	language at all, and some don't even know what machine code is).
;
;---------------------------------------------------------------------
;
;		Reset Index
; RESET NO.	Function
;  RST 000	Cold start, general restart
;  RST 010	Go to ROM 7 (for user)
;  RST 020	Output an ASCII character
;  RST 030	Input and ASCII charcter
;  RST 040	Test for RUBOUT
;  RST 050	Search for character in 'E' register
;  RST 060	Breakpoint Execute
;  RST 070	Timing loop
;
;		Subroutine index
;	(Start addresses of many of the routines used here.
;	which may be usable to other software)
; Start Address	Function
;  000013	Output carriage return and line feed
;  000177	Test for octal character
;  000205	3 digit octal input (compressed to 1 byte)
;  000255	3 digit octal input (used to display 1 byte)
;  000311	Address increment (uses CLP-LOC 013377,013376)
;  000326	Address decrement
;  000344	Address compare (CLP, CLP-1)
;  000362	Compare and increment (used to test for end of routine)
;  001000	Octal dump (DPO)
;  001023	Fetch data from location addressed by CLP
;  001047	Display data at CLP
;  001055	Display blank, CLP (address)
;  001075	Output CR/LF, CLP
;  001111	Put data into CLP
;  001120	Octal input (LDO)
;  001200	Input an address (2 bytes)
;  001236	Octal editor (EDT)
;  001336	Indirect JMP
;  001353	Clear breakpoint (CBP)
;  002000	Prom programmer routine (PRG)
;  002110	Set up CLP (LOC)
;  002115	Dump in BNPF format (DBF)
;  002201	Load in BNPF format (LBF)
;  002057	Bank to bank translate (TRN)
;  002347	Set breakpoint (SBP)
;  003000	Controller routine
;  003131	General error routine
;  003150	Table search
;  003244	Breakpoint execute
;  005063	Register decode
;  005313	Print 3 ASCII bytes
;
; ROM 0 - 000000
;
	LAI	@001		; Cold start
	OUT	@012		; Idle TTY
	XRA			; Get zero
	OUT	@013		; Idle PTR
	JMP	@003000		; Go to controller
; RST 010 - Users routine
	JMP	@007000		; Restart 0 - User routine
; 000013 CR/LF routine
	LBI	@215		; CR
	RST	@020		; Output character
	LBI	@212		; LF
; RST 020 - Output one character
	LCI	@375		;
	LDI	@177		; Set up timing
	RST	@070		; 1st bit is longer
	JMP	@000140		; Continued elsewhere
; RST 030 - I/P character
	LAI	@001
	OUT	@013		; Enable PTR
	LDI	@302		; Set up timing
	JMP	@000075		; Continued
; RST 040 - Rubout test
	LAI	@177
	CPB
	RFZ			; Not RUBOUT - return
	LBI	@337		; O/P Arrow
	RST	@020		; Output character
	RET			; Flag set to ignore input
; RST 050 - Search for character in reg E
	RST	@030		; Get character
	LAB			; Fetch I/P
	CPE			; Compare
	RTZ			; Got char
	JMP	@000050		; Try next one
	HLT			; Unused byte
; RST 060 - XQI Brkpt
	JMP	@003244		; Handle
; I/P continued
	LAB
	CPI	@001		; Cntrl-A I/P
	RFZ			; No- go ahead
	RST	@000		; Yes- panic and restart
; RST 070 - Timing loop
	IND			; Bump count
	JFZ	@000070		; Looping
	RET			; Done
; 000075 I/P continued
	HLT			; Wait for I/P
	RST	@070		; Time first bit
	XRA			; Clear A reg
	OUT	@013		; Idle ptr for now
	OUT	@012		; Start O/P
	LCI	@370		; Set up 1 bit delay
	LDI	@171
	RST	@070		; Wait for it
	INP	@000		; Get bit
	XRI	@377		; Compliment I/P
	OUT	@012		; Echo to O/P
	RAR			; Rotate into B
	LAB			; with previous
	RAR			; bits
	LBA
	INC			; Bump counter
	JFZ	@000104		; Loop for more bits
	LAB			; Got 8 bits now
	NDI	@177		; Ignore parity (MSB)
	LBA
	LDI	@171		; O/P stop
	RST	@070		; and O/P idle state
	LAI	@001
	OUT	@012
	JMP	@000063		; to be continued
; 000140 O/P (cont)
	INC
	JFZ	@000022		; Keep timing
	XRA			; Clear A
	OUT	@012		; Start O/P
	LCI	@370		; Set up timing
	LDI	@171
	RST	@070		; Wait for next bit
	LAB			; Fetch bit from B
	OUT	@012		; and output bit
	RAR			; Now set up the next
	LBA			; bit, store it in B
	LAI	@000
	RAR
	ADB
	LBA
	INC			; Bump count
	JFZ	@000150		; More to O/P, so loop
	LDI	@171		; Done
	RST	@070		; O/P Stop and Idle bits
	LAI	@001
	OUT	@012
	RET			; Goodbye
; 000177 Test for Octal
	RST	@030		; Fetch char
	NDI	@370		; Mask 3 bits
	CPI	@060		; is it 06X? (ZF tells all)
	RET			; Go away
; 000205 Octal I/P
	CAL	@000177		; Get digit
	JFZ	@000205		; Not Octal, try again
	LAB			; Put digit in A
	RRC			; Rotate
	RRC			; Rotate
	LMA			; Stash it
	RST	@030		; Fetch digit
	RST	@040		; Test for Rubout
	JTZ	@000205		; Try again
	LAM			; Fetch last digit
	NDI	@300		; Mask unused bits
	LMA			; Store it
	LAI	@007		; Put in 3 more bits
	NDB			; Rotate into position
	RLC
	RLC
	RLC
	ADM			; Add in the old data
	LMA			; Store it
; Entry for correction done
	RST	@030		; Fetch digit
	RST	@040		; Test
	JTZ	@000217		; Rubout
	LAI	@007		; Mask all but 3 bits
	NDB
	ADM			; Add the previous bits
	LMA			; Stash data
	RET			; Done
; 000255 Octal O/P 3 digits
	LBI	@240		; (blank)
	RST	@020
	LAM			; Fetch byte
	RLC			; Move bits 7 and 6
	RLC			; to pos 1 and 2
	NDI	@003		; Mask the rest
	ADI	@260		; Convert to ASCII
	LBA			; Set up for O/P
	RST	@020		; O/P
	LAM			; Fetch byte
	RRC			; Set up buts 4,5,6
	RRC
	RRC
	NDI	@007		; Mask
	ADI	@260		; Convert
	LBA
	RST	@020		; O/P
	LAM			; Bits 1,2,3 this time
	NDI	@007
	ADI	@260
	LBA			; Now O/P
	RST	@020
	RET			; All done
; 000311 Address INCR (2 bytes)
	LLI	@376		; Set to CLP
	LHI	@013
	LBM			; Fetch
	INB			; Incr LSB
	LMB			; Store
	RFZ			; Carry
	INL			; Yes- incr MSB
	LBM			; Fetch
	INB			; Incr
	LMB			; Store
	RET			; Done
; 000326 Address DECR (2 bytes)
	LLI	@376		; Set to CLP
	LHI	@013
	LBM			; Fetch
	DCB			; Decr
	LMB			; Store
	INL			; Point to MSB
	INB			; Was LSB
	RFZ			; No- return
	LBM			; Yes- do MSB
	DCB
	LMB
	RET			; Done
; 000344 Address COMP (4 bytes)
	LLI	@377		; Set to CLP
	LHI	@013
	LAM			; Fetch MSB
	DCL
	LBM			; Getch LSB
	DCL
	CPM			; Compare MSB
	RFZ			; Not equal- return
	LAB			; Put LSB into A
	DCL
	CPM			; Compare
	RET			; Go away (ZF=1 if equal)
; 000362 Comp ADDR and INCR is NOT =
	CAL	@000344		; Comp addr
	JFZ	@000311		; Incr addr
	RST	@000		; Now restart
;
	LAA			; Unused location
	LAA			; Unused location
	LAA			; Unused location
	LAA			; Unused location
	LAA			; Unused location
	LAA			; Unused location
	LAA			; Unused location
;
; ROM 1 - 001000
;
; 001000 OCTAL DUMP (DPO)
	HLT			; Wait
	LEI	@010		; Set up char/line
	CAL	@001073		; O/P CLP
	CAL	@001047		; O/P CLP Contents
	CAL	@000362		; Incr and compare CLP
	DCE			; Incr line count
	JTZ	@001001		; New line, print addr
	JMP	@001006		; Same line, just loop
; 001023 Get data (FROM CLP) - Puts data into 013370
	LLI	@377		; Set to CLP
	LHI	@013		; 
	LAM			; MS in 'A'
	DCL
	LLM			; LS in L
	LHA			; Now put MS in H
	RLC			; Rotate to test bit 8
	LAM			; Fetch LS
	RFC			; Return if not extended memory
	LHI	@013		; Get data from I/P port
	LAL			; Set temp store location
	LLI	@370
	OUT	@010		; O/P LS
	INP	@001		; Get data
	LMA			; Put into memory
	RET			; GO!
; 001047 Get data from CLP and print it
	CAL	@001023
	JMP	@000253
; 001055 O/ ' HHHLLL'
	LLI	@377		; Set to CLP
	LHI	@013
	LBI	@240		; O/P blank
	RST	@020
	CAL	@000256		; O/P MS byte
	DCL			; O/P LS byte
	JMP	@000256		; And return to CALL when done
; 001073 PRINT CR/LF HHHLLL
	LLI	@377		; Set to CLP
	LHI	@013
	CAL	@000013		; O/P CR/LF
	CAL	@001064		; O/P adr
	LBI	@257		; O/P slash
	RST	@020
	RET			; Done
; 001111 Get CLP put data there
	CAL	@001023		; Set to CLP
	JMP	@000205		; Fetch data
;
	LAA			; NOP not used
; 001120 Octal input (LDO0)
	CAL	@000013		; O/P CR/LF
	LEI	@057		; Search for slash ('/')
	RST	@050
	RST	@030		; Fetch character
	LAB
	CPI	@015		; Is it CR
	JTZ	@001123		; Yes- Wait for another slash
	CAL	@001111		; No- Put data at CLP
	CAL	@000362		; Compare and INCR CLP
	JMP	@001126		; Loop
; 001146 Copy (CPY)
	LLI	@373		; Set up 'L'
	CAL	@001205		; Input new start of block
	CAL	@001023		; Set up H and L
	LCM			; Fetch data
	LLI	@373
	CAL	@001025		; Set H,L in new adr
	LMC			; Store data
	CAL	@000362		; INCR from adr
	LLI	@372
	CAL	@000313		; INCR to adr
	JMP	@001153		; Loop
; 001200 Get address (2 bytes)
	LLI	@377		; Set CLP
	CAL	@000013		; O/P CRLF
	LBI	@252		; O/P *
	RST	@020
	LHI	@013		; CLP page
	CAL	@000205		; Get a byte (MS)
	DCL			; set L for LS
	RST	@030		; Get next byte
	RST	@040		; RUB-OUT?
	JFZ	@000213		; No- Get the new byte as before
	INL			; Yes- Restore L to MS addr
	LAM			; Fetch MS byte
	NDI	@370		; Mask 3 bits
	LMA			; Store
	CAL	@000240		; Get 3 new bits
	JMP	@001215		; Now- the LS byte
; 001236 Octal Editor (EDT)
	CAL	@001073		; CR/LF+CLP
	CAL	@001247		; Process line (BYTE)
	JMP	@001236		; Loop
	RST	@030		; Fetch I/P
	LAB
	CPI	@122		; Test for 'R'
	JTZ	@003014		; Yes- then return
	CPI	@052		; Test for '*'
	LLI	@377		; Set L to CLP
	JTZ	@002110		; Go to LOC routine
	CPI	@100		; Test for '0'
	JTZ	@003320		; Go to XQT
	CPI	@136		; Test for 'UP ARROW'
	JTZ	@000326		; Then decr CLP
	CPI	@040		; Test for blank
	JTZ	@001321		; Print this byte
	CAL	@000200		; Failed all tests, is I/P octal?
	RFZ			; No- Ignore it
	CAL	@001023		; Yes- set H and L
	CAL	@000213		; Get 2 more digits and store the byte
	JMP	@000311		; Incr CLP and loop
; 001321
	CAL	@001047		; Fetch and print data
	RST	@030		; I/P more
	LAB			; to A reg
	CPI	@137		; Is it back arrow
	CTZ	@000205		; Yes- replace data byte
	JMP	@000311		; Incr CLP and loop
; 001336 Indirect Jump
	LLI	@371
	LHI	@013		; Set H,L to unused RAM
	LMI	@104		; Store 'JMP'
	INL
	LMB			; LS adr to B
	INL
	LMA			; MS adr to A
	JMP	@013371		; Go jmp in
; 001353 Clear Breakpoint (CBP)
	LLI	@365
	LHI	@013		; 3 bytes for brkpt pointers
	LEM			; What was instr
	INL
	INL
	CAL	@001027		; Set H and L
	LDI	@100		; Is L= 100 (no brkpt set)
	CPD
	RTZ			; Yes- return untouched
	LME			; No- clear brkpt
	LLI	@367		; Replace instr
	LHI	@013		; Put 100 in MS adr location
	LMD
	RET			; Go away
;
; ROM 2 - 002000
;
; 002000 Programmer (PRG)
	LBI	@045		; Type %
	RST	@020
	RST	@030		; Input timing constant
	RLC			; Giving A= 005 (1602A/1702A)
	RLC			;        N= 071 (1602/1702)
	LEA			; Save away for later
	CAL	@001023		; Get data and set H and L
	LAL			; Get PROM address
	OUT	@010		; And output to programmer
	INP	@001		; Get ROM data
	CPM			; and if not equal
	CFZ	@002027		; Go program
	CAL	@000362		; Increment address pointer
	JMP	@002007		; and go back to test next byte
; 002027 Prog. Sequence
	LBI	@001		; Start with 1 try
	CAL	@002051		; Go program it
	LAB			; Data is not read as correct
	RLC			; So overkill 4 times
	RLC
	LBA			; B still counts tries
	CAL	@002051		; Go overkill
	DCB			; Until B
	JFZ	@002040		; Equals zero
	RST	@020		; And output null character
	RET			; Indicating end of byte
; 002051
	LAM			; Get data
	XRI	@377		; Compliment it
	OUT	@011		; And put it in the buffer
	LAI	@004		; Set up for the 15msec
	OUT	@013		; Pulse generator
	XRA			; Hit it once
	OUT	@013		; Giving one 3.0 msec pulse
	LCE			; E still has timing constant
	LDI	@325		; Inner time-out
	RST	@070		; Loop
	DCC			; Total loop time is
	JFZ	@002063		; 15 msec or 160 msec
	INP	@001		; Hows the data look?
	CPM
	RTZ			; If the same return
	INB			; B counts unsuccessful tries
	JFZ	@002051		; If not 377 tries try again
	CAL	@001055		; Print current location pointer
	LBI	@277		; and then a  ?
	RST	@020		; and give up by doing
	RST	@000		; a complete restart
; 002110 Set CLP (LOC)
	LLI	@377		; Address of CLP
	JMP	@003143		; I/P addr, ret home
; 002115 BNPF dump loop (DBF)
	HLT			; Wait
	LLI	@371		; Scratch location
	LMI	@005		; O/P 5 bytes per line
	LBI	@240		; Now, O/P a blank
	RST	@020
	CAL	@001023		; Get data
	LLA			; Save it in L
	LBI	@302		; O/P 'B'
	RST	@020
	LEI	@010		; 8 bits per byte
	LAL			; Rotate data in 'L'
	RLC			; Put next bit in carry
	LLA
	LBI	@316		; Set 'B' to 'N'
	JFC	@002150		; If bit is 0, jump
	LBI	@320		; Bit =1 so change to 'P'
	RST	@020		; O/P whatever it is
	DCE			; One more bit done
	JFZ	@002136		; Loop if more
	LBI	@306		; Done byte, O/P 'F'
	RST	@020
	CAL	@000362		; Incr, comp CLP
	LLI	@371		; Set up 'L' again
	LBM			; One more byte O/P
	DCB
	LMB
	JFZ	@002122		; More on this line
	CAL	@000013		; New line (CR/LF)
	JMP	@002116		; Keep going
; 002201 BNPF load (LBF)
	LAA			; NOP
	LEI	@102		; Wait for a 'B'
	RST	@050
	LEI	@370		; Now 8 bits expected
	CAL	@001023		; Set H,L
	LMI	@000		; Clear some RAM
	RST	@030		; Fetch character
	LAB			; Into 'A'
	CPI	@116		; Is it 'N'
	JTZ	@002232		; Yes- stash it
	XRI	@377		; No- compliment
	CPI	@257		; Is it 'P'
	JFZ	@002101		; No- Error
	RAR			; Yes- put bit in carry
	LAM			; Get previous bits
	RAL			; Rotate in new bit
	LMA			; Stash it
	INE			; Count your bits
	JFZ	@002214		; Not done, loop
	RST	@030		; Yes- one more check
	LAB
	CPI	@106		; Last character must be an 'F'
	JFZ	@002101		; No- Panic
	CAL	@000362		; Yes- Incr CLP, Check if done
	JMP	@002202		; Loop if you get here
; 002257 Bank to bank translate (TRN)
	LLI	@373
	CAL	@000205		; Fetch old bank no.
	LBI	@337		; O/P back arrow
	RST	@020
	DCL			; Fetch new bank no.
	CAL	@000205
	CAL	@001023		; Get data (INSTR)
	LEM
	CAL	@006320		; Is it 1,2 or 3 byte instr
	LEA			; 'A' has pointer (0=1byte)
	CAL	@000362		; Incr CLP        (1=2byte)
	LAE			; Rotate pointer  (3=3byte)
	RRC
	JTC	@002302		; Loop for more
	CPI	@140		; Was it a 3 byte instr (JMP or CAL)
	JFZ	@002273		; No- go to next byte
	CAL	@001023		; Yes- set up H,L
	DCL			; to last byte of JMP or CAL
	LAM			; Fetch byte
	LHI	@013		; Was it our magic no.?
	LLI	@373
	CPM
	JFZ	@002273		; No- go away
	DCL			; Yes- get the new one
	LEM
	CAL	@001023		; Set up H,L
	DCL			; (LS-1) of course
	LME			; Replace MS byte
	JMP	@002273		; Now- we are really done
; 002347 Set breakpoint (SBP)
	CAL	@001353		; Clear OLD
	CAL	@001200		; Fetch adr of new brkpt
	CAL	@001023		; Set up H,L to CLP
	LCL			; Save H,L
	LDH
	LMI	@065		; Set RST 060 into location
	LHI	@013		; Save the old instr
	LLI	@365
	LMA			; It was left in 'A'
	INL
	LMC			; 'L' (LS adr)
	INL
	LMD			; 'H' (MS adr)
	JMP	@003000		; go home to mommy
;
; ROM 3 - 003000
;
; 003000 Monitor and controller
	CAL	@000013		; CR/LF
	LEI	@010		; Set up loop
	LBI	@255		; Character is '-'
	RST	@020		; Go print '--------'
	DCE			; Count
	JFZ	@003007		; Loop
	CAL	@000013		; New line
	CAL	@003067		; Fetch input
	JFC	@003017		; Loop if not 'A'-'Z'
	CAL	@003100		; Now get two more charcters
	CAL	@003150		; Find it in the table
	JTZ	@006000		; Not found!! go to LDS
; 003036 EXEC routine
	LLI	@373
	LHI	@013
	LMA			; Store address (MS)
	DCL			; From 5 byte table
	LMB			; Store address (LS)
	NDI	@200		; From 5 byte table
	CFZ	@003137		; Go fetch  initial and final address
	CFZ	@000013		; If MS=1xxxxxxx, start with CR/LF
	LLI	@371		; JMP in 371
	LMI	@104		; Yes it is an indirect JMP
	CAL	@013371		; So go
	JMP	@003014		; And continue when done
; 003067 CHAR TEST
	RST	@030		; Get char
	LAI	@100		; Test for LT 'A'
	CPB
	LAB
	RFC			; Pass if GT or EQ 'A'
	CPI	@133		; Test for GT 'Z'
	RET			; Go, carry tells all
; 003100 SYM Input
	LEI	@002
	LLI	@350		; Char in 013350
	LHI	@013
	LMA			; Store
	CAL	@003067		; Test next char
	JFC	@003131		; Not 'A'-'Z' !! error!
	INL			; Set up next one
	DCE			; Count
	JFZ	@003106		; Not done, Loop
	LMA			; Done- store last char
	LEA			; Now set up reg, 3 goes in 'E'
	DCL
	LDM			; 2 in 'D'
	DCL
	LCM			; and 1 in 'C'
	RET			; All done
; 003131 Errors come here
	LBI	@277
	RST	@020		; Print '?'
	JMP	@003014		; Go get another input
; 003137 Initial and final adr
	CAL	@001200		; CR/LF and '*'
	DCL			; Got first adr
	LBI	@240		; Print blank
	JMP	@001207		; Get final adr, go back home
; 003150 Search table
	LBI	@022
	LLI	@021		; 5 byte table
	LHI	@004
	LAM			; Now get first char
	INL			; Ready for next char
	CPC			; Compare table and I/P
	JFZ	@003204		; JMP if not equal
	LAM			; Get 2nd
	INL			; Ready for 3rd
	CPD			; Compare
	JFZ	@003205		; JMP if not the same
	LAM			; Now for the 3rd
	INL			; And prepare for data
	CPE			; Compare as before
	JFZ	@003206		; and jump if not nice
	LBM			; Get 'GO TO' address
	INL			; 
	LAM			; 2 bytes of it
	RET			; And return
	INL			;	Look at next symbol
	INL			;	in the table
	INL
	INL
	DCB			; Count our trys
	RTZ			; End of table
	JMP	@003156		; More to check
; 003215 3byte table search
	LHI	@004
	DCC			; 'C' is counter
	RTZ			; Return when done table
	LAM			; New look at first entry
	INL			; Compare with data
	CPD			; JMP if not liked
	JFZ	@003237		; 2nd entry as above
	LAM
	CPE
	JFZ	@003237		; and jump, maybe
	INL			; Fetch data from table
	LAM
	RET			; Return to LDS routine
; 003237
	INL			; Next entry
	INL			; EOOP and try again
	JMP	@003217		; LOOP and try again
; 003244 BRKPT Execute
	LEH
	LDL			; Save L,H losing D,E
	LLI	@364		; Save registers A-E
	LHI	@013		; in RAM (LIC 013364 to 013360)
	LME
	DCL
	LMD
	DCL
	LMC
	DCL
	LMB
	DCL
	LMA
	LAI	@030		; Now display carry flag
	RAL			; Rotate in carry and convert to
	LEA			; ASCII
	LBI	@240		; O/P blank
	RST	@020
	LBE			; Carry flag
	RST	@020
	LEI	@005		; Set up count to print registers
	LLI	@360		; Start of saved registers
	CAL	@000253		; Print byte as octal
	INL			; Next register
	DCE			; Count
	JFZ	@003300		; Loop till done
	DCL			; Go back one reg
	CAL	@001027		; And get data at H,L location
	CAL	@000253		; And print it
	RST	@000		; Now we are done, go home
; 003320 XQI routine
	LLI	@373
	CAL	@003143		; Load address
	JMP	@003052		; Exec will send us there
;
; ROM number 3 continued with DPS routines
;
; 003330 DPS output
	CAL	@005352		; Get 3 bytes
	CAL	@005104		; Load them into registers
	CAL	@005313		; Output them
	LEM			; Load E with data
	CAL	@006320		; Decode length
	RRC			; 1 byte instr?
	JFC	@005363		; Yes- go to line check
	LEA			; Save length bits
	CAL	@000362		; Incr adr
	CAL	@001023		; Get data
	DCE			; 3 bytes maybe?
	JTS	@003372		; Sign flag =1 if so
	CAL	@000253		; O/P Immediate data
	JMP	@005363		; And go to line check
; 003372
	LCM			; Yes its 3 byte! get LS adr
	CAL	@000362		; Inc CLP
	LBC			; Move adr to B
	LAA			; NOP (unused byte)
;
; ROM 4 - 004000
;
	CAL	@001023		; Get data (MS adr byte)
	LCM			; Save in C
	CAL	@005104		; Load 3 bytes
	INL			; Set up data pointers
	INL
	CAL	@001061		; Output this address
	JMP	@005363		; and go on to line check
;
; ROM 4 contains the symbol tables as follows:
;
	ORG	@004021
;
; 1. 5 byte tabpe
;
; The 5 byte table occupies positions 004021 to 004157 inclusive
; and contains all monitor commands plus the machine commands HLT,
; INP,OUT,RST and the special symbol ???, indicating a no find
; condition on output. The input routine does not use this symbol.
;
; The format is thus:
;  ASCII     X     Q     T    (data field)
;  OCTAL    130   121   124   320   003
;  ADDRESS  021   022   023   024   025
;
; When a find is made during a search, the data field is moved to
; registers A dbd B, and an indirect jump is made to that address. If
; the MS half of the address is a 2xx, the exec will look for two
; addresses before going to the routine.
;
; During the symbolic dump, the last 5 symbols are used fro the
; appropriate machine commands, and are stored as output.
;
	DB	'X','Q','T',@320,@003
	DB	'E','D','T',@236,@001
	DB	'L','D','O',@120,@201
	DB	'L','B','F',@201,@202
	DB	'D','P','O',@000,@201
	DB	'D','B','F',@115,@202
	DB	'D','P','S',@000,@205
	DB	'C','P','Y',@146,@201
	DB	'T','R','N',@257,@202
	DB	'S','B','P',@347,@002
	DB	'C','B','P',@353,@001
	DB	'P','R','G',@000,@202
	DB	'L','O','C',@110,@002
	DB	'D','L','P',@055,@001
	DB	'H','L','T',@046,@006
	DB	'R','S','T',@270,@006
	DB	'I','N','P',@270,@006
	DB	'O','U','T',@270,@006
	DB	'?','?','?'
;
; 2. 3 byte table
;
; This table contains two bytes of ASCII code and one data byte,
; which is a masked portion of the instruction. The format is:
;
;  ASCII     N     D    (data)
;  OCTAL    116   104   244
;  LOCATION 252   253   254
;
; The table occupies locations 004156 to 004273, and is used in two
; ways. The LDS routine compares the two ASCII characters to the input
; characters, and returns the data in the register if a find is made.
;
; For the DPS routine, the partial word (data) is tested, and the
; H and L registers are used to retrieve the ASCII as needed.
;
	DB	'L','C',@002
	DB	'R','C',@012
	DB	'A','L',@022
	DB	'A','R',@032
	DB	'J','M','P',@104	; (JMP)
	DB	'C','A','L',@106	; (CAL)
	DB	'R','E','T',@007	; (RET)
	DB	'T','C',@040
	DB	'F','C',@000
	DB	'T','Z',@050
	DB	'F','Z',@010
	DB	'T','S',@060
	DB	'F','S',@020
	DB	'T','P',@070
	DB	'F','P',@030	; Was @050 -> @030
	DB	'A','D',@204
	DB	'A','C',@214
	DB	'S','U',@224
	DB	'S','B',@234
	DB	'N','D',@244
	DB	'X','R',@254
	DB	'O','R',@264
	DB	'C','P',@274
	DB	'I','N',@000
	DB	'D','C',@001
;
; 3. 4 byte table
;
; The 4 byte table occupies positions 004274 to 004377, and is used
; by the DPS routine. The format is:
;
;           MASK     DATA     ADDRESS  DATA FIELD
;           361      101      161      144
;  LOC      310      311      312      313
;
; The MASK character is used to mask (AND) don't care bits in the
; input byte. The remaining bits are compared to the data in the
; next field to decode an instruction. If a find is made the
; address is used for an indirect jump (to 005AAA). The last entry
; is an unconditional find which outputs the error symbol ???/
;
; The data field column is used for various purposes by the called
; routine.
;
	DB	@377,@377,@155,@132
	DB	@376,@000,@155,@132
	DB	@376,@070,@155,@156
	DB	@361,@101,@161,@144
	DB	@347,@002,@251,@037
	DB	@307,@006,@262,@352
	DB	@307,@005,@161,@137
	DB	@307,@004,@125,@111
	DB	@307,@001,@142,@273
	DB	@307,@000,@142,@270
	DB	@303,@003,@215,@202
	DB	@303,@102,@215,@176
	DB	@301,@101,@161,@151
	DB	@303,@100,@215,@172
	DB	@300,@300,@272,@000
	DB	@300,@200,@120,@000
	DB	@000,@000,@155,@156
;
; ROM 5 - 005000
;
	ORG	@005000
; 005000 Symbolic Dump
	LBI	@012
	RST	@020		; Print 3 LF's
	RST	@020
	RST	@020
	LEI	@076		; Set up lines/page
	LLI	@353		; And store number at 013353
	LHI	@013
	LME
	CAL	@001073		; Get CLP and print it
	CAL	@001047		; Get data and print it
	LEM			; Save data in 'E'
	LDM			; And in 'D'
	CAL	@005063		; Assume bits 3-5 are a destination reg.
	DCL			; Store it at 013351,013352
	LMA
	LLI	@274		; Set up start of 4-byte table
	LHI	@004
	LAD			; Get mask from table
	NDM			; And mask dont care buts
	INL			; Now check the rest
	CPM			; with the table
	JFZ	@005055		; Jump if no find
	LAI	@005		; Load MS bits of adr
	INL
	LBM			; Load LS byte of adr
	INL
	LCM			; Load C with data from table
	JMP	@001336		; and do an indirect jump to routine
	INL			; (no find) INCR L to
	INL			; next table entry
	INL
	JMP	@005035		; Go loop
; 005063 Register decode
	LAD			; Get data
	RRC
	RRC			; Look at bits 3-5
	RRC
	NDI	@007		; Mask the rest
	ADI	@370		; and add start of table
	LLA			; Table adr to 'L'dr
	LHI	@006		; MS adr of table
	LAM			; Get register
	LLI	@352
	JMP	@005114		; Done
; 005101 5 byte load
	LLI	@352		; Set DP
	LHI	@013
	LMC			; Save C
	DCL
	LMB			; Save B
	DCL			; L=350 now
	LHI	@013		; Entry for 1 byte load
	LMA			; And save A
	RET			; Go away somewhere
; 005120 ACC group routine
	LAD
	CAL	@005067		; Decode source reg
	LCA			; and put in C
; 005125 Entry for immediate
	LAD
	NDI	@070		; Mask out source part
	ADI	@204		; (Specially for 'I' instr)
	LLI	@240		; Start of ACC in 3 byte table
	CAL	@005336		; Go find data in table
	JMP	@003333		; Go print it
; 005142 INX/DCX routines
	CAL	@005063
	LLC			; Setup adr for 3 byte table
	LCA			; Save 'A' for now
	LAD			; Get binary data
	NDI	@001		; Mask all but LS bit
	JMP	@005134		; Seach table, go home
	LLC			; Get adr for 5 byte table
	JMP	@003330		; Go to output
; 005161 INP/OUT/RST
	LLC			; Table addr
	LED
	CAL	@005305		; O/P symbol
	LAM			; Fetch data
	NDI	@300		; Check bits 6-7
	LAM			; and restore data
	JTZ	@005210		; JMP to 00xxxxxx (RST)
	NDI	@076		; Mask to 00xxxxx0
	RRC			; Set up for I/O port no.
	LLI	@352		; Put the number away
	LHI	@013		; for now
	LMA
	JMP	@003364		; Go to output
	NDI	@070		; Mask data to 00XXX000	(RST no.)
	JMP	@005200		; Go output it
; 005215 JMP/CAL/RET group
	LLC
	LHI	@004		; Set up for table
	LEM			; Fetch J,C,or R from table
	LAD			; Restore binary
	NDI	@307		; Mask and check if unconditional
	INL			; Transfer
	INL
	INL
	CPM
	JTZ	@003330		; Yes- go to output
	LLI	@210		; No- look up condition
	LAD			; In 3 byte table
	NDI	@070		; Mask all but condition
	CAL	@005336		; Go search
	LCB			; Char 3
	LBA			; Char 2
	LAE			; Char 1
	JMP	@003333		; Go output
; 005251 Rotate group
	LAD			; Get data
	NDC			; Mask as per table
	LLI	@160		; Rot in 3 byte table
	LEI	@122		; Load E with 'R' and pretend
	JMP	@005240		; its a transfer
; 005262 Load Immediate
	LLC			; Set up adr
	LHI	@013
	LMI	@111		; Load 3rd char as 'I' (source reg.)
	JMP	@005276		; And treat as ordinary load
; 005272 Load reg to reg
	LAD			; Get data
	CAL	@005067		; Get source reg
	DCL
	DCL
	LMI	@114		; Load 'L' as 1st char
	JMP	@003336		; Go to output
	CAL	@005352		; 3 byte transfer
	CAL	@005104		; 3 byte load
; 005313 Print 3 bytes (routine)
	LBI	@240
	RST	@020		; O/P two blanks
	RST	@020
	LLI	@350		; Adr of first char
	LHI	@013
	LBM			; Fetch it
	RST	@020		; Print
	INL			; Next char
	LBM
	RST	@020		; Print
	INL			; Once more now
	LBM
	RST	@020
	JMP	@001023		; Go get more data
; 005@336 3 byte table search
	LHI	@004
	CPM			; Compare
	JTZ	@005356		; Exit if found
	INL			; Next entry
	INL
	INL
	JMP	@005340		; Loop
; 005352 3 byte transfer
	LHI	@004
	DCL
	LCM			; Get 3rd char from table
	DCL
	LBM			; 2nd char
	DCL
	LAM			; 1st char
	RET			; Go
; 005363 Line check
	CAL	@000362		; Incr CLP
	LLI	@353
	LEM			; Fetch line count
	DCE			; Update it
	JTZ	@005000		; End of page, O/P 3 LF's
	JMP	@005013		; Ok go on to next line
;
; ROM 6 - 006000
;
; 006000 Symbolic Load (LDS)
	LAC			; Get 1st char
	CPI	@114		; Is it an 'L'
	JFZ	@006122		; No- test for 'R'
	LBI	@306		; Partial word load instruction
	LAD			; Look at 2nd char
	CAL	@006345		; Encode as destination reg
	RLC
	RLC
	RLC
	ADB			; Stash with partial word
	LBA			; in 'B'
	LAI	@111		; Is 3rd char an 'I' ?
	CPE
	JTZ	@006043		; Yes- go to immediate routine
	LAE			; No- encode source register as above
	CAL	@006345
	LCA
	LAB			; Get dummy word
	NDI	@370		; Discard bits 0-3 (A=3x6)
	ADC			; and put in the real one
	JMP	@006046		; Now go to clean up
; 006043 Immediate Load
	LAI	@077
	NDB			; Mask to 00xxxxxx
; 006045 Finish routine
	LEA			; A has instr
	CAL	@001023		; Get CLP
	LME			; Put instr there
	LAA			; NOP (not used)
	CAL	@006320		; Decode length
	CAL	@000311		; Incr CLP
	RRC			; Check length bits
	JFC	@003014		; Leave us when no more bits to carry
	LEA			; Not done- save the bits
	LBI	@240		; Print a blank
	RST	@020
	DCE			; Is it a 3byte instr?
	JTS	@006105		; Sign flag tells all (SF=1 for 3 byte instr)
	CAL	@001111		; Get data and input
	XRA			; Clear A
	JMP	@006057		; And loop
; 006105 3byte (must want an adr)
	CAL	@000311		; Incr CLP
	CAL	@001023		; Get more data
	CAL	@001212		; and store two bytes (CLP, CLP-1)
	JMP	@006101		; Go back to loop
	HLT			; Unused HALT(1)
; 006122 Test for 1st char = 'R'
	CPI	@122
	JFZ	@006146		; No- keep looking
	LCI	@005		; Is it a rotate?
	LLI	@156
	CAL	@003215		; Search 3 byte table
	LLI	@202
	JTZ	@006234		; If no find, test for return
	JMP	@006046		; Go finish up
; 006146 ACC group
	LBE
	LED			; Put characters away
	LDC
	LCI	@013		; Set up table search
	LLI	@236		; (ACC group, IN(R), DC(R))
	CAL	@003215		; Search table
	JTZ	@006214		; No find, keep looking
	LCA			; Get 1st char
	NDI	@200		; Check for immediate instr
	LAC			; Restore char
	LEB
	JFZ	@006020		; Go away if immediate instr
	LAB			; Test the 3rd char
	CAL	@006345		; Encode as a register
	RLC
	RLC
	RLC
	ADC			; Add to partial word
	JMP	@006046		; Finish up
	CAL	@001023		; 6 bytes not used
	JMP	@003143		; (!!!)
	LCD
	LDE			; Musical registers
	LEB
	LLI	@172		; Start of table (JMP)
	LAC
	CPM			; Try 1st char
	JTZ	@006234		; Jump if find
	LLI	@176		; Try 'CAL'
	CPM
	JFZ	@003131		; No (!) must be an error
	INL			; Is it unconditional?
	LCI	@002
	CAL	@003215		; Then go to finish
	JFZ	@006046		; Get part word
	DCL			; As much as we can
	LAM			; Blank out some
	NDI	@303
	LBA			; and load up the condition
	LLI	@206
	LCI	@011
	CAL	@003215
	JTZ	@003131		; No- find error(!)
	ADB			; Add in condition bits
	JMP	@006046		; Finish it
; 006270 INP/OUT/RST
	LED
	LBI	@240		; Enter as monitor routine
	RST	@020		; Print a blank
	CAL	@000205		; Input the octal argument
	LAA			; NOP (Again -really Tom !!)
	LAE			; Get second char
	CPI	@123		; Is it an 'S'
	LAM			; Get the octal argument
	LEI	@005		; Assume it's RST
	JTZ	@006314		; And skip ahead if it is
	RLC			; Must be INP/OUT routine argument
	LEI	@101		; And put the rest into E
	ADE			; Add the two parts together
	JMP	@006046		; And finish (goodbye cruel world(
; 006320 Instruction Length Test
	XRA
	LBA			; Clear register
	LAE			; Get data
	NDI	@305
	CPI	@004		; Is it immediate?
	JTZ	@006342		; Yes- Begone
	NDI	@301
	CPI	@100		; Is it a transfer?
	LAB			; Clear A
	RFZ			; Pass if 3 byte (JMP,CAL group)
	INB			; Now set up B
	INB
	INB			; Come here if 2 byte
	LAB			; Now A is 001 or 003
	RET			; Go home and tell about it
; 006345 Register Decode
	LLI	@370
	LHI	@006		; Look at table
	CPM			; Test
	JFZ	@006361		; No find -loop
	LAL			; A find! get the address
	NDI	@007		; Mask 00000xxx
	RET			; And return with a number
	INL			; Next value
	JFZ	@006351		; Not zero go loop
	JMP	@003131		; Not in table- its an error folks
;
; Register lookup table
;
	DB	@101,@102,@103,@104,@105,@110,@114,@115
