;
; 8008 Simulation engine for MOD8
;
; ?COPY.TXT 1991-2007 Dave Dunfield
; **See COPY.TXT**.
;
DGRP	GROUP	DSEG,BSEG
CSEG	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CSEG, DS:DGRP, SS:DGRP
	PUBLIC	_S8008
	EXTRN	_inport:NEAR, _outport:NEAR, _hltirq:NEAR
; Opcode handler jump table
OJMPT	LABEL	WORD
	DW	?HLT	; 00 4
	DW	?HLT	; 01 4
	DW	?RLC	; 02 io5
	DW	?RFC	; 03 i4
	DW	?ADI	; 04 os8
	DW	?RST	; 05 5
	DW	?LAI	; 06 s8
	DW	?RET	; 07 5
	DW	?INB	; 08 io5
	DW	?DCB	; 09 io5
	DW	?RRC	; 0A io5
	DW	?RFZ	; 0B i4
	DW	?ACI	; 0C ios8
	DW	?RST	; 0D 5
	DW	?LBI	; 0E s8
	DW	?RET	; 0F 5
	DW	?INC	; 10 io5
	DW	?DCC	; 11 io5
	DW	?RAL	; 12 io5
	DW	?RFS	; 13 i4
	DW	?SUI	; 14 os8
	DW	?RST	; 15 5
	DW	?LCI	; 16 s8
	DW	?RET	; 17 5
	DW	?IND	; 18 io5
	DW	?DCD	; 19 io5
	DW	?RAR	; 1A io5
	DW	?RFP	; 1B i4
	DW	?SBI	; 1C ios8
	DW	?RST	; 1D 5
	DW	?LDI	; 1E s8
	DW	?RET	; 1F 5
	DW	?INE	; 20 io5
	DW	?DCE	; 21 io5
	DW	?NOP	; 22 2
	DW	?RTC	; 23 i4
	DW	?NDI	; 24 os8
	DW	?RST	; 25 5
	DW	?LEI	; 26 s8
	DW	?RET	; 27 5
	DW	?INH	; 28 io5
	DW	?DCH	; 29 io5
	DW	?NOP	; 2A 2
	DW	?RTZ	; 2B i4
	DW	?XRI	; 2C os8
	DW	?RST	; 2D 5
	DW	?LHI	; 2E s8
	DW	?RET	; 2F 5
	DW	?INL	; 30 io5
	DW	?DCL	; 31 io5
	DW	?NOP	; 32 2
	DW	?RTS	; 33 i4
	DW	?ORI	; 34 os8
	DW	?RST	; 35 5
	DW	?LLI	; 36 s8
	DW	?RET	; 37 5
	DW	?INM	; 38 io5
	DW	?DCM	; 39 io5
	DW	?NOP	; 3A 2
	DW	?RTP	; 3B i4
	DW	?CPI	; 3C os8
	DW	?RST	; 3D 5
	DW	?LMI	; 3E s9
	DW	?RET	; 3F 5
	DW	?JFC	; 40 id10
	DW	?INP	; 41 8
	DW	?CFC	; 42 id10
	DW	?INP	; 43 8
	DW	?JMP	; 44 d11
	DW	?INP	; 45 8
	DW	?CAL	; 46 d11
	DW	?INP	; 47 8
	DW	?JFZ	; 48 id10
	DW	?INP	; 49 8
	DW	?CFZ	; 4A id10
	DW	?INP	; 4B 8
	DW	?JMP	; 4C d11
	DW	?INP	; 4D 8
	DW	?CAL	; 4E d11
	DW	?INP	; 4F 8
	DW	?JFS	; 50 id10
	DW	?OUT	; 51 6
	DW	?CFS	; 52 id10
	DW	?OUT	; 53 6
	DW	?JMP	; 54 d11
	DW	?OUT	; 55 6
	DW	?CAL	; 56 d11
	DW	?OUT	; 57 6
	DW	?JFP	; 58 id10
	DW	?OUT	; 59 6
	DW	?CFP	; 5A id10
	DW	?OUT	; 5B 6
	DW	?JMP	; 5C d11
	DW	?OUT	; 5D 6
	DW	?CAL	; 5E d11
	DW	?OUT	; 5F 6
	DW	?JTC	; 60 id10
	DW	?OUT	; 61 6
	DW	?CTC	; 62 id10
	DW	?OUT	; 63 6
	DW	?JMP	; 64 d11
	DW	?OUT	; 65 6
	DW	?CAL	; 66 d11
	DW	?OUT	; 67 6
	DW	?JTZ	; 68 id10
	DW	?OUT	; 69 6
	DW	?CTZ	; 6A id10
	DW	?OUT	; 6B 6
	DW	?JMP	; 6C d11
	DW	?OUT	; 6D 6
	DW	?CAL	; 6E d11
	DW	?OUT	; 6F 6
	DW	?JTS	; 70 id10
	DW	?OUT	; 71 6
	DW	?CTS	; 72 id10
	DW	?OUT	; 73 6
	DW	?JMP	; 74 d11
	DW	?OUT	; 75 6
	DW	?CAL	; 76 d11
	DW	?OUT	; 77 6
	DW	?JTP	; 78 id10
	DW	?OUT	; 79 6
	DW	?CTP	; 7A id10
	DW	?OUT	; 7B 6
	DW	?JMP	; 7C d11
	DW	?OUT	; 7D 6
	DW	?CAL	; 7E d11
	DW	?OUT	; 7F 6
	DW	?ADA	; 80 o5
	DW	?ADB	; 81 o5
	DW	?ADC	; 82 o5
	DW	?ADD	; 83 o5
	DW	?ADE	; 84 o5
	DW	?ADH	; 85 o5
	DW	?ADL	; 86 o5
	DW	?ADM	; 87 o8
	DW	?ACA	; 88 io5
	DW	?ACB	; 89 io5
	DW	?ACC	; 8A io5
	DW	?ACD	; 8B io5
	DW	?ACE	; 8C io5
	DW	?ACH	; 8D io5
	DW	?ACL	; 8E io5
	DW	?ACM	; 8F io8
	DW	?SUA	; 90 o5
	DW	?SUB	; 91 o5
	DW	?SUC	; 92 o5
	DW	?SUD	; 93 o5
	DW	?SUE	; 94 o5
	DW	?SUH	; 95 o5
	DW	?SUL	; 96 o5
	DW	?SUM	; 97 o8
	DW	?SBA	; 98 io5
	DW	?SBB	; 99 io5
	DW	?SBC	; 9A io5
	DW	?SBD	; 9B io5
	DW	?SBE	; 9C io5
	DW	?SBH	; 9D io5
	DW	?SBL	; 9E io5
	DW	?SBM	; 9F io8
	DW	?NDA	; A0 o5
	DW	?NDB	; A1 o5
	DW	?NDC	; A2 o5
	DW	?NDD	; A3 o5
	DW	?NDE	; A4 o5
	DW	?NDH	; A5 o5
	DW	?NDL	; A6 o5
	DW	?NDM	; A7 o8
	DW	?XRA	; A8 o5
	DW	?XRB	; A9 o5
	DW	?XRC	; AA o5
	DW	?XRD	; AB o5
	DW	?XRE	; AC o5
	DW	?XRH	; AD o5
	DW	?XRL	; AE o5
	DW	?XRM	; AF o8
	DW	?ORA	; B0 o5
	DW	?ORB	; B1 o5
	DW	?ORC	; B2 o5
	DW	?ORD	; B3 o5
	DW	?ORE	; B4 o5
	DW	?ORH	; B5 o5
	DW	?ORL	; B6 o5
	DW	?ORM	; B7 o8
	DW	?CPA	; B8 o5
	DW	?CPB	; B9 o5
	DW	?CPC	; BA o5
	DW	?CPD	; BB o5
	DW	?CPE	; BC o5
	DW	?CPH	; BD o5
	DW	?CPL	; BE o5
	DW	?CPM	; BF o8
	DW	?LAA	; C0 5
	DW	?LAB	; C1 5
	DW	?LAC	; C2 5
	DW	?LAD	; C3 5
	DW	?LAE	; C4 5
	DW	?LAH	; C5 5
	DW	?LAL	; C6 5
	DW	?LAM	; C7 8
	DW	?LBA	; C8 5
	DW	?LBB	; C9 5
	DW	?LBC	; CA 5
	DW	?LBD	; CB 5
	DW	?LBE	; CC 5
	DW	?LBH	; CD 5
	DW	?LBL	; CE 5
	DW	?LBM	; CF 8
	DW	?LCA	; D0 5
	DW	?LCB	; D1 5
	DW	?LCC	; D2 5
	DW	?LCD	; D3 5
	DW	?LCE	; D4 5
	DW	?LCH	; D5 5
	DW	?LCL	; D6 5
	DW	?LCM	; D7 8
	DW	?LDA	; D8 5
	DW	?LDB	; D9 5
	DW	?LDC	; DA 5
	DW	?LDD	; DB 5
	DW	?LDE	; DC 5
	DW	?LDH	; DD 5
	DW	?LDL	; DE 5
	DW	?LDM	; DF 8
	DW	?LEA	; E0 5
	DW	?LEB	; E1 5
	DW	?LEC	; E2 5
	DW	?LED	; E3 5
	DW	?LEE	; E4 5
	DW	?LEH	; E5 5
	DW	?LEL	; E6 5
	DW	?LEM	; E7 8
	DW	?LHA	; E8 5
	DW	?LHB	; E9 5
	DW	?LHC	; EA 5
	DW	?LHD	; EB 5
	DW	?LHE	; EC 5
	DW	?LHH	; ED 5
	DW	?LHL	; EE 5
	DW	?LHM	; EF 8
	DW	?LLA	; F0 5
	DW	?LLB	; F1 5
	DW	?LLC	; F2 5
	DW	?LLD	; F3 5
	DW	?LLE	; F4 5
	DW	?LLH	; F5 5
	DW	?LLL	; F6 5
	DW	?LLM	; F7 8
	DW	?LMA	; F8 7
	DW	?LMB	; F9 7
	DW	?LMC	; FA 7
	DW	?LMD	; FB 7
	DW	?LME	; FC 7
	DW	?LMH	; FD 7
	DW	?LML	; FE 7
	DW	?HLT	; FF 4
; Cycle table
; 10000000 = Load flags on entry
; 01000000 = Save flags on exit
; 00100000 = Two operand bytes
; 00010000 = One operand bytes
; 00001111 = Cycle count
CYCLE	LABEL	BYTE
	DB	004h,004h,0C5h,084h,058h,005h,018h,005h	; 00-07
	DB	0C5h,0C5h,0C5h,084h,0D8h,005h,018h,005h	; 08-0F
	DB	0C5h,0C5h,0C5h,084h,058h,005h,018h,005h	; 10-17
	DB	0C5h,0C5h,0C5h,084h,0D8h,005h,018h,005h	; 18-1F
	DB	0C5h,0C5h,002h,084h,058h,005h,018h,005h	; 20-27
	DB	0C5h,0C5h,002h,084h,058h,005h,018h,005h	; 28-2F
	DB	0C5h,0C5h,002h,084h,058h,005h,018h,005h	; 30-37
	DB	0C5h,0C5h,002h,084h,058h,005h,019h,005h	; 38-3F
	DB	0AAh,008h,0AAh,008h,02Bh,008h,02Bh,008h	; 40-47
	DB	0AAh,008h,0AAh,008h,02Bh,008h,02Bh,008h	; 48-4F
	DB	0AAh,006h,0AAh,006h,02Bh,006h,02Bh,006h	; 50-57
	DB	0AAh,006h,0AAh,006h,02Bh,006h,02Bh,006h	; 58-5F
	DB	0AAh,006h,0AAh,006h,02Bh,006h,02Bh,006h	; 60-67
	DB	0AAh,006h,0AAh,006h,02Bh,006h,02Bh,006h	; 68-6F
	DB	0AAh,006h,0AAh,006h,02Bh,006h,02Bh,006h	; 70-77
	DB	0AAh,006h,0AAh,006h,02Bh,006h,02Bh,006h	; 78-7F
	DB	045h,045h,045h,045h,045h,045h,045h,048h	; 80-87
	DB	0C5h,0C5h,0C5h,0C5h,0C5h,0C5h,0C5h,0C8h	; 88-8F
	DB	045h,045h,045h,045h,045h,045h,045h,048h	; 90-97
	DB	0C5h,0C5h,0C5h,0C5h,0C5h,0C5h,0C5h,0C8h	; 98-9F
	DB	045h,045h,045h,045h,045h,045h,045h,048h	; A0-A7
	DB	045h,045h,045h,045h,045h,045h,045h,048h	; A8-AF
	DB	045h,045h,045h,045h,045h,045h,045h,048h	; B0-B7
	DB	045h,045h,045h,045h,045h,045h,045h,048h	; B8-BF
	DB	005h,005h,005h,005h,005h,005h,005h,008h	; C0-C7
	DB	005h,005h,005h,005h,005h,005h,005h,008h	; C8-CF
	DB	005h,005h,005h,005h,005h,005h,005h,008h	; D0-D7
	DB	005h,005h,005h,005h,005h,005h,005h,008h	; D8-DF
	DB	005h,005h,005h,005h,005h,005h,005h,008h	; E0-E7
	DB	005h,005h,005h,005h,005h,005h,005h,008h	; E8-EF
	DB	005h,005h,005h,005h,005h,005h,005h,008h	; F0-F7
	DB	007h,007h,007h,007h,007h,007h,007h,004h	; F8-FF
;
; Simulate an 8008 instruction
;
;	BX	contains opcode * 2
;	SI 	contains PC after instruction read
;	DL	contains cycle count
;	CL	contains first operand (if any)
;	CH	contains second operand (if any)
;
_S8008:	MOV	AL,DGRP:_HLT	; Get HLT flag
	AND	AL,AL		; Halted?
	JNZ	e88b		; Yes, stop
	MOV	SI,DGRP:_PC	; Get PC
	AND	SI,03FFFh	; Mask unused bits
	MOV	ES,DGRP:_SEG	; Get segment
	MOV	BL,ES:[SI]	; Get opcode
	INC	SI		; Skip to next
	AND	SI,3FFFh	; Mask
	XOR	BH,BH		; Zero high
	MOV	DL,CYCLE[BX]	; CL = cycle count
	SHL	BX,1		; x2
	TEST	DL,030h		; 1st operand?
	JZ	s88a		; No operand
	MOV	CL,ES:[SI]	; Get next
	INC	SI		; Skip to next
	AND	SI,3FFFh	; Mask
	TEST	DL,20h		; 2nd operand?
	JZ	s88a		; No operand
	MOV	CH,ES:[SI]	; Get next
	INC	SI		; Skip to next
	AND	SI,3FFFh	; Wrap
s88a:	TEST	DL,80h		; Load flags
	JZ	s88b		; No
	PUSH	WORD PTR DGRP:_FLAGS
	POPF
s88b:	MOV	AL,DGRP:_A	; Get ACC
	CALL	OJMPT[BX]	; Execute instruction
;
E8008:	PUSHF			; Save flags
	POP	AX		; Get into AX
	TEST	DL,40h		; Save flags on exit?
	JZ	e88a		; No
	MOV	DGRP:_FLAGS,AX	; Save flags
e88a:	MOV	DGRP:_PC,SI	; Save updated PC
	AND	DX,000Fh	; Remove all but cycle
	ADD	DX,DGRP:_CYCLE	; Add to count
	MOV	DGRP:_CYCLE,DX	; Resave
	RET
e88b:	JMP	_hltirq		; Execute HLT irq handler
;
; Halt
?HLT:	MOV	DGRP:_HLT,255	; Set HLT flag
?LAA:
?LBB:
?LCC:
?LDD:
?LEE:
?LHH:
?LLL:
?NOP:	RET
;
; Restart
?RST:	SHR	BX,1		; Move it back
	AND	BL,38h		; Save only ours
	PUSH	BX		; Save BX
	CALL	xpushPC		; Push PC
	POP	SI		; Set new SI
	RET
; Rotates
?RLC:	ROL	AL,1
	JMP	SHORT A8008	; Resave A
?RRC:	ROR	AL,1
	JMP	SHORT A8008
?RAL:	RCL	AL,1
	JMP	SHORT A8008
?RAR:	RCR	AL,1
A8008:	MOV	DGRP:_A,AL	; Resave A
	RET
; Arithmetic operations
?ADI:	ADD	AL,CL
adx:	MOV	DGRP:_A,AL
	RET
?ADA:	ADD	AL,DGRP:_A
	JMP	SHORT adx
?ADB:	ADD	AL,DGRP:_B
	JMP	SHORT adx
?ADC:	ADD	AL,DGRP:_C
	JMP	SHORT adx
?ADD:	ADD	AL,DGRP:_D
	JMP	SHORT adx
?ADE:	ADD	AL,DGRP:_E
	JMP	SHORT adx
?ADH:	ADD	AL,DGRP:_H
	JMP	SHORT adx
?ADL:	ADD	AL,DGRP:_L
	JMP	SHORT adx
?ADM:	MOV	CL,AL
	CALL	getm
	ADD	AL,CL
	JMP	SHORT adx
;
?ACI:	ADC	AL,CL
acx:	MOV	DGRP:_A,AL
	RET
?ACA:	ADC	AL,DGRP:_A
	JMP	SHORT acx
?ACB:	ADC	AL,DGRP:_B
	JMP	SHORT acx
?ACC:	ADC	AL,DGRP:_C
	JMP	SHORT acx
?ACD:	ADC	AL,DGRP:_D
	JMP	SHORT acx
?ACE:	ADC	AL,DGRP:_E
	JMP	SHORT acx
?ACH:	ADC	AL,DGRP:_H
	JMP	SHORT acx
?ACL:	ADC	AL,DGRP:_L
	JMP	SHORT acx
?ACM:	MOV	CL,AL
	CALL	getm
	ADC	AL,CL
	JMP	SHORT acx
;
?SUI:	SUB	AL,CL
sux:	MOV	DGRP:_A,AL
	RET
?SUA:	SUB	AL,DGRP:_A
	JMP	SHORT sux
?SUB:	SUB	AL,DGRP:_B
	JMP	SHORT sux
?SUC:	SUB	AL,DGRP:_C
	JMP	SHORT sux
?SUD:	SUB	AL,DGRP:_D
	JMP	SHORT sux
?SUE:	SUB	AL,DGRP:_E
	JMP	SHORT sux
?SUH:	SUB	AL,DGRP:_H
	JMP	SHORT sux
?SUL:	SUB	AL,DGRP:_L
	JMP	SHORT sux
?SUM:	MOV	CL,AL
	CALL	getm
	SUB	CL,AL
	MOV	DGRP:_A,CL
	RET
;
?SBI:	SBB	AL,CL
sbx:	MOV	DGRP:_A,AL
	RET
?SBA:	SBB	AL,DGRP:_A
	JMP	SHORT sbx
?SBB:	SBB	AL,DGRP:_B
	JMP	SHORT sbx
?SBC:	SBB	AL,DGRP:_C
	JMP	SHORT sbx
?SBD:	SBB	AL,DGRP:_D
	JMP	SHORT sbx
?SBE:	SBB	AL,DGRP:_E
	JMP	SHORT sbx
?SBH:	SBB	AL,DGRP:_H
	JMP	SHORT sbx
?SBL:	SBB	AL,DGRP:_L
	JMP	SHORT sbx
?SBM:	MOV	CL,AL
	CALL	getm
	SBB	CL,AL
	MOV	DGRP:_A,CL
	RET
; Jumps
?JTC:	JC	?JMP
	RET
?JFC:	JNC	?JMP
	RET
?JTZ:	JZ	?JMP
	RET
?JFZ:	JNZ	?JMP
	RET
?JTS:	JS	?JMP
	RET
?JFS:	JNS	?JMP
	RET
?JTP:	JPE	?JMP
	RET
?JFP:	JPO	?JMP
	RET
?CAL:	CALL	xpushPC
?JMP:	MOV	SI,CX
	RET
; Calls
?CTC:	JC	?CAL
	RET
?CFC:	JNC	?CAL
	RET
?CTZ:	JZ	?CAL
	RET
?CFZ:	JNZ	?CAL
	RET
?CTS:	JS	?CAL
	RET
?CFS:	JNS	?CAL
	RET
?CTP:	JPE	?CAL
	RET
?CFP:	JPO	?CAL
	RET
; Returns
?RTC:	JC	?RET
	RET
?RFC:	JNC	?RET
	RET
?RTZ:	JZ	?RET
	RET
?RFZ:	JNZ	?RET
	RET
?RTS:	JS	?RET
	RET
?RFS:	JNS	?RET
	RET
?RTP:	JPE	?RET
	RET
?RFP:	JPO	?RET
	RET
?RET:	MOV	BL,DGRP:_SP	; Get stack
	SUB	BL,2		; Backup
	AND	BX,0Eh		; Save only 0-7
	MOV	SI,DGRP:_STACK[BX] ; Get value
	MOV	DGRP:_SP,BL	; Resave
	RET
; Load A
?LAB:	MOV	AL,DGRP:_B
lax:	MOV	DGRP:_A,AL
	RET
?LAC:	MOV	AL,DGRP:_C
	JMP	SHORT lax
?LAD:	MOV	AL,DGRP:_D
	JMP	SHORT lax
?LAE:	MOV	AL,DGRP:_E
	JMP	SHORT lax
?LAH:	MOV	AL,DGRP:_H
	JMP	SHORT lax
?LAL:	MOV	AL,DGRP:_L
	JMP	SHORT lax
?LAM:	CALL	getm
	JMP	SHORT lax
; Load B
?LBM:	CALL	getm
?LBA:	MOV	DGRP:_B,AL
	RET
?LBC:	MOV	AL,DGRP:_C
	JMP	SHORT ?LBA
?LBD:	MOV	AL,DGRP:_D
	JMP	SHORT ?LBA
?LBE:	MOV	AL,DGRP:_E
	JMP	SHORT ?LBA
?LBH:	MOV	AL,DGRP:_H
	JMP	SHORT ?LBA
?LBL:	MOV	AL,DGRP:_L
	JMP	SHORT ?LBA
; Load C
?LCM:	CALL	getm
?LCA:	MOV	DGRP:_C,AL
	RET
?LCB:	MOV	AL,DGRP:_B
	JMP	SHORT ?LCA
?LCD:	MOV	AL,DGRP:_D
	JMP	SHORT ?LCA
?LCE:	MOV	AL,DGRP:_E
	JMP	SHORT ?LCA
?LCH:	MOV	AL,DGRP:_H
	JMP	SHORT ?LCA
?LCL:	MOV	AL,DGRP:_L
	JMP	SHORT ?LCA
; Load D
?LDM:	CALL	getm
?LDA:	MOV	DGRP:_D,AL
	RET
?LDB:	MOV	AL,DGRP:_B
	JMP	SHORT ?LDA
?LDC:	MOV	AL,DGRP:_C
	JMP	SHORT ?LDA
?LDE:	MOV	AL,DGRP:_E
	JMP	SHORT ?LDA
?LDH:	MOV	AL,DGRP:_H
	JMP	SHORT ?LDA
?LDL:	MOV	AL,DGRP:_L
	JMP	SHORT ?LDA
; Load E
?LEM:	CALL	getm
?LEA:	MOV	DGRP:_E,AL
	RET
?LEB:	MOV	AL,DGRP:_B
	JMP	SHORT ?LEA
?LEC:	MOV	AL,DGRP:_C
	JMP	SHORT ?LEA
?LED:	MOV	AL,DGRP:_D
	JMP	SHORT ?LEA
?LEH:	MOV	AL,DGRP:_H
	JMP	SHORT ?LEA
?LEL:	MOV	AL,DGRP:_L
	JMP	SHORT ?LEA
; Load H
?LHM:	CALL	getm
?LHA:	MOV	DGRP:_H,AL
	RET
?LHB:	MOV	AL,DGRP:_B
	JMP	SHORT ?LHA
?LHC:	MOV	AL,DGRP:_C
	JMP	SHORT ?LHA
?LHD:	MOV	AL,DGRP:_D
	JMP	SHORT ?LHA
?LHE:	MOV	AL,DGRP:_E
	JMP	SHORT ?LHA
?LHL:	MOV	AL,DGRP:_L
	JMP	SHORT ?LHA
; Load L
?LLM:	CALL	getm
?LLA:	MOV	DGRP:_L,AL
	RET
?LLB:	MOV	AL,DGRP:_B
	JMP	SHORT ?LLA
?LLC:	MOV	AL,DGRP:_C
	JMP	SHORT ?LLA
?LLD:	MOV	AL,DGRP:_D
	JMP	SHORT ?LLA
?LLE:	MOV	AL,DGRP:_E
	JMP	SHORT ?LLA
?LLH:	MOV	AL,DGRP:_H
	JMP	SHORT ?LLA
; Get value from [HL]
getm:	MOV	BX,WORD PTR DGRP:_L
	MOV	AL,ES:[BX]
	RET
; Put value to [HL]
?LMB:	MOV	AL,DGRP:_B
?LMA:	MOV	BX,WORD PTR DGRP:_L
	MOV	ES:[BX],AL
	RET
?LMC:	MOV	AL,DGRP:_C
	JMP	SHORT ?LMA
?LMD:	MOV	AL,DGRP:_D
	JMP	SHORT ?LMA
?LME:	MOV	AL,DGRP:_E
	JMP	SHORT ?LMA
?LMH:	MOV	AL,DGRP:_H
	JMP	SHORT ?LMA
?LML:	MOV	AL,DGRP:_L
	JMP	SHORT ?LMA
;
?LAI:	MOV	DGRP:_A,CL	; Set A
	RET
?LBI:	MOV	DGRP:_B,CL	; Set B
	RET
?LCI:	MOV	DGRP:_C,CL	; Set C
	RET
?LDI:	MOV	DGRP:_D,CL	; Set D
	RET
?LEI:	MOV	DGRP:_E,CL	; Set E
	RET
?LHI:	MOV	DGRP:_H,CL	; Set H
	RET
?LLI:	MOV	DGRP:_L,CL	; Set L
	RET
?LMI:	MOV	AL,CL		; Get immediate
	JMP	SHORT ?LMA
; Increments & Decrements
?INB:	INC	BYTE PTR DGRP:_B
	RET
?INC:	INC	BYTE PTR DGRP:_C
	RET
?IND:	INC	BYTE PTR DGRP:_D
	RET
?INE:	INC	BYTE PTR DGRP:_E
	RET
?INH:	INC	BYTE PTR DGRP:_H
	RET
?INL:	INC	BYTE PTR DGRP:_L
	RET
?INM:	CALL	getm
	INC	AL
	JMP	?LMA
;
?DCB:	DEC	BYTE PTR DGRP:_B
	RET
?DCC:	DEC	BYTE PTR DGRP:_C
	RET
?DCD:	DEC	BYTE PTR DGRP:_D
	RET
?DCE:	DEC	BYTE PTR DGRP:_E
	RET
?DCH:	DEC	BYTE PTR DGRP:_H
	RET
?DCL:	DEC	BYTE PTR DGRP:_L
	RET
?DCM:	CALL	getm
	DEC	AL
	JMP	?LMA
; AND, OR, XOR
?NDI:	AND	AL,CL
ndx:	MOV	DGRP:_A,AL
	RET
?NDA:	AND	AL,DGRP:_A
	JMP	SHORT ndx
?NDB:	AND	AL,DGRP:_B
	JMP	SHORT ndx
?NDC:	AND	AL,DGRP:_C
	JMP	SHORT ndx
?NDD:	AND	AL,DGRP:_D
	JMP	SHORT ndx
?NDE:	AND	AL,DGRP:_E
	JMP	SHORT ndx
?NDH:	AND	AL,DGRP:_H
	JMP	SHORT ndx
?NDL:	AND	AL,DGRP:_L
	JMP	SHORT ndx
?NDM:	MOV	CL,AL
	CALL	getm
	AND	AL,CL
	JMP	SHORT ndx
;
?ORI:	OR	AL,CL
orx:	MOV	DGRP:_A,AL
	RET
?ORA:	OR	AL,DGRP:_A
	JMP	SHORT orx
?ORB:	OR	AL,DGRP:_B
	JMP	SHORT orx
?ORC:	OR	AL,DGRP:_C
	JMP	SHORT orx
?ORD:	OR	AL,DGRP:_D
	JMP	SHORT orx
?ORE:	OR	AL,DGRP:_E
	JMP	SHORT orx
?ORH:	OR	AL,DGRP:_H
	JMP	SHORT orx
?ORL:	OR	AL,DGRP:_L
	JMP	SHORT orx
?ORM:	MOV	CL,AL
	CALL	getm
	OR	AL,CL
	JMP	SHORT orx
;
?XRI:	XOR	AL,CL
xrx:	MOV	DGRP:_A,AL
	RET
?XRA:	XOR	AL,DGRP:_A
	JMP	SHORT xrx
?XRB:	XOR	AL,DGRP:_B
	JMP	SHORT xrx
?XRC:	XOR	AL,DGRP:_C
	JMP	SHORT xrx
?XRD:	XOR	AL,DGRP:_D
	JMP	SHORT xrx
?XRE:	XOR	AL,DGRP:_E
	JMP	SHORT xrx
?XRH:	XOR	AL,DGRP:_H
	JMP	SHORT xrx
?XRL:	XOR	AL,DGRP:_L
	JMP	SHORT xrx
?XRM:	MOV	CL,AL
	CALL	getm
	XOR	AL,CL
	JMP	SHORT xrx
; Compares
?CPI:	CMP	AL,CL
	RET
?CPA:	CMP	AL,DGRP:_A
	RET
?CPB:	CMP	AL,DGRP:_B
	RET
?CPC:	CMP	AL,DGRP:_C
	RET
?CPD:	CMP	AL,DGRP:_D
	RET
?CPE:	CMP	AL,DGRP:_E
	RET
?CPH:	CMP	AL,DGRP:_H
	RET
?CPL:	CMP	AL,DGRP:_L
	RET
?CPM:	MOV	CL,AL
	CALL	getm
	CMP	CL,AL
	RET
; Input & output
?INP:	PUSH	SI		; Save PC
	PUSH	DX		; Save flags
	SHR	BX,1		; Reset to offset 0
	SHR	BX,1		; Drop low bit
	AND	BX,7		; Save only port number
	PUSH	BX		; Pass as parm
	CALL	_inport		; Perform C function
	POP	BX		; Clean stack
	MOV	DGRP:_A,AL	; Save result
	POP	DX		; Restore flags
	POP	SI		; Restore PC
	RET
?OUT:	PUSH	SI		; Save PC
	PUSH	DX		; Save flags
	SHR	BX,1		; Reset to offset 0
	SHR	BX,1		; Drop low bit
	AND	BX,1Fh		; Save only port number
	PUSH	BX		; Pass as parm
	XOR	AH,AH		; Zero high
	PUSH	AX		; Save
	CALL	_outport	; Perform C function
	ADD	SP,4		; Clean stack
	POP	DX		; Restore flags
	POP	SI		; Restore PC
	RET
;
; -- Housekeeping routines --
;
; Push PC on stack
xpushPC: MOV	BL,DGRP:_SP	; Get stack
	AND	BX,0Eh		; Mask
	MOV	DGRP:_STACK[BX],SI ; Save PC
	ADD	BL,2		; Skip to next
	AND	BL,0Eh		; Mask again
	MOV	DGRP:_SP,BL	; Resave SP
	RET
;
CSEG	ENDS
;
; Initialized data
;
DSEG	SEGMENT	BYTE PUBLIC 'IDATA'
	PUBLIC	_HLT, _A, _B, _C, _D, _E, _H, _L, _PC, _SP, _FLAGS
_HLT	DB	0
_A	DB	0
_C	DB	0
_B	DB	0
_E	DB	0
_D	DB	0
_L	DB	0
_H	DB	0
_SP	DB	0
_PC	DW	0
_FLAGS	DW	0
DSEG	ENDS
;
; Uninitialized data
;
BSEG	SEGMENT	BYTE PUBLIC 'UDATA'
	PUBLIC	_SEG, _STACK, _CYCLE
_SEG	DW	1 DUP(?)	; Active code segment
INTFLAG	DB	1 DUP(?)	; Interrupts captured flag
SAVESP	DW	1 DUP(?)	; Saved SP during SFR calls
_STACK	DW	8 DUP(?)	; Internal stack
_CYCLE	DW	1 DUP(?)	; Cycle counter
BSEG	ENDS
	END
