/*
; Lines with ';' and blank are ignored
#NAME text		<= Substitition text
+expression		<= Include packet if expression TRUE
-expression		<= Include packet if expression FALSE
n, %b, @o and $x are constant numbers
() 		used to nest
{}		Like () but value is printed
[n]		= Byte from packet data
[>n]	= BE word from packet
[<n]	= LE word from packet
+, -, *, /, %, &, |, ^, =, !=, <, >, <=, >=, <<, >>, &&, || = Dyadic operators
-, ~, !	= Monadic operators
*/
#include <stdio.h>
// #define DEBUG

#define	NAMES	200		// Number of names
#define	CONDS	200		// Number of conditions
#define	NLEN	16		// Length of name
#define	LEVELS	8		// Depth of resolution stack

#define	FNE		0x80	// !=
#define	FLE		0x81	// <=
#define	FGE		0x82	// >=
#define	FSL		0x83	// <<
#define	FSR		0x84	// >>
#define	FAN		0x85	// &&
#define	FOR		0x86	// ||

unsigned
	Iptr,				// Input pointer
	Ibase,				// Input base
	Seg,				// External segment
	Stop,				// Top of external segment
	Ntop,				// Top of name table
	Ctop,				// Top of condition table
	Line,				// Current line number
	Rsp,				// Resolution stack pointer
	Rstack[LEVELS],		// Resolution stack
	Bstack[LEVELS],		// Base pointer stack
	Lstack[LEVELS],		// Line number stack
	Nptr[NAMES],		// Name resolution pointers
	Cptr[CONDS],		// Condition pointers
	Nline[NAMES],		// Name lines
	Cline[CONDS];		// Condition lines
FILE
	*fpi,
	*fpo;
unsigned char
	*Ptr,				// General pointer
	*InFile,			// Input file
	*OutFile,			// Output file
	*FilFile,			// Filter file
	TxtSub = 255,		// Perform text sub
	Verbose,			// Verbose output
	Xmode,				// !0 means interpreting memory
	Ctype[CONDS],		// Conditional type
	Temp[256],			// Temp buffer
	Names[NAMES][NLEN],	// Name tables
	Buffer[2048];		// Data buffer

unsigned char Help[] = { "\
Sniff Filter - "#__DATE__" - Dave Dunfield\n\n\
Use:	SNIFFF infile outfile condfile[.FIL] [options]\n\n\
opts:	/V	- Verbose output\n" };	

unsigned value(void);
unsigned expr(unsigned char term);

// Display error line for in-memory buffered data
void showerr(unsigned line)
{
	int c;
	unsigned i, j;
	i = j = Ibase;
	if(line)
		printf("%u: ", line);
	while(c = peek(Seg, i++))
		putc((c == '\t') ? ' ' : c, stdout);
	putc('\n', stdout);
	if(line) {
		do {
			putc(' ', stdout); }
		while(line /= 10);
		fputs("  ", stdout); }
	while(++j < Iptr)
		putc(' ', stdout);
	fputs("^\n", stdout);
}

// Display a formatted error message
register error(unsigned args)
{
	unsigned char *p, buf[81];
	_format_(nargs() * 2 + &args, buf);
	printf("%u: ", Line);
	fputs(buf, stdout);
	putc('\n', stdout);
	if(Xmode) {
		showerr(0);
		while(Rsp) {
			Iptr = Rstack[--Rsp];
			Ibase = Bstack[Rsp];
			showerr(Lstack[Rsp]); } }
	else {
		fputs(p=Buffer, stdout);
		putc('\n', stdout);
		while(++p < Ptr)
			putc(' ', stdout);
		fputs("^\n", stdout); }
	exit(-1);
}

// Skip to non-blank
int skip()
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

// Add string to external segment pool
unsigned add_pool(unsigned char *s)
{
	unsigned i;
	unsigned char p;

	while(isspace(*s))
		++s;
	p = s;
	i = Stop;
	while(*s) {
		poke(Seg, Stop++, *s++);
		if(!Stop)
			error("Segment overflow"); }
	while((s > p) && isspace(*--s))
		--Stop;
	poke(Seg, Stop++, 0);
	return i;
}

#ifdef DEBUG
// Get a string from the literal pool
unsigned char *get_pool(unsigned char *dest, unsigned index)
{
	unsigned char *p, c;
	p = dest;
	do {
		*p++ = c = peek(Seg, index++); }
	while(c);
	return dest;
}
#endif

// Get character from input with automatic stack resolution
#if 0
int Xget()
{
	int c;
	unsigned i;
	unsigned char *p;
again:
	if(!(c = peek(Seg, Iptr))) {
		if(Rsp) {
			Iptr = Rstack[--Rsp];
			Ibase = Bstack[Rsp];
			Line = Lstack[Rsp];
			goto again; }
		return 0; }
	if(isalpha(c) && TxtSub) {	// Text substitution
		p = Temp;
		while(isalnum(c = peek(Seg, Iptr))) {
			*p++ = toupper(c);
			++Iptr; }
		*p = 0;
		for(i=0; i < Ntop; ++i) {
			if(!strcmp(Names[i], Temp)) {
				if(Rsp >= LEVELS)
					error("Nesting too deep");
				Lstack[Rsp] = Line;
				Bstack[Rsp] = Ibase;
				Rstack[Rsp++] = Iptr;
				Iptr = Ibase = Nptr[i];
				goto again; } }
		error("Unknown: '%s'", Temp); }
	return c;
}

// Skip to non-blank in input stream
int Xskip()
{
	int c;
	while(isspace(c=Xget()))
		++Iptr;
	return c;
}
#else
// Resolve a named symbol in the input stream
void Xresolve()
{
	unsigned i;
	for(i=0; i < Ntop; ++i) {
		if(!strcmp(Names[i], Temp)) {
			if(Rsp >= LEVELS)
				error("Nesting too deep");
			Lstack[Rsp] = Line;
			Bstack[Rsp] = Ibase;
			Rstack[Rsp++] = Iptr;
			Ibase = Iptr = Nptr[i];
			Line = Nline[i];
			return; } }
	error("Unknown: '%s'", Temp);
}

// Get next character from input stream
int Xget() asm
{
xg0:	MOV		ES,DGRP:_Seg		// Get extra segment
		MOV		BX,DGRP:_Iptr		// Get input pointer
xg1:	MOV		AL,ES:[BX]			// Get character
		AND		AL,AL				// End?
		JNZ		xg2					// No, continue
; End of string - look for Resolution Stack entry
		MOV		BX,DGRP:_Rsp		// Get stack pointer
		AND		BX,BX				// Value on stack
		JZ		xge					// No, exit
		DEC		BX					// Prev entry
		MOV		DGRP:_Rsp,BX		// Resave
		ADD		BX,BX				// *2 for word entres
		MOV		AX,DGRP:_Lstack[BX]	// Get line number
		MOV		DGRP:_Line,AX		// Reset line
		MOV		AX,DGRP:_Bstack[BX]	// Get base pointer
		MOV		DGRP:_Ibase,AX		// Set new value
		MOV		BX,DGRP:_Rstack[BX]	// Load next pointer
		MOV		DGRP:_Iptr,BX		// Save new pointer
		JMP short xg1				// And proceed
; We have data - check for alphanumerics
xg2:	CMP		AL,'A'				// Uppercase range?
		JB		xg3					// No, try lower
		CMP		AL,'Z'				// Uppercase range?
		JBE		xg4					// Yes, we have alpha
xg3:	CMP		AL,'a'				// Lowercase range?
		JB		xge					// No, not alpha
		CMP		AL,'z'				// Lowercase range?
		JA		xge					// No, not alpha
; We have alphanumeric string
xg4:	MOV		AH,DGRP:_TxtSub		// Get sub flag
		AND		AH,AH				// Do sub?
		JZ		xge					// Not alpha
; Collect string into memory buffer
		MOV		DI,offset DGRP:_Temp	// Point to dest
xg5:	MOV		AL,ES:[BX]			// Get character
		CMP		AL,'a'				// Lowercase range?
		JB		xg6					// No, try upper
		CMP		AL,'z'				// Lowercase range?
		JA		xg6					// No, upper
		AND		AL,0DFh				// Convert to upper
		JMP short xg8				// And proceed
xg6:	CMP		AL,'A'				// Uppercase range?
		JB		xg7					// No, try numeric
		CMP		AL,'Z'				// Uppercase range?
		JBE		xg8					// Yes, we have alpha
xg7:	CMP		AL,'0'				// Number?
		JB		xg9					// No - not alphanumeric
		CMP		AL,'9'				// Number?
		JA		xg9					// No - not alpha numeric
xg8:	MOV		[DI],AL				// Save data
		INC		BX					// Next in source
		INC		DI					// Next in dest
		JMP short xg5				// And get next
xg9:	XOR		AL,AL				// Get zero
		MOV		[DI],AL				// Resave
		MOV		DGRP:_Iptr,BX		// And resave BX
		CALL	_Xresolve			// Resolve
		JMP		xg0					// And continue
xge:	XOR		AH,AH				// Zero high
}

// Skip to non-blank in input stream
int Xskip() asm
{
xc1:	CALL	_Xget				// Get character
		CMP		AL,' '				// Space?
		JZ		xc2					// Handle it
		CMP		AL,09h				// Tab?
		JNZ		xc3					// No
xc2:	INC		word ptr DGRP:_Iptr	// Next
		JMP short xc1				// And continue
xc3:	XOR		AH,AH				// Zero high
}
#endif

// Process a value element (within an expression)
unsigned value(void)
{
	unsigned i, b, v, c;

	if(isdigit(c=Xskip())) {
		b = 10;
		goto num; }
	++Iptr;
	switch(c) {
	case '%' : b = 2;	goto num;
	case '@' : b = 8;	goto num;
	case '$' : b = 16;	num:
		v = i = TxtSub = 0;
		for(;;) {
			if(isdigit(c = Xget()))
				c -= '0';
			else if((c >= 'a') && (c <= 'f'))
				c -= ('a'-10);
			else if((c >= 'A') && (c <= 'F'))
				c -= ('A'-10);
			else
				break;
			v = (v * b) + c;
			++Iptr;
			++i; }
		TxtSub = 255;
		if(!i)
			error("Digit expected");
		return v;
	case '-' : return -value();
	case '~' : return ~value();
	case '!' : return !value();
	case '(' : return expr(')');
	case '{' : v = expr('}');
		printf("{%u-%04x}", v, v);
		return v;
	case '[' :		// Memory reference
		v = b = c = 1;
		switch(Xget()) {
		case '>' : v = 0;			// Big endian
		case '<' : b = 2;			// Word value
			++Iptr; }
		i = expr(']');
		if(v) {	// Little endian - work from far end
			i += (b-1);
			c = -1;
			v = 0; }
		while(b--) {
			v = (v << 8) | Buffer[i];
			i += c; }
		return v;
	} error("Syntax error");
}

// Process an expression
unsigned expr(unsigned char term)
{
	unsigned c, i, v;
	static unsigned level;

	++level;
	v = value();
top:
	switch(c = Xskip()) {			// Termination characters
	case ']' :
	case ')' :
	case '}' : ++Iptr;
	case 0 :
		if(c != term) {
			if(term)
				error("Expected: %c", term);
			error("Extra data on line"); }
		--level;
		return v; }

	++Iptr;

	switch((Xget() << 8) | c) {		// Two character operators
	case '!=' : c = FNE; goto x2;
	case '<=' : c = FLE; goto x2;
	case '>=' : c = FGE; goto x2;
	case '<<' : c = FSL; goto x2;
	case '>>' : c = FSR; goto x2;
	case '&&' : c = FAN; if(v) goto x2; goto x1;
	case '||' : c = FOR; if(!v) goto x2;
	x1:	if(level == 1) {
			--level;
			return v; }
	x2:	++Iptr; }

	i = value();

	switch(c) {						// Single character operators
	case '+' : v += i;		goto top;
	case '-' : v -= i; 		goto top;
	case '*' : v *= i;		goto top;
	case '/' : v /= i;		goto top;
	case '%' : v %= i;		goto top;
	case '&' : v &= i;		goto top;
	case '|' : v |= i;		goto top;
	case '^' : v ^= i;		goto top;
	case '=' : v = v == i;	goto top;
	case FNE : v = v != i;	goto top;
	case FLE : v = v <= i;	goto top;
	case FGE : v = v >= i;	goto top;
	case FSL : v = v << i;	goto top;
	case FSR : v = v >> i;	goto top;
	case FAN : v = v && i;	goto top;
	case FOR : v = v || i;	goto top;
	} error("Unknown operation");
}

main(int argc, char *argv[])
{
	unsigned i, j, k, l, a;
	unsigned char *p, f;

	for(i=1; i < argc; ++i) {
		Ptr = argv[i];
		switch((toupper(*Ptr++)<<8) | toupper(*Ptr++)) {
		case '/V' :
		case '-V' : Verbose = 255;		continue;
		} Ptr -= 2;
		if(!InFile) {
			InFile = Ptr;
			continue; }
		if(!OutFile) {
			OutFile = Ptr;
			continue; }
		if(!FilFile) {
			FilFile = Ptr;
			continue; }
help:	abort(Help); }
	if(!FilFile)
		goto help;

	Seg = alloc_seg(4096);

	// Get filter file name
	p = Buffer;
	f = 0;
	for(;;) switch(*p++ = *FilFile++) {
		case 0 : goto ex;
		case '.' : f = 255;	continue;
		case '\\':
		case ':' : f = 0; }
ex:	if(!f)
		strcpy(p-1, ".FIL");

	fpi = fopen(Buffer, "rvq");
	while(fgets(Ptr = Buffer, sizeof(Buffer), fpi)) {
		++Line;
		switch(skip()) {
			default: error("Unknown directive");
			case ';' :						// Comment
			case 0	 :	continue;			// Empty line
			case '#' :						// Name definition
				++Ptr;
				if(!isalpha(skip()))
					error("Bad name");
				if(Ntop >= NAMES)
					error("Too many names");
				p = Names[Ntop];
				while(isalnum(*Ptr))
					*p++ = toupper(*Ptr++);
				*p = 0;
				Nline[Ntop] = Line;
				Nptr[Ntop++] = add_pool(Ptr);
				continue;
			case '+' :	i = 255;	break;
			case '-' :	i = 0; }
		// Store a conditional defintion
		if(Ctop >= CONDS)
			error("Too many conditions");
		Cline[Ctop] = Line;
		Ctype[Ctop] = i;
		Cptr[Ctop++] = add_pool(Ptr+1); }
	fclose(fpi);
	Xmode = 255;

#ifdef DEBUG
	fpo = fopen("D:BIN", "wvqb");
	for(i=0; i < Stop; ++i)
		putc(peek(Seg, i), fpo);
	fclose(fpo);
	for(i=0; i < Ntop; ++i)
		printf("'%s' = '%s'\n", Names[i], get_pool(Buffer, Nptr[i]));
	for(i=0; i < Ctop; ++i)
		printf("'%s'\n", get_pool(Buffer, Cptr[i]));
	for(i=0; i < Ctop; ++i) {
		Iptr = Ibase = Cptr[i];
		Line = Cline[i];
		j = expr(0);
		printf("%u %04x\n", j, j); }
#endif
	fpi = fopen(InFile, "rvqb");
	fpo = fopen(OutFile, "wvqb");
	l = a = 0;
	for(;;) {
		if((k=fget(&j, 2, fpi)) != 2) {
			if(k)
				error("Corrupt file %u/%u", 2, k);
			break; }
		++l;
		if((k=fget(Buffer, j, fpi)) != j)
			error("Corrupt file %u/%u", j, k);
		for(i=f=0; i < Ctop; ++i) {
			Line = Cline[i];
			Iptr = Ibase = Cptr[i];
			if(expr(Rsp=0)) {		// True
				if(Ctype[i]) {
					fput(&j, 2, fpo);
					fput(Buffer, j, fpo);
					++a;
					f = 255; }
				break; } }
		if(Verbose)
			printf("Packet %u - %u - %s\n", i, j, f ? "Yes" : "No"); }
	fclose(fpo);
	fclose(fpi);
	printf("Rejected %u, Retained %u of %u packets.\n", l-a, a, l);
}
