#include <stdio.h>
#include <window.h>

#define	DATA_SIZE	5000

static char hello[] = {
"Sniff Reader 1.0 - 2001-2012 Dave Dunfield ** See COPY.TXT **." };

unsigned char
	*packet,				// Pointer to current packet
	*emsg = &hello,			// Error message
	to[6],					// Receiver address
	from[6],				// From address
	data[DATA_SIZE],		// Packet data
	search_type,			// Type of search
	Sbuffer[51],			// Search for text buffer
	buffer[100],			// Temp buffer
	*filename;				// Filename to read

FILE
	*fp;					// Handle to open file

unsigned
	seg0,					// Offset - byte 0
	seg1,					// Offset - byte 1
	seg2,					// Offset - byte 2
	seg3,					// Offset - byte 3
	ptop,					// Maximum packet number
	Slen,					// STbuffer length
	pnumber,				// Current packet number
	address,				// Data address
	length,					// Length of current packet
	type,					// Type of current packet

struct WINDOW
	*Twin,					// Title window
	*Dwin,					// Data window
	*Iwin;					// Information window

static char help[] = { "\n\
Use:	sniffr	filename [options]\n\n\
opts:	/M	= force Monochrome screen\n" };

static char help1[] = { "\n\
	PgUp	= Previous packet	F1	= Help request\n\
	PgDn	= Next packet		F2	= Search ASCII data\n\
	Home	= First packet		F3	= Search HEX data\n\
	End	= Last packet		F4	= Search PACKET TYPE\n\
	Up	= Previous data line	F5	= Search TO address\n\
	Down	= Next data line	F6	= Search FROM address\n\
	Left	= Previous data page	F7	= Repeat last search\n\
	Right	= Next data page	F8	= Goto packet number\n\
	^Left	= Previous data char\n\
	^Right	= Next data char	ESC	= Exit" };

unsigned m_attrs[] = {
	WSAVE|WCOPEN|REVERSE,
	WSAVE|WCOPEN|NORMAL };
unsigned c_attrs[] = {
	WSAVE|WCOPEN|0x47,
	WSAVE|WCOPEN|0x17 };
unsigned *attrs = &c_attrs;

unsigned reverse(value) asm
{
	MOV		AH,4[BP]
	MOV		AL,5[BP]
}

main(int argc, char *argv[])
{
	unsigned i, a, a1, j;
	unsigned char *ptr, *ptr1, c;

	printf("%s\n", hello);

	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((toupper(*ptr++) << 8) | toupper(*ptr++)) {
		case '?'<<8:
		case '-?' :
		case '/?' : abort(help);
		case '-M' :
		case '/M' : attrs = m_attrs;			continue;
		}
		if(filename) {
			printf("Bad option: '%s' - use ? for help\n", argv[i]);
			return; }
		filename = argv[i]; }

	if(!filename)
		abort("Filename required");

	if(!(seg0 = alloc_seg(4096*4)))
		abort("Not enough memory!");

	seg1 = seg0 + (4096*1);
	seg2 = seg0 + (4096*2);
	seg3 = seg0 + (4096*3);

	fp = fopen(filename, "rvqb");

	index_file();

	Twin = wopen(0, 0, 80, 1, WSAVE|WCOPEN|REVERSE);
	if(W_BASE == 0xB000) attrs = m_attrs;
	Iwin = wopen(0, 1, 80, 1, attrs[0]);
	Dwin = wopen(0, 2, 80,23, attrs[1]);
	wcursor_off();

re_read:
	read_packet();
	address = 0;
re_draw:
	a = a1 = address;
	for(i=0; i < 16; ++i) {
		wgotoxy(0, i+1);
		if(a < length) {
			wprintf(" %04x ", a);
			for(j=0; j < 16; ++j) {
				if(!(j&3))
					wputc(' ');
				if(a < length)
					wprintf(" %02x", data[a++]);
				else
					wputs("   "); }
			wputs("    ");
			for(j=0; j < 16; ++j) {
				if(a1 < length) {
					c = data[a1++];
					wputc(((c >= ' ') && (c <= 0x7F)) ? c : '.'); }
				else
					wputc(' '); } }
			wcleol(); }

re_cmd:
	if(emsg) {
		if(*emsg == '!')
			beep(1000, 100);
		w_printf(Twin, "\r%s", emsg);
		w_cleow(Twin);
		emsg = 0; }
	else
		w_printf(Twin, "\r%-5u  %-65s F1=help", ptop, filename);

	switch(i = wgetc()) {
	case 0x1B :
	case _K10 :
		wclose();
		wclose();
		wclose();
		fclose(fp);
		return;
	case _KPU :
		if(pnumber)
			--pnumber;
		goto re_read;
	case _KPD :
		if(++pnumber < ptop)
			goto re_read;
	case _KEN :
		pnumber = ptop-1;
		goto re_read;
	case _KHO :
		pnumber = 0;
		goto re_read;
	case _KLA :
		address = (address > 256) ? address - 256 : 0;
		goto re_draw;
	case _KRA :
		if(length <= 256)
			address = 0;
		else if((address += 256) >= (length-256))
			address = length-256;
		goto re_draw;
	case _KUA :
		address = (address > 16) ? address - 16 : 0;
		goto re_draw;
	case _KDA :
		if(length <= 256)
			address = 0;
		else if((address += 16) >= (length-256))
			address = length-256;
		goto re_draw;
	case _CLA :
		address = (address > 1) ? address - 1 : 0;
		goto re_draw;
	case _CRA :
		if(length <= 256)
			address = 0;
		else if(++address >= (length-256))
			address = length-256;
	case ' ' :		// re-fresh
		goto re_draw;
	case _K1 :		// Help request
	case '?' :
		wclwin();
		ptr = help1;
		j = 0;
		while(c = *ptr++) {
			if(c == '\t') {			/* tab */
				do
					wputc(' ');
				while(++j % 8); }
			else {						/* not a tab */
				j = (c != '\n') && j+1;
				wputc(c); } }
		wputs("\n\n      Press SPACE to continue.");
		goto re_cmd;
	case _K8 :		// Goto line number
		sprintf(buffer, "%u", pnumber+1);
	rek1:
		wgotoxy(0, 22);
		wputs("Packet num?");
		switch(wgets(15, 22, buffer, 5)) {
		default: goto rek1;
		case 0x1B: goto clean_input;
		case '\n' : }
		i = atoi(buffer) - 1;
		if(i >= ptop) {
			emsg = "!Not available";
			goto clean_input; }
		pnumber = i;
		read_packet();
		address = 0;
		goto clean_input;
	case _K2 :		// Search for ASCII
		if(search_type != 1) {
			*Sbuffer = 0;
			search_type = 1; }
	rek2:
		wgotoxy(0, 22);
		wputs("Enter string?");
		switch(wgets(15, 22, Sbuffer, 54)) {
		default: goto rek2;
		case 0x1B: goto clean_input;
		case '\n' : }
		search_data(Sbuffer, Slen = strlen(Sbuffer), address);
	clean_input:
		wcursor_off();
		wgotoxy(0, 22);
		wcleow();
		goto re_draw;
	case _K3 :		// Search for HEX
		if(search_type != 2) {
			*buffer = 0;
			search_type = 2; }
	rek3:
		wgotoxy(0, 22);
		wputs("Enter data?");
		switch(wgets(15, 22, ptr = buffer, 54)) {
		default: goto rek3;
		case 0x1B: goto clean_input;
		case '\n' : }
		Slen = 0;
		for(;;) {
			while(isspace(*ptr))
				++ptr;
			if(!*ptr) {
				search_data(Sbuffer, Slen, address);
				goto clean_input; }
			if(!isxdigit(*ptr)) {
				emsg = "!Bad hex digit";
				goto clean_input; }
			Sbuffer[Slen++] = atox(ptr);
			while(isxdigit(*ptr))
				++ptr; }
	case _K4 :		// Search for TYPE
		if(search_type != 5) {
			*buffer = 0;
			search_type = 5; }
	rek4:
		wgotoxy(0, 22);
		wputs("Enter type?");
		switch(wgets(15, 22, ptr = buffer, 4)) {
		default: goto rek4;
		case 0x1B: goto clean_input;
		case '\n' : }
		Slen = reverse(atox(ptr));
		search_ptype(Slen, pnumber);
		goto clean_input;
	case _K5 :		// Search for TO
		if(search_type != 3) {
			*buffer = 0;
			search_type = 3; }
		ptr1 = "To addr?";
		goto do_addr_search;
	case _K6 :		// Search for FROM
		if(search_type != 4) {
			*buffer = 0;
			search_type = 4; }
		ptr1 = "From addr?";
	do_addr_search:
		wgotoxy(0, 22);
		wputs(ptr1);
		switch(wgets(15, 22, ptr = buffer, 54)) {
		default: goto do_addr_search;
		case 0x1B: goto clean_input;
		case '\n' : }
		Slen = 0;
		for(;;) {
			while(isspace(*ptr))
				++ptr;
			if(!*ptr) {
				search_addr((search_type == 3) ? to : from,  Sbuffer, Slen, pnumber);
				goto clean_input; }
			if(!isxdigit(*ptr)) {
				emsg = "!Bad hex digit";
				goto clean_input; }
			Sbuffer[Slen++] = atox(ptr);
			while(isxdigit(*ptr))
				++ptr; }
	case _K7 :		// Search again
		switch(search_type) {
		case 1 : 
		case 2 : search_data(Sbuffer, Slen, address+1);			goto re_draw;
		case 3 : search_addr(to, Sbuffer, Slen, pnumber+1);		goto re_draw;
		case 4 : search_addr(from, Sbuffer, Slen, pnumber+1);	goto re_draw;
		case 5 : search_ptype(Slen, pnumber+1);					goto re_draw;
		} emsg = "!No active search";
		goto re_cmd;
	} emsg = "!Unknown command";
	goto re_cmd;
}

/*
 * Read next packet from the file
 */
read_packet()
{
	unsigned i, oh, ol;

	ol = (peek(seg1, pnumber) << 8) | peek(seg0, pnumber);
	oh = (peek(seg3, pnumber) << 8) | peek(seg2, pnumber);

	if(fseek(fp, oh, ol, 0))
		error_exit("File read error");

	if(!fget(&length, sizeof(length), fp))
		error_exit("File read error");

	if(	(fget(to, sizeof(to), fp) != sizeof(to))
	 ||	(fget(from, sizeof(from), fp) != sizeof(from))
	 || (fget(&type, sizeof(type), fp) != sizeof(type)) )
		error_exit("File read error");

	if((length -= 14) > sizeof(data))
		error_exit("File read error");

	if(fget(data, length, fp) != length)
		error_exit("File read error");

	w_printf(Iwin, "\r%-5u  to:", pnumber+1);
	for(i=0; i < sizeof(to); ++i)
		w_printf(Iwin, "%02x ", to[i]);

	w_puts("    from:", Iwin);
	for(i=0; i < sizeof(from); ++i)
		w_printf(Iwin, "%02x ", from[i]);

	w_printf(Iwin, "    type:%04x", reverse(type));
	w_cleow(Iwin);
}

/*
 * Exit the program on a fatal error
 */
error_exit(char *m)
{
	wclose();
	wclose();
	wclose();
	fclose(fp);
	fputs(m, stdout);
	exit(-1);
}

/*
 * Locate packet in buffer
 */
index_file()
{
	unsigned l;
	unsigned char offset[4], ltemp[4];

	printf("%-5u packets indexed", 0);

	longset(offset, ptop = 0);
	rewind(fp);

	for(;;) {
		if((l = fget(&length, sizeof(length), fp)) != sizeof(length)) {
			if(!l)
				break;
			format_error:
				fclose(fp);
				abort("\nPacket file format error!"); }

		if((length -= 14) > sizeof(data))
			goto format_error;

		if(	(fget(to, sizeof(to), fp) != sizeof(to))
		 ||	(fget(from, sizeof(from), fp) != sizeof(from))
		 || (fget(&type, sizeof(type), fp) != sizeof(type)) )
			goto format_error;

		if(fget(data, length, fp) != length)
			goto format_error;

		poke(seg0, ptop, offset[0]);
		poke(seg1, ptop, offset[1]);
		poke(seg2, ptop, offset[2]);
		poke(seg3, ptop, offset[3]);

		if(!(++ptop & 1023))
			printf("\r%u", ptop);
		longset(ltemp, length+16);
		longadd(offset, ltemp); }

	printf("\r%u\n", ptop);
}

compare(d1, d2, s) asm
{
		MOV		SI,8[BP]	; Get data1 pointer
		MOV		DI,6[BP]	; Get data2 pointer
		MOV		CX,4[Bp]	; Get size
xloop:	MOV		AL,[SI]		; Get data1
		CMP		AL,[DI]		; Match?
		JNZ		fail		; No, skip it
		INC		SI			; Next data1
		INC		DI			; Next data2
		LOOP	xloop		; Do them all
		MOV		AX,-1		; Indicate success
		POP		BP			; Restore caller
		RET
fail:	XOR		AX,AX		; Indicate fail
}

/*
 * Search for data in packet
 */
search_data(unsigned char *d, unsigned l, unsigned ad)
{
	unsigned l1, p, a;

	if(!l)
		return;
	p = pnumber;
	a = address;

	for(;;) {
		if(l <= length) {
			l1 = length - l;
			while(ad <= l1) {
				if(compare(data+ad, d, l)) {
					address = ad;
					return; }
				++ad; } }

		if(wtstc() == 0x1B) {
			pnumber = p;
			read_packet();
			emsg = "!Aborted";
			return; }

		if(++pnumber >= ptop) {
			pnumber = p;
			read_packet();
			emsg = "!Not found";
			return; }

		ad = 0;
		read_packet(); }
}

/*
 * Search for address in packet
 */
search_addr(unsigned char *f, unsigned char *d, unsigned l, unsigned p)
{
	unsigned l1, pn;

	if(!l)
		return;

	pn = pnumber;
	pnumber = p;

	for(;;) {
		if(pnumber >= ptop) {
			pnumber = pn;
			read_packet();
			emsg = "!Not found";
			return; }

		read_packet();

		l1 = l;
		while(l1) {
			--l1;
			if(f[l1] != d[l1])
				goto next; }
		address = 0;
		return;
	next:
		++pnumber;

		if(wtstc() == 0x1B) {
			pnumber = pn;
			read_packet();
			emsg = "!Aborted";
			return; } }
}

/*
 * Search for type in packet
 */
search_ptype(unsigned t, unsigned p)
{
	unsigned pn;

	pn = pnumber;
	pnumber = p;

	for(;;) {
		if(pnumber >= ptop) {
			pnumber = pn;
			read_packet();
			emsg = "!Not found";
			return; }

		read_packet();

		if(type == t) {
			address = 0;
			return; }

		++pnumber;

		if(wtstc() == 0x1B) {
			pnumber = pn;
			read_packet();
			emsg = "!Aborted";
			return; } }
}
