#include <stdio.h>
#include <window.h>

#define	Debug(x)		//printf x;
#define	Xdebug(x)		//printf x;

#define	WA_STAT			0x70		// Status window
#define	WA_MAIN			0x17		// MAIN window
#define	WA_EDIT			0x13		// EDIT window
#define	WA_HILITE		0x1E		// Hilited text
#define	WA_ERROR		0x14		// ERROR

unsigned
	Fseg,				// File position marker segment
	Ftop,				// File position marker segment top
	Psize,				// Size of packet
	Npacket,			// Number of packets
	Dtop,				// Top of dump struct
	Cpacket,			// Current packet
	Cdump,				// Current dump
	Lpacket = 32768,	// Last packet loaded
	Csum[2],			// Checksum Accumulator
	Crc32table[256][2],	// Precomputed Crc-32 table
	M_addr,				// Memory access address
	R_eg[3][2],			// Register values
	Line,				// Parser line number
	FindP = -1,			// Find packet
	FindS,				// Start of find offset
	FindE,				// End of find offset
	Seg,				// External segment
	Stop,				// Top of external segment
	Spos,				// Position in segment
	Position;			// Current buffer position
	Ibase = 10,			// Inline number base
	Abase = 10,			// Address number base
	Xoutp;				// Current output position

FILE
	*fp;				// General file pointer

unsigned char
	*ptr,				// General pointer
	Uline,				// Unget line flag
	M_size,				// Size of memory access
	M_size1,			// Size of first access
	M_oper,				// Memory operation type
	M_oper1,			// Type of first access
	Raw = 1,			// Raw display
	Emsg,				// Error message display
	Etype,				// Error type
	Dsize,				// Data block size
	Ftype,				// Last Find type
	Xaddr,				// Add address to value
	FindT[64],			// Text find buffer
	FindX[64],			// Hex find buffer
	Dbuffer[128],		// Data block buffer
	Pbuffer[8192];		// Packet input buffer

struct WINDOW
	*swin,				// Status window
	*mwin;				// Main window

struct DUMP_STRUCT {
	unsigned	Addr;		// Dump base address
	unsigned	Nbytes;		// Number of bytes to allow
	unsigned	Lines;		// Lines to display
	unsigned	Position;	// Current position
	unsigned	Y;			// Y - window position
	} dump_struct[16];

unsigned char Help[] = { "\n\
Use:	SNIFFV	capture_file [options]\n\n\
opts:	/A		- include Address when decoding templates\n\
	A=2|8|10|16	- numeric-base for decoded Address values	[10]\n\
	B=file[.PTB]	- load template from Binary file		[None]\n\
	I=2|8|10|16	- numeric-base for decoded Inline values	[10]\n\
	T=file[.PTT]	- load template from Text file			[None]\n\
\nIf both T= & B= are supplied, the first is converted into the second.\n\
\n2010-2012 Dave Dunfield ** See COPY.TXT **.\n" };

unsigned char Ihelp[] = { "\n\
Sniff Viewer 1.0 interactive commands:\n\
\n\
\x84F1 = Help display\x8BPgUp/PgDn\x83= Next/Previous packet\n\
\x84F2 = Template/Data/All\x86Home/End\x84= First/Last packet\n\
\x84F3 = Goto packet (number)\x84Tab/Bksp\x83= Move between dump fields\n\
\x84F5 = Search Text\x8EUp/Down\x83= Previous/Next dump line\n\
\x84F6 = Search Hex\x8DLeft/Right\x82= Previous/Next dump page\n\
\x84F7 = Repeat search\x89^Left/^Right = First/Last dump page\n\
\x83F10 = Exit Sniff Viewer" };

extern unsigned Longreg[];

/*
 * Report & error and terminate
 */
register error(unsigned args)
{
	unsigned char buf[128], *p;
	_format_(nargs() * 2 + &args, buf);
	switch(Etype) {
	case 1 :		// Definition parser
		if(Line)
			printf("%u: ", Line);
		fputs(buf, stdout);
		putc('\n', stdout);
		if(Line) {
			fputs(p=Dbuffer, stdout);
			putc('\n', stdout);
			while(p < ptr) {
				++p;
				putc(' ', stdout); }
			fputs("^\n", stdout); }
		break;
	case 2 :		// Definition decoder
		printf("%04x: ", Spos);
		goto plain;
	case 3 :		// Windowed application
		wclose();
		wclose();
	case 0 :		// Plain output
plain:	fputs(buf, stdout);
		putc('\n', stdout); }

	if(fp)
		fclose(fp);
	exit(-1);
}

register status(unsigned args)
{
	unsigned char buf[81];
	_format_(nargs() * 2 + &args, buf);
	w_clwin(swin);
	w_puts(buf, swin);
	Emsg = 255;
}

/*
 * Index the packet file
 */
void index_file(void)
{
	unsigned i, o[2], l[2];

	printf("%-5u packets indexed.", 0);

	longset(o, Ftop = Npacket = 0);
	rewind(fp);
	for(;;) {
		if((i = fget(&Psize, sizeof(Psize), fp)) != sizeof(Psize)) {
			if(!i)
				break;
fmterr:		error("Packet file format error"); }
		if(i > sizeof(Pbuffer))
			error("Packet too large (%u>%u", i, sizeof(Pbuffer));
		if(fget(Pbuffer, Psize, fp) != Psize)
			goto fmterr;
		if(!(Npacket & 3)) {
			pokew(Fseg, Ftop, o[1]);
			pokew(Fseg, Ftop+2, *o);
			Ftop += 4;
			if(!(Npacket & 255))
				printf("\r%u", Npacket+1); }
		longset(l, Psize+2);
		longadd(o, l);
		++Npacket; }
	printf("\r%u\n", Npacket);
	rewind(fp);
}

/*
 * Load a packet into memory
 */
load_packet(unsigned n)
{
	unsigned i, h, l, m;

	if((m=(n - Lpacket)) < 4) {
		goto rm; }

	m = n & 3;
	h = peekw(Fseg, i = n & 0xFFFC);
	l = peekw(Fseg, i+2);
	if(fseek(fp, h, l, 0))
		error("Seek error");

rd:	if(	(fget(&Psize, sizeof(Psize), fp) != sizeof(Psize))
	||	(fget(Pbuffer, Psize, fp) != Psize) )
		error("Read error");
rm:
	if(m & 3) {
		--m;
		goto rd; }
	Lpacket = n;
}

unsigned char PKTdata(unsigned o)
{
	if((o += Position) >= Psize) {
		*W_OPEN = WA_ERROR;
		return 0; }
	if(Lpacket == FindP) {
		if((o < FindE) && (o >= FindS))
			*W_OPEN = WA_HILITE; }
	return Pbuffer[o];
}

/*
 * Display a memory dump
 */
void dump(struct DUMP_STRUCT *d)
{
	unsigned p, l, i, j, k;
	unsigned char *a, wa;

//	status("A:%04x N:%u L:%u P:%u Y:%u", d->Addr, d->Nbytes, d->Lines, d->Position, d->Y);
	wa = *W_OPEN;
	a = d->Addr;							// Base address
	p = d->Position;						// Current position
	l = d->Nbytes;							// Maxumum length
	wgotoxy(0, d->Y);
	for(i=0; i < d->Lines; ++i) {
		wprintf(" %04x ", p);
		for(j=0; j < 16; ++j) {
			if(!(j&3))
				wputc(' ');
			if((k = p+j) < l) {
				wprintf(" %02x", PKTdata(a+k));
				*W_OPEN = wa; }
			else
				wprintf("   "); }
		wprintf("   ");
		for(j=0; j < 16; ++j) {
			k = ' ';
			if(p < l)  {
				k = PKTdata(a+p);
				if((k < ' ') || (k > 0x7E))
					k = 0xFA; }
			++p;
			wputc(k);
			*W_OPEN = wa; }
		wcleol();
		wputc('\n'); }

	i = W_OPEN->WINcurx;
	j = W_OPEN->WINcury;
	k = 78;
	if(d->Position) {
		wgotoxy(k, d->Y);
		wputc(0x18);
		if(d->Lines < 2)
			++k; }
	if(p < d->Nbytes) {
		wgotoxy(k, d->Y + d->Lines - 1);
		wputc(0x19); }
	W_OPEN->WINcurx = i;
	W_OPEN->WINcury = j;
	*W_OPEN = WA_MAIN;
}

/*
 * Record a dump into dump structure for later resolution
 */
void xdump(unsigned addr, int nbytes, unsigned lines)
{
	unsigned i;
	struct DUMP_STRUCT *d;

	if((nbytes > 0) && lines) {
		i = (nbytes + 15) / 16;
		if((i < lines) || !lines)
			lines = i;

		d = dump_struct[Dtop];
		d->Y = W_OPEN->WINcury;
		d->Addr = addr;
		d->Nbytes = nbytes;
		d->Lines = lines;
		d->Position = 0;
		dump(d);

		if((lines * 16) < nbytes)
			++Dtop; }
}

/*
 * Display MAC address
 */
void showmac(unsigned char *m, unsigned char *p)
{
	unsigned i;
	w_puts(p, swin);
	for(i=0; i < 5; ++i)
		w_printf(swin, "%02x:", *m++);
	w_printf(swin, "%02x", *m);
}

/*
 * Decode a packet
 */
void decode_packet()
{
	unsigned char f;

	*W_OPEN = WA_MAIN;
	Cdump = Dtop = Spos = 0;

	f = 0;
	switch(Raw) {
	case 0 :
		xdump(0, Psize, 24);
		break;
	case 1 :
		while(Spos < Stop) {
			longset(R_eg[2], Psize);
			*W_OPEN = WA_MAIN;
			if(test_section(f))
				f = 255; }
	default :
		if(!f)
			xdump(14, Psize-14, 24); }
}

/*
 * Adjust filename to include extension if not supplied
 */
void file(unsigned char *dest, unsigned char *source, unsigned char *ext)
{
	unsigned char f;
	f = 0;
	while(*dest = *source) {
		++dest;
		switch(*source++) {
		case ':' :
		case '\\': f = 0;	continue;
		case '.' : f = 255; } }
	if(!f)
		strcpy(dest, ext);
}

/*
 * Zero a segment
 */
void zseg(unsigned s)
{
	unsigned i;
	i = 0;
	do {
		pokew(s, i, 0); }
	while(i -= 2);
}

/*
 * Display prompt on status line & get string
 */
int string(unsigned char *prompt, unsigned char *dest, unsigned length)
{
	unsigned c, x;
	struct WINDOW *w;

	w = W_OPEN;
	W_OPEN = swin;
	wclwin();
	wputs(prompt);
	x = W_OPEN->WINcurx;
	ptr = dest;
	for(;;) switch(c = wgets(x, 0, dest, length)) {
		case 0x1B:
			W_OPEN = w;
			wcursor_off();
			return 255;
		case '\n':
			W_OPEN = w;
			wcursor_off();
			return 0; }
}

skip()
{
	while(isspace(*ptr))
		++ptr;
	return (*ptr == ';') ? 0 : *ptr;
}

/*
 * Get value from input line
 */
int value(unsigned *vp, unsigned b)
{
	unsigned c, v;
	unsigned char f;

	switch(skip()) {
	case '%' : b = 2;	goto nb;
	case '@' : b = 8;	goto nb;
	case '.' : b = 10;	goto nb;
	case '$' : b = 16;	nb: ++ptr; }

	v = f = 0;
	for(;;) {
		c = *ptr;
		if((c >= '0') && (c <= '9'))
			c -= '0';
		else if((c >= 'a') && (c <= 'f'))
			c -= ('a'-10);
		else if((c >= 'A') && (c <= 'F'))
			c -= ('A'-10);
		else
			c = 255;
		if(c > b) {
			if(f) switch(*ptr) {
				case ' ' :
				case 0 :
					*vp = v;
					return 0; }
			status("Bad number");
			return 255; }
		v = (v * b) + c;
		f = 255;
		++ptr; }
}

#define INLINE
#define	Lputc(x) wputc(x)
#include "sniffd.c"

compare(d1, d2, s) asm
{
		MOV		SI,8[BP]	; Get data1 pointer
		MOV		DI,6[BP]	; Get data2 pointer
		MOV		CX,4[Bp]	; Get size
xloop:	MOV		AL,[SI]		; Get data1
		CMP		AL,[DI]		; Match?
		JNZ		fail		; No, skip it
		INC		SI			; Next data1
		INC		DI			; Next data2
		LOOP	xloop		; Do them all
		MOV		AX,-1		; Indicate success
		POP		BP			; Restore caller
		RET
fail:	XOR		AX,AX		; Indicate fail
}

int find(void)
{
	unsigned e, length;
	unsigned char *search;

	if(Ftype) {		// Hex search
		length = 0;
		ptr = FindX;
		do {
			if(value(&e, 16))
				return 255;
			Dbuffer[length++] = e; }
		while(skip());
		search = Dbuffer; }
	else			// Text search
		length = strlen(search = FindT);

	wclwin();
	wputs("Scanning\n");
	FindP = Cpacket;
	while(FindP < Npacket) {
		wgotoxy(0, 1);
		wprintf("%u", FindP);
		load_packet(FindP);
		e = (Psize - length)+1;
		while(FindS < e) {
			if(compare(Pbuffer+FindS, search, length)) {
				status("Found at offset %u/%04x in packet %u", FindS, FindS, FindP+1);
				FindE = FindS + length;
				Cpacket = FindP;
				return 0; }
			++FindS; }
		FindS = 0;
		++FindP; }
	load_packet(Cpacket);
	status("Not found!");
	FindE = FindS = 0;
	return FindP = -1;
}

/*
 * Display status window
 */
void showstat()
{
	w_printf(swin, "\r%c%5u-%-5u%5u/%04x", "ATD"[Raw], Cpacket+1, Npacket, Psize, Psize);
	showmac(Pbuffer, "  to:");
	showmac(Pbuffer+6, "   fr:");
	w_printf(swin, "  ty:%02x%02x", Pbuffer[12], Pbuffer[13]);
}

unsigned getbase(void)
{
	unsigned b;
	switch(b = getdecimal()) {
	default: error("Bad number-base, must be: 2, 8, 10 or 16");
	case 2 :
	case 8 :
	case 10:
	case 16: }
	return b;
}

main(int argc, char *argv[])
{
	unsigned i, e;
	struct DUMP_STRUCT *d;

	e = 0;
	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((toupper(*ptr++) << 8) | toupper(*ptr++)) {
		case '-A' :
		case '/A' : Xaddr = 255;								continue;
		case 'I=' : Ibase = getbase();							continue;
		case 'A=' : Abase = getbase();							continue;
		case 'T=' : file(Pbuffer+128, ptr, ".PTT"); e += e|3;	continue;
		case 'B=' : file(Pbuffer+256, ptr, ".PTB"); e += e|4;	continue;
		}
		if(*Pbuffer)
			abort(Help);
		file(Pbuffer, ptr-2, "");
	}

	// Handle template
	if(e) {
		zseg(Seg = (Fseg = alloc_seg(8192)) + 4096);
		switch(e) {
		default: error("Invalid T=/B= arguments");
		case 10 :	// T= B=
			if(*Pbuffer)
				abort(Help);
		case 3 :	// T=
			fp = fopen(Pbuffer+128, "rvq");
			Etype = 1;
			while(define_section());
			fclose(fp);
			break;
		case 11 :	// B= T=
			if(*Pbuffer)
				abort(Help);
		case 4 :	// B=
			fp = fopen(Pbuffer+256, "rvqb");
			while((i = getc(fp)) != EOF)
				poke(Seg, Stop++, i);
			fclose(fp); }
		printf("Template size: %u\n", Stop);
		switch(e) {
		case 10 :	// T= B=
			fp = fopen(Pbuffer+256, "wvqb");
			for(i=0; i < Stop; ++i)
				putc(peek(Seg, i), fp);
			fclose(fp);
			return;
		case 11 :	// B= T=
			fp = fopen(Pbuffer+128, "wvq");
			Etype = 2;
			while(Spos < Stop)
				decode_section();
			fclose(fp);
			return; }
		if(Xaddr)
			return; }
	else
		Fseg = alloc_seg(4096);

	if(!*Pbuffer)
		abort(Help);

	zseg(Fseg);
	fp = fopen(Pbuffer, "rvqb");
	index_file();
	swin = wopen(0, 0, 80, 1, WSAVE|WCOPEN|WA_STAT);
	mwin = wopen(0, 1, 80,24, WSAVE|WCOPEN|WA_MAIN);
	wcursor_off();
	Etype = 3;
	status("Sniff Viewer 1.0 - Dave Dunfield - "#__DATE__" - Press F1 for help.");

reload:
	load_packet(Cpacket);
redraw:
	if((Raw == 1) && !Stop)
		Raw = 2;
	if(!Emsg)
		showstat();
	wclwin();
	decode_packet();
redump:
	if(Dtop) {
		*W_OPEN = WA_EDIT;
		dump(d = dump_struct[Cdump]);
		e = ((d->Nbytes - 1) & 0xFFF0) - ((d->Lines-1) * 16); }
	for(;;)	{
		i = wgetc();
		if(Emsg) {
			showstat();
			Emsg = 0; }
		switch(i) {
		case _KPU: if(Cpacket) --Cpacket;	goto reload;
		case _KHO: Cpacket = 0;				goto reload;
		case _KPD: if(++Cpacket < Npacket)	goto reload;
		case _KEN: Cpacket = Npacket-1;		goto reload;
		case _K1 :
		case '?' :
			wclwin();
			ptr = Ihelp;
			while(i = *ptr++) {
				if(i & 0x80) {
					while(i & 0x7F) {
						--i;
						wputc(' '); }
					continue; }
				wputc(i); }
			wgotoxy(0, 23); wputs("Press any key.");
			wgetc();
			goto redraw;
		case _K2 : if(++Raw > 2) Raw = 0;	goto redraw;
		case _K3 :
			*Dbuffer = 0;
			if(string("Packet?", Dbuffer, 10))
				goto redraw;
			if(value(&i, 10))
				goto redraw;
			if(--i >= Npacket) {
				status("Packet # must be 1-%u", Npacket);
				goto redraw; }
			Cpacket = i;
			goto reload;
		case _K5 :
			if(string("Find-Text?", FindT, sizeof(FindT)-1))
				goto redraw;
			Ftype = FindS = 0;
			find();
			goto redraw;
		case _K6 :
			if(string("Find-Hex?", FindX, sizeof(FindX)-1))
				goto redraw;
			Ftype = 1;
			FindS = 0;
			find();
			goto redraw;
		case _K7 :
			if(!FindE) {
				status("No search active");
				continue; }
			if(FindP == Cpacket)
				++FindS;
			else
				FindS = 0;
			find();
			goto redraw;
		case _K10 :
		case 0x1B :
			wclose();
			wclose();
			fclose(fp);
			return;	}

		if(Dtop) switch(i) {
		case _KBS:					// Previous field
			i = (Cdump ? Cdump : Dtop) - 1;
		chdump:
			dump(dump_struct[Cdump]);
			Cdump = i;
			goto redump;
		case '\t':					// Next field
			if((i = Cdump + 1) >= Dtop)
				i = 0;
			goto chdump;
		case _KUA:					// Up in field
			d->Position -= 16;
		UPT:if(!(d->Position & 0x8000))
				goto redump;
		case _CLA:					// Beginning of field
			d->Position = 0;
			goto redump;
		case _KDA:					// Down in field
			d->Position += 16;
		DNT:if(d->Position <= e)
			goto redump;
		case _CRA:					// End of field
			d->Position = e;
			goto redump;
		case _KLA: d->Position -= (d->Lines * 16);	goto UPT;
		case _KRA: d->Position += (d->Lines * 16);	goto DNT; } }
}
