// Changed
#include <stdio.h>
#include <file.h>
#define	DEBUG	2
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#define	POOL		16384
#define	TREES		16
#define	NPATS		16

#define	O_BEFORE	0x01
#define	O_MARK		0x02
#define	O_SDIR		0x04
#define	O_TREE		0x08
#define	O_NINI		0x10
#define	O_WRITE		0x20
#define	O_QUIET		0x40
#define	O_FORM		0x80	// Force Mark

unsigned
	Line,
	ISyes, ISno, IScur,
	Y, Mo, D, H, Mi, Se,
	_Y, _Mo, _D, _H, _Mi, _Se,
	Sh, Sl, At, Ti, Da,
	Cti, Cda,
	Fname, Fext,
	Ttop,
	Ntop,
#if DEBUG&1 
	MPtop,
#endif
	Ptop;
FILE
	*fp;
unsigned char
	*Ptr,
	*Tfile,
	*Tree[TREES],
	*Npat[NPATS],
	Opt,
	ABflg,
	Dtop,			// Dir follow
	Dir[256],		// Dtop preceed
	Pattern[128],
	Xpattern[128],
	Wtop,
	Wdir[128],
	Ctop,
	Cfile[128],
	Temp[128],
	CpyBuf[4096],
	Pool[POOL];
#define	MSIZE	(POOL+4096+128)

#ifdef _DVM_
	#include "R:\\Vhelp.h"
	#define	Help	Vhelp
#else
	#include "R:\\DHelp.H"
	#define	Help	Dhelp
#endif

void Pc(unsigned char c)	{	putc(c, stdout);	}
void Ps(unsigned char *s)	{	fputs(s, stdout);	}
void Nl(void)				{	Pc('\n');			}
//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	if(Line) printf("%u: ", Line);
	Ps(buf);
	exit(-1);
}

// Skip to non-blank
int skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

unsigned trim(void)
{
	unsigned i;
	i = 0;
	while(Ptr[i]) ++i;
	while(i && isspace(Ptr[i-1])) --i;
	Ptr[i] = 0;
	return i;
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			Error("String pool overflow"); }
	while(Pool[Ptop++] = *p++);
#if DEBUG&1
	if(Ptop > MPtop)
		MPtop = p;
#endif
	return Pool+t;
}

/*
 * Match a filename against a pattern using unix rules
 * - '?' matches any single character
 * - '*' matches any substring
 * - '.' is treated like any other character
 */
int Fmatch(unsigned char *name, unsigned char *pattern)
{
	unsigned char c;

//	for(;;) switch(c = toupper(*pattern++)) {
	for(;;) switch(c = *pattern++) {
	case 0 : return *name == 0;	// ?!*name
	case '?' :
		if(!*name++)
			return 0;
		break;
	case '*' :
		if(!*pattern)
			return 1;
		while(*name) {
			if(Fmatch(name, pattern))
				return 1;
			++name; }
		return 0;
	default:
//		if(toupper(*name++) != c)
		if(*name++ != c)
			return 0; }
}

unsigned compare(void)
{
	unsigned i;
	for(i=0; i < Ntop; ++i) {
		if(Fmatch(Temp, Npat[i]))
			return 0; }
	i = 0;
	if(Da > Cda) goto r1;
	if(Da < Cda) goto r0;
	if(Ti > Cti) {
r1:		i = 255; }
r0:	if(Opt & O_BEFORE)
		i = i ? 0 : 255;
	return i;
}

void End(unsigned char *p, unsigned char *e)
{
	unsigned t;
	t = *p++;
	while(p[t]) ++t;
	if(t && e) switch(p[t-1]) {
	default	:
		p[t++] = '\\';
	case ':':
	case'\\':	strcpy(p+t, e); }
	*--p = t;
}

void Wstart()
{
//	unsigned y, m, d;
	unsigned i;
	if(!*Wdir)
		Error("?W=");
//	get_date(&d, &m, &y);
	sprintf(Temp, "%u%02u%02u", Y, Mo, D);
	End(&Wtop, Temp);
	Ps("Wdir: ");
	Ps(Wdir);
	Nl();
	if(mkdir(Wdir))
		Error("mkdir failed");
	i = 0; while(Temp[i]) ++i;
	strcpy(Temp+i, ".TXT");
	End(&Wtop, Temp);
	Debug(("o1'%s'\n", Wdir))
	fp = fopen(Wdir, "wvq");
}
void Write()
{
	FILE	*fpi, *fpo;
	unsigned i;
	static unsigned wn;
	if(!Wtop)
		Wstart();
	sprintf(Wdir+Wtop, "%u", ++wn);
	Ps(Wdir+Wtop);
	Pc('\t');
	Ps(Dir);
	Nl();

	fputs(Wdir+Wtop, fp);
	putc('\t', fp);
	fputs(Dir, fp);
	putc('\n', fp);

	Debug(("O2'%s'%s'\n", Dir, Wdir))
	fpi = fopen(Dir, "rbvq");
	fpo = fopen(Wdir, "wbvq");
	while(i = fget(CpyBuf, sizeof(CpyBuf), fpi)) {
		fput(CpyBuf, i, fpo);
		if(i != sizeof(CpyBuf))
			break; }
	fclose(fpo);
	fclose(fpi);
}

void showtd(unsigned ti, unsigned da)
{
	printf("%04u-%02u-%02u", (da>>9)+1980,		(da>>5)&15, da&31);
	printf(" %3u:%02u:%02u", ti>>11,	(ti>>5)&63, (ti&31)*2);
}
	
void dodir(void)
{
	unsigned i, dt, pt;
	dt = Dtop; pt = Ptop;
//	while(Dir[Dtop]) ++Dtop;
	End(&Dtop, "");
	if(Opt & O_SDIR) {
//		Dir[Dtop] = 0;
		Ps("Dir: ");
		Ps(Dir);
		Nl(); }
	strcpy(Dir+Dtop, "*.*");
	if(find_first(Dir, 0x3F, Temp, &Sh, &Sl, &At, &Ti, &Da))
		goto ex;
	do {
#ifdef _DVM_
		if(At & (DIRECTORY)) {
			if(*Temp != '.')
				Pstring(Temp);
			continue; }
#else
		if(At & (DIRECTORY|HIDDEN|SYSTEM|VOLUME)) {
			if(!(At & (HIDDEN|SYSTEM|VOLUME))) {
				if(*Temp != '.')
					Pstring(Temp); }
			continue; }
#endif
		if(kbtst() == 0x1B)
			Error("?Abort");
		if(Fmatch(Temp, Pattern)) {
			if(compare()) {
				strcpy(Dir+Dtop, Temp);
				if(Opt & O_WRITE)
					Write();
				else {
					if(!(Opt & O_QUIET)) {
						showtd(Ti, Da);
						Pc(' '); }
					Ps(Dir);
					Nl(); } } } }
	while !find_next(Temp, &Sh, &Sl, &At, &Ti, &Da);
	i = pt;
	while(i < Ptop) {
		strcpy(Dir+Dtop, Pool+i);
		dodir();
		while(Pool[i++]); }
ex:	Dtop = dt; Ptop = pt;
}

void help(unsigned char c)
{
	Ptr = c ? Help : Time;
	while(c = *Ptr++) {
		if(c & 0x80) {
			while(c-- & 0x7F)
				Pc(' ');
			continue; }
		Pc(c); }
	exit(0);
}

unsigned ISbits(void)
{
	unsigned c, v;
	unsigned char *p;
	skip(); trim();
	p = Ptr;
	v = 0;
	Debug(("[ISb'%s'%x", Ptr, v))
	while(c = *Ptr) {
		if((c -= '0') > 9)
			goto er;
		v |= (1 << c);
		++Ptr; }
	Debug(("=%x]", v))
	if(Ptr <= p) {
er:		Error("BadBITs'%s'", p); }
	return v;
}

unsigned Value(unsigned l, unsigned h, unsigned def)
{
	unsigned c, v;
	unsigned char d, *p;

	v = 0;
	p = Ptr;
	while((c = (d = *Ptr) - '0') < 10) {
		v = (v * 10) + c;
		++Ptr; }
	if(Ptr == p)
		v = def;

	switch(d) {
	default:
er:		if(Tfile) {
			Ps("Check \";=time\"in first line of: ");
		 	Ps(Cfile);
			Nl(); }
		Error("Bad time!");
	case 0	:
		_Y = _D = _H = _Mi = _Se = 0;
		_Mo = 1;
		break;
	case '/':
	case ':':
//	case '-':
	case '_':
	case'\\':
	case ';':
	case ' ':
	case'\t':	++Ptr; }
	Debug(("[%u'%s]\n", v, Ptr))
	if((v < l) || (v > h)) goto er;
	return v;
}

void Gtime(void)
{
	Debug1(("[%u/%u/%u %u:%u:%u]\n", Y, Mo, D, H, Mi, Se))
	_Y=Y; _Mo=Mo; _D=D; _H=H; _Mi=Mi; _Se=Se;
	Cda = 	(Value(1980, 2100, _Y) - 1980) << 9;
	Cda	|=	Value(1, 12, _Mo) << 5;
	Cda |=	Value(0, 31, _D );
	Cti =	Value(0, 23, _H ) << 11;
	Cti |=	Value(0, 59, _Mi) << 5;
	Cti |=	Value(0, 59, _Se) /2;
//showtd(Cti, Cda);
}

unsigned DoFile(unsigned char *p)
{
	unsigned i;
	Fname = i = 0;
a1:	Fext = 0;
a2:	switch(p[i++]) {
	case ':':
	case'\\':	Fname = i;	goto a1;
	case '.':	Fext = i;
	default	:				goto a2;
	case 0	:	; }
	return i-1;
}

void Arg(unsigned ie)
{
	unsigned char c;

	switch(skip()) {
	case '?':	help(Ptr[1] - '=');
	case '-':
	case '/':	++Ptr;
a1:		switch(c = toupper(*Ptr++)) {
		default	:	--Ptr;
			ISyes = ISbits() | 0x8000;
			return;
		case '?':	help(*Ptr - '=');
/*ChtTxt R:\Dhelp.h
use:	CHANGE	tree\pattern... [options]

opts:	-B				show files changed Before
		-D				show Directories scanned
		-Ffile			show since 'file' timestamp (otherwise -I file)
		-Ifile[.INI]	set Initialization file			[CHANGED.INI]
			If specified file is not found, and does not indicate a path,
			CHANGED will check tha path in %DDCDATA% environment variable.
		-M				Mark -Ifile with current time
		-N				do Not look in CHANGED.INI for more arguments
		-Q				Quiet: less output
		-T				show Trees processed
		-W				Write changed files to W= path
		-W=path			set path for Writing changed files
		-!pattern		don't look at files matching this pattern
		-=y/m/d_h:m:s	look Since/Before this time		[?= help]
		-0-9..			force INI sections
		-+0-9..			add to ""
		--0-9..			remove from ""

Show/Backup changed files over large tree(s).		See: CHANGED.TXT

Dave Dunfield   -   https://dunfield.themindfactory.com~
*/
		case '`':	Ps(Ptr); Nl(); return;
		case '+':	ISyes |= ISbits();	return;
		case '-':	ISno  |= ISbits();	return;
		case 'F':
			Tfile = Pstring(Ptr);
			return;
		case '!':
			if(Ntop >= NPATS)
				Error("Too many -!'s");
			strupr(Ptr);
			Npat[Ntop++] = Pstring(Ptr);
			return;
		case 'W':
			if(*Ptr == '=') {
				strcpy(Wdir, Ptr+1);
				return; }
			c = O_WRITE;
			goto a2;
		case 'I':
			if(ie) Error("Can't set -I in .INI");
			strcpy(Cfile, Ptr);
			return;
//		case '?':	goto he;
		case 'M':
			c = (Opt & O_MARK) ? O_FORM : O_MARK;
			goto a2;
		case '=':
			Gtime();
			break;
		case 'B':	c = O_BEFORE;	goto a2;
		case 'D':	c = O_SDIR;		goto a2;
		case 'N':	c = O_NINI;		goto a2;
		case 'Q':	c = O_QUIET;	goto a2;
		case 'T':	c = O_TREE;
a2:			Opt |= c; }
		if(*Ptr)
			goto a1;
		return; }
	if(!ie) {
		DoFile();
		if(!Fname)
			strcpy(Xpattern, Ptr);
		return; }
	if(Ttop >= TREES)
		Error("Too many trees");
	Tree[Ttop++] = Pstring(Ptr);
}

unsigned Xgd(void)
{
	unsigned i; //, j, k;
	unsigned char c, hd[128];
	Debug(("Xd1'%s'\n", Cfile))
//	i = k = 0;
//l1:	j = 0;
//l2:	switch(Cfile[i++]) {
//	case ':':
//	case'\\':	k = i;	goto l1;
//	case '.':	j = i;
//	default	:			goto l2;
//	case 0	:	; }
//	if(!j)
//		strcpy(Cfile+i-1, ".INI");
//	strcpy(Temp, Cfile+k);
	i = DoFile(Cfile);
	if(!Fext)
		strcpy(Cfile+i, ".INI");
	strcpy(Temp, Cfile+Fname);
	Debug(("Fn'%s'%s'%u\n", Cfile, Temp, Fname))
	strcpy(hd, "_:\\");
	*hd = get_drive() + 'A';
	getdir(hd+3);
	Debug(("Hd'%s'\n", hd))
	if(!*Cfile) {
		strcpy(Cfile, hd);
		return; }
	c = toupper(*Cfile);
	if((c >= 'A') && (c <= 'Z') && (Cfile[1] == ':')) {
		Debug(("Sd'%c'\n", c))
		set_drive(c -= 'A');
		if(get_drive() != c)
			goto e1;
		if(Fname < 3)
			goto l4;
		if(Fname == 3)
			++Fname; }
	if(Fname) {
		Cfile[Fname-1] = 0;	//?
		if(cd(Cfile)) {
e1:			printf("?Dir:'%s'\n", Cfile);
			c = 0;
			goto e2; } }
l4:	strcpy(Cfile, "_:\\");
	*Cfile = get_drive() + 'A';
	getdir(Cfile+3);
	c = 255;
e2:	set_drive(*hd-'A');
	cd(hd);
	if(!c)
		exit(-1);
	End(&Ctop, Temp);
	return Fname;
}


main(int argc, char *argv[])
{
	unsigned i, j, k;
//	unsigned char c;

	get_date(&D, &Mo, &Y);	// D,M,Y
t1:	i = D;
	get_time(&H, &Mi, &Se);
	get_date(&D, &Mo, &Y);
	if(D != i) goto t1;

#if 0
if(argc < 2) Error("?arg");
Ptr = argv[1]; Gtime();
showtd(Cti, Cda); return;
#endif

	strcpy(Cfile, "CHANGED");
	for(i=1; i < argc; ++i) {
		Ptr = argv[i];
		Debug(("A1'%s'\n", Ptr))
		Arg(0); }
	// Locate INI file
	i = Xgd();
	Debug(("Cf%u'%s'\n", i, Cfile))
	if(!(Opt & O_NINI)) {
		Debug(("O3A'%s'\n", Cfile))
		if(!(fp = fopen(Cfile, "r"))) {
			if(!i) {
				if(getenv("DDCDATA", CpyBuf)) {
					Ctop = 0;
					strcpy(Cfile, CpyBuf);
					End(&Ctop, Temp); } }
			Debug(("O3b'%s'\n", Cfile))
			fp = fopen(Cfile, "rvq"); }
		IScur = 0xFFFF;
		while(fgets(Ptr = Dir, sizeof(Dir)-1, fp)) {
			++Line;
			switch(skip()) {
			case ':':
				switch(toupper(*++Ptr)) {
				case 'C':	++Ptr;
					if(!(ISyes & 0x8000))
						ISyes |= ISbits();
					Debug(("[:%x]", ISyes))
				case 'R':
					continue; }
				IScur = ISbits();
			case ';':
			case 0	:	continue; }
			if((~ISno) & IScur & ISyes) {
				trim();
				Debug(("A'%s'\n", Ptr))
				Arg(7); } }
		fclose(fp);
		Line = 0; }

	if(!Ttop) {
		Debug(("[H2]"))
he:		help(7); }

	if(Tfile) {
		if(find_first(Tfile, 0, Temp, &Sh, &Sl, &At, &Cti, &Cda)) {
			Ps("Not found: ");
			Ps(Tfile);
			exit(-1); }
		find_close(); }
	else if(!(Cti | Cda)) {
		fp = fopen(Cfile, "rv");
		fgets(Temp, sizeof(Temp)-1, fp);
		fclose(Tfile = fp);
		if(strbeg(Temp, ";=")) {
			Ptr = Temp+2;
			Gtime(); } }
	if(!(Opt & O_QUIET)) {
		Ps("Files changed ");
		Ps((Opt & O_BEFORE) ? "before " : "since ");
		showtd(Cti, Cda);
		Nl(); }

//	for(i=0; i < Ttop; ++i)
//		printf("T'%s'\n", Tree[i]);
	for(fp=i=0; i < Ttop; ++i) {
		strcpy(Dir, Tree[i]);
		if(Opt & O_TREE) {
			Ps("Tree: ");
			Ps(Dir);
			Nl(); }
		j = k = 0;
a1:		switch(Dir[j++]) {
		case ':':
		case'\\':	k = j;
		default	:	goto a1;
		case 0	:	; }
		if(!k) {
			Ps("Arguments must include PATH\n\n");
			goto he; }
		strcpy(Pattern, *Xpattern ? Xpattern : Dir+k);
		Dir[k] = 0;
		strupr(Pattern);
		dodir(); }
	if(fp)
		fclose(fp);
	if(Opt & O_MARK) {
		Debug(("O4'%s'\n", Cfile))
		if(!(Opt & (O_WRITE|O_FORM)))
			Error("-M without -W - use -MM to force");
		fp = fopen(Cfile, "rvq");
		k = fget(Temp, MSIZE, fp);
		fclose(fp);

		j = 0;
		if(strbeg(Temp, ";="))
			while(Temp[j++] != '\n');
		sprintf(Pattern, ";=%04u/%02u/%u %u:%02u:%02u\n", Y, Mo, D, H, Mi, Se);
		Ps("!Mark! ");
		Ps(Pattern+2);
		fp = fopen(Cfile, "wvq");
		fputs(Pattern, fp);
		fput(Temp+j, k-j, fp);
		fclose(fp); }
#if DEBUG&1
	printf("P:%u\n", MPtop);
#endif
}
/*ChtTxt Time
Times are specified as: year month day hour minite second
 hour and minite are in 24 hour format: 00:00 to 23:59

Between each item you can use:  / :  or  -	eg: 2021/08/10-13:92:00

Any items not supplied will default to the current time, but you must use
the separator to advance to the next item. Any items left after the end of
your input will be set to the lowest possible value:

eg:		-=			changed this year		now/1/0-0:0:0
		-=/			changed this month  	now/now/0-0:0:0
		-=//		changed today			now/now/now-0:0:0
		-=//-		changed this hour		now/now/now-now:0:0
		-=//-12		changed since 12:00	now/now/now-12:0:0

Time is stored in DOS (16 bit) format, which means:
	Year is 1980-2107, and resolution is 2 seconds.
*/
/*ChtTxt R:\Vhelp.h
use:	CHANGE	tree\pattern... [options]

opts:	-B				show files changed Before
		-D				show Directories scanned
		-Ffile			show since 'file' timestamp (otherwise -I file)
		-Ifile[.INI]	set Initialization file			[CHANGED.INI]
			If specified file is not found, and does not indicate a path,
			CHANGED will check tha path in %DDCDATA% environment variable.
		-M				Mark -Ffile with current time
		-N				do Not look in CHANGED.INI for more arguments
		-Q				Quiet: less output
		-T				show Trees processed
		-W				Write changed files to W= path
		~"-W=path~"		set path for Writing changed files
		-!pattern		don't look at files matching this pattern
		~"-=y/m/d_h/m/s~"	look Since/Before this time		["?="]
		-0-9..			force INI sections
		-+0-9..			add to ""
		--0-9..			remove from ""

Show/Backup changed files over large tree(s).		See: CHANGED.TXT

Dave Dunfield   -   https://dunfield.themindfactory.com~
*/
/*ChtTxt Time
Times are specified as: year month day hour minite second
 hour and minite are in 24 hour format: 00:00 to 23:59

Between each item you can use:  / :  or  -	eg: 2021/08/10-13:92:00

Any items not supplied will default to the current time, but you must use
the separator to advance to the next item. Any items left after the end of
your input will be set to the lowest possible value:

eg:		-=			changed this year		now/1/0-0:0:0
		-=/			changed this month  	now/now/0-0:0:0
		-=//		changed today			now/now/now-0:0:0
		-=//_		changed this hour		now/now/now-now:0:0
		-=//_12		changed since 12:00	now/now/now-12:0:0

Time is stored in DOS (16 bit) format, which means:
	Year is 1980-2107, and resolution is 2 seconds.
*/
//ChtCmd cc changed -pod
